/* ------------------------------------------------------------------------- */
/* VIEWEDMI.CMD - View online EDMI issues                       Nov 16, 1995 */
/* Written by Graham TerMarsch (gtermars@infomatch.com)                      */
/* ------------------------------------------------------------------------- */
/* This REXX script allows you to view all of the issues of EDMI that you    */
/* have in a given directory at one time.  I wrote this because I found that */
/* there were several occaisions when I wanted to perform a search through   */
/* only the EDMI issues that I've got here and not any of my other online    */
/* help.  So, I wrote this little script to start up a session with all of   */
/* the issues in it.  Enjoy!                                                 */
/* ------------------------------------------------------------------------- */
/* For this script to work, it is assumed that the path that contains all of */
/* your EDMI issues is listed in the HELP variable.                          */
/* ------------------------------------------------------------------------- */
/* If you have any problems with this software or would like to contact the  */
/* author, he can be e-mailed at gtermars@infomatch.com.  To keep up to date */
/* on this and other software by this author, point your WebExplorer over to */
/* http://www.infomatch.com/~gtermars.                                       */
/* ------------------------------------------------------------------------- */

/* ------------------------------------------------------------------------- */
/* Variables:                                                                */
/*                                                                           */
/* EDMIPATH     Full path to where you store your EDMI issues.  If this path */
/*              is NOT in your HELP listing in your CONFIG.SYS file you will */
/*              have trouble                                                 */
/* EDMI         Array which will be declared later but will contain all of   */
/*              the filenames of the available EDMI issues.                  */
/* ISSUES       String containing all of the filenames for the EDMI issues;  */
/*              will be used to start the OS/2 help viewer.                  */
/* I            Index into array of available issues.                        */
/* ------------------------------------------------------------------------- */
ISSUES = ''
I = 1

/* ------------------------------------------------------------------------- */
/* Parse the given command line argument.  If none exists, display usage     */
/* message and quit.                                                         */
/* ------------------------------------------------------------------------- */
PARSE ARG EDMIPATH
IF (EDMIPATH = '') THEN DO
        say 'ViewEDMI.Cmd'
        say 'Written by Graham TerMarsch (gtermars@infomatch.com)'
        say ''
        say 'Views all EDMI issues in a given directory.'
        say ''
        say 'Usage:     ViewEDMI <path>'
        exit
END

IF (SUBSTR(EDMIPATH, LENGTH(EDMIPATH), 1) <> '\') THEN DO
        EDMIPATH = INSERT( '\', EDMIPATH, LENGTH(EDMIPATH) )
END

/* ------------------------------------------------------------------------- */
/* Load any necessary REXX functions.                                        */
/* ------------------------------------------------------------------------- */
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call RxFuncAdd "SysDropFuncs", "RexxUtil", "SysDropFuncs"
call SysLoadFuncs

/* ------------------------------------------------------------------------- */
/* Generate a listing of all of the EDMI issues in that directory into the   */
/* EDMI array.  If no issues are available, display a message and quit.      */
/* ------------------------------------------------------------------------- */
call SysFileTree EDMIPATH'EDMI*.Inf', 'EDMI', 'O'

IF (EDMI.0 = 0) THEN DO
        say 'No issues of EDMI are available in the "'EDMIPATH'" directory.'
        exit
END

/* ------------------------------------------------------------------------- */
/* Create a string holding the filenames of all of the issues.               */
/* ------------------------------------------------------------------------- */
DO UNTIL (I >= EDMI.0)
        IF (I > 1) THEN DO
                ISSUES = INSERT( '+', ISSUES, LENGTH(ISSUES) )
        END

        ISSUES = INSERT( EDMI.I, ISSUES, LENGTH(ISSUES) )

        I = I + 1
END

/* ------------------------------------------------------------------------- */
/* Start the OS/2 help viewer.  Being that I expect the command line to be   */
/* quite long, we'll cheat here and set an environment variable, start the   */
/* help viewer, and then reset the environment variable.                     */
/* ------------------------------------------------------------------------- */
'@SET ALLEDMIISSUES=' || ISSUES
'@start VIEW ALLEDMIISSUES'
'@SET ALLEDMIISSUES='

/* ------------------------------------------------------------------------- */
/* Cleanup.                                                                  */
/* ------------------------------------------------------------------------- */
call SysDropFuncs
