/* Author Michael Mrosowski*/
/* Version 0.1*/
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <ctype.h>

#define INCL_WHATEVER
#define INCL_DOSDEVIOCTL
#include <os2.h>

#define maxbufflen 4000

HFILE comhandle=0;
int delay=100;

unsigned char sigin;

void tocom(void *buffer,int len)
{
  ULONG written;

  DosWrite(comhandle,buffer,len,&written);
}

char localkey=0;

int fromcom(char *buffer)
{ ULONG read=0;
  int lc;

  if(comhandle)
    DosRead(comhandle,buffer,1,&read);

  lc=_read_kbd(0,0,0);         /*local keyboard*/
  if(lc!=-1)
  {
    buffer[0]=(char)lc;
    read=1;
    localkey=(char)lc;
  }
  return read;
}

int carrierlost(void)
{ APIRET        rc;
  long          dummy;
  unsigned char modeminfo;

  if(comhandle) {
    rc=DosDevIOCtl(comhandle, IOCTL_ASYNC, ASYNC_GETMODEMINPUT, 0,0,0,&modeminfo,
                   1,&dummy);
    if(rc==0)
      return !((modeminfo>>7) &1);
  }
  return 0;
}


char inbuffer[maxbufflen],outbuffer[maxbufflen];
int inbufflen=0;

 #define  NPIPEIN_NAME   "\\PIPE\\DUMMSIG."         /* Pipe name             */
 #define  NPIPEOUT_NAME   "\\PIPE\\DUMMOUT."         /* Pipe name             */

 HFILE      hSignal,hPipe;                    /* Pipe handle           */
 ULONG      ulAction;                            /* Open action           */
 APIRET     rc;                                  /* Return code           */
 
void initpipe(char *name,HFILE *hpipe)
{    /*Dosmakenmpipe*/
 printf("Dos Create Pipe name : %s\n",name);fflush(stdout);
 rc = DosCreateNPipe(name,              /* Create named pipe     */
                     hpipe,                  /* Pipe handle           */
                     NP_ACCESS_DUPLEX,        /* Allow duplex access   */
                     NP_NOWAIT        |       /* Blocking mode         */

                     NP_TYPE_BYTE     |       /* Msg oriented pipe     */
                     NP_READMODE_BYTE |       /* Msg oriented read     */
                     255,                     /* max 255 instances*/
                     sizeof(outbuffer),       /* Outbound buffer size  */
                     sizeof(inbuffer),        /* Inbound buffer size   */
                     0);/*should be 0*/       /* Default timeout value */
 printf("Dos Create Pipe returns : %d\n",rc);fflush(stdout);
 do {
   rc = DosConnectNPipe(*hpipe);              /* Connect to requester  */
   if(rc) DosSleep(100);
 } while(rc);
 printf("Pipe connected\n",rc);fflush(stdout);
}


ULONG bytesread,byteswritten;

int main(int argc, char *argv[], char *envp[])
{
  char inname[128],outname[128];
  int sleepval=100;
  int lastcarriercheckago=0;
  int nocarrier=0;

  if(argc>=3)
  {
   strcpy(inname,NPIPEIN_NAME);
   strcpy(outname,NPIPEOUT_NAME);
   strcat(inname,argv[1]); /*add node id to pipenames*/
   strcat(outname,argv[1]);
   comhandle=atoi(argv[2]);
   printf("ServDumm, Michael Mrosowski is to blame for this.\n");
   printf("Node : %s, Comhandle : %d\n",argv[1],comhandle);fflush(stdout);

   initpipe(outname,&hPipe);
   initpipe(inname,&hSignal);
   do
   {
     if(sleepval) {
       DosSleep(sleepval);
       lastcarriercheckago+=sleepval;
     } else lastcarriercheckago+=2;
     if (lastcarriercheckago>=1000) {
       nocarrier=carrierlost();
       lastcarriercheckago=0;
     }

     /*get outputdata*/
     rc = DosRead(hPipe,                      /* Read request          */
                  outbuffer,                  /* Request buffer        */
                  maxbufflen,                 /* Size of buffer        */
                  &bytesread);                /* No. of bytes read     */

     if(bytesread) /*send outputdata to com-handle*/
       tocom(outbuffer,bytesread);

     if(!inbufflen)
       inbufflen=fromcom(inbuffer); /*get inputdata from com-handle*/

     if(!bytesread && !inbufflen) /*increase wait-delay if no data send/rec*/
       {if(sleepval<100) sleepval+=5;}
     else sleepval=0;

                      /*check signal pipe*/
     sigin=0;
     do {             /* get signals last signal */
       rc = DosRead(hSignal,                   /* Read signal           */
                    &sigin,                    /* Request buffer        */
                    sizeof(sigin),             /* Size of buffer        */
                    &bytesread);               /* No. of bytes read     */
     } while(bytesread);

     if(inbufflen) {
        rc = DosWrite(hPipe,                   /* Write buffer to pipe   */
                      inbuffer,                   /* Reply buffer          */
                      inbufflen,                  /* Size of buffer        */
                      &byteswritten);             /* No. of bytes written  */
        inbufflen-=byteswritten;
     }
   } while (sigin!=2 && !nocarrier);
   if(nocarrier) {printf("Carrier lost !!\n\n");fflush(stdout);}
   rc = DosDisConnectNPipe(hPipe);
   rc = DosDisConnectNPipe(hSignal);
   return 0;
 }
 else
 {
   printf("Please give me the nodeid and comhandle as Parameter !\n");
   return 1;
 }
}
