Procedure ReadUtilFile(CFGInfo : String);
Var
  ReadUtil : String;
begin
    Assign(OHandle,AllTrim(CFG.DataPath)+'ILLUTILS.CFG');
    Reset(OHandle);
    repeat
         ReadLn(OHandle,ReadUtil);
    until (CFGInfo = ReadUtil) OR (eof(OHandle));
end;

Function DoReadCFG : String;
Var
  ReadStr : String;
begin
    repeat
         ReadLn(OHandle,ReadStr);
         ReadStr := AllTrim(ReadStr);
    until (ReadStr[1] <> '#') AND (Length(ReadStr) <> 0);
    if ReadStr[1] = '"' then
    begin
        Delete(ReadStr,1,1);
        Delete(ReadStr,Length(ReadStr),1);
    end;
    DoReadCFG := ReadStr;
end;

Procedure WriteUser;
Var
  UserRecord    : File of USERSFile;
  SpareStr      : String;
  Done          : Boolean;
  UserText,
  RHandle       : Text;
  Index, UserID : Integer;
begin
    Index := 0;
    Assign(UserText,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
    Reset(UserText);
    ReadLn(UserText,UserID);
    if UserID <> USERS.UserIndex then
    begin
        repeat
             inc(Index);
             ReadLn(UserText,SpareStr);
        until Index = USERS.UserIndex;
        Index := 0;
        Assign(RHandle,AllTrim(CFG.TempPath)+'TMPUSERS.LST');
        ReWrite(RHandle);
        Reset(UserText);
        ReadLn(UserText,SpareStr);
        WriteLn(RHandle,SpareStr);
        if USERS.UserIndex <> 1 then
        begin
            repeat
                 inc(Index);
                 ReadLn(UserText,SpareStr);
                 WriteLn(RHandle,SpareStr);
            until Index = (USERS.UserIndex-1);
            ReadLn(UserText,SpareStr);
            WriteLn(RHandle,USERS.Handle);
            if not eof(UserText) then
            begin
                repeat
                     ReadLn(UserText,SpareStr);
                     WriteLn(RHandle,SpareStr);
                until eof(UserText);
            end;
        end
        else
        begin
            WriteLn(RHandle,USERS.Handle);
            ReadLn(UserText,SpareStr);
            if not eof(UserText) then
            begin
                repeat
                     ReadLn(UserText,SpareStr);
                     WriteLn(RHandle,SpareStr);
                until eof(UserText);
            end;
        end;
        Close(UserText);
        Close(RHandle);
        Erase(UserText);
        ReName(RHandle,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
        Assign(UserRecord,AllTrim(CFG.DataPath)+'ILLUSERS.DAT');
        Reset(UserRecord);
        Seek(UserRecord,USERS.UserIndex-1);
        Write(UserRecord,USERS);
        Close(UserRecord);
    end
    else
    begin
        Close(UserText);
        Assign(UserText,AllTrim(CFG.MsgPath)+'ILLMSGBX.DAT');
        if Exist(AllTrim(CFG.MsgPath)+'ILLMSGBX.DAT') then
        begin
            Reset(UserText);
            ReadLn(UserText,USERS.MSGId);
            Close(UserText);
            Assign(UserText,AllTrim(CFG.MsgPath)+'ILLMSGBX.DAT');
            Reset(UserText);
            Assign(RHandle,AllTrim(CFG.TempPath)+'ILLMSGBX.TMP');
            ReWrite(RHandle);
            ReadLn(UserText,Index);
            inc(Index);
            WriteLn(RHandle,Index);
            repeat
                 ReadLn(UserText,SpareStr);
                 WriteLn(RHandle,SpareStr);
            until eof(UserText);
            Write(RHandle,'[');
            Write(RHandle,USERS.MSGId);
            WriteLn(RHandle,']');
            Close(UserText);
            Close(RHandle);
            Erase(UserText);
            Rename(RHandle,AllTrim(CFG.MsgPath)+'ILLMSGBX.DAT');
        end
        else
        begin
            USERS.MSGId := 1;
            ReWrite(UserText);
            WriteLn(UserText,'2');
            Write(UserText,'[');
            Write(UserText,USERS.MSGId);
            WriteLn(UserText,']');
            Close(UserText);
        end;
        Assign(UserText,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
        Append(UserText);
        WriteLn(UserText,USERS.Handle);
        Close(UserText);
        Assign(UserRecord,AllTrim(CFG.DataPath)+'ILLUSERS.DAT');
        Reset(UserRecord);
        Seek(UserRecord,FileSize(UserRecord));
        Write(UserRecord,USERS);
        Close(UserRecord);
        inc(UserID);
        Assign(RHandle,AllTrim(CFG.TempPath)+'TMPUSERS.LST');
        ReWrite(RHandle);
        Assign(UserText,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
        Reset(UserText);
        ReadLn(UserText,SpareStr);
        WriteLn(RHandle,UserID);
        repeat
             ReadLn(UserText,SpareStr);
             WriteLn(RHandle,SpareStr);
        until eof(UserText);
        Close(UserText);
        Close(RHandle);
        Erase(UserText);
        ReName(RHandle,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
        if USERS.Validated = False then
        begin
            Assign(UserText,AllTrim(CFG.DataPath)+'ILLNEWUV.DAT');
            if Exist(AllTrim(CFG.DataPath)+'ILLNEWUV.DAT') then
            begin
                Append(UserText);
            end
            else
            begin
                ReWrite(UserText);
            end;
            Write(UserText,'[');
            Write(UserText,USERS.MSGId);
            WriteLn(UserText,']');
            WriteLn(UserText,'0');
            WriteLn(UserText,'0');
            Close(UserText);
        end;
    end;
end;

Procedure DeleteUser(Handle : String);
Var
  TmpUSERS            : USERSFile;
  TempStr, SpareStr   : String;
  UserList, TempFile,
  Handle1, Handle2    : Text;
  UserRecord,
  UserRecordTmp       : File of USERSFile;
  DelIndex, Index,
  Loop, TotalUSERS    : Integer;
begin
    TmpUSERS := USERS;
    Assign(UserList,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
    Reset(UserList);
    ReadLn(UserList,TotalUSERS);
    DelIndex := 0;
    repeat
         inc(DelIndex);
         ReadLn(UserList,TempStr);
         TempStr := AllTrim(TempStr);
    until (TempStr = Handle) OR (eof(UserList));
    Close(UserList);
    CR;
    if TempStr <> Handle then
    begin
        GetStringDAT(6);
    end
    else
    begin
        GetStringDAT(47);
        if TotalUSERS = 2 then
        begin
            Assign(UserList,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
            Erase(UserList);
            Assign(UserRecord,AllTrim(CFG.DataPath)+'ILLUSERS.DAT');
            Erase(UserRecord);
        end
        else
        begin
            Index := 0;
            Assign(TempFile,AllTrim(CFG.TempPath)+'TEMPUS.TMP');
            ReWrite(TempFile);
            Assign(UserList,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
            Reset(UserList);
            ReadLn(UserList,Loop);
            dec(Loop);
            WriteLn(TempFile,Loop);
            if DelIndex <> 1 then
            begin
                repeat
                     inc(Index);
                     ReadLn(UserList,TempStr);
                     WriteLn(TempFile,TempStr);
                until Index = (DelIndex-1);
            end;
            ReadLn(UserList,TempStr);
            if not eof(UserList) then
            begin
                repeat
                     ReadLn(UserList,TempStr);
                     WriteLn(TempFile,TempStr);
                until eof(UserList);
            end;
            Close(UserList);
            Close(TempFile);
            Erase(UserList);
            Rename(TempFile,AllTrim(CFG.DataPath)+'ILLUSERS.LST');
            Index := 0;
            Assign(UserRecord,AllTrim(CFG.DataPath)+'ILLUSERS.DAT');
            Reset(UserRecord);
            Assign(UserRecordTmp,AllTrim(CFG.TempPath)+'TEMPUS.TMP');
            ReWrite(UserRecordTmp);
            if DelIndex <> 1 then
            begin
                repeat
                     inc(Index);
                     Read(UserRecord,USERS);
                     Write(UserRecordTmp,USERS);
                until Index = (DelIndex-1);
            end;
            Read(UserRecord,USERS);
            if USERS.Validated = False then
            begin
                Assign(Handle1,AllTrim(CFG.DataPath)+'ILLNEWUV.DAT');
                Reset(Handle1);
                Assign(Handle2,AllTrim(CFG.TempPath)+'ILLNEWUV.TMP');
                ReWrite(Handle2);
                ReadLn(Handle1,SpareStr);
                Delete(SpareStr,1,1);
                Delete(SpareStr,Length(SpareStr),1);
                Loop := StrToInt(SpareStr);
                if Loop <> USERS.MSGId then
                begin
                    repeat
                         ReadLn(Handle1,SpareStr);
                         if (SpareStr[1] = '[') AND
                            (SpareStr[Length(SpareStr)] = ']') then
                         begin
                             TempStr := SpareStr;
                             Delete(SpareStr,1,1);
                             Delete(SpareStr,Length(SpareStr),1);
                             Loop := StrToInt(SpareStr);
                         end
                         else
                         begin
                             WriteLn(Handle2,SpareStr);
                         end;
                    until Loop = USERS.MSGId;
                    repeat
                         ReadLn(Handle1,SpareStr);
                    until (SpareStr[1] = '[') AND (SpareStr[Length(SpareStr)] = ']') OR (eof(Handle1));
                end
                else
                begin
                    repeat
                         ReadLn(Handle1,SpareStr);
                    until (SpareStr[1] = '[') AND (SpareStr[Length(SpareStr)] = ']') OR (eof(Handle1));
                    if eof(Handle1) then
                    begin
                        Close(Handle1);
                        Close(Handle2);
                        Erase(Handle1);
                        Erase(Handle2);
                    end;
                end;
                if Exist(AllTrim(CFG.DataPath)+'ILLNEWUV.DAT') then
                begin
                    if not eof(Handle1) then
                    begin
                        WriteLn(Handle2,SpareStr);
                        repeat
                             ReadLn(Handle1,SpareStr);
                             WriteLn(Handle2,SpareStr);
                        until eof(Handle1);
                    end;
                    Close(Handle1);
                    Close(Handle2);
                    Erase(Handle1);
                    Rename(Handle2,AllTrim(CFG.DataPath)+'ILLNEWUV.DAT');
                end;
            end;
            if not eof(UserRecord) then
            begin
                repeat
                     Read(UserRecord,USERS);
                     dec(USERS.UserIndex);
                     Write(UserRecordTmp,USERS);
                until eof(UserRecord);
            end;
            Close(UserRecord);
            Close(UserRecordTmp);
            Assign(UserRecord,AllTrim(CFG.DataPath)+'ILLUSERS.DAT');
            Erase(UserRecord);
            Assign(UserRecordTmp,AllTrim(CFG.TempPath)+'TEMPUS.TMP');
            Rename(UserRecordTmp,AllTrim(CFG.DataPath)+'ILLUSERS.DAT');
        end;
        Assign(Handle1,AllTrim(CFG.MsgPath)+'ILLMSGBX.DAT');
        Reset(Handle1);
        Assign(Handle2,AllTrim(CFG.TempPath)+'ILLMSGBX.TMP');
        ReWrite(Handle2);
        SpareStr := IntToStr(USERS.MSGId);
        repeat
             ReadLn(Handle1,TempStr);
             if TempStr = '['+SpareStr+']' then
             begin
                 repeat
                      ReadLn(Handle1,TempStr);
                 until (TempStr[1] = '[') AND (TempStr[Length(TempStr)] = ']') OR (eof(Handle1));
                 if not eof(Handle1) then
                 begin
                     WriteLn(Handle2,TempStr);
                 end;
             end
             else
             begin
                 WriteLn(Handle2,TempStr);
             end;
        until eof(Handle1);
        Close(Handle1);
        Close(Handle2);
        Erase(Handle1);
        Rename(Handle2,AllTrim(CFG.MsgPath)+'ILLMSGBX.DAT');
    end;
    USERS := TmpUSERS;
end;

Procedure WriteLog(LogStr : String;Time : Boolean);
Var
  LogFile        : Text;
  Result         : Boolean;
  Hour, Minute,
  Second, Sec100 : Word;
  PostFix        : String[2];
begin
    if CFG.Logs = 'Y' then
    begin
        if not Exist(AllTrim(CFG.LogPath)+'ILLUSION.LOG') then
        begin
            Assign(LogFile,AllTrim(CFG.LogPath)+'ILLUSION.LOG');
            ReWrite(LogFile);
        end
        else
        begin
            Assign(LogFile,AllTrim(CFG.LogPath)+'ILLUSION.LOG');
            Append(LogFile);
        end;
        if Time = True then
        begin
            GetTime(Hour,Minute,Second,Sec100);
            if Hour > 12 then
            begin
                Hour := Hour - 12;
	        PostFix := 'pm';
            end
            else
            begin
                PostFix := 'am';
            end;
            if Hour < 10 then
            begin
                Write(LogFile,' ');
            end;
            Write(LogFile,Hour,':');
            if Minute < 10 then
            begin
	        Write(LogFile,'0');
            end;
            Write(LogFile,Minute);
            Write(LogFile,PostFix,'  ');
        end
        else
        begin
            Write(LogFile,'         ');
        end;
        WriteLn(LogFile,LogStr);
        Close(LogFile);
    end;
end;

Function GetDrive : Byte;
Var
  Regs : Registers;
begin
    Regs.AX := $1900;
    Intr($21,Regs);
    GetDrive := Regs.AL;
end;

Procedure WriteCFG;
Var
  CFGHandle : File of CFGFile;
begin
    Assign(CFGHandle,AllTrim(CFG.ExePath)+'CONFIG.BBS');
    ReWrite(CFGHandle);
    Write(CFGHandle,CFG);
    Close(CFGHandle);
end;

Procedure ReadCFG;
Var
  CFGHandle : File of CFGFile;
  TempDir   : String[40];
begin
    GetDir(GetDrive+1,TempDir);
    Insert('\',TempDir,Length(TempDir)+1);
    Assign(CFGHandle,TempDir+'CONFIG.BBS');
    Reset(CFGHandle);
    Read(CFGHandle,CFG);
    Close(CFGHandle);
end;

Procedure TemplateMenu;
Const
    MaxItems = 2;
    X        = 35;
    Y        = 7;
Var
  Input : Char;
  Loop  : Byte;
  Done  : Boolean;
begin
    {Draw your input screen here!}
    Loop := 1;
    Done := False;
    repeat
         repeat
                {Do something cool here, while you are waiting for a keypress}
         until KeyPressed;
         Input := ReadKey;
         if Input in [UpArrow,DownArrow] then
         begin
             if Input = UpArrow then
             begin
                 dec(Loop);
                 if Loop = 0 then
                 begin
                     Loop := MaxItems;
                 end;
             end
             else if Input = DownArrow then
             begin
                 inc(Loop);
                 if Loop = MaxItems+1 then
                 begin
                     Loop := 1;
                 end;
             end;
             {Put whatever you are using to mark the current selected item}
             GotoXY(X,Y+Loop);
             {Put your marker here, using the Write command}
         end
         else if Input = ReturnKey then
         begin
             Done := True;
             {Depending on what you want to do, you do it here} 
             {Use the Loop number to tell you want to execute}
             if Loop = 1 then
             begin
             end
             else if Loop = 2 then
             begin
             end;
         end
         else if Input = ESCKey then
         begin
             Done := True;
         end;
    until Done;
end;