rem 
rem $Header: cat7201.sql 7020100.1 94/09/23 22:13:14 cli Generic<base> $ 
rem 
Rem  Copyright (c) 1992 by Oracle Corporation 
Rem    NAME
Rem      cat7201.sql - upgrade Oracle RDBMS from version 7.1.X to 7.2.1
Rem    DESCRIPTION
Rem
Rem    NOTES
Rem      Run this as INTERNAL.  Run it before installing catalog or pl/sql.
Rem      It is safe to run it on 7.1.2.
Rem    MODIFIED   (MM/DD/YY)
Rem     vraghuna   08/18/94 -  bump up export compatibility
Rem     jbellemo   06/24/94 -  Creation
 
rem
rem Trusted Stored Procedures
rem
create table objpriv$                       /* privileges granted to objects */
( obj#          number not null,                            /* object number */
  privilege#    number not null)                         /* privilege number */
/

REM This will get bumped up as the views evolve. The insert is needed
REM for upgrades from 7.0 or new databases. The update is needed for 
REM databases that have older compatibility.
REM These are the releases when the compatibility was bumped:
REM    7.0.* - no compatibility - assume zero
REM    7.1.3 - set to one
REM    7.2.1 - set to two
insert into props$ 
select 'EXPORT_VIEWS_VERSION', '2', 'Export views revision #' from dual
where not exists
  (select 'x' from props$ where name = 'EXPORT_VIEWS_VERSION')
/
update props$ set value$ = 2 where name = 'EXPORT_VIEWS_VERSION'
/
commit
/
REM Check for Procedural Option
CREATE OR REPLACE view exu7cpo (value) AS
		SELECT DECODE(value, 'TRUE', 1, 'FALSE', 0, 2) 
		FROM v$option
		WHERE parameter = 'procedural'
/
grant select on exu7cpo to public
/
