rem 
rem $Header: catsvrmg.sql 7020200.1 95/02/15 18:32:00 cli Generic<base> $ 
rem 
Rem  Copyright (c) 1991 by Oracle Corporation 
Rem    NAME
Rem      catsvrmg.sql - Create the views and tables required for Server Manager
Rem    DESCRIPTION
Rem      
Rem    RETURNS
Rem 
Rem    NOTES
Rem      Connects as internal (no password)
Rem    MODIFIED   (MM/DD/YY)
Rem     dsternbe   02/10/95 -  update version number
Rem     msinykin   01/25/94 -  update version number 
Rem     barthur    01/23/94 -  Remove the sm$security items we no longer need 
Rem     barthur    01/11/94 -  Add DROP SYS.SM$ROLE_TREE
Rem     barthur    12/30/93 -  Add new views and table for improvements to secu
Rem     ameyer     10/28/93 -  Updated version number to match database (7.1.2)
Rem     ameyer     10/21/93 -  Fixed sm$version.version_number to be VSNNUMBER.
Rem                         -  Also removed old tables and @@catnosvm.sql
Rem     ameyer     10/12/93 -  Added sm$version and comments. 
Rem     durry      09/22/93 -  add public alias for v$sess_io 
Rem     sstorkel   09/10/93 -  Remove connect command. 
Rem     barthur    07/30/93 -  Change sm$ts view for the new tablespace select 
Rem     msinykin   06/21/93 -  Clean up views. 
Rem     barthur    05/07/93 -  Creation 

REM List of Server Manager Tables and views
REM These need to be created by SYS when Server Manager is installed.
REM
REM This script needs to be run as INTERNAL or SYS
REM

REM For debugging
REM set echo ON

REM You *must* be connected as SYS or INTERNAL for this script to
REM work correctly.

REM sm$version
REM Version_number is conceptually VSNNUMBER(version_text).
REM In the case of '7.1.2.0.0', it's hex 0x07102000
REM converted to decimal 118497280.
create or replace view sys.sm_$version as
    select '7.2.2.0.0' version_text, 119545856 version_number, created
    from sys.dba_objects where owner = 'SYS' and object_name = 'SM_$VERSION';
grant select on sys.sm_$version to public;
drop public synonym sm$version;
create public synonym sm$version for sys.sm_$version;

REM sm$ts_avail
create or replace view sys.sm$ts_avail as
    select tablespace_name, sum(bytes) bytes from dba_data_files
    group by tablespace_name;

REM sm$ts_used
create or replace view sys.sm$ts_used as
    select tablespace_name, sum(bytes) bytes from dba_segments
    group by tablespace_name;

REM sm$ts_free
create or replace view sys.sm$ts_free as
    select tablespace_name, sum(bytes) bytes from dba_free_space
    group by tablespace_name;

REM sm$audit_config
create or replace view sys.sm$audit_config
    ( audit_type, schema_user, audit_target) as
    select 'Object', owner, object_type || ' ' || object_name
    from sys.dba_obj_audit_opts
    where ALT != '-/-' OR AUD != '-/-' OR COM != '-/-' OR DEL != '-/-'
       OR GRA != '-/-' OR IND != '-/-' OR INS != '-/-' OR LOC != '-/-'
       OR REN != '-/-' OR SEL != '-/-' OR UPD != '-/-' OR REF != '-/-'
       OR EXE != '-/-'
    union all select 'Privilege', user_name, privilege
    from sys.dba_priv_audit_opts
    union all select 'Statement', user_name, audit_option
    from sys.dba_stmt_audit_opts;

REM sm$integrity_cons
create or replace view sys.sm$integrity_cons as
select owner || '.' || table_name table_name, constraint_name,
    decode(status, 'ENABLED', 'Y', NULL) enabled from sys.dba_constraints;

REM Now, make v$sess_io public.
REM This is here as a workaround for bug #149629.  Basically, there is a bug
REM in catalog.sql.  It fails to create the view and public synonym for
REM v$sess_io.  This makes it impossible for regular DBA's to run monitors
REM using this view.
REM This should disappear at some point.
create or replace view sys.v_$sess_io as select * from sys.v$sess_io;
drop public synonym v$sess_io;
create public synonym v$sess_io for sys.v_$sess_io;
