rem 
rem $Header: dbmsarpc.sql 7020100.1 94/09/23 22:14:33 cli Generic<base> $ 
rem 
Rem  Copyright (c) 1993 by Oracle Corporation 
Rem    NAME
Rem      dbmsarpc.sql - DBMS asynchronous RPC services
Rem    DESCRIPTION
Rem      This file contains sql wich creates packages used by asynchronous 
Rem      replication.  The packages are interfaces to kernel services.
Rem      All packages are created in the schema 'SYS'.
Rem      Packages are:
Rem        dbms_asyncrpc - interface to kernel streaming RPC service used to
Rem                        implement the dbms_defer_packages.
Rem        dbms_defer_pack - interface to kernel data packing service used to
Rem                          implement the dbms_defer packages.
Rem      
Rem    RETURNS
Rem 
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem    DEPENDENCIES
Rem      These packages use calls from  the DBMS_SQL, DBMS_ASYNCRPC, and
Rem      DBMS_DEFER_PACK packages
Rem      
Rem    USAGE
Rem      This script is to be run by user SYS.
Rem
Rem    SECURITY
Rem      EXECUTE on these packages should only be granted to the user 
Rem      owing the dbms_defer pakages, normally REPLICATION.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     dsdaniel   07/15/93 -  Creation


REM ********************************************************************
REM THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
REM COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE
REM RDBMS.  SPECIFICALLY, THE PSD* ROUTINES MUST NOT BE CALLED
REM DIRECTLY BY ANY CLIENT AND MUST REMAIN PRIVATE TO THE PACKAGE BODY.
REM ********************************************************************

CREATE OR REPLACE  PACKAGE dbms_defer_pack IS

  ------------
  --  OVERVIEW
  --
  -- This package is used for "longification".  It packs varchar2, data, 
  -- number,
  -- rowid, or raw datatypes ino character buffers.
   ------------
  --  SECURITY
  --
  --  Security can be achieved by use of 'grant execute', and by writing cover
  --  packages that only expose particular features or pipenames to particular
  --  users or roles.
  ----------------------------
  --  PROCEDURES AND FUNCTIONS
  --
  procedure pack(item     IN     VARCHAR2,
                 buffer   IN OUT CHAR,
                 position IN OUT BINARY_INTEGER);
  procedure pack(item     IN     NUMBER,
                 buffer   IN OUT CHAR,
                 position IN OUT BINARY_INTEGER);
  procedure pack(item     IN     DATE,
                 buffer   IN OUT CHAR,
                 position IN OUT BINARY_INTEGER);
  procedure pack_raw(item     IN     RAW,
                     buffer   IN OUT CHAR,
                     position IN OUT BINARY_INTEGER);
  procedure pack_rowid(item     IN     ROWID,
                       buffer   IN OUT CHAR,
                       position IN OUT BINARY_INTEGER);
  --  Pack an item into the message buffer
  --  Input parameters:
  --    item
  --      Item to pack into the local message buffer.
  --  Exceptions:
  --    ORA-06558 generated if message buffer overflows (currently 4096
  --    bytes).  Each item in the buffer takes one byte for the type,
  --    two bytes for the length, plus the actual data.  There is also one
  --    byte needed to terminate the message.
  --
  procedure unpack(item     OUT    VARCHAR2,
                   buffer   IN OUT CHAR,
                   position IN OUT BINARY_INTEGER);
  procedure unpack(item     OUT    NUMBER,
                   buffer   IN OUT CHAR,
                   position IN OUT BINARY_INTEGER);
  procedure unpack(item     OUT    DATE,
                   buffer   IN OUT CHAR,
                   position IN OUT BINARY_INTEGER);
  procedure unpack_raw(item     OUT    RAW,
                       buffer   IN OUT CHAR,
                       position IN OUT BINARY_INTEGER);
  procedure unpack_rowid(item     OUT    ROWID,
                         buffer   IN OUT CHAR,
                         position IN OUT BINARY_INTEGER);
  --  Unpack an item from the local message buffer
  --  Output parameters:
  --    item
  --      The argument to receive the next unpacked item from the local 
  --      message buffer.
  --  IN out parameters
  --    buffer
  --      The character buffer contianing the packed data.
  --    position
  --      Position of the item to extract. Advanced to next item in buffer.
  --  Exceptions:
  --    ORA-06556 or 06559 are generated if the buffer contains
  --    no more items, or if the item is not of the same type as that
  --    requested (see 'next_item_type' below).
  --
  FUNCTION next_item_type(buffer   IN CHAR,
                          position IN BINARY_INTEGER)
    RETURN INTEGER;
  --  Get the type of the next item in the local message buffer
  --  Input parameters. 
  --    buffer
  --      The character buffer contianing the packed data.
  --    position
  --      Position of the item to extract. 
  --  Return value:
  --    Type of next item in buffer:
  --      0 if no more items in buffer;
  --      See dbms_defer.arg_type_* for other types

  PROCEDURE reset_buffer(buffer IN OUT CHAR, position OUT BINARY_INTEGER);
  --  reset buffer positioning indicators to 0. 
  --  Input/Output parameters. 
  --    buffer
  --      The character buffer contianing the packed data.
  --   Output parameters. 
  --    position
  --      Position of the item to extract. Set to first item in buffer.

END dbms_defer_pack;
/

CREATE OR REPLACE PACKAGE BODY dbms_defer_pack IS
  
                                                           /* icd interfaces */
  PROCEDURE copyintobuf(a IN VARCHAR2, pos IN OUT BINARY_INTEGER,
      buf IN OUT CHAR);
    PRAGMA INTERFACE (C, copyintobuf);                      -- 1 (see psdicd.c)
  PROCEDURE copyintobuf(a IN NUMBER, pos IN OUT BINARY_INTEGER, 
      buf IN OUT CHAR);
    PRAGMA INTERFACE (C, copyintobuf);                      -- 2 (see psdicd.c)
  PROCEDURE copyintobuf(a IN DATE, pos IN OUT BINARY_INTEGER, 
      buf IN OUT CHAR);
    PRAGMA INTERFACE (C, copyintobuf);                      -- 3 (see psdicd.c)
  PROCEDURE copyintobufbinary(a IN RAW, pos IN OUT BINARY_INTEGER,
      buf IN OUT CHAR);
    PRAGMA INTERFACE (C, copyintobufbinary);                -- 4 (see psdicd.c)
  PROCEDURE copyintobufrowid(a IN ROWID, pos IN OUT BINARY_INTEGER,
      buf IN OUT CHAR);
    PRAGMA INTERFACE (C, copyintobufrowid);                 -- 5 (see psdicd.c)

  PROCEDURE copyfrombuf(a OUT VARCHAR2, pos IN OUT BINARY_INTEGER, 
      buf IN CHAR);
    PRAGMA INTERFACE (C, copyfrombuf);                      -- 6 (see psdicd.c)
  PROCEDURE copyfrombuf(a OUT NUMBER, pos IN OUT BINARY_INTEGER, buf IN CHAR);
    PRAGMA INTERFACE (C, copyfrombuf);                      -- 7 (see psdicd.c)
  PROCEDURE copyfrombuf(a OUT DATE, pos IN OUT BINARY_INTEGER, buf IN CHAR);
    PRAGMA INTERFACE (C, copyfrombuf);                      -- 8 (see psdicd.c)
  PROCEDURE copyfrombufbinary(a OUT RAW , pos IN OUT BINARY_INTEGER, 
      buf IN CHAR);
    PRAGMA INTERFACE (C, copyfrombufbinary);                -- 9 (see psdicd.c)
  PROCEDURE copyfrombufrowid(a OUT ROWID, pos IN OUT BINARY_INTEGER, 
      buf IN CHAR);
    PRAGMA INTERFACE (C, copyfrombufrowid);                 -- 10 (see psdicd.c)

  FUNCTION gettypefrombuf(pos IN BINARY_INTEGER, buf IN CHAR) 
      RETURN BINARY_INTEGER;
    PRAGMA INTERFACE (C, gettypefrombuf);                   -- 11 (see psdicd.c)



  PROCEDURE pack(item IN VARCHAR2,
                 buffer IN OUT CHAR,
                 position IN OUT BINARY_INTEGER) IS 
  BEGIN
    copyintobuf(item, position, buffer);
  END;
  PROCEDURE pack_raw(item IN RAW,
                     buffer IN OUT CHAR,
                     position IN OUT BINARY_INTEGER) IS 
  BEGIN
    copyintobufbinary(item, position, buffer);
  END;
  PROCEDURE pack_rowid(item IN ROWID,
                       buffer IN OUT CHAR,
                       position IN OUT BINARY_INTEGER) IS 
  BEGIN
    copyintobufrowid(item, position, buffer);
  END;
  PROCEDURE pack(item IN NUMBER,
                 buffer IN OUT CHAR,
                 position IN OUT BINARY_INTEGER) IS 
  BEGIN
    copyintobuf(item, position, buffer);
  END;
  PROCEDURE pack(item IN DATE,
                 buffer IN OUT CHAR,
                 position IN OUT BINARY_INTEGER) IS 
  BEGIN
    copyintobuf(item, position, buffer);
  END;

  PROCEDURE unpack(item OUT VARCHAR2,
                   buffer IN OUT CHAR,
                   position IN OUT BINARY_INTEGER) IS
  BEGIN
    copyfrombuf(item, position, buffer);
  END;

  PROCEDURE unpack_raw(item OUT RAW,
                       buffer IN OUT CHAR,
                       position IN OUT BINARY_INTEGER) IS
  BEGIN
    copyfrombufbinary(item, position, buffer);
  END;
  PROCEDURE unpack_rowid(item OUT ROWID,
                         buffer IN OUT CHAR,
                         position IN OUT BINARY_INTEGER) IS
  BEGIN
    copyfrombufrowid(item, position, buffer);
  END;
  PROCEDURE unpack(item OUT NUMBER,
                   buffer IN OUT CHAR,
                   position IN OUT BINARY_INTEGER) IS 
  BEGIN
    copyfrombuf(item, position, buffer);
  END;
  PROCEDURE unpack(item out date,
                   buffer IN OUT char,
                   position IN OUT BINARY_INTEGER) IS 
   BEGIN
    copyfrombuf(item, position, buffer);
  END;

  FUNCTION next_item_type(buffer   IN char,
                          position IN binary_integer)
    RETURN INTEGER IS
  BEGIN
    RETURN gettypefrombuf(position, buffer);
  END;

  PROCEDURE reset_buffer(buffer   IN OUT CHAR,
                         position OUT    BINARY_INTEGER) is
  BEGIN
    position := 0;
  END;
END dbms_defer_pack;
/


REM ********************************************************************
REM THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
REM COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE
REM RDBMS.  
REM ********************************************************************

CREATE OR REPLACE PACKAGE dbms_asyncrpc IS
  -------------------
  --  OVERVIEW
  -- 
  -- This package is the interface to the kernel streaming rpc service.
  ------------
  --  SECURITY
  --
  -- Execute on this packages should only be granted to user 'REPLICATION'
  -- owner of the dbms_defer_sys package.
  ----------------------
  --  PROCEDURES
  --

  PROCEDURE push_pending_calls(rpi_cursor  IN BINARY_INTEGER,
                               nodename    IN VARCHAR2,
                               buffer_size IN BINARY_INTEGER);
    PRAGMA INTERFACE (C,  push_pending_calls);		-- 1 (see psdicd.c)  
  --  Execute deferred RPCs at nodename using kernel streaming rpc service.
  --  Input parameters:
  --    rpi_cursor
  --      Identifier (derived with the dbms_sql.get_rpi_cursor call) that 
  --      be used with kernel rpi calls for a cursors that has been parsed
  --      with a sql statement like:
  --      SELECT callno, buffer_number, schemaname, packagename, procname, 
  --             argcount, parm_buffer
  --        FROM def$_call
  --        WHERE deferred_tran_db = :localnode AND
  --              defered_tran_id  = :tranid
  --        ORDER BY callno, buffer_number;
  --      The bind variables have alreay been bound.  push_pending_calls will 
  --      define column variables and fetch results.  The cursor is never 
  --      closed by push_pending_calls.
  --      This query provides the sequence of calls (with their parameters 
  --      encoded in the parm_buffer field for a single transaction deferred 
  --      for execution at the dblink identified by  nodename.
  --    nodename
  --      node (dblink) to execute calls at.  dblink is resolved by...
  --    buffer_size
  --      largest buffer (in bytest) needed to hold the value of the 
  --      buffer column in the query
  --  Exceptions
  --    As encountered during execution of calls. 
  PROCEDURE error_call_position(nodename IN  VARCHAR2,
                                position OUT BINARY_INTEGER);
  --  Return the position (1 based) within the transaciton of a call
  --  That encountered an error.  Not valid other than after an error has
  --  occurred.
  --  INPUT PARAMETERS
  --    nodename
  --      node (dblink) to execute calls at.  dblink is resolved by...
  --    position
  --      the position in the stream of the call that encountered the
  --      error.
  

END dbms_asyncrpc;
/

CREATE OR REPLACE PACKAGE BODY dbms_asyncrpc AS

PROCEDURE psdgep(nodename     IN  VARCHAR2,
                 functiontype OUT BINARY_INTEGER,
                 position     OUT BINARY_INTEGER,
                 identifier   OUT BINARY_INTEGER);
PRAGMA INTERFACE(C, psdgep);                         -- 2 (see psdicd.c)  

PROCEDURE error_call_position(nodename IN  VARCHAR2,
                              position OUT BINARY_INTEGER) IS
fcn BINARY_INTEGER;
idn BINARY_INTEGER;
BEGIN
  psdgep(nodename,fcn,position,idn);
END error_call_position;

END dbms_asyncrpc;
/
  
drop public synonym dbms_asyncrpc;
/
create public synonym dbms_asyncrpc for sys.dbms_asyncrpc;
/
-- grant below is probably desired for use of this package by replication
-- grant execute on sys.dbms_asyncrpc to replication;
/

