rem
rem $Header: dbmsgen.sql 7020200.1 95/02/15 18:31:49 cli Generic<base> $ 
rem
Rem  Copyright (c) 1993 by Oracle Corporation 
Rem    NAME
Rem     dbmsgen.sql - Replication code generators.
Rem          
Rem    DESCRIPTION
Rem     Routines to generate shadow tables, triggers, and packages for
Rem     table replication.
Rem     Routines to generate wrappers for replication of standalone procedure
Rem     invocations, and packaged procedure invocations.
Rem     Routines which support generated replication code.  
Rem    
Rem    RETURNS
Rem     None
Rem     
Rem    NOTES
Rem      The procedural option is needed to use this facility.
Rem
Rem      This package is installed by sys (connect internal).
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     jstamos    11/11/94 -  merge changes from branch 1.1.710.7
Rem     adowning   10/13/94 -  merge rev 1.1.710.4
Rem     adowning   09/21/94 -  improved comments
Rem     ldoo       08/18/94 -  Changed to use columns in the column group
Rem                            instead of parameter columns in the if
Rem                            ignore_discard_flag then section of user funcs.
Rem     adowning   08/10/94 -  Move dbms_maint_gen to prvt from dbms
Rem     ldoo       07/19/94 -  Took out FLOAT as a valid column datatype.
Rem     ldoo       06/23/94 -  Added automatic conflict resolution.
Rem     ldoo       05/09/94 -  Changed the generated trigger by replacing
Rem                            dbms_defer arg calls with dbms_reputil arg
Rem                            calls.  Hence reduce size and enhance speed.
Rem                            Added arg call procedures in dbms_reputil pkg.
Rem     ldoo       03/02/94 -  The argument$.type for ROWID is 69 not 11.
Rem                         -  Default for generate_wrapper_package.procedure_
Rem                            prefix should be NULL.
Rem                         -  Proper error message for attempt to wrap func.
Rem     ldoo       02/25/94 -  Fixed plsql parser bug workaround.
Rem                         -  Do not validate generate_trigger.package_name.
Rem     ldoo       02/18/94 -  Skip LONG and LONG RAW columns in row/col repl.
Rem                         -  Fixed hanging is_dest_node_provided function.
Rem     ldoo       02/17/94 -  Workaround plsql parser bug by adding () to
Rem                            every ten AND clauses in the generated package.
Rem     ldoo       01/21/94 -  Fixed to support mixed-case object names.
Rem     ldoo       01/18/94 -  Added 2 more in parameters to 
Rem                              generate_wrapper_package.
Rem                            Use array parsing.
Rem                            Removed commit statement.
Rem                            Replaced some functions with shared ones.
Rem     ldoo       12/17/93 -  Fixed bug about having extra ');' for
Rem                              column-level replication.
Rem                            Fixed bug about not preserving user-assigned
Rem                              package_name and trigger_name.  
Rem                            Uppercased 'p', '$rp', 't' and '$rt'.
Rem                            Validated IN parameter values.
Rem                            Defaulted USER if output_table is not prefixed
Rem                              with schema name.
Rem                            Double quoted column names in generated trigger.
Rem                            Modified already_exists() to use dba views. 
Rem                            Loop until generated package/trigger name is
Rem                              unique.
Rem     ldoo       10/18/93 -  Eliminated IN OUT parameters.  Supports Remote-
Rem                            Only, Synchronous, and Mixed Replications. 
Rem     dsdaniel   09/01/93 -  split into multiple packages, merged in dbmsrepu
Rem     ldoo       08/25/93 -  Coded to the 8/20 version of spec.
Rem     bsouder    08/13/93 -  minor beautification, corrected dbms_snapshot
Rem                            call
Rem     celsbern   08/13/93 -  added comments
Rem     ldoo	   08/13/93 -  Creation to RDBMS spec.

CREATE OR REPLACE PACKAGE dbms_defergen IS

  ------------
  --  OVERVIEW
  -- 
  --  This package provides support for the generation of triggers and 
  --  procedures used in table replication, updatable snapshots, and 
  --  invocation replication of procedures and packages. 
  --  Use of the replication catalog and the output of this package provide
  --  a asynchronous replication of data between different databases.

  -----------------
  --  NEW DATATYPES
  --
  TYPE V128Tab IS TABLE OF VARCHAR2(128)
    INDEX BY BINARY_INTEGER;
  -- Used as temporary storage of destination node names.

  TYPE V92Tab IS TABLE OF VARCHAR2(92)
    INDEX BY BINARY_INTEGER;
  -- Used as temporary storage of conflict resolution routine names.

  TYPE V30Tab IS TABLE OF VARCHAR2(30)
    INDEX BY BINARY_INTEGER;
  -- Used as temporary storage of column names, table names, package names,
  -- procedure names and data types as each trigger or procedure is 
  -- built.  

  TYPE V1Tab IS TABLE OF VARCHAR2(1)
    INDEX BY BINARY_INTEGER;
  -- Used as temporary storage of flag whether columns are nullable or not.

  TYPE BoolTab IS TABLE OF BOOLEAN
    INDEX BY BINARY_INTEGER;
  -- Used to pass switches to control various generator options.

  TYPE NumTab IS TABLE OF NUMBER
    INDEX BY BINARY_INTEGER;
  -- Used as temporary storage of column lengths and procedure overload number.


  --------------------
  --  GLOBAL VARIABLES
  --
  INIT_V128Tab V128Tab;  -- Used to default list of destination node names.


  -----------------
  -- ERROR MESSAGES
  --
  missschema_num NUMBER := -23306;
  -- "schema %s does not exist"

  missobj_num NUMBER := -23308;
  -- "object %s does not exist or is invalid"

  misspk_num NUMBER := -23346;
  -- "primary key is undefined for table %s"

  datatypefail_num NUMBER := -23347;
  -- "datatype %s for column \"%s\" table %s not supported"

  pmodefail_num NUMBER := -23348;
  -- "cannot replicate procedure %s; only IN parameters supported"

  progfail_num NUMBER := -23349;
  -- "cannot generate replication support for functions"

  recurfail_num NUMBER := -23350;
  -- "maximum number of recursive calls exceeded"

  ptypefail_num NUMBER := -23351;
  -- "parameter datatype %s for procedure %s not supported"

  ----------------------------
  --  PROCEDURES AND FUNCTIONS
  --
  PROCEDURE create_audit_table(table_schema  IN  VARCHAR2,
                               table_name    IN  VARCHAR2,
                               audit_table   IN  VARCHAR2,
                               key_columns   IN  V30Tab,
                               do_ddl        IN  BOOLEAN,
                               output_table  IN  VARCHAR2,
                               name_assigned OUT VARCHAR2);
  -- Create a shadow table for the given table if necessary.  
  -- Input parameters:
  --  schema_name The name of the schema containing the table to be
  --    replicated.  Defaults to invoking user.
  --  table_name The name of the table being replicated.
  --  audit_table The name to be assigned to the shadow table being
  --    created.  If null, the shadow table name is generated.
  --  key_columns List of columns that constitute the primary key for the
  --    shadow table.  If null, the database dictionary is used to
  --    determine the primary key.
  --  do_ddl If TRUE (the default) the DDL generated is executed.  If FALSE,
  --    then output_table should be specified so that the DDL generated
  --    will be saved in a table.  
  --  output_table The name of the table to write the DDL to (if not NULL). 
  --    The table must have a format compatible with the following:
  --
  --                  Column Name  Data Type
  --                  -----------  ---------
  --                  name         varchar2(30)
  --                  type         varchar2(12)
  --                  linenum      number
  --                  text         varchar2(255)
  --
  --    Both do_ddl and an output table may be specified.  
  -- Output parameter:
  --  name_assigned The name actually assigned to the shadow table.  Because
  --    of conflicts, this is not always predictable if the audit_table
  --    input is not specified.  This value is needed as input to both
  --    generate_package and generate_triggers procedures.
  -- Exceptions: TBD

  PROCEDURE alter_audit_table(table_schema  IN     VARCHAR2,
                              audit_table   IN     VARCHAR2,
                              do_ddl        IN     BOOLEAN,
                              output_table  IN     VARCHAR2,
                              ddl_string    IN OUT dbms_sys_sql.varchar2s);
  -- Modify the given shadow table if necessary.  New columns may be added to
  -- the shadow table.  
  -- Input parameters:
  --  schema_name The name of the schema containing the table to be replicated.
  --    Defaults to invoking user.
  --  table_name The name of the table being replicated.
  --  audit_table The name of the shadow table.  
  --  do_ddl If TRUE (the default) the DDL generated is executed.  If FALSE,
  --    then output_table should be specified so that the DDL generated
  --    will be saved in a table.  
  --  output_table The name of the table to write the DDL to (if not NULL). 
  --    The table must have a format compatible with the following:
  --
  --                  Column Name  Data Type
  --                  -----------  ---------
  --                  name         varchar2(30)
  --                  type         varchar2(12)
  --                  linenum      number
  --                  text         varchar2(255)
  --
  --    Both do_ddl and an output table may be specified.  
  -- Output parameter:
  --  ddl_string The DDL string for altering the shadow table.  
  -- Exceptions: TBD

  PROCEDURE generate_audit_package(table_schema          IN  VARCHAR2,
                                   table_name            IN  VARCHAR2,
                                   package_name          IN  VARCHAR2,
                                   do_ddl                IN  BOOLEAN,
                                   output_table          IN  VARCHAR2,
                                   name_assigned         OUT VARCHAR2);
  -- For the given table, generate the package that contains just package
  -- variables used for passing old audit column values from the replication
  -- update procedure to the replication trigger.  
  -- Input parameters:
  --  schema_name The name of the schema containing the table to be replicated.
  --    Defaults to invoking user.
  --  table_name The name of the table being replicated.
  --  package_name The name to be assigned to the package being created.  
  --    If null, the package name is generated.  If non-null,
  --    CREATE OR REPLACE PACKAGE is used to replace the package
  --    even if a package with that name already exists.
  --  do_ddl If TRUE (the default) the DDL generated is executed.  If FALSE,
  --    then output_table should be specified so that the DDL generated
  --    will be saved in a table.  
  --  output_table The name of the table to write the DDL to (if not NULL). 
  --    The table must have a format compatible with the following:
  --
  --                  Column Name  Data Type
  --                  -----------  ---------
  --                  name         varchar2(30)
  --                  type         varchar2(12)
  --                  linenum      number
  --                  text         varchar2(255)
  --
  --    Both do_ddl and an output table may be specified.  
  -- Output parameter:
  --  name_assigned The name actually assigned to the package.  Because of
  --    conflicts, this is not always predictable if the
  --    package_name input is not specified.  This value is needed
  --    as input to both generate_package and generate_triggers
  --    procedures.
  -- Exceptions: TBD

  PROCEDURE generate_priority_package(table_schema          IN  VARCHAR2,
                                      package_name          IN  VARCHAR2,
                                      do_ddl                IN  BOOLEAN,
                                      output_table          IN  VARCHAR2,
                                      name_assigned         OUT VARCHAR2);
  -- Generate the package that contains functions used for resolving conflicts
  -- by priority groups.    
  -- Input parameters:
  --  schema_name The name of the repschema.  Defaults to invoking user.
  --  package_name The name to be assigned to the package being created.  If
  --    null, the package name is generated.  If non-null,
  --    CREATE OR REPLACE PACKAGE is used to replace the package
  --    even if a package with that name already exists.
  --  do_ddl If TRUE (the default) the DDL generated is executed.  If FALSE,
  --    then output_table should be specified so that the DDL generated
  --    will be saved in a table.  
  --  output_table The name of the table to write the DDL to (if not NULL).
  --    The table must have a format compatible with the following:
  --
  --                  Column Name  Data Type
  --                  -----------  ---------
  --                  name         varchar2(30)
  --                  type         varchar2(12)
  --                  linenum      number
  --                  text         varchar2(255)
  --
  --    Both do_ddl and an output table may be specified.  
  -- Output parameter:
  --  name_assigned The name actually assigned to the package.  Because of
  --    conflicts, this is not always predictable if the
  --    package_name input is not specified.  This value is needed
  --    as input to generate_resolution_package procedure.  
  -- Exceptions: TBD

  PROCEDURE generate_package(table_schema       IN  VARCHAR2,
                             table_name         IN  VARCHAR2,
                             repl_package       IN  VARCHAR2,
                             reso_package       IN  VARCHAR2,
                             key_columns        IN  V30Tab,
                             audit_table        IN  VARCHAR2,
                             audit_package      IN  VARCHAR2,
  --                           ins_conflict_proc IN  V92Tab,
  --                           upd_conflict_proc IN  V92Tab,
  --                           del_conflict_proc IN  V92Tab,
                             do_ddl             IN  BOOLEAN,
                             output_table       IN  VARCHAR2,
                             repl_name_assigned OUT VARCHAR2,
                             reso_name_assigned OUT VARCHAR2);
  -- Generate the replication package for a table.  
  -- Input parameters:
  --  table_schema The name of the schema containing the table to be
  --    replicated.  Defaulting to invoking user.  
  --  table_name The name of the table being replicated.  
  --  repl_package The name to be assigned to the replication package being
  --    created.  If null, the package name is generated.  If non-null,
  --    CREATE OR REPLACE PACKAGE is used to replace the package even if a
  --    package with that name already exists.  
  --  reso_package The name to be assigned to the resolution package being
  --    created.  If null, the package name is generated.  If non-null,
  --    CREATE OR REPLACE PACKAGE is used to replace the package even if a
  --    package with that name already exists.  
  --  key_columns List of columns that constitute the primary key for the
  --    replicated table.  If null, the database dictionary is used to
  --    determine the primary key.  
  --  audit_table The name of the shadow table if automatic generation of
  --    audit information is required. 
  --  audit_package The name of audit package if automatic generation of
  --    audit information is required.  
  --  do_ddl If TRUE (the default) the DDL generated is executed.  If FALSE,
  --    then output_table should be specified so the DDL generated will be
  --    saved in a table. 
  --  output_table The name of the table to write the DDL to (if not NULL). 
  --    The table must have a format compatible with the following:
  --
  --                  Column Name  Data Type
  --                  -----------  ---------
  --                  name         varchar2(30)
  --                  type         varchar2(12)
  --                  linenum      number
  --                  text         varchar2(255)
  --
  --    Both do_ddl and an output table may be specified. 
  --  Output parameters:
  --   repl_name_assigned The name actually assigned to the replication
  --     package.  Because of conflicts, this is not always predictable if the
  --     repl_package input is not specified.  This value is needed as input to
  --     generate_triggers. 
  --   reso_name_assigned The name actually assigned to the resolution
  --     package.  Because of conflicts, this is not always predictable if the
  --     reso_package input is not specified. 
  -- Exceptions: TBD

  PROCEDURE generate_triggers(table_schema  IN  VARCHAR2,
                              table_name    IN  VARCHAR2,
                              trigger_name  IN  VARCHAR2,
                              package_name  IN  VARCHAR2,
                              key_columns   IN  V30Tab,
                              audit_table   IN  VARCHAR2,
                              audit_package IN  VARCHAR2,
                              do_ddl        IN  BOOLEAN,
                              output_table  IN  VARCHAR2,
                              name_assigned OUT VARCHAR2,
                              dest_node     IN  V128Tab default INIT_V128Tab);
  -- Generate the replication trigger for a table.
  -- Input parameters:
  --  table_schema The name of the schema containing the table to be
  --    replicated.  Defaulting to invoking user.  
  --  table_name The name of the table being replicated. 
  --  trigger_name The name to be assigned to the trigger being created. If
  --    null, the trigger name is generated.  If not null, the trigger will
  --    replace an existing trigger with the same name. 
  --  package_name The name of the package that the generated triggers defer
  --    calls to.  If null, the name is derived from the table name. 
  --  key_columns List of columns that constitute the primary key for the
  --    replicated table.  If null, the database dictionary is used to
  --    determine the primary key.  
  --  audit_table The name of the shadow table if automatic generation of
  --    audit information is required. 
  --  audit_package The name of audit package if automatic generation of
  --    audit information is required. 
  --  do_ddl If TRUE (the default) the DDL generated is executed.  If FALSE,
  --    then output_table should be specified so the DDL generated will be
  --    saved in a table. 
  --  output_table The name of the table to write the DDL to (if not NULL).
  --    The table must have a format compatible with the following:
  --
  --                  Column Name  Data Type
  --                  -----------  ---------
  --                  name         varchar2(30)
  --                  type         varchar2(12)
  --                  linenum      number
  --                  text         varchar2(255)
  --
  --    Both do_ddl and an output table may be specified. 
  --  dest_node If synchronously replicated, specify here the list of
  --    destination nodes; otherwise, leave it NULL. 
  -- Output parameter:
  --  name_assigned The name actually assigned to the trigger.  Because of
  --    conflicts, this is not always predictable if the trigger_name input is
  --    not specified.  
  -- Exceptions: TBD

  PROCEDURE generate_wrapper_package(sname            IN  VARCHAR2,
                                     pkg              IN  VARCHAR2,
                                     package_prefix   IN  VARCHAR2,
                                     procedure_prefix IN  VARCHAR2,
                                     do_ddl           IN  BOOLEAN,
                                     output_table     IN  VARCHAR2,
                                     generate_package IN  BOOLEAN,
                                     generate_body    IN  BOOLEAN,
                                     name_assigned    OUT VARCHAR2,
                                     call_local       IN  BOOLEAN
                                                                 default FALSE,
                                     mixed_replmethod IN  BOOLEAN
                                                                 default FALSE,
                                     dest_node        IN  V128Tab
                                                         default INIT_V128Tab);
  -- Generate a wrapper package for the given package.
  -- Input parameters:
  --  sname The name of the replicated schema.  Defaulting to invoking user.  
  --  pkg The replicated package. 
  --  package_prefix The prefix for the new package.  Defaulting to 'DEFER_'.
  --  procedure_prefix The prefix for each new procedure.
  --  do_ddl If TRUE (the default) the DDL generated is executed.  If FALSE,
  --    then output_table should be specified so the DDL generated will be
  --    saved in a table. 
  --  output_table The name of the table to write the DDL to (if not NULL).
  --    The table must have a format compatible with the following:
  --
  --                  Column Name  Data Type
  --                  -----------  ---------
  --                  name         varchar2(30)
  --                  type         varchar2(12)
  --                  linenum      number
  --                  text         varchar2(255)
  --
  --    Both do_ddl and an output table may be specified. 
  --  generate_package If FALSE, do not generate the package specification.
  --    Default to TRUE, generate the package specification.
  --  generate_body If FALSE, do not generate the package body.  Default to
  --    TRUE, generate the package body.
  --  call_local If TRUE, the generated code will call the package locally.
  --    Default to FALSE, the generated code will not call the package locally.
  --  mixed_replmethod If TRUE, the generated code allows mixing of table
  --    replication and procedure invocation replication.   Default to FALSE.
  --  dest_node If synchronously replicated, specify here the list of
  --    destination nodes; otherwise, leave it NULL. 
  -- Output parameter:
  --  name_assigned The name actually assigned to the new package.  Because of
  --    conflicts, this is not always predictable if the package_prefix 
  --    input is not specified.  
  -- Exceptions: TBD

  PROCEDURE generate_wrapper_procedure(sname            IN  VARCHAR2,
                                       proc             IN  VARCHAR2,
                                       prefix           IN  VARCHAR2,
                                       do_ddl           IN  BOOLEAN,
                                       output_table     IN  VARCHAR2,
                                       name_assigned    OUT VARCHAR2,
                                       call_local       IN  BOOLEAN
                                                                 default FALSE,
                                       mixed_replmethod IN  BOOLEAN
                                                                 default FALSE,
                                       dest_node        IN  V128Tab
                                                         default INIT_V128Tab);
  -- Generate a wrapper procedure for the given procedure.
  -- Input parameters:
  --  sname The name of the replicated schema.  Defaulting to invoking user.  
  --  proc The replicated procedure. 
  --  prefix The prefix for the wrapper procedure.
  --  do_ddl If TRUE (the default) the DDL generated is executed.  If FALSE,
  --    then output_table should be specified so the DDL generated will be
  --    saved in a table. 
  --  output_table The name of the table to write the DDL to (if not NULL).
  --    The table must have a format compatible with the following:
  --
  --                  Column Name  Data Type
  --                  -----------  ---------
  --                  name         varchar2(30)
  --                  type         varchar2(12)
  --                  linenum      number
  --                  text         varchar2(255)
  --
  --    Both do_ddl and an output table may be specified. 
  --  call_local If TRUE, the generated code will call the package locally.
  --    Default to FALSE, the generated code will not call the package locally.
  --  mixed_replmethod If TRUE, the generated code allows mixing of table
  --    replication and procedure invocation replication.   Default to FALSE.
  --  dest_node If synchronously replicated, specify here the list of
  --    destination nodes; otherwise, leave it NULL. 
  -- Output parameter:
  --  name_assigned The name actually assigned to the wrapper procedure.
  --    Because of conflicts, this is not always predictable if the prefix 
  --    input is not specified.  
  -- Exceptions: TBD

END dbms_defergen;
/

DROP PUBLIC SYNONYM dbms_defergen;

CREATE PUBLIC SYNONYM dbms_defergen for dbms_defergen;

CREATE OR REPLACE PACKAGE dbms_reputil AS

  ------------
  --  OVERVIEW
  --
  --  This package is referenced only by the generated code.

  -------------------
  -- GLOBAL VARIABLES
  --
  replication_is_on BOOLEAN;  -- If false, do not forward/defer the update.
  from_remote BOOLEAN;        -- If false, the update is local.
  global_name VARCHAR2(128);  -- The global name of the local database.

  ---------------------------
  -- PROCEDURES AND FUNCTIONS
  --
  PROCEDURE replication_on;
  -- Turn on replication.

  PROCEDURE replication_off;
  -- Turn off replication.

  --
  -- Automatic conflict resolution logic.
  --
  PROCEDURE recursion_on;
  -- Keep track of the number of recursion.  

  PROCEDURE recursion_off;
  -- The number of recursion is initialized to zero.

  PROCEDURE rep_begin;
  -- Initialization at the beginning of each rep_delete, rep_insert, and 
  -- rep_update.

  PROCEDURE rep_end;
  -- Clean up at the end of each rep_delete, rep_insert, and rep_update.

  FUNCTION get_constraint_name(errmsg IN VARCHAR2)
    RETURN VARCHAR2;
  -- Return the name of the uniqueness contraint in the ORA error message. 

  FUNCTION minimum(new                 IN  NUMBER,
                   cur                 IN  NUMBER,
                   ignore_discard_flag OUT BOOLEAN)
    RETURN BOOLEAN;
  -- If new > cur, then ignore_discard_flag is TRUE; otherwise it is FALSE.
  -- Return FALSE if any input parameter is null; otherwise return TRUE.

  FUNCTION minimum(new                 IN  VARCHAR2,
                   cur                 IN  VARCHAR2,
                   ignore_discard_flag OUT BOOLEAN)
    RETURN BOOLEAN;
  -- If new > cur, then ignore_discard_flag is TRUE; otherwise it is FALSE.
  -- Return FALSE if any input parameter is null; otherwise return TRUE.

  FUNCTION minimum(new                 IN  DATE,
                   cur                 IN  DATE,
                   ignore_discard_flag OUT BOOLEAN)
    RETURN BOOLEAN;
  -- If new > cur, then ignore_discard_flag is TRUE; otherwise it is FALSE.
  -- Return FALSE if any input parameter is null; otherwise return TRUE.

  FUNCTION maximum(new                 IN  NUMBER,
                   cur                 IN  NUMBER,
                   ignore_discard_flag OUT BOOLEAN)
    RETURN BOOLEAN;
  -- If new < cur, then ignore_discard_flag is TRUE; otherwise it is FALSE.
  -- Return FALSE if any input parameter is null; otherwise return TRUE.

  FUNCTION maximum(new                 IN  VARCHAR2,
                   cur                 IN  VARCHAR2,
                   ignore_discard_flag OUT BOOLEAN)
    RETURN BOOLEAN;
  -- If new < cur, then ignore_discard_flag is TRUE; otherwise it is FALSE.
  -- Return FALSE if any input parameter is null; otherwise return TRUE.

  FUNCTION maximum(new                 IN  DATE,
                   cur                 IN  DATE,
                   ignore_discard_flag OUT BOOLEAN)
    RETURN BOOLEAN;
  -- If new < cur, then ignore_discard_flag is TRUE; otherwise it is FALSE.
  -- Return FALSE if any input parameter is null; otherwise return TRUE.

  FUNCTION average(new                 IN OUT NUMBER,
                   cur                 IN     NUMBER,
                   ignore_discard_flag OUT    BOOLEAN)
    RETURN BOOLEAN;
  -- Output new as the average of new + old.
  -- Ignore_discard_flag is always FALSE.
  -- Return FALSE if any input parameter is null; otherwise return TRUE.

  FUNCTION additive(old                 IN     NUMBER,
                    new                 IN OUT NUMBER,
                    cur                 IN     NUMBER,
                    ignore_discard_flag OUT    BOOLEAN)
    RETURN BOOLEAN;
  -- Output new as cur + (new - old).  Ignore_discard_flag is always FALSE.
  -- Return FALSE if any input parameter is null; otherwise return TRUE.

  FUNCTION discard(ignore_discard_flag OUT BOOLEAN)
    RETURN BOOLEAN;
  -- Ignore_discard_flag is always TRUE.
  -- Always return TRUE.

  FUNCTION overwrite(ignore_discard_flag OUT BOOLEAN)
    RETURN BOOLEAN;
  -- Ignore_discard_flag is always FALSE.
  -- Always return TRUE.

  FUNCTION append_site_name(new                 IN OUT VARCHAR2,
                            str                 IN     VARCHAR2,
                            max_len             IN     NUMBER,
                            ignore_discard_flag OUT    BOOLEAN)
    RETURN BOOLEAN;
  -- Output new with str appended to it. Ignore_discard_flag is always FALSE.
  -- Return FALSE if any input parameter is null or the length of str plus one
  -- is greater than max_len; otherwise return TRUE.

  FUNCTION append_sequence(new                 IN OUT VARCHAR2,
                           max_len             IN     NUMBER,
                           ignore_discard_flag OUT    BOOLEAN)
    RETURN BOOLEAN;
  -- Output new with a sequence generated number appended to it.
  -- Ignore_discard_flag is always FALSE.  
  -- Return FALSE if any input parameter is null or the length of the generated
  -- number is greater than max_len; otherwise return TRUE.

  --
  -- A hack to make the trigger smaller and run faster.
  --
  PROCEDURE number_arg   (old  IN NUMBER,
                          new  IN NUMBER,
                          flag IN CHAR);
  -- Cover routine for dbms_defer.number_arg.  Using flag to determine whether
  -- to defer old or new or both.  Valid flag values are: 'I', 'D', and 'U'.

  PROCEDURE date_arg     (old  IN DATE,
                          new  IN DATE,
                          flag IN CHAR);
  -- Cover routine for dbms_defer.date_arg.  Using flag to determine whether
  -- to defer old or new or both.  Valid flag values are: 'I', 'D', and 'U'.

  PROCEDURE varchar2_arg (old  IN VARCHAR2,
                          new  IN VARCHAR2,
                          flag IN CHAR);
  -- Cover routine for dbms_defer.varchar2_arg. Using flag to determine whether
  -- to defer old or new or both.  Valid flag values are: 'I', 'D', and 'U'.

  PROCEDURE char_arg     (old  IN CHAR,
                          new  IN CHAR,
                          flag IN CHAR);
  -- Cover routine for dbms_defer.char_arg.  Using flag to determine whether
  -- to defer old or new or both.  Valid flag values are: 'I', 'D', and 'U'.

  PROCEDURE rowid_arg    (old  IN ROWID,
                          new  IN ROWID,
                          flag IN CHAR);
  -- Cover routine for dbms_defer.rowid_arg.  Using flag to determine whether
  -- to defer old or new or both.  Valid flag values are: 'I', 'D', and 'U'.

  PROCEDURE raw_arg      (old  IN RAW,
                          new  IN RAW,
                          flag IN CHAR);
  -- Cover routine for dbms_defer.raw_arg.  Using flag to determine whether
  -- to defer old or new or both.  Valid flag values are: 'I', 'D', and 'U'.

  PROCEDURE enter_statistics(sname             IN VARCHAR2,
                             oname             IN VARCHAR2,
                             conflict_type     IN VARCHAR2,
                             reference_name    IN VARCHAR2,
                             method_name       IN VARCHAR2,
                             function_name     IN VARCHAR2,
                             priority_group    IN VARCHAR2,
                             primary_key_value IN VARCHAR2,
                             resolved_date     IN DATE default SYSDATE);
  -- Record that the given conflict has been resolved with the given
  -- resolution.
  -- Input parameters:
  --  sname The name of the schema containing the table to be replicated.
  --  oname The name of the table being replicated.
  --  conflict_type The type of conflict.  Valid values are: `UPDATE',
  --    `UNIQUENESS', and `DELETE'.
  --  reference_name If the conflict type is 'DELETE', enter the replicated
  --    table name here.  If the conflict type is `UPDATE', enter the column
  --    group name here.  If the conflict type is `UNIQUE CONSTRAINT', enter
  --    the unique constraint name here.
  --  method_name The conflict resolution method.
  --  function_name If the method is 'USER FUNCTION', enter the user
  --    resolution function name here.
  --  priority_group If the method is `PRIORITY GROUP', enter the name of
  --    priority group used for resolving the conflict.
  --  primary_key_value The primary key value for the row whose conflict is
  --    being resolved.  
  --  resolved_date The date at which the conflict is resolved.  

END dbms_reputil;
/

DROP PUBLIC SYNONYM dbms_reputil;

CREATE PUBLIC SYNONYM dbms_reputil FOR dbms_reputil;

GRANT EXECUTE ON dbms_reputil TO PUBLIC;


