rem 
rem $Header: dbmsrrpc.sql 7020100.1 94/09/23 22:14:45 cli Generic<base> $ 
rem 
Rem  Copyright (c) 1993 by Oracle Corporation 
Rem  Copyright (c) 1992,1993 by Oracle Corporation
Rem  ***** Oracle Propriatary                                           *****
Rem  ***** This file contains the embodyment of propriatary technology. *****
Rem  ***** It is for the sole use of Oracle employees and Oracle        *****
Rem  ***** customers who have executed non-disclousure agreements.      *****
Rem  ***** The contents of this file may not be disclosed to persons    *****
Rem  ***** or organization who have not executed a non-disclousure      *****
Rem  ***** agreement.                                                   *****
Rem    NAME
Rem      dbmsrrpc.sql - replicated deferred remote procedure calls
Rem    DESCRIPTION
Rem      This file contains sql which creates the base tables
Rem      used to store deferred remote procedure calls for used in
Rem      transaction replication.
Rem      The external interfaces and bodies of two replication packages are 
Rem      also included, as are some sequences used by the packages.
Rem      All objects  are created in the schema 'REPLICATION'.
Rem      Tables:
Rem         defErrors
Rem         defTranDest
Rem         defCallDest
Rem         defDefaultDest
Rem         defTran
Rem         defCall
Rem       Packages
Rem         dbms_defer
Rem         dbms_defer_query
Rem         dbms_defer_sys
Rem         dbms_defer_pack
Rem         dbms_asyncrpc
Rem       Sequences
Rem         defrpc$_txn_order_sequence
Rem 
Rem    NOTES
Rem      The algorithms used here were originally concieved by Sandeep
Rem	 Jain, and are described in a forthcomming memo by Sandeep Jain
Rem      and Dean Daniels Titled "A Method for Defering Remote Procedure Calls
Rem      Utilizing a Relational Database System.
Rem
Rem      The structures implemented by this package should probably be a
Rem      cluster.  The create table statements can be modified to include
Rem      storage information as appropriate for a particular installation.
Rem
Rem    DEPENDENCIES
Rem      These packages use calls from  the DBMS_SQL, DBMS_ASYNCRPC, and
Rem      DBMS_DEFER_PACK packages
Rem      
Rem    USAGE
Rem      This script is to be run by user REPLICATION, which needs DBA
Rem       priviledges.  The package dbms_defer_pack, which is an interface
Rem       to kernel data packing routines needs be be created by user sys
Rem       and granted to REPLICATION
Rem
Rem    SECURITY
Rem      Tables and sequences created by this script are kept private
Rem      The dbms_defer package is granted to public, but it is reasonable to 
Rem      restrict access
Rem      to users creating replicated applicatons.  
Rem      The dbms_defer_sys package is 
Rem      kept  private
Rem      The dbms_defer_pack package is owned by user sys because it is
Rem      an interface to kernel functions.
Rem     
Rem    COMPATIBILITY
Rem    MODIFIED   (MM/DD/YY)
Rem     dsdaniel   05/17/93 -  upgrade to 7.0/7.1 version 
Rem     dsdaniel   02/22/93 -  Creation 

Rem   *******************************************************************

DROP TABLE def$_error;
DROP TABLE def$_trandest;
DROP TABLE def$_calldest;
DROP TABLE def$_call;
DROP TABLE def$_tran;
DROP VIEW deferror;
DROP VIEW deftrandest;
DROP VIEW defcalldest;
DROP VIEW defcall;
DROP VIEW deftran;

--  create a table for deferred transactions. This has one row for 
--  each transaction.
--  transaction id size is taken from gendef.h 
CREATE TABLE def$_tran (
  deferred_tran_id VARCHAR2(22),  -- transaction id
  deferred_tran_db VARCHAR2(128), -- creation or copying node
    CONSTRAINT dfrpc$_tran_primary
      PRIMARY KEY(deferred_tran_id, deferred_tran_db),
  origin_tran_id   VARCHAR2(22),  -- original tid (if copied)
  origin_tran_db   VARCHAR2(128), -- origial  node
  origin_user      VARCHAR2(30),  -- user 
  delivery_order   NUMBER,        -- order to deliver to destinations
  destination_list CHAR(1),       -- R = RepSchema, D = def$_calldest
  start_time       DATE,          -- time original tid started
  commit_comment VARCHAR2(50));   -- commit comment
/
-- table which defines the execution order for defered transactions

--  create the call table.  One row for each deferred call.
CREATE TABLE def$_call  (
  callno            NUMBER,         -- UID of call, orders calls in transaction
  deferred_tran_db VARCHAR2(128),   -- origin
    CONSTRAINT def$_calls_primary
      PRIMARY KEY(callno, buffer_number, deferred_tran_db),
  deferred_tran_id  VARCHAR2(22),   -- transaction id
    CONSTRAINT def$_calls_prnt
       FOREIGN KEY(deferred_tran_id,  deferred_tran_db)
       REFERENCES def$_tran(deferred_tran_id, deferred_tran_db)
       ON DELETE CASCADE,
  schemaname    VARCHAR2(30),      -- schema name
  packagename   VARCHAR2(30),      -- package name
  procname      VARCHAR2(30),      -- procedue name
  argcount      NUMBER,            -- # of args 
  buffer_number NUMBER,            -- parameters buffer number 
  parm_buffer   LONG RAW);         -- parameters buffer    
/
--  create the  table that identifies a call to be executed	
--  at a remote node. One row for each callsXnode.
--  The projection of this table by node is the queue of transactions for 
--  a node.
CREATE TABLE def$_calldest(
  callno           NUMBER,        -- call id 
  deferred_tran_id VARCHAR2(22),  -- deferred transaction
  deferred_tran_db VARCHAR2(128), -- deferred transaction
  dummy_buffer_number NUMBER DEFAULT 1, -- for forign key reference
    CONSTRAINT def$_calldest_call
      FOREIGN KEY(callno, dummy_buffer_number,  deferred_tran_db)
      REFERENCES def$_call(callno, buffer_number, deferred_tran_db),
  dblink           VARCHAR2(128)  -- dblink to destination
    CONSTRAINT def$_call_dblink_null NOT NULL);
/                    
-- create the table that is the queue of transacitons for a destination
CREATE TABLE def$_trandest(
  deferred_tran_id VARCHAR2(22),  -- deferred transaction
  deferred_tran_db VARCHAR2(128), -- deferred transaction
    CONSTRAINT def$_trandest_tran
      FOREIGN KEY(deferred_tran_id, deferred_tran_db)
      REFERENCES def$_tran(deferred_tran_id, deferred_tran_db),
  dblink           VARCHAR2(128)  -- dblink to destination
    CONSTRAINT def$_trandest_dblink_null NOT NULL);
/

--  create the table where the exceptions get logged. One row for each
--  transactionXorigin_node when the execution of the transaction at 
--  this  node encountered  an error.
CREATE TABLE def$_error(
  deferred_tran_db VARCHAR2(128),  -- node origination/copying txn
  deferred_tran_id VARCHAR2(22),   -- transaction id
    CONSTRAINT def$_error_tran
      FOREIGN KEY(deferred_tran_id, deferred_tran_db)
      REFERENCES def$_tran(deferred_tran_id, deferred_tran_db),
  callno           NUMBER,           -- UID of call
-- forign key constrain on call not used.  Users can create error transacitons
-- with null or invalid callno - it is for documenation only
--  dummy_buffer_number NUMBER DEFAULT 1,
--    CONSTRAINT def$_error_call
--      FOREIGN KEY(callno, dummy_buffer_number, deferred_tran_db)
--      REFERENCES def$_call(callno, buffer_number, deferred_tran_db),
   destination     VARCHAR2(128),  -- dblink transaciton destined to
     CONSTRAINT def$_error_primary
        PRIMARY KEY(deferred_tran_id, deferred_tran_db, destination),
   error_time      DATE,           -- time at which 
                                   -- conflit occured
   error_number    NUMBER,         -- error 
                                   -- number reported
   error_msg       VARCHAR2(200)); -- error message
/
CREATE VIEW deferror AS
  SELECT deferred_tran_db, deferred_tran_id, callno, destination, 
         error_time, error_number, error_msg 
    FROM def$_error;
/
CREATE VIEW deftrandest AS
  SELECT * from def$_trandest;
/
CREATE VIEW defcalldest AS
  SELECT  callno, deferred_tran_id, deferred_tran_db, dblink
    FROM def$_calldest
/
CREATE VIEW defcall AS
  SELECT  callno, deferred_tran_db, deferred_tran_id, schemaname, packagename,
          procname, argcount 
    FROM def$_call
    WHERE buffer_number = 1;
/
CREATE VIEW deftran AS
  SELECT * from def$_tran;
/

--  Create table of default nodes for replication targets
--  this table is managed by calls in dbms_defer_sys
DROP TABLE def$_defaultdest;
DROP VIEW  defdefaultdest;
CREATE TABLE def$_defaultdest (
  dblink VARCHAR2(128)  -- dblink 
    CONSTRAINT def$_defalutdest_primary
    PRIMARY KEY);
/
CREATE VIEW defdefaultdest AS
  SELECT * from def$_defaultdest;
/



CREATE OR REPLACE PACKAGE dbms_defer AS
  -------------------
  --  OVERVIEW
  -- 
  -- This package in the user interface to a replicated transactional 
  -- deferred remote
  -- procedre call facility.  Replicated applications use the calls 
  -- in this interface
  -- to queue procedure call for later transactional execution at remote nodes.
  -- These routines are typically called from either after row triggers 
  -- or application
  -- specified update procedures.
  ------------
  --  SECURITY
  --
  -- By default, this package is granted to public, but it may be 
  -- more appropriate to
  -- restrict execution to users authorized to create replicated applications.
  -- *WARNING* Deferred RPC are executed by user REPLICATION, 
  -- which has DBA priviledges,
  -- not by the queueing user.  Thus it is potentially possible 
  -- for a user cause the
  -- execution of a procedure that he is not directly authorized to execute.
  -------------
  --  CONSTANTS
  --
  --     constants used in the arg_type column of the def$_args table
  --     definitions cpopied from dtydef.h
  --
  arg_type_num      CONSTANT NUMBER := 2;  -- DTYNUM 
  arg_type_char     CONSTANT NUMBER := 96; -- DTYAFC
  arg_type_varchar2 CONSTANT NUMBER := 1;  -- DTYCHAR
  arg_type_date     CONSTANT NUMBER := 12; -- DTYDAT
  arg_type_rowid    CONSTANT NUMBER := 11; -- DTYRID
  arg_type_raw      CONSTANT NUMBER := 23; -- DTYBIN
  --
  ---------
  --  TYPES
  --
  --    node list type used for the defer_txn call
  --      representation is an array (table) indexed from 1 up to the count
  TYPE node_list_t IS TABLE OF  VARCHAR2(128) INDEX BY BINARY_INTEGER;
  --
  -----------------
  --  EXCEPTIONS
  --
  --  Generic errors that are not important enough for specific exceptions
  --  string text will explain them further.  These are internal errors.
  dbms_defererror EXCEPTION;
  PRAGMA exception_init(dbms_defererror, -20671);
  --  
  --    dbms_defer package detects mal-formed call (e.g. argument count miss-match)
  malformedcall EXCEPTION;
  PRAGMA  exception_init(malformedcall, -20670);  
  --   generic exceptions that (user-written) defered procedures 
  --   can raise to indicate
  --   that the remote update has failed because of data updates by concurrent 
  --   transactions.  A deferror table record will be created by the deferred 
  --    rpc executor
  updateconflict  EXCEPTION;
  PRAGMA  exception_init(updateconflict, -20669);
  --   generic exceptions that (user-written) defered procedures 
  --   can raise to indicate 
  --   that the remote update has failed because communications failures
  --   so that a a deferror table record will not be created by the 
  --   deferred rpc 
  --   executor.
  commfailure  EXCEPTION;
  PRAGMA  exception_init(commfailure, -20668);
  --   mixed use repcat determined destinations and non-repca destinations
  --   in one transaction 
  mixeddest  EXCEPTION;
  PRAGMA  exception_init(mixeddest, -20667);
  --   parameter length exceed deferred rpc limits (2000 char/varchar2, 255 raw)
  --   in one transaction 
  parameterlength  EXCEPTION;
  PRAGMA  exception_init(parameterlength, -20666);
  ----------------------
  --  PROCEDURES
  --
  PROCEDURE commit_work(commit_work_comment IN VARCHAR2);
  --  Perform a transaction commmit after checking for well-formed 
  --    defered RPCs.
  --    Must be used instead of the commit work sql call for 
  --    transactions defering RPCS.
  --    Updates the comment_comment and commit_scn fields in 
  --    the def$_txn table.
  --  Input parameters:
  --    commit_work_comment
  --      Up to fifty characters to describe the transaction 
  --        in the def$_txns
  --        table and system two-phase commit tables (this latter 
  --        once we figure out
  --        how to get it in.)  Comment is truncated to fifty characters.
  --  Exceptions
  --    ORA-20670 (malformedcall) if there is an defer_rpc_arg 
  --      call missing or defer_txn
  --      was not called for this transaction.
  --
  --
  --
  --  Transaction and call deferrral procedures
  --    A defered transaction consist of the following:
  --      Call to dbms_defer.transaction (this is optional, the first call to 
  --      dbms_defer.call will call transaction)
  --      one or more complete calls, each of which consists of 
  --        Call to dbms_defer.call
  --           zero of more calls (depending on arg_count in 
  --           dbms_defer.call) to dbms_defer.arg_*
  --      commit or call to commit_work
  -- 
  --  DESTINATION SPECIFICATION
  --  Destinations can be specified in seversal ways
  --  A) All deferred procedures are in repcat and the default list is
  --     NOT specified int the transcion call.
  --  OR
  --  B) destionation are specified without repcat using the following order 
  --     of precidence
  --   1) list specified in the nodes parameter to dbms_defer.call
  --   2) list specified in the nodes parameter to dbms_defer.transaction
  --   3) list specified in defdefaultdest table.]=
  --   The mixeddest exeception is raised if an attempt to mix destinations modees
  --   is detected.
  --
  PROCEDURE transaction;
  PROCEDURE transaction(nodes      IN node_list_t,
                        node_count IN BINARY_INTEGER);
  --  Mark a transaciton as defered (as containing deferred RPCs )
  --     This call is optional.  The first call to dbms_defer.call 
  --     in a transaction will call
  --     deftxn (with no arguments) if it has not been previously called.
  --     Input parameters are optional, and if they are not 
  --     specified the destination
  --     list is taken from the system defaults stored in the 
  --     def$_defaultdest table and
  --     maintained by the dbms_defer_sys.add_default_node and 
  --     dbms_defer_sys.delete_default_node calls
  --  Input parameters:
  --    nodes
  --      Table containg a list of nodes (dblink) to propogate the 
  --      deferred calls of the 
  --        transaction to.  Indexed from 1 to node_count.  
  --        Case insensitive comparison
  --        used for node lists.
  --        Use of this parameter overrides distribution lists as 
  --        specified in repcat.
  --    node_count
  --      Count of the number of entries in nodes.
  --  Exceptions
  --    ORA-20670 (malformedcall) if the previous transaction 
  --      not correctly formed 
  --      or terminated
  ----

  PROCEDURE call( schema_name  IN VARCHAR2,
                  package_name IN VARCHAR2,
                  proc_name    IN VARCHAR2,    
                  arg_count    IN BINARY_INTEGER);

  PROCEDURE call( schema_name  IN VARCHAR2,
                  package_name IN VARCHAR2,
                  proc_name    IN VARCHAR2,    
                  arg_count    IN BINARY_INTEGER,
                  nodes        IN node_list_t,
                  node_count   IN BINARY_INTEGER);
  --  Defer a remote procedure call.  Automatically call 
  --    deftxn if this is the first
  --    call call of a transaction.
  --  Input parameters:
  --    schema_name
  --      Name of the schema containing the remote procedure.  For
  --      compatibility with future compile-time checking only string
  --      constants should be used.  
  --    package_name
  --      Name of the package containing the remote procedure.  For
  --      compatibility with future compile-time checking only string
  --      constants should be used.  
  --    proc_name
  --      Name of the remote procedure to call.  
  --        For compatibility with
  --        future syntatic integration
  --        and compile-time checking only string constants should be used.
  --    arg_count
  --       Number of parameters to the procedure.  This must 
  --       exactly match the number of
  --       defrpcarg_* calls immediatly following the dbms_defer.call call.
  --    nodes
  --      Optional table containing a list of nodes to propogate the 
  --      deferred call to.  
  --        Case insensitive comparison
  --        used for node lists.
  --      If not specified, the destination list is determined by the
  --      list passed to the transaction procedure, or the system defaults,
  --      Use of this parameter in any deferreed call invalidate the use of
  --      the use of repcat to determine distribution lists in any
  --      calls for a transaction.
  --    node_count
  --      Count of the number of entries in nodes.
  --  Exceptions  -- 
  --  Exceptions
  --    ORA-20670 (malformedcall) if the previous call not 
  --      correctly formed (number of
  --      defrpcarg_* call not matched to arg_count).
  ----

  PROCEDURE number_arg(arg IN nUMBER);
  --  Queue a number parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The number value of the parameter to the call 
  --        previously defered with a 
  --        dbms_defer.call call.
  --  Exceptions: none.
  --------

  PROCEDURE date_arg(arg IN DATE);
  --  Queue a date parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The date value of the parameter to the call previously 
  --      defered with a 
  --        dbms_defer.call call.
  --  Exceptions: none.
  --------
    
  PROCEDURE varchar2_arg(arg  IN VARCHAR2);
  --  Queue a varchar2 parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The varchar2 value of the parameter to the call 
  --        previously defered with a 
  --        dbms_defer.call call. The length of arg is limited to 2000.
  --  Exceptions: 
  --    whatever error sql gives if arg exceeds 2000 characters.

  PROCEDURE char_arg(arg  IN CHAR);
  --  Queue a char parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The char value of the parameter to the call previously 
  --        defered with a 
  --        dbms_defer.call call. The length of arg is limited to 2000.
  --  Exceptions: 
  --    whatever error sql gives if arg exceeds 2000 characters.

  ---------------------
  -- The following calls will not be supported until dbms_sql 
  -- supports rowid and raw arguments.
  -- 
  -- rowids can not be
  -- used on different nodes.  It might be reasonable to use a
  -- rid in a defered call 
  -- to a local node, but be carefull
  PROCEDURE rowid_arg(arg IN ROWID);
  --  Queue a rowid parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The rowid value of the parameter to the call 
  --        previously defered with a 
  --        dbms_defer.call call.
  --  Exceptions: 
  --    dbms_deferError
  --------

  -- The following calls will not be supported until dbms_sql 
  -- supports 
  -- 
  PROCEDURE raw_arg(arg IN raw);
  --  Queue a rowid parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The raw value of the parameter to the call 
  --        previously defered with a 
  --        dbms_defer.call call.
  --  Exceptions: 
  --    dbms_deferError
  --------
  --------
END dbms_defer;
/
--  The follwoing grant to public might be re-considered. 
--  The public synonym is 
--  probably usefull
GRANT EXECUTE ON dbms_defer TO PUBLIC;
DROP PUBLIC SYNONYM dbms_defer;
CREATE PUBLIC SYNONYM dbms_defer FOR replication.dbms_defer;



CREATE OR REPLACE PACKAGE dbms_defer_query AS
  -------------------
  --  OVERVIEW
  -- 
  -- This package permits querying the deferred RPC queu data that
  -- is not exposed through views.
  PROCEDURE  get_arg(callno           IN  NUMBER,
                     deferred_tran_db IN  VARCHAR2,
                     arg_no           IN  NUMBER,
                     arg_type         OUT NUMBER,
                     arg_num          OUT NUMBER,
                     arg_char         OUT VARCHAR2,
                     arg_date         OUT DATE,
                     arg_raw          OUT RAW,
                     arg_rowid        OUT ROWID);
  -- Retrieve data of a deferred call parameter.
  -- Input parameters
  --  callno
  --    call identifier from the defCall view
  --  deferred_tran_db 
  --    database deferring call from the defCall view
  --  arg_no
  --    postition of desired parameter  in calls argument list
  ----
  --  Output parameters
  --  arg_type
  --    determines which of the other output parameters contains the 
  --    result value.
  --  arg_num
  --    parameter value if arg_type =    arg_type_num
  --  arg_char
  --    parameter value if arg_type =    arg_type_char | arg_type_varchar2
  --  arg_date
  --    parameter value if arg_type =    arg_type_date
  --  arg_raw
  --    parameter value if arg_type =    arg_type_raw
  --  arg_rowid
  --    parameter value if arg_type =    arg_type_rowid
  ------
  --  EXCEPTIONS
  --    NO_DATA_FOUND desired parameted value not found in the deferred rpc
  --    queue tables.
  -------
END dbms_defer_query;
/
CREATE OR REPLACE PACKAGE BODY dbms_defer_query AS
  -------------------
  --  OVERVIEW
  -- 
  -- This package permits querying the deferred RPC queu data that
  -- is not exposed through views.
  -- 
  -- GLOBAL VARIABLES
  --  global variable are used to cache the parameter buffer from 
  --  the previous invocation and so avoid n^2 performance when
  --  retrieving successive parameters for a call
  last_callno  NUMBER;
  last_tran_db VARCHAR2(128);
  last_arg_no  NUMBER;
  last_parm_buffer RAW(4096);  -- dbms_defer_sys.parm_buffer_size
  last_buffer_number NUMBER;
  last_parm_position BINARY_INTEGER;

  PROCEDURE  get_arg(callno           IN  NUMBER,
                     deferred_tran_db IN  VARCHAR2,
                     arg_no           IN  NUMBER,
                     arg_type         OUT NUMBER,
                     arg_num          OUT NUMBER,
                     arg_char         OUT VARCHAR2,
                     arg_date         OUT DATE,
                     arg_raw          OUT RAW,
                     arg_rowid        OUT ROWID) IS
  -- Retrieve data of a deferred call parameter.
  -- Input parameters
  --  callno
  --    call identifier from the defCall view
  --  deferred_tran_db 
  --    database deferring call from the defCall view
  --  arg_no
  --    postition of desired parameter  in calls argument list
  ----
  --  Output parameters
  --  arg_type
  --    determines which of the other output parameters contains the 
  --    result value.
  --  arg_num
  --    parameter value if arg_type =    arg_type_num
  --  arg_char
  --    parameter value if arg_type =    arg_type_char | arg_type_varchar2
  --  arg_date
  --    parameter value if arg_type =    arg_type_date
  --  arg_raw
  --    parameter value if arg_type =    arg_type_raw
  --  arg_rowid
  --    parameter value if arg_type =    arg_type_rowid
  ------
  --  EXCEPTIONS
  --    NO_DATA_FOUND desired parameted value not found in the deferred rpc
  --    queue tables.
  -------
  updb   VARCHAR2(128) := UPPER(deferred_tran_db);
  an     BINARY_INTEGER;  -- loop variable
  atype  INTEGER;         -- buffer for type
  achar  VARCHAR2(2000);  -- buffer for chars
  anum   NUMBER;          -- buffer for numbers
  araw   RAW(256);        -- buffer for raws
  arowid ROWID;           -- buffer for rowid
  adate  DATE;            -- buffer for date
  BEGIN
    IF last_callno IS NULL 
       OR (last_callno != callno OR last_tran_db != updb) 
       OR (last_arg_no >= arg_no) THEN
      last_callno := callno;
      last_tran_db := updb;
      last_buffer_number := 1;
      dbms_defer_pack.reset_buffer(last_parm_buffer, last_parm_position);
      BEGIN
        SELECT parm_buffer INTO last_parm_buffer
          FROM def$_call
          WHERE def$_call.callno = last_callno
            AND def$_call.deferred_tran_db = last_tran_db
            AND def$_call.buffer_number = last_buffer_number;
      EXCEPTION WHEN NO_DATA_FOUND THEN
        last_callno := NULL;
        RAISE;
      END;
      last_arg_no := 0;
    END IF;

    FOR an IN last_arg_no+1..arg_no LOOP
      atype := dbms_defer_pack.next_item_type(last_parm_buffer,
                                              last_parm_position);
      IF atype = 0 THEN
        last_buffer_number := last_buffer_number + 1;
        dbms_defer_pack.reset_buffer(last_parm_buffer, last_parm_position);
        BEGIN
          SELECT parm_buffer INTO last_parm_buffer
            FROM def$_call
            WHERE def$_call.callno = last_callno
              AND def$_call.deferred_tran_db = last_tran_db
              AND def$_call.buffer_number = last_buffer_number;
        EXCEPTION WHEN NO_DATA_FOUND THEN
          last_callno := NULL;
          RAISE;
        END;
        atype := dbms_defer_pack.next_item_type(last_parm_buffer,
                                                last_parm_position);
        -- need sanity check here at atype != 0
      END IF;
 
      IF atype = dbms_defer.arg_type_num THEN
        dbms_defer_pack.unpack(anum,last_parm_buffer, last_parm_position);
      ELSIF atype = dbms_defer.arg_type_char 
            OR atype = dbms_defer.arg_type_varchar2 THEN
        dbms_defer_pack.unpack(aCHAR,last_parm_buffer, last_parm_position);
      ELSIF atype = dbms_defer.arg_type_date THEN
        dbms_defer_pack.unpack(adate,last_parm_buffer, last_parm_position);
      ELSIF atype = dbms_defer.arg_type_raw THEN
        dbms_defer_pack.unpack_raw(araw,last_parm_buffer, last_parm_position);
      ELSIF atype = dbms_defer.arg_type_rowid THEN
        dbms_defer_pack.unpack_rowid(arowid, last_parm_buffer,
                                     last_parm_position);
        -- need sanity check for invalid type 
      END IF;
    END LOOP;
    arg_type := atype;
    last_arg_no := arg_no;
    IF atype = dbms_defer.arg_type_num THEN
      arg_num := anum;
    ELSIF atype= dbms_defer.arg_type_char 
          OR atype=dbms_defer.arg_type_varchar2 THEN

      arg_char := achar;
    ELSIF atype = dbms_defer.arg_type_date THEN
      arg_date := adate;
    ELSIF atype = dbms_defer.arg_type_raw THEN
      arg_raw := araw;
    ELSIF atype = dbms_defer.arg_type_rowid THEN
      arg_rowid := arowid;
    END IF;
  END get_arg;
END dbms_defer_query;
/

CREATE OR REPLACE PACKAGE dbms_defer_internal_sys AS
  -------------------
  --  OVERVIEW
  -- 
  -- This package is the internal component of the system administrator  
  -- interface to a replicated 
  -- transactional deferred remote
  -- procedure call facility. This package contains procedures called by  
  -- the create_error procedure in dbms_defer_sys using dynamic sql.
  ------------
  --  SECURITY
  --
  -- By default, this package is owned by user REPLICATION and 
  -- execution should be granted only to user REPLICATION, or to the 
  -- owner of the dbms_defer_sys package.
  -- See the security considerations for 
  -- the dbms_defer package for related considerations.
  -------------
  --  CONSTANTS

  --  PROCEDURES

  PROCEDURE error_tran(deferred_tran_id  IN VARCHAR2,
                       deferred_tran_db  IN VARCHAR2,
                       origin_tran_id    IN VARCHAR2,
                       origin_tran_db    IN VARCHAR2,
                       origin_user       IN VARCHAR2,
                       delivery_order    IN NUMBER,
                       destination_list  IN CHAR,
                       start_time        IN DATE,
                       commit_comment    IN VARCHAR2,
                       error_callno      IN NUMBER, 
                       error_destination IN VARCHAR2,
                       error_number      IN NUMBER,
                       error_message     IN VARCHAR2); 
  -- Create def$_error record and (if necessaary) def$_tran record for
  -- a transaction.
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --    origin_tran_id  
  --      Origin transaction id - for def$_tran record
  --    origin_tran_db   
  --      Transaction origin site - for def$_tran record
  --    origin_user      
  --      user creating transaction - for def$_tran record
  --    delivery_order   
  --      executeion ordef for transaction - for def$_tran record
  --    destination_list 
  --      flag indicating routing - for def$_tran record
  --    start_time       
  --      original transaction start time - for def$_tran record
  --    commit_comment   
  --      transaction annotation - for def$_tran record
  --    error_callno     
  --      call encountering error - for def$_error record
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --    error_number     
  --      Oracle error number - for def$_error record
  --    error_message    
  --      oralce error message - for def$_error record
  --  Exceptions 
  --    DUP_VAL_ON_INDEX
  --     Error reocrd alread exists.
  ----------
 
  PROCEDURE error_call(deferred_tran_id  IN VARCHAR2,
                       deferred_tran_db  IN VARCHAR2,
                       error_destination IN VARCHAR2,
                       callno            IN NUMBER,
                       schemaname        IN VARCHAR2,
                       packagename       IN VARCHAR2,
                       procname          IN VARCHAR2,
                       argcount          IN NUMBER);
  -- Create def$_error record and (if necessaary) def$_tran record for
  -- a transaction.
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call to copy to def$_calls record
  --    schemaname 
  --      name of call schema to copy to def$_calls record
  --    packagename 
  --      name of call package to copy to def$_calls record
  --    procname 
  --      name of call procedure to copy to def$_calls record
  --    argcount
  --      number of parameters - goes in def$_calls record
  --
  -- EXCEPTION
  --   mallformedcall
  --     error_tran not previously called
  ---------
  PROCEDURE error_arg_num(deferred_tran_id  IN VARCHAR2,
                          deferred_tran_db  IN VARCHAR2,
                          error_destination IN VARCHAR2,
                          callno            IN NUMBER,
                          argno             IN NUMBER,
                          arg               IN NUMBER);
  -- Pass number parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   mallformedcall
  --     error_call not previously called
  ---------
  PROCEDURE error_arg_char(deferred_tran_id  IN VARCHAR2,
                           deferred_tran_db  IN VARCHAR2,
                           error_destination IN VARCHAR2,
                           callno            IN NUMBER,
                           argno             IN NUMBER,
                           arg               IN CHAR);
  -- Pass char parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   mallformedcall
  --     error_call not previously called
  ---------  
  PROCEDURE error_arg_varchar2(deferred_tran_id  IN VARCHAR2,
                               deferred_tran_db  IN VARCHAR2,
                               error_destination IN VARCHAR2,
                               callno            IN NUMBER,
                               argno             IN NUMBER,
                               arg               IN VARCHAR2);
  -- Pass number parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   mallformedcall
  --     error_call not previously called
  ---------
  PROCEDURE error_arg_date(deferred_tran_id  IN VARCHAR2,
                           deferred_tran_db  IN VARCHAR2,
                           error_destination IN VARCHAR2,
                           callno            IN NUMBER,
                           argno             IN NUMBER,
                           arg               IN DATE);
  -- Pass date parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   mallformedcall
  --     error_call not previously called
  ---------
  PROCEDURE error_arg_raw(deferred_tran_id  IN VARCHAR2,
                          deferred_tran_db  IN VARCHAR2,
                          error_destination IN VARCHAR2,
                          callno            IN NUMBER,
                          argno             IN NUMBER,
                          arg               IN RAW);
  -- Pass raw parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   mallformedcall
  --     error_call not previously called
  ---------
  PROCEDURE error_arg_rowid(deferred_tran_id  IN VARCHAR2,
                            deferred_tran_db  IN VARCHAR2,
                            error_destination IN VARCHAR2,
                            callno            IN NUMBER,
                            argno             IN NUMBER,
                            arg               IN ROWID);
  -- Pass rowid parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   mallformedcall
  --     error_call not previously called
  ---------
  PROCEDURE error_end_tran(deferred_tran_id  IN VARCHAR2,
                           deferred_tran_db  IN VARCHAR2,
                           error_destination IN VARCHAR2,
                           callcount         IN NUMBER);
  -- inticate end of error transactions to remote site
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callcount
  --      count of calls in transaction
  --      Used to verify consistency of multiple call
  -- EXCEPTION
  --   mallformedcall
  --     Inputs not as expected.
END dbms_defer_internal_sys;
/

CREATE OR REPLACE PACKAGE BODY dbms_defer_internal_sys AS
  -------------------
  --  OVERVIEW
  -- 
  -- This package is the internal component of the system administrator  
  -- interface to a replicated 
  -- transactional deferred remote
  -- procedure call facility. This package contains procedures called by  
  -- the create_error procedure in dbms_defer_sys using dynamic sql.
  ------------
  --  SECURITY
  --
  -- By default, this package is owned by user REPLICATION and 
  -- execution should be granted only to user REPLICATION, or to the 
  -- owner of the dbms_defer_sys package.
  -- See the security considerations for 
  -- the dbms_defer package for related considerations.
  -------------
  --  CONSTANTS

  --  GLOBAL VARIABLES
  --    These variables are used to check for correctly formed error calls
  ---
  current_tran_id       VARCHAR2(22);
  current_tran_db       VARCHAR2(128);
  current_tran_dest     VARCHAR2(128);
  current_callno        NUMBER;
  current_next_arg      BINARY_INTEGER;
  current_call_argcount BINARY_INTEGER;
  current_tran_call_count BINARY_INTEGER;
  -- flags to deal with dupliate tran/call records
  current_call_loop     BOOLEAN;
  current_tran_loop     BOOLEAN;
  -- parameter buffer data
  current_buffer_number BINARY_INTEGER;
  current_buffer        RAW(4096) := rpad('00',8192,'00');
                        -- dbms_defer_sys.parm_buffer_size
  current_position      BINARY_INTEGER;

  --  INTERNAL PROCEDURES
  PROCEDURE write_buffer IS
  -- write out the curret parm buffer
  -- watch out! wierd 2* is due to implicit hexing and de-hexing
  buf RAW(4096) := SUBSTR(current_buffer,1,
                          2 *  (current_position + 1));
  BEGIN
    IF current_buffer_number = 1 THEN
      -- buffer is alread there
      UPDATE def$_call
        SET parm_buffer = buf
        WHERE def$_call.deferred_tran_id = current_tran_id
          AND def$_call.deferred_tran_db = current_tran_db
         AND def$_call.callno = current_callno
          AND def$_call.buffer_number = 1;
    ELSE
      INSERT INTO def$_call (callno, buffer_number, deferred_tran_db,
                             deferred_tran_id, parm_buffer)
        VALUES(current_callno, current_buffer_number, current_tran_db,
               current_tran_id, buf);
    END IF;
    dbms_defer_pack.reset_buffer(current_buffer, current_position);
    current_buffer_number := current_buffer_number + 1;
  END write_buffer;

  -----
  PROCEDURE eoc IS
  -- common procesing for end of arg_* calls
  -- check for end of call
  BEGIN 
    IF current_next_arg = current_call_argcount THEN
      IF NOT current_call_loop THEN
        write_buffer;
      END IF;
      current_callno := NULL;
      current_tran_call_count := current_tran_call_count + 1;
    ELSE
      current_next_arg := current_next_arg + 1;
    END IF;
  END eoc;

  PROCEDURE malformed IS
   -- generate an exception including internal state 
   -- capture the state of the package for the error message */
  argcount  NUMBER := current_call_argcount;
  argno     NUMBER := current_next_arg;
  calltid   VARCHAR2(22) := current_tran_id;
  curcall   NUMBER := current_callno;

  BEGIN

    /* correct the package state so that future calls will work */
    current_callno         := NULL;
    current_tran_id        := NULL;

    /* raise the exception */
    raise_application_error(-20670,
                            'Mall-formed defered rpc error call [argcount: '
                            || to_char(argcount) 
                            || ', argno: ' 
                            || to_char(argno) 
                            || ', call: ' || to_char(curcall) 
                            || ', currenttid: ' || calltid || ']');
END malformed;
  --  PROCEDURES

  PROCEDURE error_tran(deferred_tran_id  IN VARCHAR2,
                       deferred_tran_db  IN VARCHAR2,
                       origin_tran_id    IN VARCHAR2,
                       origin_tran_db    IN VARCHAR2,
                       origin_user       IN VARCHAR2,
                       delivery_order    IN NUMBER,
                       destination_list  IN CHAR,
                       start_time        IN DATE,
                       commit_comment    IN VARCHAR2,
                       error_callno      IN NUMBER, 
                       error_destination IN VARCHAR2,
                       error_number      IN NUMBER,
                       error_message     IN VARCHAR2) IS
  -- Create def$_error record and (if necessaary) def$_tran record for
  -- a transaction.
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --    origin_tran_id  
  --      Origin transaction id - for def$_tran record
  --    origin_tran_db   
  --      Transaction origin site - for def$_tran record
  --    origin_user      
  --      user creating transaction - for def$_tran record
  --    delivery_order   
  --      executeion ordef for transaction - for def$_tran record
  --    destination_list 
  --      flag indicating routing - for def$_tran record
  --    start_time       
  --      original transaction start time - for def$_tran record
  --    commit_comment   
  --      transaction annotation - for def$_tran record
  --    error_callno     
  --      call encountering error - for def$_error record
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --    error_number     
  --      Oracle error number - for def$_error record
  --    error_message    
  --      oralce error message - for def$_error record
  --  Exceptions 
  --    DUP_VAL_ON_INDEX
  --     Error reocrd alread exists.
  --    malformedcall
  --      Previous error transaction  not correctly ended.
  ----------
  BEGIN
    -- Check for malformed call
    IF current_tran_id IS NOT NULL THEN
      malformed;
    END IF;
    
    -- insert tran record - catch dupval on index error because 
    -- this call might be executing over a loopback link
    current_tran_loop := FALSE;
    BEGIN
      INSERT INTO def$_tran(deferred_tran_id, deferred_tran_db, origin_tran_id,
                            origin_tran_db, origin_user, delivery_order,
                            destination_list, start_time, commit_comment)
        VALUES(error_tran.deferred_tran_id, error_tran.deferred_tran_db,
               error_tran.origin_tran_id, error_tran.origin_tran_db,
               error_tran.origin_user, error_tran.delivery_order,
               error_tran.destination_list,
               error_tran.start_time, error_tran.commit_comment);
    EXCEPTION WHEN DUP_VAL_ON_INDEX THEN
      -- ok, a loopback error
      current_tran_loop := TRUE;
    END;
    
    -- inset the error recort - simply reflect dubval back to caller.
    INSERT INTO def$_error(deferred_tran_db, deferred_tran_id, callno,
                           destination, error_time, error_number, error_msg)
      VALUES(error_tran.deferred_tran_db, error_tran.deferred_tran_id,
             error_tran.error_callno, error_tran.error_destination, SYSDATE,
             error_tran.error_number, error_tran.error_message);

    -- fill in the tran state
    current_tran_id   := error_tran.deferred_tran_id;
    current_tran_db   := error_tran.deferred_tran_db;
    current_tran_dest := error_tran.error_destination;
    current_tran_call_count := 0;
END error_tran;
  ------

  PROCEDURE error_call(deferred_tran_id  IN VARCHAR2,
                       deferred_tran_db  IN VARCHAR2,
                       error_destination IN VARCHAR2,
                       callno            IN NUMBER,
                       schemaname        IN VARCHAR2,
                       packagename       IN VARCHAR2,
                       procname          IN VARCHAR2,
                       argcount          IN NUMBER) IS
  -- Create def$_error record and (if necessaary) def$_tran record for
  -- a transaction.
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call to copy to def$_calls record
  --    schemaname 
  --      name of call schema to copy to def$_calls record
  --    packagename 
  --      name of call package to copy to def$_calls record
  --    procname 
  --      name of call procedure to copy to def$_calls record
  --    argcount
  --      number of parameters - goes in def$_calls record
  --
  -- EXCEPTION
  --   malformedcall
  --     error_tran not previously called
  ---------
  BEGIN
    -- correct for correctly formed error transaction
    IF current_tran_id IS NULL OR
       current_callno IS NOT NULL OR
       current_tran_id   != error_call.deferred_tran_id OR
       current_tran_db   != error_call.deferred_tran_db OR
       current_tran_dest != error_call.error_destination THEN
      malformed;
    END IF;
    -- 	INSERT the first call record without a parm_buffer 
    --  here we will use a different technicuq than dbms_defer.call where
    --  we jumped through hoops to avoid updateing the first call record
    --  to after the insert.
    current_call_loop := FALSE;
    BEGIN
      INSERT INTO def$_call(deferred_tran_id, deferred_tran_db, callno,
                            schemaname, packagename, procname, argcount,
                            buffer_number)
        VALUES(current_tran_id, current_tran_db, error_call.callno,
               error_call.schemaname, error_call.packagename, 
               error_call.procname, error_call.argcount, 1);
    EXCEPTION WHEN DUP_VAL_ON_INDEX THEN
      IF current_tran_loop THEN
        -- must have dup tran record to have dup call record
        current_call_loop := TRUE;
      ELSE
        malformed;
      END IF;
    END;
    -- inset the calldest record
    IF NOT current_call_loop THEN
      INSERT INTO def$_calldest(deferred_tran_id, deferred_tran_db, callno,
                                dblink)
         VALUES (current_tran_id, current_tran_db, callno, current_tran_dest);
    END IF;

    -- set the global state
    IF error_call.argcount > 0 THEN
      current_callno := error_call.callno;
      current_next_arg := 1;
      current_call_argcount := error_call.argcount;
      current_buffer_number := 1;
      dbms_defer_pack.reset_buffer(current_buffer, current_position);
    ELSE
      current_tran_call_count := current_tran_call_count + 1;
    END IF;
  END error_call;

  --------    
  PROCEDURE error_arg_num(deferred_tran_id  IN VARCHAR2,
                          deferred_tran_db  IN VARCHAR2,
                          error_destination IN VARCHAR2,
                          callno            IN NUMBER,
                          argno             IN NUMBER,
                          arg               IN NUMBER) IS
  -- Pass number parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   malformedcall
  --     error_call not previously called
  ---------
  buffer_overflow EXCEPTION;
  PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);

  BEGIN
    -- check for malformed call
    IF current_tran_id IS NULL OR
       current_callno  IS NULL OR
       current_tran_id != deferred_tran_id OR
       current_tran_db != deferred_tran_db OR
       current_tran_dest != error_destination OR
       current_callno    != callno OR
       current_next_arg  != argno THEN
      malformed;
    END IF;
    IF NOT current_call_loop THEN
      BEGIN
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      EXCEPTION WHEN buffer_overflow THEN
        write_buffer;    
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      END;
    END IF;
    -- end of call ?
    eoc;
  END error_arg_num;
  --------
  PROCEDURE error_arg_char(deferred_tran_id  IN VARCHAR2,
                           deferred_tran_db  IN VARCHAR2,
                           error_destination IN VARCHAR2,
                           callno            IN NUMBER,
                           argno             IN NUMBER,
                           arg               IN CHAR) IS
  -- Pass char parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   malformedcall
  --     error_call not previously called
  ---------  
  buffer_overflow EXCEPTION;
  PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);

  BEGIN
    -- check for malformed call
    IF current_tran_id IS NULL OR
       current_callno  IS NULL OR
       current_tran_id != deferred_tran_id OR
       current_tran_db != deferred_tran_db OR
       current_tran_dest != error_destination OR
       current_callno    != callno OR
       current_next_arg  != argno THEN
      malformed;
    END IF;
    IF NOT current_call_loop THEN
      BEGIN
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      EXCEPTION WHEN buffer_overflow THEN
        write_buffer;    
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      END;
    END IF;
    -- end of call ?
    eoc;
  END error_arg_char;
  ---
 
  PROCEDURE error_arg_varchar2(deferred_tran_id  IN VARCHAR2,
                               deferred_tran_db  IN VARCHAR2,
                               error_destination IN VARCHAR2,
                               callno            IN NUMBER,
                               argno             IN NUMBER,
                               arg               IN VARCHAR2) IS
  -- Pass number parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   malformedcall
  --     error_call not previously called
  ---------
  buffer_overflow EXCEPTION;
  PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);

  BEGIN
    -- check for malformed call
    IF current_tran_id IS NULL OR
       current_callno  IS NULL OR
       current_tran_id != deferred_tran_id OR
       current_tran_db != deferred_tran_db OR
       current_tran_dest != error_destination OR
       current_callno    != callno OR
       current_next_arg  != argno THEN
      malformed;
    END IF;
    IF NOT current_call_loop THEN
      BEGIN
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      EXCEPTION WHEN buffer_overflow THEN
        write_buffer;    
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      END;
    END IF;
    -- end of call ?
    eoc;
  END error_arg_varchar2;
 ---
  PROCEDURE error_arg_date(deferred_tran_id  IN VARCHAR2,
                           deferred_tran_db  IN VARCHAR2,
                           error_destination IN VARCHAR2,
                           callno            IN NUMBER,
                           argno             IN NUMBER,
                           arg               IN DATE) IS
  -- Pass date parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   malformedcall
  --     error_call not previously called
  ---------
  buffer_overflow EXCEPTION;
  PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);

  BEGIN
    -- check for malformed call
    IF current_tran_id IS NULL OR
       current_callno  IS NULL OR
       current_tran_id != deferred_tran_id OR
       current_tran_db != deferred_tran_db OR
       current_tran_dest != error_destination OR
       current_callno    != callno OR
       current_next_arg  != argno THEN
      malformed;
    END IF;
    IF NOT current_call_loop THEN
      BEGIN
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      EXCEPTION WHEN buffer_overflow THEN
        write_buffer;    
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      END;
    END IF;
    -- end of call ?
    eoc;
  END error_arg_date;
 ---  
  PROCEDURE error_arg_raw(deferred_tran_id  IN VARCHAR2,
                          deferred_tran_db  IN VARCHAR2,
                          error_destination IN VARCHAR2,
                          callno            IN NUMBER,
                          argno             IN NUMBER,
                          arg               IN RAW) IS
  -- Pass raw parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   malformedcall
  --     error_call not previously called
  ---------
  buffer_overflow EXCEPTION;
  PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);
  BEGIN
    -- check for malformed call
    IF current_tran_id IS NULL OR
       current_callno  IS NULL OR
       current_tran_id != deferred_tran_id OR
       current_tran_db != deferred_tran_db OR
       current_tran_dest != error_destination OR
       current_callno    != callno OR
       current_next_arg  != argno THEN
      malformed;
    END IF;
    IF NOT current_call_loop THEN
      BEGIN
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      EXCEPTION WHEN buffer_overflow THEN
        write_buffer;    
        dbms_defer_pack.pack_raw(arg, current_buffer, current_position);
      END;
    END IF;
    -- end of call ?
    eoc;
  END error_arg_raw;
  --- 

  PROCEDURE error_arg_rowid(deferred_tran_id  IN VARCHAR2,
                            deferred_tran_db  IN VARCHAR2,
                            error_destination IN VARCHAR2,
                            callno            IN NUMBER,
                            argno             IN NUMBER,
                            arg               IN ROWID) IS
  -- Pass rowid parameter to site createing def$_error/ and related call
  -- Records
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callno
  --      call number 
  --      Used to verify consistency of multiple call
  --    argno
  --      parameter position
  --      Used to verify consistency of multiple call
  --    arg
  --      parmeter for call
  -- EXCEPTION
  --   malformedcall
  --     error_call not previously called
  ---------
  buffer_overflow EXCEPTION;
  PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);

  BEGIN
    -- check for malformed call
    IF current_tran_id IS NULL OR
       current_callno  IS NULL OR
       current_tran_id != deferred_tran_id OR
       current_tran_db != deferred_tran_db OR
       current_tran_dest != error_destination OR
       current_callno    != callno OR
       current_next_arg  != argno THEN
      malformed;
    END IF;
    IF NOT current_call_loop THEN
      BEGIN
        dbms_defer_pack.pack(arg,current_buffer,current_position);
      EXCEPTION WHEN buffer_overflow THEN
        write_buffer;    
        dbms_defer_pack.pack_rowid(arg, current_buffer, current_position);
      END;
    END IF;
    -- end of call ?
    eoc;
  END error_arg_rowid;
  ---
 
  PROCEDURE error_end_tran(deferred_tran_id  IN VARCHAR2,
                           deferred_tran_db  IN VARCHAR2,
                           error_destination IN VARCHAR2,
                           callcount         IN NUMBER) IS
  -- inticate end of error transactions to remote site
  --  Input parameters
  --    deferred_tran_id
  --      Identifier of error transaction assigned at origin or copying site.
  --      Used to verify consistency of multiple calls
  --    deferred_tran_db 
  --      Site where transaction originated or was copied
  --      Used to verify consistency of multiple calls
  --    error_destination
  --      dblink where error encountered - for def$_error record
  --      Used to verify consistency of multiple calls
  --    callcount
  --      count of calls in transaction
  --      Used to verify consistency of multiple call
  -- EXCEPTION
  --   malformedcall
  --     Inputs not as expected.
  BEGIN
    -- check for malformed tran
    IF current_tran_id IS NULL OR
       current_callno IS NOT NULL OR
       current_tran_id != deferred_tran_id OR
       current_tran_db != deferred_tran_db OR
       current_tran_dest != error_destination OR
       current_tran_call_count != callcount THEN
      malformed;
    END IF;
    current_tran_id := NULL;
  END error_end_tran;
END dbms_defer_internal_sys;
/


CREATE OR REPLACE PACKAGE dbms_defer_sys AS
  -------------------
  --  OVERVIEW
  -- 
  -- This package is the system administrator  interface to a replicated 
  -- transactional deferred remote
  -- procedure call facility.  Administrators and replication 
  -- deamons can execute
  -- transactions queued for remote nodes using this facility 
  -- and administrators
  -- can control the nodes to which remote calls are destined.
  ------------
  --  SECURITY
  --
  -- By default, this package is owned by user REPLICATION and 
  -- execution should 
  -- only to administrators and deamons that perform 
  -- replciation adinistration and
  -- execute defered transactions.  See the security considerations for 
  -- the dbms_defer package for related considerations.
  -------------
  --  CONSTANTS
  --  size of long buffer used for packing parameters
  parm_buffer_size CONSTANT NUMBER := 4096;
  --  PROCEDURES

  -- manage default replication node lists

  PROCEDURE add_default_dest(dblink IN VARCHAR2);
  --  Add a node to the default list for replication targets.
  --  Input parameters
  --    dblink
  --      name of the node (dblink) to add tRo the default list.
  --  Exceptions 
  --    DUP_VAL_ON_INDEX
  --     dblink is already in the default list.
  ----------
 
  PROCEDURE delete_default_dest(dblink IN VARCHAR2);
  --  Delete a node from the default list for repliation targets
  --  Input parameters
  --    dblink
  --      name of the node (dblink) to delete from the default list.
  --      Operation is a no-op if dblink is not in the list.
  --  Exceptions
  --    none.
  -----------------

  PROCEDURE execute(destination       IN VARCHAR2,
                    stop_on_error     IN BOOLEAN := FALSE,
                    transaction_count IN BINARY_INTEGER := 0,
                    execution_seconds IN BINARY_INTEGER := 0);
  --  Execute transactions queued for destination_node. stop_on_error 
  --  determins whether processing
  --  of subsequent transaction continues after an error is detected. 
  --  deftrandest (and defcalldest if appropriate) entries 
  --  for the successfully executed 
  --  transactions are deleted and if there are no other refreences, 
  --  the defcall adn deftran entries are deleted.
  --  Input Parameters:
  --    destination
  --      node (dblink) at which to execute 
  --      deferred transaction.  Case
  --      insesitive comparisons used.
  --    stop_on_error
  --      If TRUE, execution of queued transactions will 
  --      alway stop when an error is
  --      encountered, leaving unattempted transaction in 
  --      the queue.  If FALSE,
  --      execution continues except when errors that appear 
  --      to mean that node is 
  --      unavailable are encountered, it which case execution 
  --      always stops, leaving
  --      unattempted transactions queued.
  --    transaction_count
  --      If positive, at most this many transactions will be executed.
  --    executions_seconds
  --      If positive, execution will stop after completions of the
  --      last transaction after this many seconds of executions.
  --  Exceptions
  --    Raises the last exception encountered before execution 
  --    stops because of 
  --    an exception.
  ----------------

  PROCEDURE execute_error(deferred_tran_id IN VARCHAR2,
                          deferred_tran_db IN VARCHAR2,
                          destination      IN VARCHAR2);

  --  (Re)Execute transactions that previously encountered conflicts. 
  --  Exectuions stops when any error is encountered.  If some input is null,
  --  then each transaciton is committed as it completes. If exactly one 
  --  transaciton is specified, then the transactions is not commited.
  --  Upon successful execution, transactions are removed for deferror, and if
  --  there are no other references, entries are deleted from 
  --  defcall and deftran.
  --  Input Parameters:
  --    deferrred_tran_db
  --      node (global_name) originating or copying transaction that 
  --      encounterd a errors. If null, then 
  --      deferred_transaciton_id must be null and  all 
  --      trnasactions from all destinations matching destinaiton 
  --      (as specified) are re-executed.
  --           
  --    deferred_transaction_id
  --      The identifier of the transation to be reexecuted.
  --      If null then if all transactions in deferror matching 
  --      deferred transaciton id and destination (as specified) 
  --      are re-executed.
  --    destination
  --      dblink that transaction was originaly destined to.
  --  Exceptions
  --    Raises the last exception encountered before execution 
  --    stops because of an exception.
  ----------------

  PROCEDURE delete_tran(deferred_tran_id IN VARCHAR2,
                        deferred_tran_db IN VARCHAR2,
                        destination      IN VARCHAR2);
  --  Delete transactions from  queues. Deletes deftrandest (and defcalldest
  --  entries if appropriate.  If there are not other references,
  --  deftran and defcall entries are deleted.
  --  Input Parameters:
  --    destination
  --      dblink for which transaction(s) are to be removed from queues.
  --      If null, the transaction specified by the other parameters are 
  --      deleted from queues for all destinations.
  --    deferred_tran_id
  --      The identifier of the transation to be deleted
  --      If null then all transactions matching destination and 
  --      deferred_tran_db are deleted.
  --    deferred_tran_db
  --      The identifier of the origin/copying node for the transaction to be
  --      deleted. If null then all transactiosn matching destination and 
  --      deferred_tran_id are deleted.
  --  Exceptions
  --    tid and/or node not found.
  ---------------
  PROCEDURE delete_error(deferred_tran_id IN VARCHAR2,
                         deferred_tran_db IN VARCHAR2,
                         destination      IN VARCHAR2);

  --  Delete transactions from  defferror table. If there are 
  --  not other references,
  --  deftran and defcall entries are deleted.
  --  Input Parameters:
  --    destination
  --      destinatoin for which transaction(s) are to be removed from 
  --      deferror.
  --      If null, the transaction specified by the other parameters are 
  --      deleted from deferror for all destinations.
  --    deferred_tran_id
  --      The identifier of the transation to be deleted
  --      If null then all transactions matching destination and 
  --      deferred_tran_db are deleted.
  --    deferred_tran_db
  --      The identifier of the origin/copying node for the transaction to be
  --      deleted. If null then all transaction matching destination and 
  --      deferred_tran_id are deleted.
  --  Exceptions
  --    tid and/or node not found.
  ---------------

  PROCEDURE copy(deferred_tran_id  IN VARCHAR2,
                 deferred_tran_db  IN VARCHAR2,
                 destination_list  IN dbms_defer.node_list_t,
                 destination_count IN BINARY_INTEGER);
  --  Copy as deferred transaciton assign it and new 
  --  deferre_tranid , deferred__tran_db, 
  -- executions_order, setting destination_list to 'D'
  --  and retaining the other fields from the stource 
  -- transaction).  The new transacitons has destitntions as 
  -- specifies by destination_list and destination_count.
  --    destination_node
  --      the Origin_
  --      Case  insesitive comparisons used.
  --    tid
  --      The identifier of the transation to be added to the node's queue.
  --  Exceptions
  --    tid  not found.
  ---------------
  PROCEDURE create_error(deferred_tran_id  IN VARCHAR2,
                         deferred_tran_db  IN VARCHAR2,
                         destination       IN VARCHAR2,
                         call              IN NUMBER,
                         error_number      IN NUMBER,
                         error_message     IN VARCHAR2);
                       
  --  Create deferror table record for a transaction at 
  --  some remote node. Delete deftrandest (and defcalldest, 
  --  if appropriate) entries for transaction at the
  --  node executing create_error. If there are not other
  --  references, delete deftran and defcall entries.
  --  Input Parameters:
  --    destiation
  --      dblink to node at which to create deferror table 
  --      entry.
  --    deferred_tran_id
  --      The identifier of the transation.
  --    deferred_tran_db 
  --      databse idetifier component of the transciton.
  --    call 
  --      The identifier of the conflicitng call.  If not null should be
  --      a call within the transaction
  --    error_number
  --      Error number for conflicts table record.
  --    error_message
  --      Error message for conflicts table record.
  --      Truncated to 200 characters.
  --
  --  Exceptions
END dbms_defer_sys;
/
CREATE OR REPLACE PACKAGE BODY dbms_defer_sys IS
  --
  --  Global Variavles
  local_node VARCHAR2(128);  -- local database name
  --  dbms_sql cursors for executing transactions
  rccursor INTEGER; -- cursor for repcat-directed transactions
  rccursorrpi INTEGER; -- rpi number for dccursor
  dccursor INTEGER; -- cursor for defcalldest-directed transactiosn
  dccursorrpi INTEGER; -- rpi number for dccursor
  ---------
  -- EXCEPTIONS
  create_error_error EXCEPTION; -- raised when an error is enountered 
                                -- when crate_error is called from            
                                -- exetute_txn_node
  --  INTERNAL PROCEDURES
  PROCEDURE delete_call_dest(deferred_tran_db   IN  VARCHAR2,
                             destination        IN  VARCHAR2,
                             deferred_tran_id   IN  VARCHAR2) IS
  -- delete from def$_call dest.
  -- delete tran ande delete_error do this a lot
  BEGIN
    DELETE FROM def$_calldest 
      WHERE def$_calldest.deferred_tran_db = delete_call_dest.deferred_tran_db
        AND def$_calldest.dblink           = delete_call_dest.destination
        AND def$_calldest.deferred_tran_id = delete_call_dest.deferred_tran_id;
  END delete_call_dest;

  --  INTERNAL PROCEDURES
  PROCEDURE delete_tran_rec(deferred_tran_db   IN  VARCHAR2,
                            deferred_tran_id   IN  VARCHAR2) IS
  -- delete from def$_tran, ignoring referential exceptions
  -- delete)tran and delete_error do this a lot
  child_exists EXCEPTION;
  PRAGMA EXECPTION_INIT(child_exists,2292);
  BEGIN
    -- Delete the txn record referential constraints may prevent this
    -- from working
    DELETE FROM def$_tran 
      WHERE def$_tran.deferred_tran_db = delete_tran_rec.deferred_tran_db
        AND def$_tran.deferred_tran_id = delete_tran_rec.deferred_tran_id;
  EXCEPTION WHEN child_exists THEN
    NULL; -- ignore this exception
  END delete_tran_rec;

  PROCEDURE execute_txn_node(deferred_tran_db   IN  VARCHAR2,
                             deferred_tran_id   IN  VARCHAR2,
                             destination        IN  VARCHAR2,
                             dest_list          IN  CHAR ) IS
  -- Execute a transaction at a remote node
  -- Input parameters:
  --   tid
  --     pseudo tid of the transaction to executed
  --   node
  --     node at which to execute transction (uppercased)
  ---
  --  Exceptions:
  --    Rasises those raised by defexecallnode.
  -----------

  err_num        NUMBER;
  err_msg        VARCHAR2(200);
  error_position BINARY_INTEGER;
  error_callno   NUMBER;
  rpicursor      NUMBER;
  -- cursor for finding callno for error
  CURSOR dc IS  
    SELECT def$_call.callno
        FROM def$_call, def$_calldest
        WHERE def$_call.deferred_tran_id =
              execute_txn_node.deferred_tran_id
          AND def$_call.deferred_tran_db =
              execute_txn_node.deferred_tran_db
          AND def$_calldest.deferred_tran_db = 
              def$_call.deferred_tran_db 
          AND def$_calldest.deferred_tran_id = 
              def$_call.deferred_tran_id
          AND def$_call.callno = def$_calldest.callno
          AND def$_calldest.dblink = execute_txn_node.destination
          AND def$_call.buffer_number = 1
        ORDER BY def$_call.callno;
  rc dc%ROWTYPE;


  BEGIN
--   dbms_output.put_line('called execute_txn_node['||
--                         deferred_tran_id || ','||
--                         deferred_tran_db  ||',' ||
--                         destination || ',' ||
--                         dest_list || ']');
    SAVEPOINT remotetrouble;
    IF dest_list = 'D' THEN
        /* use the defcalldest cursor */
      rpicursor := dccursorrpi;
      dbms_sql.bind_variable(dccursor,':tid',deferred_tran_id);
      dbms_sql.bind_variable(dccursor,':localnode',deferred_tran_db);
      dbms_sql.bind_variable(dccursor,':dest',destination);
    END IF;
    BEGIN
      dbms_asyncrpc.push_pending_calls(rpicursor,destination,
                                       dbms_defer_sys.parm_buffer_size);

    EXCEPTION WHEN OTHERS  THEN
      err_num := SQLCODE;
      err_msg := SUBSTR(SQLERRM,1,200);
--      dbms_output.put_line('errornum:'||to_char(err_num)||
--                           ' errormg: '||err_msg);
      /* find the callno that got the error */
      /* capture the error message, roolback to the savepoint, */
      /* insert the erorr */
      /* data into the conflicts table */
      dbms_asyncrpc.error_call_position(destination,error_position);
--      dbms_output.put_line('error_position: '||to_char(error_position));
      error_callno := NULL;
      IF error_position > 0 THEN
        IF dest_list='D' THEN
          OPEN dc;
          FOR i in 1..error_position  LOOP
            FETCH dc INTO rc;
            EXIT WHEN dc%NOTFOUND;
            IF error_position = i THEN
              error_callno := rc.callno;
            END IF;
          END LOOP;
        END IF;
      END IF;
--      dbms_output.put_line('error_call: '||to_char(error_callno));
      ROLLBACK TO remotetrouble;
      BEGIN
        create_error(deferred_tran_id, deferred_tran_db, destination,
                     error_callno, err_num, err_msg);
      EXCEPTION WHEN OTHERS THEN
        -- tell caller the error was in adding the conflict
        RAISE create_error_error;
      END;
      -- raise the error back to the caller
      RAISE;
    END;
    -- Transaction executed ok, delete the call-node records.
    delete_tran(execute_txn_node.deferred_tran_id,
                execute_txn_node.deferred_tran_db,
                execute_txn_node.destination);
  END execute_txn_node;

  PROCEDURE execute_error_call(callno           IN NUMBER   ,
                               deferred_tran_db IN VARCHAR2 ) IS
  -- execute a single call (locally) withiing an error transaction
  sname  VARCHAR2(30);
  pkname VARCHAR2(30);
  prname VARCHAR2(30);
  acount NUMBER;
  cname  VARCHAR2(92);
  argstr VARCHAR2(20000);
  sqlcur INTEGER;
  TYPE numtab  IS TABLE OF NUMBER         INDEX BY BINARY_INTEGER;
  TYPE chartab IS TABLE OF VARCHAR2(2000) INDEX BY BINARY_INTEGER;
  TYPE datetab IS TABLE OF DATE           INDEX BY BINARY_INTEGER;
  TYPE rawtab  IS TABLE OF RAW(255)       INDEX BY BINARY_INTEGER;
  TYPE rowtab  IS TABLE OF ROWID          INDEX BY BINARY_INTEGER;
  numargs   numtab;
  charargs  chartab;
  dateargs  datetab;
  rawargs   rawtab;
  rowargs   rowtab;
  atype     NUMBER;
  dummy     BINARY_INTEGER;
  BEGIN
    -- get call name, generate text of call for dbms_sql
    SELECT schemaname, packagename, procname, argcount 
      INTO sname, pkname, prname, acount
      FROM def$_call
      WHERE def$_call.callno = execute_error_call.callno
        AND def$_call.deferred_tran_db = execute_error_call.deferred_tran_db
        AND def$_call.buffer_number = 1;
    IF pkname IS NULL THEN
      cname := sname || '.' || prname;
    ELSE
      cname := sname || '.' || pkname || '.' || prname;
    END IF;
    -- generate parmaert string
    IF acount = 0 THEN
      argstr := '; ';
    ELSE
      argstr := '(:a1';
      IF acount > 1 THEN
        FOR i in 2..acount LOOP
          argstr := argstr || ', :a' || to_char(i);
        END LOOP;
      END IF;
      argstr := argstr || '); ';
    END IF;
    
    -- parse call
    sqlcur := dbms_sql.open_cursor;
--    dbms_output.put_line('error_call: '||cname||argstr);
    BEGIN  -- clean up cursor on error
      dbms_sql.parse(sqlcur,
                     'BEGIN ' ||
                     cname || argstr ||
                     'END;');
     -- retireve and bind parameters
      IF acount > 0 THEN
        FOR i in 1..acount LOOP
          dbms_defer_query.get_arg(callno, deferred_tran_db, i, atype,
                                   numargs(i), charargs(i), dateargs(i),
                                   rawargs(i), rowargs(i));
          IF    atype = dbms_defer.arg_type_num THEN
            dbms_sql.bind_variable(sqlcur,':a'||to_char(i),numargs(i));
          ELSIF atype = dbms_defer.arg_type_char OR
                atype = dbms_defer.arg_type_varchar2 THEN
            dbms_sql.bind_variable(sqlcur,':a'||to_char(i),charargs(i));
          ELSIF atype = dbms_defer.arg_type_date THEN
            dbms_sql.bind_variable(sqlcur,':a'||to_char(i),dateargs(i));
          ELSIF atype = dbms_defer.arg_type_raw THEN
            dbms_sql.bind_variable_raw(sqlcur,':a'||to_char(i),rawargs(i));
          ELSIF atype = dbms_defer.arg_type_rowid THEN
            dbms_sql.bind_variable_rid(sqlcur,':a'||to_char(i),rowargs(i));
          ELSE
            -- need check for bad case
            RAISE dbms_defer.dbms_defererror;
          END IF;
        END LOOP;
      END IF;
      -- execute call
      dummy := dbms_sql.execute(sqlcur);
      dbms_sql.close_cursor(sqlcur);
    EXCEPTION WHEN OTHERS THEN
      dbms_sql.close_cursor(sqlcur);
      RAISE;
    END;
  END execute_error_call;
  
  PROCEDURE execute_error_txn(deferred_tran_id IN VARCHAR2,
                              deferred_tran_db IN VARCHAR2,
                              destination      IN VARCHAR2) IS
  -- execute a single transaction that appears in def$_error
  exist NUMBER;
  BEGIN
    SAVEPOINT troublefree;
    -- verify that the transaciton exists
    SELECT 1 INTO exist
      FROM def$_error
      WHERE def$_error.deferred_tran_id = execute_error_txn.deferred_tran_id
        AND def$_error.deferred_tran_db = execute_error_txn.deferred_tran_db
        AND def$_error.destination = execute_error_txn.destination;
    
    -- execute each call of the transaciton
    
    FOR r IN
      (SELECT callno 
         FROM def$_calldest
         WHERE def$_calldest.dblink = destination
           AND def$_calldest.deferred_tran_id = 
               execute_error_txn.deferred_tran_id
           AND def$_calldest.deferred_tran_db = 
               execute_error_txn.deferred_tran_db
         ORDER by callno) LOOP
      execute_error_call(r.callno,execute_error_txn.deferred_tran_db);
    END LOOP;
    -- delete transaction from error queue
    delete_error(execute_error_txn.deferred_tran_id,
                 execute_error_txn.deferred_tran_db,
                 execute_error_txn.destination);
  EXCEPTION WHEN OTHERS THEN
    ROLLBACK TO troublefree;
    RAISE;
  END execute_error_txn;

  PROCEDURE add_default_dest(dblink IN VARCHAR2) IS
  --  Add a node to the default list for replication targets.
  --  Input parameters
  --    dblink
  --      name of the node (dblink) to add to the default list.
  --  Exceptions 
  --    DUP_VAL_ON_INDEX
  --     dblink is already in the default list.
  ----------
  BEGIN
    INSERT INTO def$_defaultdest (dblink)
      VALUES (UPPER(add_default_dest.dblink));
  EXCEPTION WHEN DUP_VAL_ON_INDEX THEN
    RAISE;
  END add_default_dest;
  
  PROCEDURE delete_default_dest(dblink IN VARCHAR2) IS
  --  Delete a node from the default list for repliation targets
  --  Input parameters
  --    dblink
  --      name of the node (dblink) to delete from the default list.
  --      Operation is a no-op if dblink is not in the list.
  --  Exceptions
  --    none.
  -----------------
  BEGIN
    DELETE FROM  def$_defaultdest
      WHERE def$_defaultdest.dblink = UPPER(delete_default_dest.dblink);
  END delete_default_dest;

  -------
  PROCEDURE execute(destination       IN VARCHAR2,
                    stop_on_error     IN BOOLEAN := FALSE,
                    transaction_count IN BINARY_INTEGER := 0,
                    execution_seconds IN BINARY_INTEGER := 0) IS
  --  Execute transactions queued for destination_node. stop_on_error 
  --  determins whether processing
  --  of subsequent transaction continues after an error is detected. 
  --  deftrandest (and defcalldest if appropriate) entries 
  --  for the successfully executed 
  --  transactions are deleted and if there are no other refreences, 
  --  the defcall adn deftran entries are deleted.
  --  Input Parameters:
  --    destination
  --      node (datatbase/dblink) at which to execute 
  --      deferred transaction.  Case
  --      insesitive comparisons used.
  --    stop_on_error
  --      If TRUE, execution of queued transactions will 
  --      alway stop when an error is
  --      encountered, leaving unattempted transaction in 
  --      the queue.  If FALSE,
  --      execution continues except when errors that appear 
  --      to mean that node is 
  --      unavailable are encountered, it which case execution 
  --      always stops, leaving
  --      unattempted transactions queued.
  --    transaction_count
  --      If positive, at most this many transactions will be executed.
  --    executions_seconds
  --      If positive, execution will stop after completions of the
  --      last transaction after this many seconds of executions.
  --  Exceptions
  --    Raises the last exception encountered before execution 
  --    stops because of 
  --    an exception.
  ----------------
  up_node    VARCHAR2(128) := UPPER(destination);

  CURSOR c IS
    SELECT def$_tran.deferred_tran_id, def$_tran.deferred_tran_db,
           def$_tran.destination_list
      FROM def$_trandest, def$_tran
      WHERE  def$_trandest.dblink = up_node 
        AND  def$_trandest.deferred_tran_db = local_node
        AND  def$_tran.deferred_tran_db = local_node
        AND  def$_tran.deferred_tran_db = def$_trandest.deferred_tran_db
        AND  def$_tran.deferred_tran_id = def$_trandest.deferred_tran_id
      ORDER BY def$_tran.delivery_order, def$_tran.deferred_tran_id;

  r          c%ROWTYPE;
  pingrows   INTEGER;
  pingcurs   INTEGER;
  tcount     BINARY_INTEGER := transaction_count;
  startime   DATE;
  execution_days NUMBER;
  BEGIN
    IF execution_seconds > 0 THEN
      execution_days := execution_seconds / 86400; -- seconds/day
      startime := SYSDATE;
    END IF;
    /* parse a cursor for pinging the remote node */
    pingcurs := dbms_sql.open_cursor;
    BEGIN
      dbms_sql.parse(pingcurs,
                     'SELECT NULL FROM dual @ ' || up_node ||
                       ' WHERE 1=0');
    EXCEPTION WHEN OTHERS THEN
      dbms_sql.close_cursor(pingcurs);
      RAISE;
    END;
    FOR r IN c LOOP 
      BEGIN
        execute_txn_node(r.deferred_tran_db, r.deferred_tran_id, up_node,
                         r.destination_list); 
      EXCEPTION WHEN create_error_error THEN
        raise;
      WHEN OTHERS THEN
        BEGIN 
          /* ping the remote node by executing the previously parse cursor */
          pingrows :=  dbms_sql.execute(pingcurs);
        EXCEPTION WHEN OTHERS THEN
          dbms_sql.close_cursor(pingcurs);
          ROLLBACK WORK; /* as if this is really going to work, since if the
                            ping failed remote node is probably dead */
          RAISE;  /* stop execution with error */
        END;
        /* if we get here, the ping succeeded, so we do not have a fatal
           network problem. commit the transaction (conflict table update)
           and continue or stop depending on the user request */
        COMMIT WORK;
        IF stop_on_error THEN
          -- clean up procedure state
          dbms_sql.close_cursor(pingcurs);
          RAISE;
        END IF;
      END;
      COMMIT WORK;
      tcount := tcount - 1;
      EXIT WHEN tcount = 0;
      IF execution_seconds > 0 THEN
        EXIT WHEN (SYSDATE - startime ) > execution_days;
      END IF;
    END LOOP;
    dbms_sql.close_cursor(pingcurs);
  END execute;

  PROCEDURE execute_error(deferred_tran_id IN VARCHAR2,
                          deferred_tran_db IN VARCHAR2,
                          destination      IN VARCHAR2) IS

  --  (Re)Execute transactions that previously encountered conflicts. 
  --  Exectuions stops when any error is encountered.  If some input is null,
  --  then each transaciton is committed as it completes. If exactly one 
  --  transaciton is specified, then the transactions is not commited.
  --  Upon successful execution, transactions are removed for deferror, and if
  --  there are no other references, entries are deleted from 
  --  defcall and deftran.
  --  Input Parameters:
  --    deferrred_tran_db
  --      node (global_name) originating or copying transaction that 
  --      encounterd a errors. If null, then 
  --      deferred_transaciton_id must be null and  all 
  --      trnasactions from all destinations matching destinaiton 
  --      (as specified) are re-executed.
  --           
  --    deferred_transaction_id
  --      The identifier of the transation to be reexecuted.
  --      If null then if all transactions in deferror matching 
  --      deferred transaciton id and destination (as specified) 
  --      are re-executed.
  --    destination
  --      dblink that transaction was originaly destined to.
  --  Exceptions
  --    Raises the last exception encountered before execution 
  --    stops because of an exception.
  ----------------
  updb   VARCHAR2(128) := UPPER(deferred_tran_db);
  updest VARCHAR2(128) := UPPER(destination);
  BEGIN
    IF deferred_tran_id IS NOT NULL
       AND deferred_tran_db IS NOT NULL THEN
      execute_error_txn(deferred_tran_id, updb, updest);
    ELSIF deferred_tran_id IS NULL 
          AND deferred_tran_db IS NOT NULL THEN
      FOR r in
        (SELECT def$_error.deferred_tran_id, 
                def$_error.deferred_tran_db, def$_tran.delivery_order
           FROM def$_error, def$_tran
           WHERE def$_error.deferred_tran_db = updb
             AND def$_error.destination = updest
             AND def$_tran.deferred_tran_id = def$_error.deferred_tran_id
             AND def$_tran.deferred_tran_db = def$_error.deferred_tran_db
           ORDER BY def$_tran.delivery_order, def$_error.deferred_tran_id)
      LOOP
        execute_error_txn(r.deferred_tran_id, updb, updest);
        commit;
      END LOOP;
    ELSIF deferred_tran_id IS NULL
          AND deferred_tran_db IS NULL THEN
      FOR r in
        (SELECT def$_error.deferred_tran_id, 
                def$_error.deferred_tran_db, def$_tran.delivery_order
           FROM def$_error, def$_tran
           WHERE def$_error.destination = updest
             AND def$_tran.deferred_tran_id = def$_error.deferred_tran_id
             AND def$_tran.deferred_tran_db = def$_error.deferred_tran_db
           ORDER BY def$_tran.delivery_order, def$_error.deferred_tran_id)
      LOOP
        execute_error_txn(r.deferred_tran_id, r.deferred_tran_db, updest);
        commit;
      END LOOP;
    END IF;
  END execute_error;
  --------------

  PROCEDURE delete_tran(deferred_tran_id IN VARCHAR2,
                        deferred_tran_db IN VARCHAR2,
                        destination      IN VARCHAR2) IS
  --  Delete transactions from  queues. Deletes deftrandest (and defcalldest
  --  entries if appropriate.  If there are not other references,
  --  deftran and defcall entries are deleted.
  --  Input Parameters:
  --    destination
  --      dblink for which transaction(s) are to be removed from queues.
  --      If null, the transaction specified by the other parameters are 
  --      deleted from queues for all destinations.
  --    deferred_tran_id
  --      The identifier of the transation to be deleted
  --      If null then all transactions matching destination and 
  --      deferred_tran_db are deleted.
  --    deferred_tran_db
  --      The identifier of the origin/copying node for the transaction to be
  --      deleted. If null then all transactiosn matching destination and 
  --      deferred_tran_id are deleted.
  --  Exceptions
  --    tid and/or node not found.
  ---------------
  updest VARCHAR2(128) := UPPER(delete_tran.destination);
  uporig VARCHAR2(128) := UPPER(delete_tran.deferred_tran_db);

  CURSOR cntd IS
    SELECT def$_trandest.deferred_tran_id,
           def$_trandest.deferred_tran_db, def$_trandest.dblink 
      FROM def$_trandest
      WHERE def$_trandest.dblink = updest
        AND def$_trandest.deferred_tran_id =delete_tran.deferred_tran_id
      FOR UPDATE;
  CURSOR cbnd IS
    SELECT def$_trandest.deferred_tran_id,
           def$_trandest.deferred_tran_db, def$_trandest.dblink 
      FROM def$_trandest
      WHERE def$_trandest.dblink = updest
        AND def$_trandest.deferred_tran_db = uporig
      FOR UPDATE;
  CURSOR cbtn IS
    SELECT def$_trandest.deferred_tran_id,
           def$_trandest.deferred_tran_db, def$_trandest.dblink 
      FROM def$_trandest
      WHERE def$_trandest.deferred_tran_id = delete_tran.deferred_tran_id
        AND def$_trandest.deferred_tran_db = uporig
      FOR UPDATE;
  CURSOR cnnd IS
    SELECT def$_trandest.deferred_tran_id,
           def$_trandest.deferred_tran_db, def$_trandest.dblink 
      FROM def$_trandest
      WHERE def$_trandest.dblink = updest
      FOR UPDATE;
  CURSOR cntn IS
    SELECT def$_trandest.deferred_tran_id,
           def$_trandest.deferred_tran_db, def$_trandest.dblink 
      FROM def$_trandest
      WHERE def$_trandest.deferred_tran_id =delete_tran.deferred_tran_id
      FOR UPDATE;
  CURSOR cbnn IS
    SELECT def$_trandest.deferred_tran_id,
           def$_trandest.deferred_tran_db, def$_trandest.dblink 
      FROM def$_trandest
      WHERE def$_trandest.deferred_tran_id =delete_tran.deferred_tran_id
      FOR UPDATE;
  CURSOR cnnn IS
    SELECT def$_trandest.deferred_tran_id,
           def$_trandest.deferred_tran_db, def$_trandest.dblink 
      FROM def$_trandest
      FOR UPDATE;

  BEGIN
    IF (deferred_tran_db     IS NOT NULL 
        AND deferred_tran_id IS NOT NULL
        AND destination      IS NOT NULL) THEN
      DELETE FROM def$_trandest 
        WHERE def$_trandest.deferred_tran_db = uporig
         AND def$_trandest.dblink            = updest
         AND def$_trandest.deferred_tran_id  = delete_tran.deferred_tran_id;
      IF SQL%ROWCOUNT > 0 THEN
        -- don't do any other deletes if there is not a deftrandest record
        -- for the trans - it might be in def$_error
        delete_call_dest(uporig, updest, delete_tran.deferred_tran_id);
        delete_tran_rec(uporig, delete_tran.deferred_tran_id);
      END IF;
    ELSIF (deferred_tran_db     IS     NULL 
           AND deferred_tran_id IS NOT NULL
           AND destination      IS NOT NULL) THEN
      FOR r IN cntd LOOP
        delete_call_dest(r.deferred_tran_db, r.dblink, r.deferred_tran_id);
        DELETE FROM def$_trandest 
          WHERE CURRENT OF cntd;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS NOT NULL 
           AND deferred_tran_id IS     NULL
           AND destination      IS NOT NULL) THEN
      FOR r IN cbnd LOOP
        delete_call_dest(r.deferred_tran_db, r.dblink, r.deferred_tran_id);
        DELETE FROM def$_trandest 
          WHERE CURRENT of cbnd;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS NOT NULL 
           AND deferred_tran_id IS NOT NULL
           AND destination      IS     NULL) THEN
      FOR r IN cbtn LOOP
        delete_call_dest(r.deferred_tran_db, r.dblink, r.deferred_tran_id);
        DELETE FROM def$_trandest 
          WHERE CURRENT of cbtn;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS     NULL 
           AND deferred_tran_id IS     NULL
           AND destination      IS NOT NULL) THEN
      FOR r IN cnnd LOOP
        delete_call_dest(r.deferred_tran_db, r.dblink, r.deferred_tran_id);
        DELETE FROM def$_trandest 
          WHERE CURRENT of cnnd;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS     NULL 
           AND deferred_tran_id IS NOT NULL
           AND destination      IS     NULL) THEN
      FOR r IN cntn LOOP
        delete_call_dest(r.deferred_tran_db, r.dblink, r.deferred_tran_id);
        DELETE FROM def$_trandest 
          WHERE CURRENT of cntn;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS NOT NULL 
           AND deferred_tran_id IS     NULL
           AND destination      IS     NULL) THEN
      FOR r IN cbnn LOOP
        delete_call_dest(r.deferred_tran_db, r.dblink, r.deferred_tran_id);    
        DELETE FROM def$_trandest 
          WHERE CURRENT of cbnn;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSE
      FOR r IN cnnn LOOP
        delete_call_dest(r.deferred_tran_db, r.dblink, r.deferred_tran_id);
        DELETE FROM def$_trandest 
          WHERE CURRENT of cnnn;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    END IF;
  END delete_tran;  
  
  ----------------
  PROCEDURE delete_error(deferred_tran_id IN VARCHAR2,
                         deferred_tran_db IN VARCHAR2,
                         destination      IN VARCHAR2) IS

  --  Delete transactions from  defferror table. If there are 
  --  not other references,
  --  deftran and defcall entries are deleted.
  --  Input Parameters:
  --    destination
  --      destinatoin for which transaction(s) are to be removed from 
  --      deferror.
  --      If null, the transaction specified by the other parameters are 
  --      deleted from deferror for all destinations.
  --    deferred_tran_id
  --      The identifier of the transation to be deleted
  --      If null then all transactions matching destination and 
  --      deferred_tran_db are deleted.
  --    deferred_tran_db
  --      The identifier of the origin/copying node for the transaction to be
  --      deleted. If null then all transaction matching destination and 
  --      deferred_tran_id are deleted.
  --  Exceptions
  --    tid and/or node not found.
  ---------------
  updest VARCHAR2(128) := UPPER(delete_error.destination);
  uporig VARCHAR2(128) := UPPER(delete_error.deferred_tran_db);

  CURSOR cntd IS
    SELECT def$_error.deferred_tran_id,
           def$_error.deferred_tran_db, def$_error.destination 
      FROM def$_error
      WHERE def$_error.destination = updest
        AND def$_error.deferred_tran_id =delete_error.deferred_tran_id
      FOR UPDATE;
  CURSOR cbnd IS
    SELECT def$_error.deferred_tran_id,
           def$_error.deferred_tran_db, def$_error.destination 
      FROM def$_error
      WHERE def$_error.destination = updest
        AND def$_error.deferred_tran_db =uporig
      FOR UPDATE;
  CURSOR cbtn IS
    SELECT def$_error.deferred_tran_id,
           def$_error.deferred_tran_db, def$_error.destination 
      FROM def$_error
      WHERE def$_error.deferred_tran_id =delete_error.deferred_tran_id
        AND def$_error.deferred_tran_db =uporig
      FOR UPDATE;
  CURSOR cnnd IS
    SELECT def$_error.deferred_tran_id,
           def$_error.deferred_tran_db, def$_error.destination 
      FROM def$_error
      WHERE def$_error.destination = updest
      FOR UPDATE;
  CURSOR cntn IS
    SELECT def$_error.deferred_tran_id,
           def$_error.deferred_tran_db, def$_error.destination 
      FROM def$_error
      WHERE def$_error.deferred_tran_id =delete_error.deferred_tran_id
      FOR UPDATE;
  CURSOR cbnn IS
    SELECT def$_error.deferred_tran_id,
           def$_error.deferred_tran_db, def$_error.destination 
      FROM def$_error
      WHERE def$_error.deferred_tran_id =delete_error.deferred_tran_id
      FOR UPDATE;
  CURSOR cnnn IS
    SELECT def$_error.deferred_tran_id,
           def$_error.deferred_tran_db, def$_error.destination 
      FROM def$_error
      FOR UPDATE;

  child_exists EXCEPTION;
  PRAGMA EXECPTION_INIT(child_exists,2292);
  -- need cases to deal with null in parms
  BEGIN
    IF (deferred_tran_db     IS NOT NULL 
        AND deferred_tran_id IS NOT NULL
        AND destination      IS NOT NULL) THEN
      DELETE FROM def$_error 
        WHERE def$_error.deferred_tran_db = uporig
         AND def$_error.destination       = updest
         AND def$_error.deferred_tran_id  = delete_error.deferred_tran_id;
      IF SQL%ROWCOUNT > 0 THEN
        -- don't do any other deletes if there is not a deferror record
        -- for the trans - it might be in def$_tran
        delete_call_dest(uporig, updest, delete_error.deferred_tran_id);
        delete_tran_rec(uporig, delete_error.deferred_tran_id);
      END IF;
    ELSIF (deferred_tran_db     IS     NULL 
           AND deferred_tran_id IS NOT NULL
           AND destination      IS NOT NULL) THEN
      FOR r IN cntd LOOP
        delete_call_dest(r.deferred_tran_db, r.destination, 
                         r.deferred_tran_id);
        DELETE FROM def$_error 
          WHERE CURRENT OF cntd;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS NOT NULL 
           AND deferred_tran_id IS     NULL
           AND destination      IS NOT NULL) THEN
      FOR r IN cbnd LOOP
        delete_call_dest(r.deferred_tran_db, r.destination, 
                         r.deferred_tran_id);
        DELETE FROM def$_error 
          WHERE CURRENT of cbnd;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS NOT NULL 
           AND deferred_tran_id IS NOT NULL
           AND destination      IS     NULL) THEN
      FOR r IN cbtn LOOP
        delete_call_dest(r.deferred_tran_db, r.destination, 
                         r.deferred_tran_id);
        DELETE FROM def$_error 
          WHERE CURRENT of cbtn;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS     NULL 
           AND deferred_tran_id IS     NULL
           AND destination      IS NOT NULL) THEN
      FOR r IN cnnd LOOP
        delete_call_dest(r.deferred_tran_db, r.destination, 
                         r.deferred_tran_id);
        DELETE FROM def$_error 
          WHERE CURRENT of cnnd;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS     NULL 
           AND deferred_tran_id IS NOT NULL
           AND destination      IS     NULL) THEN
      FOR r IN cntn LOOP
        delete_call_dest(r.deferred_tran_db, r.destination, 
                         r.deferred_tran_id);
        DELETE FROM def$_error 
          WHERE CURRENT of cntn;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSIF (deferred_tran_db     IS NOT NULL 
           AND deferred_tran_id IS     NULL
           AND destination      IS     NULL) THEN
      FOR r IN cbnn LOOP
        delete_call_dest(r.deferred_tran_db, r.destination, 
                         r.deferred_tran_id);
        DELETE FROM def$_error 
          WHERE CURRENT of cbnn;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    ELSE
      FOR r IN cnnn LOOP
        delete_call_dest(r.deferred_tran_db, r.destination, 
                         r.deferred_tran_id);
        DELETE FROM def$_error 
          WHERE CURRENT of cnnn;
        delete_tran_rec(r.deferred_tran_db, r.deferred_tran_id);
      END LOOP;
    END IF;
  END delete_error;

  PROCEDURE copy(deferred_tran_id  IN VARCHAR2,
                 deferred_tran_db  IN VARCHAR2,
                 destination_list  IN dbms_defer.node_list_t,
                 destination_count IN BINARY_INTEGER) IS
  --  Copy as deferred transaciton assign it and new 
  --  deferre_tranid , deferred__tran_db, 
  -- executions_order, setting destination_list to 'D'
  --  and retaining the other fields from the stource 
  -- transaction).  The new transacitons has destitntions as 
  -- specifies by destination_list and destination_count.
  -- This call commits the current transaction.
  --    destination_node
  --      the Origin_
  --      Case  insesitive comparisons used.
  --    tid
  --      The identifier of the transation to be added to the node's queue.
  --  Exceptions
  --    tid  not found.
  ---------------
  updb  VARCHAR2(128) := UPPER(deferred_tran_db);
  dummy INTEGER;
  tid   VARCHAR2(128);
  step  NUMBER;
  CURSOR c IS
    SELECT schemaname, packagename, procname, argcount, buffer_number,
           parm_buffer
      FROM def$_call
      WHERE def$_call.deferred_tran_db = updb
        AND def$_call.deferred_tran_id = copy.deferred_tran_id
      ORDER BY callno, buffer_number;
  r c%ROWTYPE;
  BEGIN
    -- verify that the transaction exists.
    SELECT 1  INTO dummy
      FROM def$_tran
      WHERE def$_tran.deferred_tran_id = copy.deferred_tran_id
        AND def$_tran.deferred_tran_db = updb;
 
    -- copy the transction record
    tid := dbms_transaction.local_transaction_id(TRUE);
    INSERT INTO def$_tran(deferred_tran_id, deferred_tran_db, 
                          origin_tran_id, origin_tran_db, origin_user,   
                          delivery_order, destination_list, start_time)
      SELECT tid, local_node, origin_tran_id, origin_tran_db, origin_user,   
              delivery_order, 'D', start_time
        FROM def$_tran
          WHERE def$_tran.deferred_tran_id = copy.deferred_tran_id
            AND def$_tran.deferred_tran_db = updb;
    -- Stick in a new deliver order, cuase can't do that in a select list
    UPDATE def$_tran
      SET delivery_order = USERENV('COMMITSCN')
      WHERE deferred_tran_id = tid
        AND deferred_tran_db = local_node;
    -- stick in the trandest records
    FOR i IN 1..copy.destination_count LOOP
      INSERT INTO def$_trandest(deferred_tran_id, deferred_tran_db, dblink)
        VALUES(tid, local_node, UPPER(copy.destination_list(i)));
    END LOOP;
    -- copy the call records
    FOR r in C LOOP
      IF r.buffer_number = 1 THEN
        step := dbms_transaction.step_id;
      END IF;
      INSERT INTO def$_call (callno, schemaname, packagename, procname,
                             argcount, buffer_number, deferred_tran_db, 
                             deferred_tran_id, parm_buffer)
         VALUES (step,  r.schemaname, r.packagename, r.procname, r.argcount, 
                 r.buffer_number, local_node, tid,  r.parm_buffer);
      -- stick in the calldest records
      IF r.buffer_number = 1 THEN
        FOR i IN 1..copy.destination_count LOOP
          INSERT INTO def$_calldest(callno, deferred_tran_id, deferred_tran_db,
                                    dblink)
            VALUES(step, tid, local_node, UPPER(copy.destination_list(i)));
        END LOOP;
      END IF;
    END LOOP;
  END copy;

  PROCEDURE create_error(deferred_tran_id  IN VARCHAR2,
                         deferred_tran_db  IN VARCHAR2,
                         destination       IN VARCHAR2,
                         call              IN NUMBER,
                         error_number      IN NUMBER,
                         error_message     IN VARCHAR2) IS
                       
  --  Create deferror table record for a transaction at 
  --  some remote node. Delete deftrandest (and defcalldest, 
  --  if appropriate) entries for transaction at the
  --  node executing create_error. If there are not other
  --  references, delete deftran and defcall entries.
  --  Input Parameters:
  --    destiation
  --      dblink to node at which to create deferror table 
  --      entry.
  --    deferred_tran_id
  --      The identifier of the transation.
  --    deferred_tran_db 
  --      databse idetifier component of the transciton.
  --    call 
  --      The identifier of the conflicitng call.  If not null should be
  --      a call within the transaction
  --    error_number
  --      Error number for conflicts table record.
  --    error_message
  --      Error message for conflicts table record.
  --      Truncated to 200 characters.
  --
  --  Exceptions
  
  updest    VARCHAR2(128) := UPPER(destination);
  uptdb     VARCHAR2(128) := UPPER(deferred_tran_db);
  sqlcursor INTEGER; 
  dummy     INTEGER;
  callcount INTEGER;
  atype  INTEGER;         -- buffer for type
  achar  VARCHAR2(2000);  -- buffer for chars
  anum   NUMBER;          -- buffer for numbers
  araw   RAW(256);        -- buffer for raws
  arowid ROWID;           -- buffer for rowid
  adate  DATE;            -- buffer for date
  order_id  NUMBER;
  tr        def$_tran%ROWTYPE;
  CURSOR dc IS
    SELECT def$_call.callno, schemaname, packagename, procname, argcount
       FROM def$_call, def$_calldest 
       WHERE def$_call.deferred_tran_id = create_error.deferred_tran_id
         AND def$_call.deferred_tran_db = uptdb
         AND def$_calldest.deferred_tran_id = create_error.deferred_tran_id
         AND def$_calldest.deferred_tran_db = uptdb
         AND def$_calldest.deferred_tran_db = 
             def$_call.deferred_tran_db 
         AND def$_calldest.deferred_tran_id = 
             def$_call.deferred_tran_id
         AND def$_calldest.dblink = updest
         AND def$_call.buffer_number = 1
       ORDER BY def$_call.callno;
  cr   dc%ROWTYPE;
  BEGIN
    -- Use a savepoint to handle remote trouble
    SAVEPOINT troublefree;

--    dbms_output.put_line('CREATE_ERROR['||deferred_tran_id||','||
--                         deferred_tran_db||','||destination||',');
--    dbms_output.put_line( to_char(call)||','||to_char(error_number)||',');
--    dbms_output.put_line( error_message||']');
    -- verify that the trasnsaction exists
    SELECT 1  INTO dummy
      FROM def$_trandest
      WHERE def$_trandest.deferred_tran_id = create_error.deferred_tran_id
        AND def$_trandest.deferred_tran_db = uptdb
        AND def$_trandest.dblink = updest;
    -- copy the transaction to the destination node
    -- This is done with dynamic sql calls to dbms_defer_internal_sys

    sqlcursor := dbms_sql.open_cursor;
    SELECT * INTO tr
      FROM def$_tran
      WHERE def$_tran.deferred_tran_id = create_error.deferred_tran_id
        AND def$_tran.deferred_tran_db = uptdb;
    
    dbms_sql.parse(sqlcursor,
                   'BEGIN ' ||
                   '  dbms_defer_internal_sys.error_tran@' ||
                        updest || '( ' ||
                          ' :dtid, :dtdb, :otid, :otdb, :ou, :do, :dl, ' ||
                          ' :st, :cc, ' ||
                          ' :ecn, :ed, :en, :em ); ' ||
                   'END; ');
   dbms_sql.bind_variable(sqlcursor,':dtid', create_error.deferred_tran_id);
   dbms_sql.bind_variable(sqlcursor,':dtdb', uptdb);
   dbms_sql.bind_variable(sqlcursor,':otid', tr.origin_tran_id);
   dbms_sql.bind_variable(sqlcursor,':otdb', tr.origin_tran_db);
   dbms_sql.bind_variable(sqlcursor,':ou',   tr.origin_user);
   dbms_sql.bind_variable(sqlcursor,':do',   tr.delivery_order);
   dbms_sql.bind_variable(sqlcursor,':dl',   tr.destination_list);
   dbms_sql.bind_variable(sqlcursor,':st',   tr.start_time);
   dbms_sql.bind_variable(sqlcursor,':cc',   tr.commit_comment);
   dbms_sql.bind_variable(sqlcursor,':ecn',  create_error.call);
   dbms_sql.bind_variable(sqlcursor,':ed',   updest);
   dbms_sql.bind_variable(sqlcursor,':en',   create_error.error_number);
   dbms_sql.bind_variable(sqlcursor,':em',   create_error.error_message);
   dummy := dbms_sql.execute(sqlcursor);

   -- send the calls
   -- only case (now) is detcalldest destinations
   callcount := 0;
   If tr.destination_list = 'D' THEN
   
     FOR cr IN dc LOOP
       callcount := callcount + 1;
       dbms_sql.parse(sqlcursor,
                      'BEGIN ' ||
                      '  dbms_defer_internal_sys.error_call@' || updest ||
                      ' ( :tid, :tdb, :edst, :cno, :sn, :pn, :pkn, :ac ); ' ||
                      'END; ');
       dbms_sql.bind_variable(sqlcursor,':tid', create_error.deferred_tran_id);
       dbms_sql.bind_variable(sqlcursor,':tdb', uptdb);
       dbms_sql.bind_variable(sqlcursor,':edst', updest);
       dbms_sql.bind_variable(sqlcursor,':cno', cr.callno);
       dbms_sql.bind_variable(sqlcursor,':sn',  cr.schemaname);
       dbms_sql.bind_variable(sqlcursor,':pn',  cr.packagename);
       dbms_sql.bind_variable(sqlcursor,':pkn', cr.procname);
       dbms_sql.bind_variable(sqlcursor,':ac',  cr.argcount);
       dummy := dbms_sql.execute(sqlcursor);
       FOR i in 1..cr.argcount LOOP
         dbms_defer_query.get_arg(cr.callno, uptdb, i, atype, anum,
                                  achar, adate, araw, arowid);
         IF atype = dbms_defer.arg_type_num THEN
           dbms_sql.parse(sqlcursor,
                          'BEGIN ' ||
                          '  dbms_defer_internal_sys.error_arg_num@' ||
                            updest ||
                          '   (:tid, :tdb, :edst, :cno, :ano, :arg);' ||
                          'END; ');      
           dbms_sql.bind_variable(sqlcursor,':arg', anum);
         ELSIF atype = dbms_defer.arg_type_char THEN
           dbms_sql.parse(sqlcursor,
                          'BEGIN ' ||
                          '  dbms_defer_internal_sys.error_arg_char@' ||
                            updest ||
                          '   (:tid, :tdb, :edst, :cno, :ano, :arg);' ||
                          'END; ');      
           dbms_sql.bind_variable(sqlcursor,':arg', achar);
         ELSIF atype=dbms_defer.arg_type_varchar2 THEN
           dbms_sql.parse(sqlcursor,
                          'BEGIN ' ||
                          '  dbms_defer_internal_sys.error_arg_varchar2@' ||
                            updest ||
                          '   (:tid, :tdb, :edst, :cno, :ano, :arg);' ||
                          'END; ');      
           dbms_sql.bind_variable(sqlcursor,':arg', achar);
         ELSIF atype = dbms_defer.arg_type_date THEN
           dbms_sql.parse(sqlcursor,
                          'BEGIN ' ||
                          '  dbms_defer_internal_sys.error_arg_date@' ||
                            updest ||
                          '   (:tid, :tdb, :edst, :cno, :ano, :arg);' ||
                          'END; ');      
           dbms_sql.bind_variable(sqlcursor,':arg', adate);
         ELSIF atype = dbms_defer.arg_type_raw THEN
           dbms_sql.parse(sqlcursor,
                          'BEGIN ' ||
                          '  dbms_defer_internal_sys.error_arg_raw@' ||
                            updest ||
                          '   (:tid, :tdb, :edst, :cno, :ano, :arg);' ||
                          'END; ');      
           dbms_sql.bind_variable_raw(sqlcursor,':arg', araw);  
         ELSIF atype = dbms_defer.arg_type_rowid THEN
           dbms_sql.parse(sqlcursor,
                          'BEGIN ' ||
                          '  dbms_defer_internal_sys.error_arg_rowid@' ||
                            updest ||
                          '   (:tid, :tdb, :edst, :cno, :ano, :arg);' ||
                          'END; ');      
           dbms_sql.bind_variable_rid(sqlcursor,':arg', arowid);
           -- need sanity check for invalid type 
         END IF;
         dbms_sql.bind_variable(sqlcursor,':tid',
                                create_error.deferred_tran_id);
         dbms_sql.bind_variable(sqlcursor,':tdb', uptdb);
         dbms_sql.bind_variable(sqlcursor,':edst', updest);
         dbms_sql.bind_variable(sqlcursor,':cno', cr.callno);
         dbms_sql.bind_variable(sqlcursor,':ano', i);

         dummy := dbms_sql.execute(sqlcursor);
       END LOOP;
     END LOOP;
   END IF;
   -- send the end of error transaciton call
   dbms_sql.parse(sqlcursor,
                  'BEGIN ' ||
                  '  dbms_defer_internal_sys.error_end_tran@' ||
                            updest ||
                          '   (:tid, :tdb, :edst, :ccnt); ' ||
                          'END; ');      
   dbms_sql.bind_variable(sqlcursor,':tid',  create_error.deferred_tran_id);
   dbms_sql.bind_variable(sqlcursor,':tdb',  uptdb);
   dbms_sql.bind_variable(sqlcursor,':edst', updest);
   dbms_sql.bind_variable(sqlcursor,':ccnt', callcount);
   dummy := dbms_sql.execute(sqlcursor);

   -- delete the transaction from the local queues
   -- can not use delete_tran becaue this migh be a loopback destinatino and
   -- we need to preserve the def$_calldest records
   DELETE FROM def$_trandest
     WHERE def$_trandest.dblink = updest
       AND def$_trandest.deferred_tran_id = create_error.deferred_tran_id
       AND def$_trandest.deferred_tran_db = uptdb;
   SELECT COUNT(*) INTO dummy
     FROM def$_error
     WHERE def$_error.deferred_tran_id = create_error.deferred_tran_id
       AND def$_error.deferred_tran_db = uptdb
       AND def$_error.destination = updest;
   IF dummy = 0 THEN -- not loop back
     delete_call_dest(uptdb, updest, create_error.destination);
     delete_tran_rec(uptdb, create_error.destination);
   END IF;
  EXCEPTION WHEN OTHERS THEN
    ROLLBACK TO troublefree;
    RAISE;
  END create_error;
  -----------------


-- PACKAGE INITIALIZATION  
BEGIN
  SELECT global_name INTO local_node FROM global_name;
  dccursor    := dbms_sql.open_cursor;
  dccursorrpi := dbms_sql.get_rpi_cursor(dccursor);
  dbms_sql.parse(dccursor,
                 'SELECT def$_call.callno, buffer_number, schemaname, ' ||
                 '       packagename, '||
                 '       procname, argcount, parm_buffer ' ||
                 '  FROM def$_call, def$_calldest ' ||
                 '  WHERE  def$_calldest.deferred_tran_id = :tid ' || 
                 '    AND def$_calldest.deferred_tran_db = :localnode ' ||
                 '    AND def$_calldest.deferred_tran_db = ' ||
                 '         def$_call.deferred_tran_db ' ||
                 '    AND def$_calldest.deferred_tran_id = ' ||
                 '         def$_call.deferred_tran_id ' ||
                 '    AND def$_calldest.callno = def$_call.callno ' ||
                 '    AND def$_calldest.dblink = :dest ' ||
                 '  ORDER BY def$_call.callno, def$_call.buffer_number');

END dbms_defer_sys;
/

CREATE OR REPLACE  PACKAGE BODY  dbms_defer AS

  -- Exceptions used internally 
  buffer_overflow EXCEPTION;
  PRAGMA EXECPTION_INIT(buffer_overflow, -6558);

  --  GLOBAL PAACKAGE STATE
  -- following state is used for checking that calls and transaction 
  -- are well-formed
  -- see dbms_deferdef.sql for description of well formed deferred transactions
  --  
  -- transaction state
  current_call_tid       VARCHAR2(22);       -- pseudo tid for checking 
                                             -- that call 
                                             -- is well formed
  -- state that contains the default distribution list for the transaction
  current_tran_dest_cat  BOOLEAN := FALSE;   -- use repcat for destinations
  current_default_list   node_list_t;
  current_default_count  BINARY_INTEGER;
  last_call_dest_default BOOLEAN := FALSE;   -- last call used default dests 

  -- call state
  current_call_id        NUMBER;             -- call id for arg calls
  current_call_arg_count BINARY_INTEGER :=0; -- total number of parameters 
                                             -- to call
                                               -- currently being processed
  current_call_schema_name  VARCHAR2(30);      -- call schema name
  current_call_package_name VARCHAR2(30);      -- call package name
  current_call_proc_name    VARCHAR2(30);      -- call procedure name  
  current_call_arg_no    BINARY_INTEGER :=0; -- last parameter processeed
  current_call_nodes     node_list_t;        -- destination for this call
                                             -- if current_tran_dest_cat =
                                             -- false;
  current_call_node_count   BINARY_INTEGER;
  current_call_buffer_count BINARY_INTEGER;  -- number of parm buffers being
                                             -- written.
  current_call_new_list     BOOLEAN;         -- new destination list
                                             -- must update tranddest 
  current_call_first_call   BOOLEAN;         -- new transactions, update
                                             -- trandest blindly
  current_call_buffer    RAW(4096) := rpad('00',8192,'00'); 
                                             -- dbms_defer_sys.parm_buffer_size
  current_call_buffer_position BINARY_INTEGER;
  -----------

  -- local node id for queue tables
  local_node VARCHAR2(128);


  -- INTERNAL PROCEDURES
  PROCEDURE malformed IS
  --  generate an exception including internal state
  argcount  VARCHAR2(100);
  argno     VARCHAR2(100);
  calltid   VARCHAR2(100);
  currtid   VARCHAR2(100);
  BEGIN
    /* capture the state of the package for the error message */
    argcount := TO_CHAR(current_call_arg_count);
    argno    := TO_CHAR(current_call_arg_no);
    calltid  := current_call_tid;
    currtid  := dbms_transaction.local_transaction_id(FALSE);

    /* correct the package state so that future calls will work */
    current_call_arg_count := 0;
    current_call_arg_no    := 0;
    current_call_tid       := NULL;

    /* raise the exception */
    raise_application_error(-20670,
                            'Mall-formed defered rpc call [argcount: ' ||
                            argcount || ', argno: ' || argno || 
                            ', calltid: ' ||
                            calltid || ', currenttid: ' || currtid || ']');
  END malformed;

  ---------------------------------------
  --  PACKAGE EXTERNAL PROCEDURES
  --

  PROCEDURE commit_work(commit_work_comment IN VARCHAR2) IS
  --  Perform a transaction commmit after checking for 
  --  well-formed defered RPCs.
  --    Must be used instead of the commit work sql call 
  --    for transactions defering RPCS.
  --    Updates the comment_comment and commit_scn fields 
  --    in the def$_txn table.
  --  Input parameters:
  --    commit_work_comment
  --      Up to fifty characters to describe the transaction 
  --      in the def$_tran
  --      table and system two-phase commit tables 
  --      Comment is truncated to fifty characters.
  --  Exceptions
  --    ORA-20670 (malformedcall) if there is an defer_rpc_arg call 
  --      missing or defer_txn
  --      was not called for this transaction.
  BEGIN
    IF current_call_arg_count != current_call_arg_no THEN
      malformed;
    END IF;
    IF current_call_tid != dbms_transaction.local_transaction_id(FALSE) THEN
      malformed;
    END IF;
    IF commit_work_comment IS NOT NULL THEN
    UPDATE def$_tran SET commit_comment = commit_work_comment
      WHERE deferred_tran_id = current_call_tid and
            deferred_tran_db = local_node;
    END IF;
    /* use the commit_comment call from standard package */
    dbms_standard.commit_cm(commit_work_comment);
    current_call_tid := NULL;
  END commit_work;


  PROCEDURE add_transaction(dest_list CHAR) IS
  --  Internal procedure to add transaction to queue tables
  --  Exceptions
  --    ORA-20670 (malformedcall) if the previous transaction 
  --      not correctly formed 
  --      or terminated
  i BINARY_INTEGER;
  BEGIN

    IF current_call_arg_count != current_call_arg_no THEN
      malformed; 
    END IF;
    current_call_tid := dbms_transaction.local_transaction_id(TRUE);
    last_call_dest_default := FALSE;
 
    INSERT INTO def$_tran(deferred_tran_id, deferred_tran_db, 
                          origin_tran_id, origin_tran_db, origin_user,   
                          delivery_order, destination_list, start_time)
      VALUES(current_call_tid, local_node, current_call_tid, local_node,
             USER, USERENV('COMMITSCN'), dest_list, SYSDATE );

  END add_transaction;

  PROCEDURE transaction IS
  --  Mark a transaciton as defered (as containing deferred RPCs )
  --     This call is optional.  The first call to dbms_defer.call in a 
  --     transaction will call
  --     transaction (with no arguments) if it has not been previously called.
  --     Input parameters are optional, and if they are not 
  --     specified the destination
  --     list is taken from the system defaults stored in the 
  --     def$_targets table and
  --     maintained by the defrpc_sys.add_default_node and 
  --     defrpc_sys.delete_default_node calls
  --  Exceptions
  --    ORA-20670 (malformedcall) if the previous 
  --      transaction not correctly formed 
  --      or terminated
  ----
  CURSOR c IS SELECT def$_defaultdest.dblink
                FROM def$_defaultdest;
  r   c%rowtype;
  BEGIN
    current_default_count := 0;
    FOR r IN c LOOP
      current_default_count := current_default_count + 1;
      current_default_list(current_default_count) := r.dblink;
    END LOOP;
    -- call common subroutine to add transaction
    add_transaction('D');
  END transaction; 


  PROCEDURE transaction(nodes      IN node_list_t,
                        node_count IN BINARY_INTEGER) IS
  --  Mark a transaciton as defered (as containing deferred RPCs )
  --     This call is optional.  The first call to dbms_defer.call in a 
  --     transaction will call
  --     transaction (with no arguments) if it has not been previously called.
  --     Input parameters are optional, and if they are not 
  --     specified the destination
  --     list is taken from the system defaults stored in the 
  --     def$_targets table and
  --     maintained by the defrpc_sys.add_default_node and 
  --     defrpc_sys.delete_default_node calls
  --  Input parameters:
  --    nodes
  --      Table containg a list of nodes to propogate the 
  --        deferred calls of the 
  --        transaction to.  Indexed from 1 to node_count. 
  --        Case insensitive comparison
  --        used for node lists.
  --    node_count
  --      Count of the number of entries in nodes.
  --  Exceptions
  --    ORA-20670 (malformedcall) if the previous transaction 
  --      not correctly formed 
  --      or terminated
  ----
  BEGIN
    current_default_count := node_count;
    current_default_list  := nodes;
    -- call common subroutine to add transaction
    add_transaction('D');
  END transaction; 

  ----------
  -- Internal procedures to implemnted deferred call record writing
  PROCEDURE write_call_record IS
    dest_already_there BINARY_INTEGER;
    writebuf RAW(4096); --  dbms_defer_sys.parm_buffer_size;
  BEGIN
    /* set up write buffer */
    IF current_call_arg_count > 0 THEN
      -- watch out! wierd implicit raw to hexing and hex to rawing
      -- that is why the 2* bufpos+1
      writebuf := SUBSTR(current_call_buffer,1,
                         2*(current_call_buffer_position+1));
    END IF;

    /* first buffer, write package data, destination data */
    IF current_call_buffer_count = 1 THEN
      /* skip writing buffer if no args */     
      IF current_call_arg_count = 0 THEN
        INSERT INTO def$_call (callno, buffer_number, deferred_tran_db,
                               deferred_tran_id,
                               schemaname, packagename, procname, argcount)
          VALUES (current_call_id,  1, local_node, current_call_tid,
                  current_call_schema_name,
                  current_call_package_name,
                  current_call_proc_name, 0);
      ELSE
      /* write buffer */
        INSERT INTO def$_call (callno, buffer_number, deferred_tran_db,
                               deferred_tran_id,
                               schemaname, packagename, procname, argcount,
                               parm_buffer)
          VALUES (current_call_id,  1, local_node, current_call_tid,
                  current_call_schema_name,
                  current_call_package_name,
                  current_call_proc_name, current_call_arg_count, writebuf);
      END IF; -- current_call_arg_count not 0
      /* set destination data */
      /* if catalog not in use set defcalldest */
      IF NOT current_tran_dest_cat THEN
        FOR i IN 1..current_call_node_count LOOP
          INSERT INTO def$_calldest(callno, deferred_tran_id, deferred_tran_db,
                                    dblink)
          VALUES(current_call_id, current_call_tid, local_node,
                 UPPER(current_call_nodes(i)));
        END LOOP;
      END IF; -- current_tran_dest_cat
      /* if this list not same a previouscall in transaciton set deftrandest */
      IF current_call_new_list THEN
        FOR i IN 1..current_call_node_count LOOP
          /* dont check for duplicated list entries on first call */
          IF NOT current_call_first_call THEN
            SELECT 1 INTO dest_already_there
              FROM  def$_trandest
              WHERE deferred_tran_id = current_call_tid AND
                    deferred_tran_db = local_node       AND
                    dblink           = UPPER(current_call_nodes(i));
          ELSE
            dest_already_there := 0;
          END IF;
          IF dest_already_there = 0 THEN
            INSERT INTO def$_trandest(deferred_tran_id,
                                      deferred_tran_db, dblink)
              VALUES(current_call_tid, local_node,
                     UPPER(current_call_nodes(i)));
          END IF;
        END LOOP;
      END IF; -- new_list
    ELSE -- buffer_count not 1 just insert the call record
      INSERT INTO def$_call (callno, buffer_number, deferred_tran_db,
                             deferred_tran_id,   parm_buffer)
         VALUES (current_call_id,  current_call_buffer_count,
                 local_node, current_call_tid, writebuf);
    END IF; -- buffer_count not 1
    current_call_buffer_count := current_call_buffer_count + 1;
    dbms_defer_pack.reset_buffer(current_call_buffer,
                                 current_call_buffer_position);
  END write_call_record;

  -- Internal Procedure to implement call procedure
  -- 
  PROCEDURE add_call( schema_name  IN VARCHAR2,
                      package_name IN VARCHAR2,
                      proc_name    IN VARCHAR2,    
                      arg_count    IN BINARY_INTEGER,
                      new_list     IN BOOLEAN,
                      first_call   IN BOOLEAN,
                      nodes        IN node_list_t,
                      node_count   IN BINARY_INTEGER) IS
  --  Defer a remote procedure call.  Automatically call 
  --    deftxn if this is the first
  --    call call of a transaction.
  --  Input parameters:
  --    schema_name
  --      Name of the schema containing the remote procedure.  For
  --      compatibility with future compile-time checking only string
  --      constants should be used.  
  --    package_name
  --      Name of the package containing the remote procedure.  For
  --      compatibility with future compile-time checking only string
  --      constants should be used.  
  --    proc_name
  --      Name of the remote procedure to call.  
  --        For compatibility with
  --        future syntatic integration
  --        and compile-time checking only string constants should be used.
  --    arg_count
  --       Number of parameters to the procedure.  This must 
  --       exactly match the number of
  --       defrpcarg_* calls immediatly following the dbms_defer.call call.
  --    new_list
  --       TRUE if deftrandest needs updates.
  --    first_call
  --       TRUE if deftrandest can be blindly updated. (first call of tran).
  --    nodes
  --      Optional table containing a list of nodes to propogate the 
  --      deferred call to.  
  --        Case insensitive comparison
  --        used for node lists.
  --      If not specified, the destination list is determined by the
  --      list passed to the transaction procedure, or the system defaults.
  --    node_count
  --      Count of the number of entries in nodes.

  BEGIN
    current_call_schema_name  := UPPER(schema_name);
    current_call_package_name := UPPER(package_name);
    current_call_proc_name    := UPPER(proc_name);
    current_call_arg_count    := arg_count;
    current_call_new_list     := new_list;
    current_call_first_call   := first_call;
    current_call_nodes        := nodes;
    current_call_node_count   := node_count;

    current_call_arg_no       := 0;
    current_call_id           := dbms_transaction.step_id;
    current_call_buffer_count :=1;
    dbms_defer_pack.reset_buffer(current_call_buffer,
                                 current_call_buffer_position);

    IF arg_count = 0 THEN
      write_call_record;
    END IF;
  END add_call;

  PROCEDURE call( schema_name  IN VARCHAR2,
                  package_name IN VARCHAR2,
                  proc_name    IN VARCHAR2,    
                  arg_count    IN BINARY_INTEGER) IS
  --  Defer a remote procedure call.  Automatically call 
  --    deftxn if this is the first
  --    call call of a transaction.
  --  Input parameters:
  --    schema_name
  --      Name of the schema containing the remote procedure.  For
  --      compatibility with future compile-time checking only string
  --      constants should be used.  
  --    package_name
  --      Name of the package containing the remote procedure.  For
  --      compatibility with future compile-time checking only string
  --      constants should be used.  
  --    proc_name
  --      Name of the remote procedure to call.  
  --        For compatibility with
  --        future syntatic integration
  --        and compile-time checking only string constants should be used.
  --    arg_count
  --       Number of parameters to the procedure.  This must 
  --       exactly match the number of
  --       defrpcarg_* calls immediatly following the dbms_defer.call call.
  --  Exceptions
  --    ORA-20670 (malformedcall) if the previous call not 
  --      correctly formed (number of
  --      defrpcarg_* call not matched to arg_count).
  cur_tid VARCHAR2(22);
  first_call BOOLEAN := FALSE;
  BEGIN
    cur_tid := dbms_transaction.local_transaction_id(FALSE);
    IF current_call_tid IS NULL OR cur_tid IS NULL OR
       current_call_tid != cur_tid THEN
      /* for repcat supplied distribution lists need different logic 
         on first call */
      first_call := TRUE;
      transaction; /* create transaction */
    END IF;
    IF current_call_arg_count != current_call_arg_no THEN
      malformed; 
    END IF;
    /* for repcat suplied distributes lists need different logic for
       new list */
    add_call(schema_name, package_name, proc_name, arg_count,
             (NOT last_call_dest_default), first_call, current_default_list,
             current_default_count);
    last_call_dest_default := TRUE;
  END call;

  PROCEDURE call( schema_name  IN VARCHAR2,
                  package_name IN VARCHAR2,
                  proc_name    IN VARCHAR2,    
                  arg_count    IN BINARY_INTEGER,
                  nodes        IN node_list_t,
                  node_count   IN BINARY_INTEGER) IS
  --  Defer a remote procedure call.  Automatically call 
  --    deftxn if this is the first
  --    call call of a transaction.
  --  Input parameters:
  --    schema_name
  --      Name of the schema containing the remote procedure.  For
  --      compatibility with future compile-time checking only string
  --      constants should be used.  
  --    package_name
  --      Name of the package containing the remote procedure.  For
  --      compatibility with future compile-time checking only string
  --      constants should be used.  
  --    proc_name
  --      Name of the remote procedure to call.  
  --        For compatibility with
  --        future syntatic integration
  --        and compile-time checking only string constants should be used.
  --    arg_count
  --       Number of parameters to the procedure.  This must 
  --       exactly match the number of
  --       defrpcarg_* calls immediatly following the dbms_defer.call call.
  --    nodes
  --      Optional table containing a list of nodes to propogate the 
  --      deferred call to.  
  --        Case insonsitive comparison
  --        used for node lists.
  --      If not specified, the destination list is determined by the
  --      list passed to the transaction procedure, or the system defaults.
  --    node_count
  --      Count of the number of entries in nodes.
  --  Exceptions
  --    ORA-20670 (malformedcall) if the previous call not 
  --      correctly formed (number of
  --      defrpcarg_* call not matched to arg_count).
  ----
  i          BINARY_INTEGER;
  cur_tid    VARCHAR2(22);
  first_call BOOLEAN := FALSE;
  BEGIN
    -- check for new transaction
    cur_tid := dbms_transaction.local_transaction_id(FALSE);
    IF current_call_tid IS NULL OR cur_tid IS NULL OR
       current_call_tid != cur_tid THEN
      transaction;
      first_call := TRUE;
    END IF;

    -- check for mall formed call
    IF current_call_arg_count != current_call_arg_no THEN
      malformed; 
    END IF;
     
    -- do the call
    add_call(schema_name, package_name, proc_name, arg_count,
             TRUE, first_call, nodes, node_count);
  END call;

  PROCEDURE number_arg(arg IN NUMBER) IS
  --  Queue a number parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The number value of the parameter to the call 
  --        previously defered with a 
  --        dbms_defer.call call.
  --  Exceptions: none.
  --------
    buffer_overflow EXCEPTION;
    PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);
  BEGIN
    current_call_arg_no := current_call_arg_no + 1;
  
    BEGIN  -- catch buffer overflow 
      dbms_defer_pack.pack(arg, current_call_buffer, 
                           current_call_buffer_position);
    EXCEPTION WHEN buffer_overflow THEN
      write_call_record;
      dbms_defer_pack.pack(arg, current_call_buffer, 
                           current_call_buffer_position);
    END;  -- catch buffer overflow
    IF current_call_arg_no = current_call_arg_count THEN
      -- last parameter of call
      write_call_record;
    END IF;
  END number_arg;

  PROCEDURE char_arg(arg  IN CHAR) IS
  --  Queue a char parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The char value of the parameter to the call previously 
  --        defered with a 
  --        dbms_defer.call call. The length of arg is limited to 2000.
  --  Exceptions: 
  --    whatever error sql gives if arg exceeds 2000 characters.
    buffer_overflow EXCEPTION;
    PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);
  BEGIN
    IF lengthb(arg) > 2000 THEN
      RAISE parameterlength;
    END IF;
    current_call_arg_no := current_call_arg_no + 1;

    BEGIN  -- catch buffer overflow 
      dbms_defer_pack.pack(arg, current_call_buffer, 
                           current_call_buffer_position);
    EXCEPTION WHEN buffer_overflow THEN
      write_call_record;
      dbms_defer_pack.pack(arg, current_call_buffer, 
                           current_call_buffer_position);
    END;  -- catch buffer overflow
    IF current_call_arg_no = current_call_arg_count THEN
      -- last parameter of call
      write_call_record;
    END IF;

  END char_arg;
 

  PROCEDURE varchar2_arg(arg  IN VARCHAR2) IS
  --  Queue a varchar2 parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The varchar2 value of the parameter to the call 
  --        previously defered with a 
  --        dbms_defer.call call. The length of arg is limited to 2000.
  --  Exceptions: 
  --    whatever error sql gives if arg exceeds 2000 characters.
  --------------
    buffer_overflow EXCEPTION;
    PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);
  BEGIN
    IF lengthb(arg) > 2000 THEN
      RAISE parameterlength;
    END IF;
    current_call_arg_no := current_call_arg_no + 1;

    BEGIN  -- catch buffer overflow 
      dbms_defer_pack.pack(arg, current_call_buffer, 
                           current_call_buffer_position);
    EXCEPTION 
      WHEN buffer_overflow THEN
        write_call_record;
        dbms_defer_pack.pack(arg, current_call_buffer, 
                             current_call_buffer_position);
    END;  -- catch buffer overflow
    IF current_call_arg_no = current_call_arg_count THEN
      -- last parameter of call
      write_call_record;
    END IF;

  END varchar2_arg;
  
  PROCEDURE date_arg(arg IN DATE) is
  --  Queue a date parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The date value of the parameter to the call previously 
  --        defered with a 
  --        dbms_defer.call call.
  --  Exceptions: none.
  -------- 
    buffer_overflow EXCEPTION;
    PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);
  BEGIN
    current_call_arg_no := current_call_arg_no + 1;

    BEGIN  -- catch buffer overflow 
      dbms_defer_pack.pack(arg, current_call_buffer, 
                           current_call_buffer_position);
    EXCEPTION WHEN buffer_overflow THEN
      write_call_record;
      dbms_defer_pack.pack(arg, current_call_buffer, 
                           current_call_buffer_position);
    END;  -- catch buffer overflow
    IF current_call_arg_no = current_call_arg_count THEN
      -- last parameter of call
      write_call_record;
    END IF;
  END date_arg;
  
  --  The following call is should be used with extreme caution. 
  --  rowids can not be
  --  used on different nodes.  It might be reasonable to use a rid 
  --  in a defered call 
  --  to a local node, but be carefull
  PROCEDURE rowid_arg(arg IN ROWID) IS
  --  Queue a rowid parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The rowid value of the parameter to the call 
  --        previously defered with a 
  --        dbms_defer.call call.
  --  Exceptions: 
  --    dbms_defererror
  --------
    buffer_overflow EXCEPTION;
    PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);
  BEGIN

    current_call_arg_no := current_call_arg_no + 1;

    BEGIN  -- catch buffer overflow 
      dbms_defer_pack.pack(arg, current_call_buffer, 
                           current_call_buffer_position);
    EXCEPTION WHEN buffer_overflow THEN
      write_call_record;
      dbms_defer_pack.pack_rowid(arg, current_call_buffer, 
                                 current_call_buffer_position);
    END;  -- catch buffer overflow
    IF current_call_arg_no = current_call_arg_count THEN
      -- last parameter of call
      write_call_record;
    END IF;
  END rowid_arg;

  PROCEDURE raw_arg(arg IN RAW) IS
  --  Queue a raw parameter value for a defered call.
  --  Input parameter:
  --    arg 
  --      The raw value of the parameter to the call 
  --        previously defered with a 
  --        dbms_defer.call call.
  --  Exceptions: 
  --    dbms_defererror
  --------
    buffer_overflow EXCEPTION;
    PRAGMA EXCEPTION_INIT(buffer_overflow,-6558);
  BEGIN
    IF lengthb(arg) > 255 THEN
      RAISE parameterlength;
    END IF;

    current_call_arg_no := current_call_arg_no + 1;

    BEGIN  -- catch buffer overflow 
      dbms_defer_pack.pack_raw(arg, current_call_buffer, 
                           current_call_buffer_position);
    EXCEPTION WHEN buffer_overflow THEN
      write_call_record;
      dbms_defer_pack.pack_raw(arg, current_call_buffer, 
                               current_call_buffer_position);
    END;  -- catch buffer overflow
    IF current_call_arg_no = current_call_arg_count THEN
      -- last parameter of call
      write_call_record;
    END IF;
  END raw_arg;
  
--------------
-- PACKAGE INITIALIZATION  
BEGIN
  SELECT global_name INTO local_node FROM global_name;
END dbms_defer;
/


