/* Copyright (c) 1991 by Oracle Corporation */
/*
   NAME
     ocikpr.h - header of K & R compilers

 *  Declare the OCI functions.
 *  Prototype information is commented out.
 *  Use this header for non-ANSI C compilers.
 *  Note that you will need to include ocidfn.h in the .c files
 *    to get the definition for cda_def.
 */

#ifndef OCIKPR
#define OCIKPR

#ifdef __IBMC__
# ifndef ORAENTRY
#  define ORAENTRY _System
# endif
#else
# ifdef __BORLANDC__
#  ifndef ORAENTRY
#   define ORAENTRY _syscall
#  endif
# else
#  define ORAENTRY
# endif
#endif

#include <oratypes.h>

#ifdef __cplusplus
extern "c" {
#endif

sword  ORAENTRY   obndra( /*_ struct cda_def *cursor, text *sqlvar, sword sqlvl,
                         ub1 *progv, sword progvl, sword ftype, sword scale,
                         sb2 *indp, ub2 *alen, ub2 *arcode, ub4 maxsiz,
                         ub4 *cursiz, text *fmt, sword fmtl, sword fmtt _*/ );
sword  ORAENTRY   obndrn( /*_ struct cda_def *cursor, sword sqlvn, ub1 *progv,
                         sword progvl, sword ftype, sword scale, sb2 *indp,
                         text *fmt, sword fmtl, sword fmtt _*/ );
sword  ORAENTRY   obndrv( /*_ struct cda_def *cursor, text *sqlvar, sword sqlvl,
                         ub1 *progv, sword progvl, sword ftype, sword scale,
                         sb2 *indp, text *fmt, sword fmtl, sword fmtt _*/ );
sword  ORAENTRY   obreak( /*_ struct cda_def *lda _*/ );
sword  ORAENTRY   ocan  ( /*_ struct cda_def *cursor _*/ );
sword  ORAENTRY   oclose( /*_ struct cda_def *cursor _*/ );
sword  ORAENTRY   ocof  ( /*_ struct cda_def *lda _*/ );
sword  ORAENTRY   ocom  ( /*_ struct cda_def *lda _*/ );
sword  ORAENTRY   ocon  ( /*_ struct cda_def *lda _*/ );
sword  ORAENTRY   odefin( /*_ struct cda_def *cursor, sword pos, ub1 *buf,
                         sword bufl, sword ftype, sword scale, sb2 *indp,
                         text *fmt, sword fmtl, sword fmtt, ub2 *rlen, 
                         ub2 *rcode _*/ );
sword  ORAENTRY   odescr( /*_ struct cda_def *cursor, sword pos, sb4 *dbsize,
                         sb2 *dbtype, sb1 *cbuf, sb4 *cbufl, sb4 *dsize,
                         sb2 *prec, sb2 *scale, sb2 *nullok _*/ );
sword  ORAENTRY   odessp( /*_ struct cda_def *cursor, text *objnam, size_t onlen,
                         ub1 *rsv1, size_t rsv1ln, ub1 *rsv2, size_t rsv2ln,
                         ub2 *ovrld, ub2 *pos, ub2 *level, text **argnam,
                         ub2 *arnlen, ub2 *dtype, ub1 *defsup, ub1* mode,
                         ub4 *dtsiz, sb2 *prec, sb2 *scale, ub1 *radix,
                         ub4 *spare, ub4 *arrsiz _*/ );
sword  ORAENTRY   oerhms( /*_ struct cda_def *lda, sb2 rcode, text *buf,
                         sword bufsiz _*/ );
sword  ORAENTRY   oermsg( /*_ sb2 rcode, text *buf _*/ );
sword  ORAENTRY   oexec ( /*_ struct cda_def *cursor _*/ );
sword  ORAENTRY   oexfet( /*_ struct cda_def *cursor, ub4 nrows,
                         sword cancel, sword exact _*/ );
sword  ORAENTRY   oexn  ( /*_ struct cda_def *cursor, sword iters, sword rowoff _*/ );
sword  ORAENTRY   ofen  ( /*_ struct cda_def *cursor, sword nrows _*/ );
sword  ORAENTRY   ofetch( /*_ struct cda_def *cursor _*/ );
sword  ORAENTRY   oflng ( /*_ struct cda_def *cursor, sword pos, ub1 *buf,
                         sb4 bufl, sword dtype, ub4 *retl, sb4 offset _*/ );
sword  ORAENTRY   olog  ( /*_ struct cda_def *lda, ub1 *hst, 
                         text *uid, sword uidl,
                         text *psw, sword pswl, 
                         text *conn, sword connl, 
                         ub4 mode _*/ );
sword  ORAENTRY   ologof( /*_ struct cda_def *lda _*/ );
sword  ORAENTRY   oopen ( /*_ struct cda_def *cursor, struct cda_def *lda,
                         text *dbn, sword dbnl, sword arsize,
                         text *uid, sword uidl _*/ );
sword  ORAENTRY   oopt  ( /*_ struct cda_def *cursor, sword rbopt, sword waitopt _*/ );
sword  ORAENTRY   oparse( /*_ struct cda_def *cursor, text *sqlstm, sb4 sqllen,
                         sword defflg, ub4 lngflg _*/ );
sword  ORAENTRY   orol  ( /*_ struct cda_def *lda _*/ );

void   ORAENTRY sqlld2  ( /*_ struct cda_def *lda, text *cname, sb4 *cnlen _*/ );
void   ORAENTRY sqllda  ( /*_ struct cda_def *lda _*/ );

/* non-blocking functions */
sword  ORAENTRY  onbset ( /*_ struct cda_def *lda _*/ ); 
sword  ORAENTRY  onbtst ( /*_ struct cda_def *lda _*/ ); 
sword  ORAENTRY  onbclr ( /*_ struct cda_def *lda _*/ ); 


/* older calls ; preferred equivalent calls above */
sword  ORAENTRY   odsc  ( /*_ struct cda_def *cursor, sword pos, sb2 *dbsize,
                         sb2 *fsize, sb2 *rcode, sb2 *dtype, sb1 *buf,
                         sb2 *bufl, sb2 *dsize _*/ );
sword  ORAENTRY   oname ( /*_ struct cda_def *cursor, sword pos, sb1 *tbuf,
                         sb2 *tbufl, sb1 *buf, sb2 *bufl _*/ );
sword  ORAENTRY   olon  ( /*_ struct cda_def *lda, text *uid, sword uidl,
                         text *pswd, sword pswdl, sword audit _*/ );
sword  ORAENTRY   orlon ( /*_ struct cda_def *lda, ub1 *hda, text *uid,
                         sword uidl, text *pswd, sword pswdl, sword audit _*/ );
sword  ORAENTRY   osql3 ( /*_ struct cda_def *cda, text *sqlstm, sword sqllen _*/ );

#ifdef __cplusplus
}
#endif

#endif  /* OCIKPR */







