rem 
rem $Header: prvtsyer.sql 7020200.1 95/02/15 18:13:28 cli Generic<base> $ 
rem 
Rem
Rem    NAME
Rem      prvtsyer.sql - PRVT_SYs_ErroR - pl/sql routines for 
Rem                     system error messages for DBMS* routines.
Rem    DESCRIPTION
Rem      These are private functions to be released in PL/SQL binary form.
Rem      The package includes routines for raising erors a la raise_application
Rem      error, but with the error rage dedicated to and allocated among
Rem      DBMS* SQL routines.
Rem      Eventuall, NLS functionality will be provided thougt an interface 
Rem      to kernel error functions.
Rem    RETURNS
Rem 
Rem    NOTES
Rem     Allocate error numbers in error.msg
Rem     Range is 23300 to 24299
Rem     For the time being, this package is used to raise ORA errors only.
Rem     Future extensions might allow other error message files.
Rem     DO NOT GRANT THIS PACKAGE TO PUBLIC
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     dsdaniel   10/13/94 -  merge changes from branch 1.1.710.4
Rem     dsdaniel   08/09/94 -  fix paramater ordering compatibility
Rem     dsdaniel   07/13/94 -  merge changes from branch 1.1.710.2&3
Rem     dsdaniel   07/13/94 -  icd compartibility problem
Rem     dsdaniel   07/08/94 -  extend functions
Rem     adowning   03/29/94 -  merge changes from branch 1.1.710.1
Rem     adowning   02/04/94 -  Branch_for_patch
Rem     adowning   02/04/94 -  Creation
Rem     adowning   02/02/94 -  split file into public / private binary files
Rem     dsdaniel   10/29/93 -  Creation
Rem     dsdaniel   11/01/93 -  Branch_for_patch
Rem
REM ********************************************************************
REM THESE PACKAGES MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
REM COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE
REM RDBMS.  SPECIFICALLY, THE PSD*  ROUTINES MUST NOT BE
REM CALLED DIRECTLY BY ANY CLIENT AND MUST REMAIN PRIVATE TO THE PACKAGE BODY.
REM ********************************************************************

CREATE OR REPLACE PACKAGE dbms_sys_error IS
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               keeperrorstack BOOLEAN DEFAULT FALSE);
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE);
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE);
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE);
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE);
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               arg5           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE);
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               arg5           VARCHAR2,
                               arg6           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE);
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               arg5           VARCHAR2,
                               arg6           VARCHAR2,
                               arg7           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE);
  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               arg5           VARCHAR2,
                               arg6           VARCHAR2,
                               arg7           VARCHAR2,
                               arg8           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE);

-- Raise a system error int the range 23300 to 24299
-- Input parameters:
--   num
--     Error number in the range 23300 to 24299
--     If the error number has a matching entry in error.msg, then the error
--     message for error.msg is used.  If there is no entry, then (but the
--     number is in rang)e, then arg1 (if given) is used as the error message
--     and no argument substitution is made.  This behavior provides 
--     compatibility with earlier versions of this module. 
--   arg[n]
--     string arguments to the error messages that are sprintfed into the error
--     message. 
--   keeerrorstack
--     if True, raised error is added to the top of the current stack,
--     so that any errors that caused this error to be raised are retained.
-- Exception:
--   raises ORA-21000 If error not in range.
END dbms_sys_error;
/

CREATE OR REPLACE PACKAGE BODY dbms_sys_error IS
-- Implementation note:  kkxere[n] routines are all implemented by the
-- kkxerse routine.
-- Further note: kkxere1 comes before kkxere0 to allow patch downgrades from
-- 7.1.5 to earlier versions (for callrs of this package with 1 arg).
-- (earlier versions only had kkxere1 (actually its predecessor)).

  PROCEDURE kkxere1(num            BINARY_INTEGER,
                    arg1           VARCHAR2,                -- 1 (see kkxe.c)
                    keeperrorstack BOOLEAN DEFAULT FALSE); 
  PRAGMA INTERFACE (c,kkxere1);
  PROCEDURE kkxere0(num            BINARY_INTEGER,
                    keeperrorstack BOOLEAN DEFAULT FALSE); -- 2 (see kkxe.c)
  PRAGMA INTERFACE (c,kkxere0);
  PROCEDURE kkxere2(num            BINARY_INTEGER,
                    arg1           VARCHAR2,
                    arg2           VARCHAR2,               -- 3 (see kkxe.c)
                    keeperrorstack BOOLEAN DEFAULT FALSE);
  PRAGMA INTERFACE (c,kkxere2);
  PROCEDURE kkxere3(num            BINARY_INTEGER,
                    arg1           VARCHAR2,
                    arg2           VARCHAR2,
                    arg3           VARCHAR2,                -- 4 (see kkxe.c)
                    keeperrorstack BOOLEAN DEFAULT FALSE);
  PRAGMA INTERFACE (c,kkxere3);
  PROCEDURE kkxere4(num            BINARY_INTEGER,
                    arg1           VARCHAR2,
                    arg2           VARCHAR2,
                    arg3           VARCHAR2,
                    arg4           VARCHAR2,                 -- 5 (see kkxe.c)
                    keeperrorstack BOOLEAN DEFAULT FALSE);
  PRAGMA INTERFACE (c,kkxere4);
  PROCEDURE kkxere5(num            BINARY_INTEGER,
                    arg1           VARCHAR2,
                    arg2           VARCHAR2,
                    arg3           VARCHAR2,
                    arg4           VARCHAR2,
                    arg5           VARCHAR2,                 -- 6 (see kkxe.c)
                    keeperrorstack BOOLEAN DEFAULT FALSE);
  PRAGMA INTERFACE (c,kkxere5);
  PROCEDURE kkxere6(num            BINARY_INTEGER,
                    arg1           VARCHAR2,
                    arg2           VARCHAR2,
                    arg3           VARCHAR2,
                    arg4           VARCHAR2,
                    arg5           VARCHAR2,
                    arg6           VARCHAR2,                 -- 7 (see kkxe.c)
                    keeperrorstack BOOLEAN DEFAULT FALSE);
  PRAGMA INTERFACE (c,kkxere6);
  PROCEDURE kkxere7(num            BINARY_INTEGER,
                    arg1           VARCHAR2,
                    arg2           VARCHAR2,
                    arg3           VARCHAR2,
                    arg4           VARCHAR2,
                    arg5           VARCHAR2,
                    arg6           VARCHAR2,
                    arg7           VARCHAR2,                 -- 8 (see kkxe.c)
                    keeperrorstack BOOLEAN DEFAULT FALSE);
  PRAGMA INTERFACE (c,kkxere7);
  PROCEDURE kkxere8(num            BINARY_INTEGER,
                    arg1           VARCHAR2,
                    arg2           VARCHAR2,
                    arg3           VARCHAR2,
                    arg4           VARCHAR2,
                    arg5           VARCHAR2,
                    arg6           VARCHAR2,
                    arg7           VARCHAR2,
                    arg8           VARCHAR2,                 -- 9 (see kkxe.c)
                    keeperrorstack BOOLEAN DEFAULT FALSE);
  PRAGMA INTERFACE (c,kkxere8);


  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere0(num,keeperrorstack);
  END raise_system_error;

  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere1(num, arg1,
            keeperrorstack);
  END raise_system_error;

  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere2(num, arg1,arg2,
            keeperrorstack);
  END raise_system_error;

  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere3(num, arg1,arg2,arg3,
            keeperrorstack);
  END raise_system_error;

  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere4(num, arg1,arg2,arg3,arg4,
            keeperrorstack);
  END raise_system_error;

  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               arg5           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere5(num, arg1,arg2,arg3,arg4,arg5,
            keeperrorstack);
  END raise_system_error;

  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               arg5           VARCHAR2,
                               arg6           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere6(num, arg1,arg2,arg3,arg4,arg5,arg6,
            keeperrorstack);
  END raise_system_error;

  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               arg5           VARCHAR2,
                               arg6           VARCHAR2,
                               arg7           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere7(num, arg1,arg2,arg3,arg4,arg5,arg6,arg7,
            keeperrorstack);
  END raise_system_error;

  PROCEDURE raise_system_error(num            BINARY_INTEGER,
                               arg1           VARCHAR2,
                               arg2           VARCHAR2,
                               arg3           VARCHAR2,
                               arg4           VARCHAR2,
                               arg5           VARCHAR2,
                               arg6           VARCHAR2,
                               arg7           VARCHAR2,
                               arg8           VARCHAR2,
                               keeperrorstack BOOLEAN DEFAULT FALSE) IS
  BEGIN
    kkxere8(num, arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,
            keeperrorstack);
  END raise_system_error;

END dbms_sys_error;
/
