/*** rexx ********************************************************************/
/*                                                                           */
/* SAMPLE1.CMD - Oracle-REXX Interface Sample                                */
/*                                                                           */
/* Sample REXX command file to demonstrate dynamic SQL methods 1,2 and 3.    */
/*                                                                           */
/*****************************************************************************/

CALL RXFUNCADD "SQLEXEC", "RXORA", "SQLEXEC"

/*---------------------------------------------------------------------------*/

SAY "Oracle-REXX Interface - Sample 1: Dynamic SQL methods 1, 2 and 3"
SAY
SAY "Enter an Oracle connect string in the form: user/password@connect"
SAY "Or simply press enter to use the sample connect string: scott/tiger"
PULL connect .
if connect = "" then
  connect = "scott/tiger"

/*---------------------------------------------------------------------------*/

SAY "Connecting as" connect

CALL SQLEXEC "CONNECT :connect"
CALL CheckSQLReturn

/*--Dynamic SQL Method 1-----------------------------------------------------*/

SAY "Creating table REXX_SAMPLE"

CALL SQLEXEC "EXECUTE IMMEDIATE create table rexx_sample (empno number(4), ename varchar2(40), deptno number(4))"
IF (result = 0) & (sqlca.sqlcode = -955) THEN DO
  SAY "REXX_SAMPLE table already exists."
  SAY "Do you wish to delete the sample table (yes/no)"
  PULL answer .
  IF answer = "YES" THEN DO
    CALL SQLEXEC "EXECUTE IMMEDIATE drop table rexx_sample"
    CALL CheckSQLReturn
    CALL SQLEXEC "EXECUTE IMMEDIATE create table rexx_sample (empno number(4), ename varchar2(40), deptno number(4))"
    END
  ELSE DO
    SAY "Ending sample"
    SIGNAL disconnect
    END
END
CALL CheckSQLReturn

/*--Dynamic SQL Method 2-----------------------------------------------------*/

SAY "Adding data to table REXX_SAMPLE"

CALL SQLEXEC "DECLARE stmt1 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt1 FROM insert into rexx_sample(empno,ename,deptno) values(:a,:b,:c)"
CALL CheckSQLReturn

empno  = 1021
ename  = 'David'
deptno = 20
CALL SQLEXEC "EXECUTE stmt1 USING :empno, :ename, :deptno"
CALL CheckSQLReturn

empno  = 1022
ename  = 'Beverly'
deptno = 20
CALL SQLEXEC "EXECUTE stmt1 USING :empno, :ename, :deptno"
CALL CheckSQLReturn

/*--Dynamic SQL Method 3-----------------------------------------------------*/

SAY "Query data from table REXX_SAMPLE"

CALL SQLEXEC "DECLARE stmt2 STATEMENT"
CALL CheckSQLReturn

CALL SQLEXEC "DECLARE csr2 CURSOR FOR stmt2"
CALL CheckSQLReturn

CALL SQLEXEC "PREPARE stmt2 FROM select empno, ename from rexx_sample where deptno=:a"
CALL CheckSQLReturn

deptno = 20
CALL SQLEXEC "OPEN csr2 USING :deptno"
CALL CheckSQLReturn

CALL SQLEXEC "FETCH csr2 INTO :empno, :ename"
DO WHILE (result = 0) & (sqlca.sqlcode = 0)
  SAY right(empno,8) ename
  CALL SQLEXEC "FETCH csr2 INTO :empno, :ename"
END
IF (result <> 0) | (sqlca.sqlcode <> 1403) THEN
  CALL CheckSQLReturn

CALL SQLEXEC "CLOSE csr2"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Drop table REXX_SAMPLE"

CALL SQLEXEC "EXECUTE IMMEDIATE drop table rexx_sample"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/
disconnect:
SAY "Disconnect"

CALL SQLEXEC "ROLLBACK RELEASE"
CALL CheckSQLReturn

/*---------------------------------------------------------------------------*/

SAY "Sample completed - Press Enter to exit"
PULL .

EXIT

/*---------------------------------------------------------------------------*/

CheckSQLReturn:
  IF result <> 0 THEN
    SAY "Invalid embedded SQL statement ("result")."
  ELSE IF sqlca.sqlcode <> 0 THEN
    SAY sqlca.sqlerrmc
  IF (result <> 0) | (sqlca.sqlcode <> 0) THEN DO
    SAY "Sample completed - Press Enter to exit"
    PULL .
    EXIT
  END
  RETURN

