/* ------------------------------------------------------------------ */
/*
 * LockOpen
 *
 * Lock this file from other Steward processes
 *
 */

TRUE = 1
FALSE = 0

LockOpen: 

parse arg FileName Mode

/* Try to lock the file first */
rc = Lock(FileName)

if rc = FALSE then return FALSE

/* Now open the actual file */
if Mode = 'READ' then
  rc = stream(FileName, 'C', 'OPEN READ')
else if Mode = 'WRITE' then
  rc = stream(FileName, 'C', 'OPEN WRITE')
else
  return FALSE

/* Check the value returned from the opening */
parse var rc state ':' code

if Mode = 'READ' & state = 'NOTREADY' & code = '110' then do
  /* assume trying to read non-existent file, so create it */
  rc = stream(FileName, 'C', 'OPEN WRITE')
  rc = stream(FileName, 'C', 'CLOSE')
  rc = stream(FileName, 'C', 'OPEN READ')
  parse var rc state ':' code
  end  

do while state = 'NOTREADY' & code = '32'
  call SysSleep 1
  if Mode = 'READ' then
    rc = stream(FileName, 'C', 'OPEN READ')
  else if Mode = 'WRITE' then
    rc = stream(FileName, 'C', 'OPEN WRITE')
  parse var rc state ':'
  end

/* We had an error attempting to open the file */
if state <> 'READY' then
  return FALSE

return TRUE

/* ------------------------------------------------------------------ */
