var gl_iItemsLoaded  = 0;
var gl_iCheckedItems = 0;
var gl_strNext = null;
var gl_WaitResult = false;
var gl_strLastText = null;
var gl_filterTimeout = null;

function _secToStr(iSec)
{
  var m = iSec / 60;
  var h = m / 60;
  var d = Math.floor(h / 24);
  
  h = Math.floor(h % 24);
  m = Math.floor(m % 60);
  iSec = Math.floor(iSec % 60);

  if ( Intl.hasOwnProperty( "RelativeTimeFormat" ) )
  {
    const rtf = new Intl.RelativeTimeFormat( undefined, {numeric:"always"} );
    const p = rtf.formatToParts( d, "day" );
    d += " " + p[2].value;
  }
  else
    d += "d";

  return d + " " + h + ":" + ("0"+m).slice(-2) + ":" + ("0"+iSec).slice(-2);
}

function LoadItems(fMore=true)
{
  if ( gl_WaitResult )
    return;

  const elList = document.getElementById( "list" );
  const elListCBAll = document.getElementById( "list__cb-all" );
  const elLoadMore = document.getElementById( "load-more" );
  const elEmpty = document.getElementById( "search-empty" );
  const fRedlist = document.getElementById( "tab-list__tab-name" ).value == "redlist";
  var strReq = "ajax_spamchk_whitelist?r=" + ( fRedlist ? '1' : '0' );

  if ( fMore ) {
    if ( gl_strNext )
      strReq += "&s=" + gl_strNext;
  }
  else {
    const strText = document.getElementById( "filter-form__text" ).value;

    if ( strText != "" )
      strReq += "&strictly=1&s=" + strText;
  }

  gl_WaitResult = true;
  elEmpty.classList.add( "pe_hidden" );

  utilAJAX( strReq,
    function(xmlRoot) {
      const xmlList = xmlRoot.firstChild;

      if ( !fMore ) {
        gl_iItemsLoaded = 0;
        gl_iCheckedItems = 0;
        utilRemoveAllChildren( elList );
        elLoadMore.classList.add( "pe_hidden" );
      }

      gl_strNext = xmlList.getAttribute( "next" );
console.log( gl_strNext );
      if ( gl_strNext )
        elLoadMore.classList.remove( "pe_hidden" );
      else
        elLoadMore.classList.add( "pe_hidden" );

      for(xmlItem of xmlList.childNodes) {
        if ( xmlItem.nodeType != 1 || xmlItem.nodeName != "item" )
          continue;

        const strTimeLeft = xmlItem.getAttribute( "time-left" );
        const strItem = utilGetNodeText( xmlItem );
        const iTimeLeft = parseInt( xmlItem.getAttribute( "time-left" ) );

        const elRow = document.createElement( "div" );
        elRow.classList.add( "pe__row" );
        elRow.classList.add( "pe__row_ctl" );
        elList.appendChild( elRow );

        const elCaption = document.createElement( "div" );
        elCaption.classList.add( "peRowCtl__caption" );
        elRow.appendChild( elCaption );

        var el = document.createElement( "input" );
        el.type = "checkbox";
        el.dataset.item = strItem;
        el.addEventListener( "change", function(e) {
          gl_iCheckedItems += (e.target.checked ? 1 : -1);
          document.getElementById( "list__del-btn" ).disabled =
            gl_iCheckedItems == 0;
        }, true );
        elCaption.appendChild( el );

        elCaption.appendChild( document.createTextNode( strItem ) );

        const elCtl = document.createElement( "div" );
        elCtl.classList.add( "peRowCtl__ctl" );
        elRow.appendChild( elCtl );

        if ( !isNaN( iTimeLeft ) )
          elCtl.appendChild( document.createTextNode( _secToStr( iTimeLeft ) ) );

        gl_iItemsLoaded++;
      }

      if ( gl_iItemsLoaded == 0 )
        elEmpty.classList.remove( "pe_hidden" );

      elListCBAll.disabled = gl_iItemsLoaded == 0;
      gl_WaitResult = false;

    }  // function(xmlRoot)
  );  // utilAJAX()
}  // LoadItems()

function Filter()
{
  const elList = document.getElementById( "list" );
  const elLoadMore = document.getElementById( "load-more" );
  const strText = document.getElementById( "filter-form__text" ).value;

  if ( gl_filterTimeout != null )
  {
    clearTimeout( gl_filterTimeout );
    gl_filterTimeout = null;
  }

  if ( strText == gl_strLastText )
    return;
  gl_strLastText = strText;

  LoadItems( false );
}  // Filter()

function DeleteItems()
{
  var aCB = document.querySelectorAll( "input:checked" );
  var strItem = "", strBody;
  const fRedlist = document.getElementById( "tab-list__tab-name" ).value == "redlist";

  strBody = "names=";

  // Make POST request body (application/x-www-form-urlencoded)
  for(var iIdx = 0; iIdx < aCB.length; iIdx++)
  {
    var elCB = aCB[iIdx];
    if ( elCB.dataset.item == undefined )
      continue;

    if ( strItem == "" )
      strItem = elCB.dataset.item;
    else
      strItem = " " + elCB.dataset.item;

    strBody += encodeURIComponent( strItem );
  }

  utilAJAXPost( "ajax_whitelist_delete?r=" + ( fRedlist ? '1' : '0' ),
                false, strBody,
    function(xmlRoot) {
      // The server returns a list of removed items.
      var xmlList = xmlRoot.firstChild;

      for(xmlItem of xmlList.childNodes) {
        if ( xmlItem.nodeType != 1 || xmlItem.nodeName != "item" )
          continue;

        const strItem = utilGetNodeText( xmlItem );
        const el = document.querySelector( "input[data-item='" + strItem + "']" );

        if ( el )
        {
          utilRemoveNode( el.parentElement.parentElement );
          gl_iItemsLoaded--;
        }
      }

      const aCB = document.querySelectorAll( "input[data-item]" );
      gl_iCheckedItems = 0;
      for(var iIdx = 0; iIdx < aCB.length; iIdx++)
      {
        if ( aCB[iIdx].checked )
          gl_iCheckedItems++;
      }
      document.getElementById( "list__del-btn" ).disabled = gl_iCheckedItems == 0;

    }
  );
}

window.addEventListener( "load", function() {
  document.getElementById( "load-more__btn" ).addEventListener( "click",
    function() { LoadItems(); }, true );

  document.getElementById( "list__cb-all" ).addEventListener( "change", function(e) {
    var aCB = document.querySelectorAll( "input[data-item]" );

    gl_iCheckedItems = 0;
    for(var iIdx = 0; iIdx < aCB.length; iIdx++)
    {
      if ( aCB[iIdx].disabled )
        continue;

      aCB[iIdx].checked = e.target.checked;
      if ( e.target.checked )
        gl_iCheckedItems++;
    }
    document.getElementById( "list__del-btn" ).disabled = gl_iCheckedItems == 0;
  } );

  document.getElementById( "list__del-btn" ).addEventListener( "click", function(e) {
    confirmation( null, DeleteItems );
  }, true );


  // Filter

  document.getElementById( "filter-form" ).addEventListener( "submit", function(e) {
    Filter( false );
    e.preventDefault();
    return false;
  }, true );

  document.getElementById( "filter-form__text" ).addEventListener( "keyup", function(e) {
    if ( gl_filterTimeout != null )
      clearTimeout( gl_filterTimeout );
    gl_filterTimeout = setTimeout( Filter, 700, false );
  }, true );

  document.getElementById( "filter-form__loupe" ).addEventListener( "click", function(e) {
    Filter( false );
    e.preventDefault();
    return false;
  }, true );

  document.getElementById( "filter-form__cross" ).addEventListener( "click", function(e) {
    document.getElementById( "filter-form__text" ).value = "";
    Filter( false );
    e.preventDefault();
    return false;
  }, true );

  LoadItems();

}, true );
