<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template name="domain-or-users-list">
  <xsl:param name="domain"/>

  <script src="js/domain_list.js" type="text/javascript" language="javascript"></script>

  <xsl:call-template name="confirmation">
    <xsl:with-param name="text">
      <xsl:choose>
        <xsl:when test="$domain">
          Are you sure you want to delete the selected users?
        </xsl:when>
        <xsl:otherwise>
          Are you sure you want to delete the selected domains along with the users?
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="caption-yes">Delete</xsl:with-param>
    <xsl:with-param name="caption-no">Cancel</xsl:with-param>
  </xsl:call-template>

  <!-- Filter items form -->
  <form method="get" id="filter-form">
    <xsl:if test="$domain">
      <input type="hidden" id="filter-form__domain" name="n"
        value="{$domain}"/>
    </xsl:if>
    <input type="hidden" id="filter-form__from" name="f"
      value="{search/@from}"/>

    <div class="list-filter">
      <a class="list-filter__control list-filter__control_cross" id="filter-form__cross"
        href="#">&#10060;</a>

      <select name="t" class="list-filter__control list-filter__type"
        id="filter-form__type">
        <option value="s">
          <xsl:if test="search/@type='s'">
            <xsl:attribute name="selected">1</xsl:attribute>
          </xsl:if>
          ab&#x2026;
        </option>
        <option value="e">
          <xsl:if test="search/@type='e'">
            <xsl:attribute name="selected">1</xsl:attribute>
          </xsl:if>
          &#x2026;ab
        </option>
        <option value="c">
          <xsl:if test="search/@type='c'">
            <xsl:attribute name="selected">1</xsl:attribute>
          </xsl:if>
          &#x2026;ab&#x2026;
        </option>
      </select>

      <input class="list-filter__text"
        id="filter-form__text"
        type="text" name="s" value="{search}" maxlength="512"/>
      <a class="list-filter__control list-filter__control_loupe" id="filter-form__loupe"
        href="#">&#128269;</a>
    </div>
  </form>

  <div class="main-content">

    <!-- Checkboxes and items -->
    <form enctype="application/x-www-form-urlencoded" method="post">
      <div class="pe">
        <div class="pe__row">
          <label>
            <input type="checkbox" id="list__cb-all" disabled="1"/>
            All
          </label>
          <input type="button" class="btn" id="list__del-btn"
            disabled="1" value="Delete"/>
          <xsl:choose>
            <xsl:when test="$domain">
              <a href="?n={$domain}&amp;new=1" class="btn">New</a>
            </xsl:when>
            <xsl:otherwise>
              <a href="?new=1" class="btn">New</a>
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </div>

      <div class="pe pe_hidden" id="load-prev">
        <div class="pe__row pe__row_btn">
          <input class="btn pe__wide-btn" id="load-prev__btn" type="button"
             value="Load previous items"/>
        </div>
      </div>

      <xsl:if test="$domain">
        <div class="pe">
          <div class="pe__row pe__row_hdr pe__row_ctl">
            <div class="peRowCtl__caption">
              User name
            </div>
            <div class="peRowCtl__ctl">
              Space used
            </div>
          </div>
        </div>
      </xsl:if>

      <div class="pe pe_list" id="list">
        <xsl:choose>
          <xsl:when test="$domain">
            <xsl:attribute name="class">pe pe_list</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="class">pe</xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
      </div>

      <div class="pe pe_hidden" id="load-more">
        <div class="pe__row pe__row_btn">
          <input class="btn pe__wide-btn" id="load-more__btn" type="button"
             value="Load more..."/>
        </div>
      </div>
    </form>

    <div class="pe pe_hidden" id="search-empty">
      <div class="pe__row">
        No results found.
      </div>
    </div>

  </div>

</xsl:template>

<xsl:template name="domain-properties__aliases-list">
  <div class="pe__row pe__row_hdr">
    Aliases
  </div>
  <form id="list__del-form" enctype="application/x-www-form-urlencoded"
    method="post">
    <div class="pe__row">
      <label>
        <input type="checkbox" id="list__cb-all"/>
        All
      </label>
      <input type="button" class="btn" id="list__del-btn"
        disabled="1" value="Delete"/>
    </div>

    <xsl:apply-templates select="alias">
      <xsl:sort select="." />
    </xsl:apply-templates>
  </form>

  <div class="pe__row">
    <form enctype="application/x-www-form-urlencoded" method="post">
      New:
      <input class="pe__inputText" type="text" name="new-aliases"/>
      <input class="btn" type="submit" value="Create"/>
    </form>
  </div>
</xsl:template>

<xsl:template match="alias">
  <div class="pe__row">
    <input type="checkbox" name="cb-item-{.}" data-item="{.}"/>
    <xsl:value-of select="."/>
  </div>
</xsl:template>

<xsl:template name="domain-properties__delete-button">
  <xsl:param name="enc-domain"/>
  <xsl:param name="enc-name"/>

  <xsl:call-template name="confirmation">
    <xsl:with-param name="text">
      <xsl:choose>
        <xsl:when test="$enc-domain">
          Are you sure you want to delete user?
        </xsl:when>
        <xsl:otherwise>
          Are you sure you want to delete domain?
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="caption-yes">Delete</xsl:with-param>
    <xsl:with-param name="caption-no">Cancel</xsl:with-param>
  </xsl:call-template>

  <div class="pe__row pe__row_btn">
    <xsl:choose>
      <xsl:when test="$enc-domain">
        <a class="btn pe__wide-btn" id="domain-properties__delete-button"
          href="?d={$enc-domain}&amp;n={$enc-name}&amp;del=1">
          Delete user
        </a>
      </xsl:when>
      <xsl:otherwise>
        <a class="btn pe__wide-btn" id="domain-properties__delete-button"
          href="?n={$enc-name}&amp;del=1">
          Delete domain
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </div>
</xsl:template>

<xsl:template match="new/message">
  <div>
    <xsl:if test="@name">
      <xsl:value-of select="@name"/>
      <xsl:text>: </xsl:text>
    </xsl:if>
    <xsl:value-of select="."/>
  </div>
</xsl:template>


<xsl:template match="ui/domains">
  <div class="location-title">
    <a id="location-title__hamburger"
      href="#menu"
      class="location-title__hamburger"></a>
    <div class="location-title__text">
      <xsl:choose>
        <xsl:when test="list">Domains</xsl:when>
        <xsl:otherwise>Domain</xsl:otherwise>
      </xsl:choose>
    </div>
  </div>

  <xsl:apply-templates select="list"/>    <!-- List of domains -->
  <xsl:apply-templates select="domain"/>  <!-- Domain: properties, new user, subst. list, DKIM -->
  <xsl:apply-templates select="user"/>    <!-- Edit user -->

</xsl:template>

<xsl:template match="domains/list">
  <xsl:if test="search">
    <xsl:call-template name="domain-or-users-list"/>
  </xsl:if>

  <xsl:apply-templates select="new"/>
</xsl:template>

<xsl:template match="domains/list/new">
  <div class="location-title">
    <a class="location-title__back" href="?t={back-list-filter/@type}&amp;s={back-list-filter}"></a>
    <div class="location-title__text">New Domain</div>
  </div>

  <div class="main-content">

    <form enctype="multipart/form-data" method="post">
      <div class="pe">
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            New domain names
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText" type="text" name="names" value="{names}"/>
          </div>
        </div>
        <div class="pe__row pe__row_btn">
          <input class="btn" type="submit" value="Apply"/>
        </div>

        <xsl:if test="message">
          <div class="pe__row pe__row_hdr">
            Errors
          </div>
          <div class="pe__row">
            <xsl:apply-templates select="message"/>
          </div>
        </xsl:if>
      </div>
    </form>

  </div>

</xsl:template>


<!-- Domain properties, new user, subst. list, DKIM -->

<xsl:template match="domains/domain">
  <xsl:if test="not(new) and not(subst-names)">
    <div class="location-title">
      <xsl:if test="/ui/cu/@level='admin'">
        <!-- Only an administrator can return to the list of domains. -->
        <a class="location-title__back"
          href="?t={back-list-filter/@type}&amp;f={back-list-filter/@from}&amp;s={back-list-filter}"></a>
      </xsl:if>
      <div class="location-title__text"><xsl:value-of select="@name"/></div>
    </div>

    <div class="tab-list unselectable">

      <xsl:if test="/ui/cu/@level='admin'">
        <!-- Only an administrator can edit domain properties. -->
        <xsl:choose>
          <xsl:when test="properties">
            <div class="tab-list__item tab-list__item_selected">Properties</div>
          </xsl:when>
          <xsl:otherwise>
            <a class="tab-list__item" href="?n={@enc-name}">Properties</a>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="DKIM">
          <div class="tab-list__item tab-list__item_selected">DKIM</div>
        </xsl:when>
        <xsl:otherwise>
          <a class="tab-list__item" href="?n={@enc-name}&amp;dkim=1">DKIM</a>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="search">
          <div class="tab-list__item tab-list__item_selected">Users</div>
        </xsl:when>
        <xsl:otherwise>
          <a class="tab-list__item" href="?n={@enc-name}&amp;s=">Users</a>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="subst-list">
          <div class="tab-list__item tab-list__item_selected">Substitutions</div>
        </xsl:when>
        <xsl:otherwise>
          <a class="tab-list__item" href="?n={@enc-name}&amp;sid=0">Substitutions</a>
        </xsl:otherwise>
      </xsl:choose>
    </div>

    <xsl:apply-templates select="properties"/>
    <xsl:apply-templates select="subst-list"/>
    <xsl:if test="search">
      <xsl:call-template name="domain-or-users-list">
        <xsl:with-param name="domain" select="@name"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:if>

  <xsl:apply-templates select="new"/>
  <xsl:apply-templates select="subst-names"/>
  <xsl:apply-templates select="DKIM"/>

</xsl:template>

<xsl:template match="domain/properties">
  <script src="js/domain_properties.js" type="text/javascript" language="javascript"></script>
  <script src="js/lists.js" type="text/javascript" language="javascript"></script>

  <div class="main-content">
    <div class="pe">
      <xsl:call-template name="domain-properties__aliases-list"/>

      <xsl:call-template name="domain-properties__delete-button">
        <xsl:with-param name="enc-name" select="../@enc-name"/>
      </xsl:call-template>
    </div>
  </div>
</xsl:template>


<!-- List of name substitution lists -->

<xsl:template match="domain/subst-list">
  <script src="js/lists.js" type="text/javascript" language="javascript"></script>
  <script src="js/substlist.js" type="text/javascript" language="javascript"></script>

  <div class="main-content unselectable">

    <xsl:call-template name="confirmation">
      <xsl:with-param name="caption-yes">Delete</xsl:with-param>
      <xsl:with-param name="caption-no">Cancel</xsl:with-param>
    </xsl:call-template>

    <form id="list__del-form" enctype="application/x-www-form-urlencoded"
      method="post">
      <!-- del-form__domain - domain name for substnames.js -->
      <input id="del-form__domain" type="hidden" value="{../@enc-name}"/>
      <div class="pe">
        <div class="pe__row">
          <label>
            <input type="checkbox" id="list__cb-all">
               <xsl:if test="not(subst)">
                 <xsl:attribute name="disabled">1</xsl:attribute>
               </xsl:if>
            </input>
            All
          </label>
          <input type="button" class="btn" id="list__del-btn"
            disabled="1" value="Delete"/>
          <a href="?n={../@enc-name}&amp;sid=0&amp;new=1" class="btn">New</a>
        </div>
      </div>
      <div class="pe">
        <xsl:apply-templates select="subst"/>
      </div>
    </form>

  </div>

</xsl:template>

<xsl:template match="subst-list/subst">
  <div class="pe__row item-drag unselectable">
    <span class="item-drag__pad unselectable">&#x2630;</span>
    <input type="checkbox" name="cb-item-{@sid}" class="unselectable" data-item="1"/>
    <a href="?n={../../@enc-name}&amp;sid={@sid}">
      <xsl:value-of select="."/>
    </a>
  </div>
</xsl:template>


<!-- Edit substitution list -->

<xsl:template match="domain/subst-names">
  <script src="js/lists.js" type="text/javascript" language="javascript"></script>

  <div class="location-title">
    <a class="location-title__back" href="?n={../@enc-name}&amp;sid=0"></a>
    <div class="location-title__text">
      Substitution list for
      <xsl:value-of select="../@name"/>
    </div>
  </div>

  <xsl:call-template name="confirmation">
    <xsl:with-param name="caption-yes">Delete</xsl:with-param>
    <xsl:with-param name="caption-no">Cancel</xsl:with-param>
  </xsl:call-template>

  <div class="main-content">

    <form enctype="multipart/form-data" method="post">
      <div class="pe">
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Pattern
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText" type="text" name="pattern" value="{subst}"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
          </div>
          <div class="peRowCtl__ctl">
            <div class="peRowCtlCtl__group">
              <div>
                <label>
                  <input name="private" type="checkbox">
                    <xsl:if test="subst/@private='1'">
                      <xsl:attribute name="checked">1</xsl:attribute>
                    </xsl:if>
                  </input>
                  Private
                </label>
              </div>
            </div>
          </div>
        </div>
        <div class="pe__row pe__row_btn">
          <input class="btn" type="submit" value="Apply"/>
        </div>
      </div>
    </form>

    <xsl:if test="subst/@sid">
      <div class="pe">
        <div class="pe__row pe__row_hdr">
          Substitute names
        </div>
        <xsl:if test="name">

          <form id="list__del-form" enctype="application/x-www-form-urlencoded"
            method="post">
            <div class="pe__row">
              <label>
                <input type="checkbox" id="list__cb-all"/>
                All
              </label>
              <input type="button" class="btn" id="list__del-btn"
                disabled="1" value="Delete"/>
            </div>
            <xsl:apply-templates select="name"/>
          </form>

        </xsl:if>
        <div class="pe__row">
          <form enctype="application/x-www-form-urlencoded" method="post">
            New:
            <input class="pe__inputText" type="text" name="new-names"/>
            <input class="btn" type="submit" value="Create"/>
          </form>
        </div>
      </div>
    </xsl:if>

  </div>

</xsl:template>

<xsl:template match="subst-names/name">
  <div class="pe__row pe__row_ctl">
    <div class="peRowCtl__caption">
      <input type="checkbox" name="cb-item-{.}" data-item="{.}"/>
      <xsl:value-of select="."/>
    </div>
  </div>
</xsl:template>


<!-- New user form -->

<xsl:template match="domain/new">
  <script src="js/domain_properties.js" type="text/javascript" language="javascript"></script>

  <div class="location-title">
    <a class="location-title__back" href="?n={../@enc-name}&amp;s="></a>
    <div class="location-title__text">
      New user in
      <xsl:value-of select="../@name"/>
    </div>
  </div>

  <div class="main-content">

    <form enctype="multipart/form-data" method="post">
      <div class="pe">
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Usernames
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText" type="text" name="names" value="{names}"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Flags
          </div>
          <div class="peRowCtl__ctl">
            <div class="peRowCtlCtl__group">
              <div>
                <label>
                  <input name="ADMIN" type="checkbox"/>
                  Administator
                </label>
              </div>
              <div>
                <label>
                  <input name="OPER" type="checkbox"/>
                  Domain operator
                </label>
              </div>
              <div>
                <label>
                  <input name="HASH" type="checkbox"/>
                  Hashed password
                </label>
              </div>
              <div>
                <label>
                  <input name="DISABLED" type="checkbox"/>
                  Disabled
                </label>
              </div>
            </div>
          </div>
        </div>

        <xsl:call-template name="password"/>

        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Storage limit
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText pe__inputText_number"
              id="storage-limit"
              type="text" value="0 Kb" name="storage-limit"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Maximum folder nesting depth
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText pe__inputText_number"
              id="depth-max"
              type="number" min="0" name="depth-max" value="0"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Forward incoming mail to local address
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText"
              name="copy-to" type="text" maxlength="512"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
          </div>
          <div class="peRowCtl__ctl">
            <div class="peRowCtlCtl__group">
              <div>
                <label>
                  <input name="LOCALCOPY" type="checkbox"/>
                  Keep a local copy
                </label>
              </div>
            </div>
          </div>
        </div>
        <div class="pe__row pe__row_btn">
          <input class="btn" type="submit" value="Apply"/>
        </div>

        <xsl:if test="message">
          <div class="pe__row pe__row_hdr">
            Errors
          </div>
          <div class="pe__row">
            <xsl:apply-templates select="message"/>
          </div>
        </xsl:if>
      </div>
    </form>

  </div>

</xsl:template>


<!-- Edit domain DKIM -->

<xsl:template match="domain/DKIM">
  <script src="js/domain_dkim.js" type="text/javascript" language="javascript"></script>

  <div class="main-content">

    <xsl:if test="private-key-installed='yes'">
      <xsl:call-template name="confirmation">
        <xsl:with-param name="text">
          The private key for this domain is already installed.
          Do you want to overwrite it with a new one?
        </xsl:with-param>
        <xsl:with-param name="caption-yes">Overwrite</xsl:with-param>
        <xsl:with-param name="caption-no">Cancel</xsl:with-param>
      </xsl:call-template>
    </xsl:if>

    <form id="setup" enctype="multipart/form-data" method="post">
      <div class="pe">
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Mode
          </div>
          <div class="peRowCtl__ctl">
            <select id="setup__mode" name="mode">
              <option value="off">
                <xsl:if test="mode='off'">
                  <xsl:attribute name="selected">1</xsl:attribute>
                </xsl:if>
                Do not use DKIM signing
              </option>
              <option value="key">
                <xsl:if test="mode='key'">
                  <xsl:attribute name="selected">1</xsl:attribute>
                </xsl:if>
                Sign with a domain key
              </option>
              <option value="delegate">
                <xsl:if test="mode='delegate'">
                  <xsl:attribute name="selected">1</xsl:attribute>
                </xsl:if>
                Delegate to another local domain
              </option>
            </select>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Domain name (SDID)
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText" id="setup__sdid" type="text" name="SDID" value="{SDID}"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Public key selector
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText" id="setup__selector" type="text" name="selector" value="{selector}"/>
          </div>
        </div>
        <div class="pe__row pe__row_btn">
          <input class="btn" type="submit" value="Apply"/>
        </div>
      </div>
    </form>

    <form id="key" enctype="multipart/form-data" method="post">
      <div class="pe">
        <div class="pe__row pe__row_hdr">
          Private key
          <xsl:choose>
            <xsl:when test="private-key-installed='yes'">
              (Installed)
            </xsl:when>
            <xsl:otherwise>
              (Not installed)
            </xsl:otherwise>
          </xsl:choose>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Password (optional)
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText" id="key__password" type="password" name="password" value="{password}"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            <label>
              <input id="key__generate" type="radio" name="pkeysrc"
                value="generate" checked="1"/>
              Generate new
            </label>
          </div>
          <div class="peRowCtl__ctl">
            Length:
            <select id="key__length" name="keylength">
              <option value="1024">1024</option>
              <option value="2048">2048</option>
            </select>
            bits
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            <label>
              <input id="key__upload" type="radio" name="pkeysrc" value="upload"/>
              Upload
            </label>
          </div>
          <div class="peRowCtl__ctl">
            <input id="key__file" type="file" name="file"/>
          </div>
        </div>
        <xsl:if test="private-key-installed='yes'">
          <div class="pe__row pe__row_ctl">
            <div class="peRowCtl__caption">
              <a id="key__getpubkey" href="data_dkimpubkey?d={../@enc-name}">Get Public Key</a>
            </div>
          </div>
        </xsl:if>
        <div class="pe__row pe__row_btn">
          <input class="btn" type="submit" value="Apply"/>
        </div>
        <xsl:if test="message">
          <div class="pe__row pe__row_hdr">
            Error
          </div>
          <div class="pe__row">
            <xsl:value-of select="message"/>
          </div>
        </xsl:if>
      </div>
    </form>

  </div>

</xsl:template>


<!-- Edit user page -->

<xsl:template match="domains/user">
  <div class="location-title">
    <a class="location-title__back"
      href="?n={@enc-domain}&amp;t={back-list-filter/@type}&amp;f={back-list-filter/@from}&amp;s={back-list-filter}"></a>

    <div class="location-title__text">
      <xsl:value-of select="@name"/>
      <xsl:text>@</xsl:text>
      <xsl:value-of select="@domain"/>
    </div>
  </div>

  <xsl:apply-templates select="properties"/>
</xsl:template>

<xsl:template match="user/properties">
  <script src="js/domain_properties.js" type="text/javascript" language="javascript"></script>
  <script src="js/lists.js" type="text/javascript" language="javascript"></script>

  <xsl:variable name="current-user-selected"
     select="/ui/cu = concat(../@name,'@',../@domain)"/>
  <xsl:variable name="cu-is-admin" select="/ui/cu/@level='admin'"/>
  <xsl:variable name="flag-admin" select="contains(flags,'ADMIN')"/>
  <xsl:variable name="flag-oper" select="contains(flags,'OPER')"/>

  <div class="main-content">

    <div class="pe">
      <div class="pe__row pe__row_ctl">
        <div class="peRowCtl__caption">
          Login time
        </div>
        <div class="peRowCtl__ctl">
          <xsl:value-of select="login-time"/>
        </div>
      </div>

      <form enctype="multipart/form-data" method="post">
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Flags
          </div>
          <div class="peRowCtl__ctl">
            <div class="peRowCtlCtl__group">
              <xsl:if test="$cu-is-admin">
                <!-- Only administrator can change ADMIN and OPER flags. -->
                <div>
                  <label>
                    <input name="ADMIN" type="checkbox">
                       <xsl:if test="$flag-admin">
                         <xsl:attribute name="checked">1</xsl:attribute>
                       </xsl:if>
                    </input>
                    Administator
                  </label>
                </div>
                <div>
                  <label>
                    <input name="OPER" type="checkbox">
                       <xsl:if test="$flag-oper">
                         <xsl:attribute name="checked">1</xsl:attribute>
                       </xsl:if>
                       <xsl:if test="$flag-admin">
                         <xsl:attribute name="disabled">1</xsl:attribute>
                       </xsl:if>
                    </input>
                    Domain operator
                  </label>
                </div>
              </xsl:if>
              <div>
                <label>
                  <input name="HASH" type="checkbox">
                     <xsl:if test="contains(flags,'HASH')">
                       <xsl:attribute name="checked">1</xsl:attribute>
                     </xsl:if>
                  </input>
                  Hashed password
                </label>
              </div>
              <div>
                <label>
                  <input name="DISABLED" type="checkbox">
                     <xsl:if test="contains(flags,'DISABLED')">
                       <xsl:attribute name="checked">1</xsl:attribute>
                     </xsl:if>
                  </input>
                  Disabled
                </label>
              </div>
            </div>
          </div>
        </div>

        <xsl:call-template name="password"/>

        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Storage used
          </div>
          <div class="peRowCtl__ctl">
            <xsl:value-of select="storage-used"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Storage limit
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText pe__inputText_number"
              id="storage-limit"
              type="text" name="storage-limit" value="{storage-limit}"/>
          </div>
        </div>
        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Maximum folder nesting depth
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText pe__inputText_number"
              id="depth-max"
              type="number" min="0" name="depth-max"
              value="{depth-max}"/>
          </div>
        </div>

        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
            Forward incoming mail to local address
          </div>
          <div class="peRowCtl__ctl">
            <input class="pe__inputText"
              name="copy-to" type="text" maxlength="512" value="{copy-to}"/>
          </div>
        </div>

        <div class="pe__row pe__row_ctl">
          <div class="peRowCtl__caption">
          </div>
          <div class="peRowCtl__ctl">
            <div class="peRowCtlCtl__group">
              <div>
                <label>
                  <input name="LOCALCOPY" type="checkbox">
                     <xsl:if test="contains(flags,'LOCALCOPY')">
                       <xsl:attribute name="checked">1</xsl:attribute>
                     </xsl:if>
                  </input>
                  Keep a local copy
                </label>
              </div>
            </div>
          </div>
        </div>

        <div class="pe__row pe__row_btn">
          <input class="btn" type="submit" value="Apply"/>
        </div>
      </form>

      <xsl:call-template name="domain-properties__aliases-list"/>

      <xsl:if test="$cu-is-admin or not(contains(flags,'OPER'))">
        <!-- Only an administrator can delete an operator. -->
        <xsl:if test="not($current-user-selected)">
          <!-- The user cannot delete himself. -->
          <xsl:call-template name="domain-properties__delete-button">
            <xsl:with-param name="enc-domain" select="../@enc-domain"/>
            <xsl:with-param name="enc-name" select="../@enc-name"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:if>
    </div>

  </div>

</xsl:template>

</xsl:stylesheet>
