<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template name="confirmation">
  <xsl:param name="text"/>
  <xsl:param name="caption-yes">Yes</xsl:param>
  <xsl:param name="caption-no">No</xsl:param>

  <script src="js/confirmation.js" type="text/javascript" language="javascript"></script>

  <div id="confirmation" class="confirmation">
    <div id="confirmation__dlg" class="confirmation__dlg">
      <div>
        <div id="confirmation__text" class="confirmation__text">
          <xsl:value-of select="$text"/>
        </div>
        <div class="confirmation__buttons">
          <input type="button" id="confirmation__btn-no" class="confirmation__btn"
            value="{$caption-no}"/>
          <input type="button" id="confirmation__btn-yes" class="confirmation__btn"
            value="{$caption-yes}"/>
        </div>
      </div>
    </div>
  </div>
</xsl:template>

<xsl:template name="password">
  <script src="js/password.js" type="text/javascript" language="javascript"></script>

  <div class="pe__row pe__row_ctl">
    <div class="peRowCtl__caption">
      New password
    </div>
    <div class="peRowCtl__ctl">
      <input class="pe__inputText"
        name="password" type="password" id="password" maxlength="256"/>
    </div>
  </div>
  <div class="pe__row pe__row_ctl">
    <div class="peRowCtl__caption">
    </div>
    <div class="peRowCtl__ctl" id="pwdcc-result">
      <div class="peRowCtl__ctlPwdCCRes peRowCtl__ctlPwdCCRes-bad" data-result="BAD">
        &#10060; Too simple password.
      </div>
      <div class="peRowCtl__ctlPwdCCRes peRowCtl__ctlPwdCCRes-weak" data-result="WEAK">
        &#10003; It is recommended to complicate.
      </div>
      <div class="peRowCtl__ctlPwdCCRes peRowCtl__ctlPwdCCRes-good" data-result="GOOD">
        &#10003; Sufficient password complexity.
      </div>
      <div class="peRowCtl__ctlPwdCCRes peRowCtl__ctlPwdCCRes-strong" data-result="STRONG">
        &#10004; Fine. Strong password.
      </div>
    </div>
  </div>
  <div class="pe__row pe__row_ctl">
    <div class="peRowCtl__caption">
      New password again
    </div>
    <div class="peRowCtl__ctl">
      <input class="pe__inputText"
        name="password2" type="password" id="password2" maxlength="256"/>
    </div>
  </div>
  <div class="pe__row pe__row_ctl">
    <div class="peRowCtl__caption">
    </div>
    <div class="peRowCtl__ctl">
      <div class="peRowCtl__ctlPwdCCRes peRowCtl__ctlPwdCCRes-bad" id="pwdcomp-result">
        &#10060; The passwords don't match.
      </div>
    </div>
  </div>
</xsl:template>

</xsl:stylesheet>
