<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="about:legacy-compat" method="html" indent="no" encoding="utf-8"/>

<xsl:template match="ui/spamchk">
  <div class="location-title">
    <a id="location-title__hamburger"
      href="#menu"
      class="location-title__hamburger"></a>
    <div class="location-title__text">
      Spam check
    </div>
  </div>

  <div class="tab-list unselectable">
    <input id="tab-list__tab-name" type="hidden" value="{name(./*)}"/>
    <xsl:choose>
      <xsl:when test="whitelist">
        <div class="tab-list__item tab-list__item_selected">Whitelist</div>
      </xsl:when>
      <xsl:otherwise>
        <a class="tab-list__item" href="?tab=whitelist">Whitelist</a>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="redlist">
        <div class="tab-list__item tab-list__item_selected">Redlist</div>
      </xsl:when>
      <xsl:otherwise>
        <a class="tab-list__item" href="?tab=redlist">Redlist</a>
      </xsl:otherwise>
    </xsl:choose>
  </div>

  <xsl:apply-templates select="whitelist"/>
  <xsl:apply-templates select="redlist"/>

</xsl:template>

<xsl:template match="spamchk/whitelist|spamchk/redlist">

  <script src="js/whitelist.js" type="text/javascript" language="javascript"></script>

  <form method="get" id="filter-form">
    <div class="list-filter">
      <!-- Filter items form -->
      <a class="list-filter__control list-filter__control_cross" id="filter-form__cross"
        href="#">&#10060;</a>
      <input class="list-filter__text"
        id="filter-form__text" autocomplete="off"
        type="text" name="s" value="{search}" maxlength="512"/>
      <a class="list-filter__control list-filter__control_loupe" id="filter-form__loupe"
        href="#">&#128269;</a>
    </div>
  </form>

  <xsl:call-template name="confirmation">
    <xsl:with-param name="text">
       Are you sure you want to delete the selected addresses?
    </xsl:with-param>
    <xsl:with-param name="caption-yes">Delete</xsl:with-param>
    <xsl:with-param name="caption-no">Cancel</xsl:with-param>
  </xsl:call-template>

  <div class="main-content">

    <div class="pe">

      <!-- Insert new -->
      <form enctype="application/x-www-form-urlencoded" method="post">
        <div class="pe__row">
          <form enctype="application/x-www-form-urlencoded" method="post">
            New:
            <input class="pe__inputText" type="text" name="new-addr"/>
            period:
            <input class="pe__inputText pe__inputText_number"
              type="number" name="new-period"/> day(s)
            <input class="btn" type="submit" value="Insert"/>
          </form>
        </div>
      </form>

      <!-- Check all, delete form -->
      <form enctype="application/x-www-form-urlencoded" method="post">
        <div class="pe__row">
          <label>
            <input type="checkbox" id="list__cb-all" disabled="1"/>
            All
          </label>
          <input type="button" class="btn" id="list__del-btn"
            disabled="1" value="Delete"/>
        </div>
      </form>
    </div>

    <div class="pe">
      <div class="pe__row pe__row_hdr pe__row_ctl">
        <div class="peRowCtl__caption">
          Address
        </div>
        <div class="peRowCtl__ctl">
          Time before removal
        </div>
      </div>
    </div>

    <div class="pe pe_list" id="list"></div>

    <div class="pe pe_hidden" id="load-more">
      <div class="pe__row pe__row_btn">
        <input class="btn pe__wide-btn" id="load-more__btn" type="button"
           value="Load more..."/>
      </div>
    </div>

    <div class="pe pe_hidden" id="search-empty">
      <div class="pe__row">
        No results found.
      </div>
    </div>

  </div>

</xsl:template>

<xsl:template match="whitelist/item">
  <xsl:value-of select="."/>
  --
  <xsl:value-of select="@time-left"/>
</xsl:template>

</xsl:stylesheet>
