/****************************************************************/
/*                    MDumpini for FtpServer                    */
/*                                                              */
/*   This script invokes the generic DumpINI to translate       */
/*   from FTPD.INI to FTPD.TNI.  Then, if multiple INI files    */
/*   are being used, it also translates each FTPD????.INI       */
/*   to the corresponding FTPD????.TNI.                         */
/*                                                              */
/*      Author:       Peter Moylan (peter@pmoylan.org)          */
/*      Last revised: 5 September 2016                          */
/*                                                              */
/*  Usage:                                                      */
/*         mdumpini                                             */
/*                                                              */
/*     (There are no arguments.)                                */
/*                                                              */
/*  Installation:                                               */
/*     Put this in the directory containing the INI file(s)     */
/*     Also ensure that DUMPINI.EXE is either in this           */
/*        directory or on the PATH                              */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

HashMax = SysIni("FTPD.INI", "$SYS", "HashMax")
IF HashMax = 'ERROR:' THEN HashMax = 0
ELSE HashMax = C2D(REVERSE(HashMax))   /* little-endian to integer */
IF HashMax = 0 THEN DO
    '@DUMPINI.EXE FTPD.INI >Nul'
    SAY "Converted 1 INI file"
END
ELSE DO
    CALL SysFileTree 'FTPD????.INI', 'files', 'FO'
    DO k = 1 TO files.0
        SAY "Processing file "files.k
        '@DUMPINI.EXE 'files.k' >Nul'
    END
    SAY "Converted "files.0" INI files"
END

EXIT 0

/****************************************************************/
