/*********************************************************************/
/*   CONTROL BLOCK NAME= PA2XXBIN                                    */
/*                                                                   */
/*   NAME OF MATCHING COBOL CONTROL BLOCK = PA2XXBIN                 */
/*                                                                   */
/*   DESCRIPTIVE NAME = PA/2 binary  record layout                   */
/*                                             (C version)           */
/*                                                                   */
/*                                                                   */
/*   COPYRIGHT        =                                              */
/*                                                                   */
/*   STATUS       Version 1 Release 01                               */
/*                                                                   */
/*                                                                   */
/*   FUNCTION =  Defines layout of PA2 binary file.                  */
/*     It is variable in length.                                     */
/*                                                                   */
/*   LIFTIME  = DSECT used within various programs, overlaying       */
/*     working storage                                               */
/*                                                                   */
/*   STORAGE CLASS = GENERAL                                         */
/*                                                                   */
/*   LOCATION      = Working storage                                 */
/*                                                                   */
/*   INNER CONTOL BLOCKS = None                                      */
/*                                                                   */
/*   NOTES :-                                                        */
/*     DEPENDENCIES = C  Compiler                                    */
/*     RESTRICTIONS = none                                           */
/*     MODULE TYPE  = Control Block Definition                       */
/*     PROCESSOR    = PS/2 and PC                                    */
/*                                                                   */
/*********************************************************************/

/* Record version number definition                                   */
#define VER_100                0x100C
/* Below added for compatability with COBOL programs reading the value
   of this in non byte-swapped form! */
#define VER_100_BYTE_SWAPPED   0x0C10

#include "pa2allen.h"

/****************************\
*                            *
*   Record data structures   *
*                            *
\****************************/

/**************\
*   DATA_SIT   *
\**************/

typedef struct
{
  char   key[4];
  char   filler[48];
} DATA_SIT;

/**************\
*   DATA_PID   *
\**************/

typedef struct
{
  char   key[KEYLEN];
   ULONG    pidnotran;                 /* Offset= 16 */
   ULONG    pidtotaltime;                /* Offset= 20 */
   ULONG    pidacttotaltime;                /* Offset=    */
   ULONG    pidtaskn;                /*Task number Offset=    */
   short    pidprty;                  /* Offset=    */
   short    pidprogramno;                  /* Offset=    */
   char     pidprogram[PIDSTACKNO][PROGRAMLEN]; /* Offset=    */
   char     pidtran[TRANLEN];                /* Offset= 28 */
   unsigned pidglbl : 1;                  /* Global Process */
   char pidfiller[9];                /* Offset=    */
} DATA_PID;

/**************\
*   DATA_BUK   *
\**************/

typedef struct
{
  char   key[KEYLEN];
ULONG kctran;                       /* Number of times transaction run */
ULONG kcbucketno[NOCLOCKS];         /* Number of times Bucket[i] started */
ULONG kcbucketstopno[NOCLOCKS];     /* Number of times Bucket[i] stopped */
ULONG kcbuckettot[NOCLOCKS];        /* Total time in millisecs in Bucket[i] */
char  filler[12];
} DATA_BUK;

/**************\
*   DATA_PCT   *
\**************/

typedef struct
{
  char   key[KEYLEN];
ULONG kctran;                       /* Number of times transaction run */
ULONG kctrantotaltime;              /* Sum of response times in millisecs */
ULONG kctranshortesttime;           /* Shortest response time in millisecs */
ULONG kctranlongesttime;            /* Longest response time in millisecs */
ULONG kcnoabend;                    /* Number of ABENDs */
ULONG kcsync;                       /*Number of SYNCPOINTs */
ULONG kcsynctotaltime;              /* Total time in SYNCPOINT in millisecs */
ULONG kcbtsync;                     /*Number of System File Manager calls in SYNCPOINT */
ULONG kcsyncbttotaltime;            /* Total time in System File Manager SYNCPOINT in millisecs */
double kcsq;                        /* Sum of squares of response times in millisecs */
char filler[4];                     /* Filler */
} DATA_PCT;

/**************\
*   DATA_SNT   *
\**************/

typedef struct
{
  char   key[KEYLEN];
  char  filler[48];
} DATA_SNT;

/**************\
*   DATA_FCT   *
\**************/

typedef struct
{
  char   key[KEYLEN];
   ULONG fctran;        /* Number of times transaction run */
   ULONG fcread;        /* Number of READs */
   ULONG fcwrite;       /* Number of WRITEs */
   ULONG fcrewrite;     /* Number of REWRITEs */
   ULONG fcdelete;      /* Number of DELETEs */
   ULONG fcunlock;      /* Number of UNLOCKs */
   ULONG fcstartbr;     /* Number of STARTBRowses */
   ULONG fcresetbr;     /* Number of RESETBRowses */
   ULONG fcendbr;       /* Number of ENDBRowses */
   ULONG fcreadnext;    /* Number of READNEXTs */
   ULONG fcreadprev;    /* Number of READPREVious */
   ULONG fcbtread;      /* Number of System File Manager calls forREADs */
   ULONG fcbtwrite;     /* Number of System File Manager calls forWRITEs */
   ULONG fcbtrewrite;   /* Number of System File Manager calls forREWRITEs */
   ULONG fcbtdelete;    /* Number of System File Manager calls forDELETEs */
   ULONG fcbtunlock;    /* Number of System File Manager calls forUNLOCKs */
   ULONG fcbtstartbr;   /* Number of System File Manager calls forSTARTBRowses */
   ULONG fcbtresetbr;   /* Number of System File Manager calls forRESETBRowses */
   ULONG fcbtendbr;     /* Number of System File Manager calls forENDBRowses */
   ULONG fcbtreadnext;  /* Number of System File Manager calls forREADNEXTs */
   ULONG fcbtreadprev;  /* Number of System File Manager calls forREADPREVious */
   ULONG fctotread;     /* Total time in millisecs for READs */
   ULONG fctotwrite;    /* Total time in millisecs for WRITEs */
   ULONG fctotrewrite;  /* Total time in millisecs for REWRITEs */
   ULONG fctotdelete;   /* Total time in millisecs for DELETEs */
   ULONG fctotunlock;   /* Total time in millisecs for UNLOCKs */
   ULONG fctotstartbr;  /* Total time in millisecs for STARTBRowses */
   ULONG fctotresetbr;  /* Total time in millisecs for RESETBRowses */
   ULONG fctotendbr;    /* Total time in millisecs for ENDBRowses */
   ULONG fctotreadnext; /* Total time in millisecs for READNEXTs */
   ULONG fctotreadprev; /* Total time in millisecs for READPREVious */
} DATA_FCT;

/**************\
*   DATA_TCT   *
\**************/

typedef struct
{
  char   key[KEYLEN];
  char  filler[48];
} DATA_TCT;

/**************\
*   DATA_TCS   *
\**************/

typedef struct
{
  char   key[KEYLEN];
  char  filler[48];
} DATA_TCS;

/**************\
*   DATA_TST   *
\**************/

typedef struct
{
  char   key[KEYLEN];
  char  filler[48];
} DATA_TST;

/**************\
*   DATA_DCT   *
\**************/

typedef struct
{
  char   key[KEYLEN];
  char  filler[48];
} DATA_DCT;

/**************\
*   DATA_PPT   *
\**************/

typedef struct
{
  char   key[KEYLEN];
  char  filler[48];
} DATA_PPT;

/*******************************\
*                               *
*   Composite data structures   *
*                               *
\*******************************/
/*******************\
*   PA2TABLE_DATA   *
\*******************/

typedef union
{
  DATA_SIT sit;
  DATA_PCT pct;
  DATA_FCT fct;
  DATA_SNT snt;
  DATA_TCT tct;
  DATA_TCS tcs;
  DATA_TST tst;
  DATA_DCT dct;
  DATA_PPT ppt;
  DATA_BUK buk;
  DATA_PID pid;
} PA2TABLE_DATA;

/*******************\
*   PA2TABLE_AREA   *
\*******************/

typedef struct
{
  PA2TABLE_DATA data[5];
} PA2TABLE_AREA;

/**************\
*   PA2TABLE   *
\**************/

typedef struct
{
  char applid[8];    /* applid as defined in sit, right aligned */
  ULONG kctrantot;   /* total transactions run */
  ULONG tottime;     /* total run time in seconds */
  char date[4];      /* date in packed decimal 00yyddd+ */
  char time[4];      /* time in packed decimal 0hhmmss+ */
  short length;      /* length of real data returned */
  short noitems;     /* number of items in array */
  short maxcurrenttran; /* maximum con-current tran */
  char entry_type[1];
  char end[1];
  char spare[16];     /* Reserved for future expansion */
  /* align to multiple of 16 */
  PA2TABLE_AREA record;
} PA2TABLE;
