#!/usr/bin/perl
#
# Get new daily virus defs (*.IDE files) from Sophos Web site.
#
# Originator page: <http://www.stalker.com/CGPSophos/>
#

my $ProxyURL='';  # 'http://proxy.company.com:8001/';

use strict;
require LWP::UserAgent;
require HTTP::Request;

my $dir;
my $signal_file;

if($^O eq 'MSWin32') {
  $dir = "C:\\CommuniGate Files\\CGPSophos\\";  #you may want to redefine this
  $signal_file = "C:\\CommuniGate Files\\CGPSophos\\update.sig";

} elsif($^O eq 'darwin') {
  $dir = "/Library/Application\ Support/Sophos\ Anti-Virus/IDEs/";
  $signal_file = "/var/CommuniGate/CGPSophos/update.sig";
} else {
  $dir = "/usr/local/sav/";
  $signal_file = "/var/CommuniGate/CGPSophos/update.sig";
}

my $dizFileName=$dir."dat_file_id.diz";

my $nDownloaded=0;


sub getCurrVersion {
  my $VersionLine;
  die "Unable to read $dizFileName\nPlease launch monthlyUpdate.pl script first.\n"
     unless( -f $dizFileName);
     
  open(FILE, "< $dizFileName")
      or die "can't open $dizFileName: $!";
  my @FileID = <FILE>;
  close(FILE);

  chomp($VersionLine = $FileID[$#FileID]);
  return ($VersionLine =~ /\((.+)\)$/)[0];
}


sub webget {
     my $ua  = LWP::UserAgent->new;
     $ua->proxy(['http', 'ftp'], $ProxyURL) if($ProxyURL);
     my $req = HTTP::Request->new('GET',$_[0]);
     my $res = $ua->request($req);

     if($res->code != 200) {
       #  print "$_[0]\n";
       return undef if(defined($_[1]));
       die "Error: " . $res->code . " " . $res->message;
     }
     return $res->content();
}

sub checkFile {
  return 1 unless(-r $_[0] && -s $_[0]);

  my $ua  = LWP::UserAgent->new;
  $ua->proxy(['http', 'ftp'], $ProxyURL) if($ProxyURL);
  my $req = HTTP::Request->new('HEAD',$_[1]);
  my $res = $ua->request($req);

  if($res->is_success) {
    return 1 if(-s $_[0] != $res->content_length);
    return 1 if( (stat($_[0]))[9] < $res->last_modified); 
  } else {
    return 1;   
  }
  return 0;
}

sub download {
     my $url = $_[0];
     my $file = $url;
     $file =~ s:.*/::g;          # remove to last /
     my $fname = $dir.$file;

     unless(checkFile($fname,$url)) {
        return;
     }
     print "Downloading: $fname\n";

     open(R,">$fname");
     print R webget($url);
     close(R);
     $nDownloaded++;
}


die "Unable to write to directory: $dir.\n"
   unless -d $dir and -w $dir;


# get current IDEs only

my $vdlVers=getCurrVersion();  #learn the current version number
print "Current VDL.DAT version: $vdlVers\n";

$vdlVers =~ s/\D//;
for(;;$vdlVers++) {
  my $url="http://www.sophos.com/downloads/ide/".$vdlVers."_list.txt";
  my $ides = webget($url,1);
  last unless($ides);
  print "Checking: $url\n";
  foreach $_ (split(/\n/,$ides)){ download($_); }
}

#my $ides = webget('http://www.sophos.com/downloads/ide/list.txt');
#foreach $_ (split(/\n/,$ides)){ download($_); }


#    get all available IDEs
#my $ides = webget('http://www.sophos.com/downloads/ide/');
#foreach $_ (split(/\</,$ides)){
#     if(m:href="/(downloads/ide/[\w\d\.\-\/]+?\.ide)\":){
#         download("http://www.sophos.com/$1");
#     }
#}

if($nDownloaded>0) {
  print " $nDownloaded files downloaded.\n";
  open SIGFILE, ">$signal_file"
      || die "Unable to write plugin signal file $signal_file: $!\n";      
  close SIGFILE;
} else {
  print "Nothing new...\n";
}

__END__
