#!/usr/bin/perl
#
# Get new monthly virus defs (vdl.dat + vdl*.vdb files) from Stalker Web site.
#
# Originator page: <http://www.stalker.com/CGPSophos/>
#

use strict;
use Net::FTP;
require Fcntl;

my $FTPServer      = "ftp.stalker.com";

my $FTPLogin       = "anonymous";
my $FTPPassword    = "postmaster\@mydomain.com";


my $FTPDirectory   = "/pub/plugins/Sophos/DatFiles";

# Local configuration
my ($CGPSophos,$UpdatesDir,$SignalFile);


if($^O eq 'MSWin32') {

 $CGPSophos      = "C:\\CommuniGatePro\\CGPSophos";
 $UpdatesDir     = "C:\\CommuniGatePro\\CGPSophos";
 $SignalFile     = "$CGPSophos\\update.sig";

} else {

 $CGPSophos      = "/var/CommuniGate/CGPSophos";
 $UpdatesDir     = "/usr/local/sav";

 $SignalFile     = "$CGPSophos/update.sig";

}


my $ftp;
my @SrcDirListing;
my @DirListing;
my $FileName;
my @FileID;
my @OldFileID;
my $CurrentVersion;
my $NewVersion;

#=======================================================================

#
# Run a couple of sanity checks
#


die "Unable to write to directory: $UpdatesDir.\n"
   unless -d $UpdatesDir and -w $UpdatesDir;

die "Unable to write to directory $CGPSophos.\n"
   unless -d $CGPSophos and -w $CGPSophos;

die "Unable to write file: $UpdatesDir/dat_file_id.diz"
   unless -w "$UpdatesDir/dat_file_id.diz" or ! -f "$UpdatesDir/dat_file_id.diz";

#
# Get the current version number and the current dat_file_id.diz
#
GetFileID();

#
# Connect to the FTP server to find the newest version

print "Connecting to '$FTPServer' via FTP protocol...\n";
$ftp = Net::FTP->new($FTPServer, Debug => 0)
   or die "Unable to open the connection to '$FTPServer'\n";

$ftp->login($FTPLogin,$FTPPassword)
   or die "Unable to login to server '$FTPServer'\n";

$ftp->cwd($FTPDirectory)
   or die "Unable to change to directory $FTPDirectory\n";

@SrcDirListing = $ftp->ls()
   or die "Unable to get directory listing for $FTPDirectory\n";

#
# Look for the one file on the server we're interested in.
#
@DirListing = grep { /^vdl-.+\.dat$/i }  @SrcDirListing;

if($#DirListing < 0) {
   die "Unable to locate the DAT files\n";
}

if($#DirListing > 0) {
  @DirListing = reverse sort @DirListing; 
}

#
# Grab the first file name which is either only or the latest.
#
$FileName = $DirListing[0];

#
# Find the version number on the remote
# server based on the file name.
#
$NewVersion = ($FileName =~ /vdl-(.+)\.dat/i)[0];

#print "new version: $NewVersion; current version: $CurrentVersion\n";

if ($NewVersion > $CurrentVersion) {

   chdir($UpdatesDir)
      or die "Unable to change to $UpdatesDir: $!\n";

   $ftp->binary();

   print "Downloading '$FileName', please wait...\n";
   $ftp->get($FileName)
      or die "Unable to get file $FTPDirectory/$FileName: $!\n";

   open(FILE, "> dat_file_id.tmp")
       or die "can't open $UpdatesDir/dat_file_id.diz: $!";
   print FILE "Virus Definition Data Files for Sophos ($NewVersion)\n";
   close(FILE);


   #  download the updated vdl*.vdb files
   #
   @DirListing = grep { /^vdl.+\.vdb$/i }  @SrcDirListing;
   foreach(@DirListing) {
     if(!(-e $_) || (stat($_))[9] < $ftp->mdtm($_) || (stat($_))[7] != $ftp->size($_)) {
       print "Downloading '$_', please wait...\n";
       $ftp->get($_)
         or die "Unable to get file $FTPDirectory/$_: $!\n"; 
     }
   }


   mkdir("archive",0777) unless -d "archive";
   if($^O eq 'MSWin32') {
     unlink("VDL-OLD.DAT");
     rename("VDL.DAT","VDL-OLD.DAT");
     rename("$FileName","VDL.DAT")
       or die "Unable to rename $FileName into VDL.DAT: $!\n";
     system("move *.IDE archive");  
   } else {
     unlink("$UpdatesDir/vdl.dat");
     symlink("$FileName","$UpdatesDir/vdl.dat")
       or die "Unable to create symlink $UpdatesDir/vdl.dat->$FileName: $!\n";
     system("mv *.ide archive/ >/dev/null");  
   }


   sysopen SIGFILE, $SignalFile, Fcntl::O_CREAT ()
      or die "Unable to write plugin signal file $SignalFile: $!\n";
   close SIGFILE;
   rename("dat_file_id.tmp","dat_file_id.diz")
       or die "Unable to rename dat_file_id.tmp into dat_file_id.diz: $!\n";

   # Save the old File ID info from Sophos
   push(@OldFileID,@FileID);

   # Get the new File ID info that was just installed
   GetFileID();

   print "\n",
         "New VDL.DAT file was loaded.\n\n",
         "   New file ID info is:\n",
         "   -----\n";
   foreach (@FileID) { print "   $_"; }
   print "   -----\n";

   print "\n",
         "   Old file ID info was:\n",
         "   -----\n";
   foreach (@OldFileID) { print "   $_"; }
   print "   -----\n";

} else {

   print "\n",
         "No new VDL.DAT file available.\n\n",
         "   Current file ID info is:\n",
         "   -----\n";
   foreach (@FileID) { print "   $_"; }
   print "   -----\n";

}

$ftp->quit();

exit;


sub GetFileID {

   my $VersionLine;

   if ( -f "$UpdatesDir/dat_file_id.diz" ) {
      open(FILE, "< $UpdatesDir/dat_file_id.diz")
         or die "can't open $UpdatesDir/dat_file_id.diz: $!";
      @FileID = <FILE>;
      close(FILE);

      # Strip out the carriage returns
      foreach (@FileID) { tr/\r//d; }

      # We assume that the version number is the first thing
      # in parentheses on the last line in the file.
      chomp($VersionLine = $FileID[$#FileID]);
      $CurrentVersion = ($VersionLine =~ /\((.+)\)$/)[0];
   } else {
      $CurrentVersion = 0;
   }

   return;
}

__END__

