﻿// ============================================= //
//   CommuniGate Media Plugin Object Generator   //
//                                               //
// Version 1.0                                   //
// Copyright (c) 2010, Stalker Software, Inc.    //
// ============================================= //

//-------------------------------------
// variables
//-------------------------------------

var objectActiveX2	= ' ></object>';
var objectNetscape2	= ' ></object>';
// add to plugin it's version 
var ActiveXGIPSVersion = 'version=2,0,2,0';
var ActiveXCGSVersion = 'version=1,0,10,0';

// CG plugin
var mediaPluginMIMEType			= 'application/npCommuniGateAV-plugin';
var mediaPluginObjectActiveX1	= '<object id="CommuniGateAV" classid="clsid:FA1F9352-0B8B-431D-BB18-7A3457F696F4" codebase=';
var mediaPluginObjectNetscape1	= '<object id="CommuniGateAV" type="'+mediaPluginMIMEType+'" width="0" height="0" codebase=';

var mediaPluginActiveXURL	= 'www.communigate.com/MediaPlugin/1.0/CGateAVX.cab';
var mediaPluginMacOSURL		= 'www.communigate.com/MediaPlugin/1.0/CommuniGateAV.dmg';
var mediaPluginNetscapeURL	= 'www.communigate.com/MediaPlugin/1.0/npCommuniGateAV.xpi';
// needed to place dll manually
var mediaPluginDLLURL		= 'mail.moscow.stalker.com/~cheba/Pronto/AVPluginSetup.exe';
//var mediaPluginOperaURL		= 'mail.moscow.stalker.com/~cheba/Pronto/npCommuniGateAV.dll';


// GIPS plugin
var gipsPluginMIMEType			= 'application/npCommuniGateAV-plugin-GIPS';
var gipsPluginObjectActiveX1	= '<object id="CommuniGateAV" classid="clsid:675AAABC-F3E3-4332-A94F-EE174AF1F833" width="0" height="0" codebase=';
var gipsPluginObjectNetscape1	= '<object id="CommuniGateAV" type="'+gipsPluginMIMEType+'" width="0" height="0" codebase=';

var gipsPluginActiveXURL		= 'www.communigate.com/MediaPluginGIPS/2.0/CommuniGateAVPluginGIPS.CAB';
var gipsPluginChromeURL			= 'www.communigate.com/MediaPluginGIPS/2.0/CGateAVPluginGIPSChromeExtension.crx';
var gipsPluginMacOSURL			= 'www.communigate.com/MediaPluginGIPS/2.0/CGateAVPluginGIPS.dmg';
var gipsPluginMacOSFirefoxURL	= 'www.communigate.com/MediaPluginGIPS/2.0/MediaPluginGIPS.xpi';
var gipsPluginNetscapeURL		= 'www.communigate.com/MediaPluginGIPS/2.0/MediaPluginGIPS.xpi';
// needed to place dll manually
var gipsPluginDLLURL			= 'mail.moscow.stalker.com/~cheba/Pronto/AVPluginSetup.exe';
//var gipsPluginOperaURL			= 'mail.moscow.stalker.com/~cheba/Pronto/npCommuniGateAVPluginGIPS.dll';

var BROWSER_IE = "IE";
var BROWSER_FF = "FF";
var BROWSER_CHROME = "Chrome";
var BROWSER_OPERA = "Opera";
var BROWSER_SAFARI = "Safari";
var BROWSER_MAC_SAFARI = "MacOS_safari";
var BROWSER_MAC_FF = "MacOS_FF";
	
// browsers that need to show URL in Pronto, for correct installation
var needURLToInstall = [BROWSER_OPERA, BROWSER_SAFARI, BROWSER_MAC_SAFARI];
var needImgToInstall = [BROWSER_FF, BROWSER_IE, BROWSER_MAC_FF, BROWSER_CHROME];
	
// common variables
var pluginName	= "cgp";
var theBrowser	= null;

//-------------------------------------
// public functions
//-------------------------------------

function getObject(thePluginName){
	theBrowser = getBrowser();
	if (!theBrowser)
		return null;
	
	pluginName = thePluginName;
	if (pluginName != "gips")
		pluginName = "cgp";
	
	return getPluginObject(theBrowser);
}

// check browsers if it needs to show URL in Pronto, for correct installation
function checkBrowserInstallNeeds(type, browserName){
	if (type == "urlCheck"){
		for (var j=0; j < needURLToInstall.length; j++){
			if (needURLToInstall[j] == browserName)
				return {checked:true};
		}
		return {checked:false};
	} else if (type == "imgCheck"){
		for (var j=0; j < needImgToInstall.length; j++){
			if (needImgToInstall[j] == browserName)
				return {checked:true};
		}
		return {checked:false};
	} else if (type == "img"){
		return {img:browserName+"_notification.png"};
	} else if (type == "browser"){
		return {browser:browserName};
	}
	return false;
}
//-------------------------------------
// additional functions
//-------------------------------------

// get plugin object for different browsers and plugins
function getPluginObject(browser) {
	return getObjectStart(browser)+ '"' + getPluginURL(browser) + '"' + getObjectEnd(browser);
}

function getObjectStart(browser) {
	if (browser == BROWSER_IE)
		return (pluginName == "cgp") ? mediaPluginObjectActiveX1 : gipsPluginObjectActiveX1;
	else
		return (pluginName == "cgp") ? mediaPluginObjectNetscape1 : gipsPluginObjectNetscape1;
}

function getHTTPSchema() {
	// for correct link in debug mode
	if (parent.location.protocol == "file:")
		return "http://";
	else
		return parent.location.protocol +"//";
}

function getMIMEType(){
	return (pluginName == "cgp") ? mediaPluginMIMEType : gipsPluginMIMEType;
}

function getObjectEnd(browser) {
	if (browser == BROWSER_IE)
		return objectActiveX2;
	else
		return objectNetscape2;
}

function getIEVersion(){
	var nv = navigator.appVersion;
	var s = nv.indexOf('MSIE')+5;
	return Number(nv.substring(s,s+1));
}

function getPluginURL(browser) {
	if (!browser)
		return "Unsupported browser";
		
	var pluginURL = getHTTPSchema();
	if (browser == BROWSER_IE) {
		var plg = (pluginName == "cgp") ? mediaPluginActiveXURL : gipsPluginActiveXURL;
		plg += '#' + ((pluginName == "cgp") ? ActiveXCGSVersion : ActiveXGIPSVersion);
		pluginURL += plg;
	} else if (browser == BROWSER_MAC_SAFARI) {
		pluginURL += (pluginName == "cgp") ? mediaPluginMacOSURL : gipsPluginMacOSURL;
	} else if (browser == BROWSER_MAC_FF) {
		pluginURL += (pluginName == "cgp") ? mediaPluginMacOSURL : gipsPluginMacOSFirefoxURL;
	} else if (browser == BROWSER_CHROME) {
		pluginURL += (pluginName == "cgp") ? mediaPluginNetscapeURL : gipsPluginChromeURL;
	} else if (browser == BROWSER_FF) {
		pluginURL += (pluginName == "cgp") ? mediaPluginNetscapeURL : gipsPluginNetscapeURL;
	} else if (browser == BROWSER_OPERA || browser == BROWSER_SAFARI) {
		pluginURL += (pluginName == "cgp") ? mediaPluginDLLURL : gipsPluginDLLURL;
	}	
	
	return pluginURL;
}

function getBrowser(){
	var browserName = null;
	var userAgent = navigator.userAgent.toLowerCase();
	var isMacOS = navigator.userAgent != null && userAgent.indexOf('mac os x') != -1;
	if (navigator.appName == "Microsoft Internet Explorer") {
		browserName = BROWSER_IE;
	} else if(isMacOS && userAgent.indexOf('firefox') != -1) {
		browserName = BROWSER_MAC_FF;
	} else if(isMacOS && userAgent.indexOf('safari') != -1) {
		browserName = BROWSER_MAC_SAFARI;
	} else if(!isMacOS && userAgent.indexOf('safari') != -1 && userAgent.indexOf('chrome') == -1) {
//		browserName = BROWSER_SAFARI;	Temporary block until correct installator
		browserName = null;
	} else if(navigator.userAgent != null && userAgent.indexOf('chrome') != -1) {
		browserName = BROWSER_CHROME;
	} else if (!isMacOS && userAgent.indexOf('firefox') != -1) {
		browserName = BROWSER_FF;
	} else if (navigator.appName == "Opera") {
//		browserName = BROWSER_OPERA;	Temporary block until correct installator
		browserName = null;
	} 
	return browserName;
}

 
