//$(function(){
//    var tt = $('.b-scroller').scroller();
//});

var g_scrollerUpdate;

(function($) {
	$.fn.scroller = function(options) {
		var THUMB_HEIGHT = 90;
		var scrollRatio = 1;

		var scroll = function(delta) {
			var currentLeft = $('.b-scroller__scroll__position').position().left;
			var newLeft = currentLeft - delta;

			var minLeft = 14;
			var maxLeft = $('.b-scroller').outerWidth() - 16
					- $('.b-scroller__scroll__position').width();

			if (newLeft < minLeft) {
				newLeft = minLeft;
			} else if (newLeft > maxLeft) {
				newLeft = maxLeft;
			}
			$('.b-scroller__scroll__position').css('left', newLeft);
			$('.b-scroller__scrollable').css('left',
					-(newLeft - minLeft) / scrollRatio);
		};

		var thumbWidthIsReady = function(photoData) {
			if (!photoData)
				return false;
			return (photoData.thumb_width != undefined)
					&& !isNaN(photoData.thumb_width)
					&& (photoData.thumb_width > 0);
		};

		var thumbHeightIsReady = function(photoData) {
			if (!photoData)
				return false;
			return (photoData.thumb_height != undefined)
					&& !isNaN(photoData.thumb_height)
					&& (photoData.thumb_height > 0);
		};

		var thumbIsReady = function(photoData) {
			if (!photoData)
				return false;
			return thumbWidthIsReady(photoData)
					&& thumbHeightIsReady(photoData);
		};

		var mouseDown = false, oldx = 0;
		$('.b-scroller__scroll__position').mousedown(function(e) {
			if (e.which == 1) {
				mouseDown = true;
				oldx = e.pageX;
				return false;
			}
		});

		$('body').mousemove(function(e) {
			if (mouseDown) {
				scroll(oldx - e.pageX);
				oldx = e.pageX;
				return false;
			}
		}).mouseup(function(e) {
			if (e.which == 1) {
				mouseDown = false;
			}
		}).mouseleave(function() {
			mouseDown = false;
		});

		$('.b-scroller__scroll__arrow_left').click(function() {
			scroll(100 * scrollRatio);
		});
		$('.b-scroller__scroll__arrow_right').click(function() {
			scroll(-100 * scrollRatio);
		});

		$('.b-scroller__scroll').click(
				function(e) {
					if (e.target.className == this.className) {
						var mult = e.pageX < $('.b-scroller__scroll__position')
								.offset().left ? 1 : -1;
						scroll(mult
								* $('.b-scroller__scroll__position')
										.outerWidth());
					}
				});

		var span, img, paneWidth = 10;
		for ( var i = 0, n = galleryData.photos.length; i < n; i++) {
			img = $('<img/>');
			img.data("imageIndex", i);
			var isLoaded = thumbIsReady(galleryData.photos[i]);
			if (isLoaded) {
				img.attr({
					src : galleryData.photos[i].thumb_src,
					height : THUMB_HEIGHT,
					width : Math
							.round(galleryData.photos[i].thumb_width
									* THUMB_HEIGHT
									/ galleryData.photos[i].thumb_height),
					id : 'photo_thumb_' + i,
					rel : 'photo_' + i
				});
			} else {
				img.attr({
					src : galleryData.photos[i].thumb_src,
					id : 'photo_thumb_' + i,
					rel : 'photo_' + i
				});
				img.hide();
				img.imagesLoaded().done(
						function(images) {
							var jImage = $(images[0]);
							var index = jImage.data("imageIndex");
							jImage.show();
							var htmlImage = jImage[0];
							
							var loadedWidth = -1;
							var loadedHeight = -1;
							if (!thumbWidthIsReady(galleryData.photos[index])) {
								loadedWidth = htmlImage.width || htmlImage.innerWidth
								|| htmlImage.naturalWidth;
								galleryData.photos[index].thumb_width = loadedWidth;
							}
							if (!thumbHeightIsReady(galleryData.photos[index])) {
								loadedHeight = htmlImage.height || htmlImage.innerHeight
								|| htmlImage.naturalHeight;
								galleryData.photos[index].thumb_height = loadedHeight;
							}
							loadedWidth = galleryData.photos[index].thumb_width;
							loadedHeight = galleryData.photos[index].thumb_height;
							if (loadedWidth > 0 && loadedHeight > 0) {
								var newWidth = Math.round(loadedWidth
										* THUMB_HEIGHT / loadedHeight);
								jImage.attr({
									height : THUMB_HEIGHT,
									width : newWidth
								});
								paneWidth += newWidth + 10;
								update();
							}
						});
			}
			span = $('<span/>');
			span.append(img);
			span.addClass('b-scroller__image');
			if (parseInt(location.hash.substr(1)) == i) {
				span.addClass('b-scroller__image_active');
			}
			$('.b-scroller__scrollable').append(span);
			paneWidth += isLoaded ? Math
					.round(galleryData.photos[i].thumb_width * THUMB_HEIGHT
							/ galleryData.photos[i].thumb_height) + 10 : 0;
		}

		function update() {
			var k = $('.b-scroller').width() / paneWidth;
			if (k > 1) {
				$('.b-scroller__scroll').hide();
			} else {
				$('.b-scroller__scroll').show();
				$('.b-scroller__scroll__position').css('width',
						Math.round(k * 100) + '%');
			}

			scrollRatio = ($('.b-scroller').outerWidth()
					- $('.b-scroller__scroll__position').outerWidth() - 14)
					/ (paneWidth - $('.b-scroller').outerWidth());
			scroll(0);
		}

		g_scrollerUpdate = update;

		$(window).resize(update);

	};
})(jQuery);
