// ============================================= //
//   CommuniGate Media Plugin Object Generator   //
//                                               //
// Version 1.1                                   //
// Copyright (c), Stalker Software, Inc.         //
// 2010 - 2011                                   //
// ============================================= //

//-------------------------------------
// variables
//-------------------------------------

// CG plugin
var CGP =
{
	id : 'cgp',

	activeXVersion : 'version=1,0,10,0',
	objectStartActiveX : '<object id="CommuniGateAV" classid="clsid:FA1F9352-0B8B-431D-BB18-7A3457F696F4" codebase=',
	objectStart : '<object id="CommuniGateAV" type="application/npCommuniGateAV-plugin" width="0" height="0" codebase=',
	objectEnd : ' ></object>',
	
	name : 'CommuniGate Media Plugin', // used for plugin detection
	
	win32_msie : 'www.communigate.com/MediaPlugin/1.0/CGateAVX.cab',
	win32_firefox : 'www.communigate.com/MediaPlugin/1.0/npCommuniGateAV.xpi',
	macintel_safari : 'www.communigate.com/MediaPlugin/1.0/CommuniGateAV.dmg'
};

// GIPS plugin
var GIPS =
{
	id : 'gips',
	
	activeXVersion : 'version=2,0,10,1',
	objectStartActiveX : '<object id="CommuniGateAV" classid="clsid:675AAABC-F3E3-4332-A94F-EE174AF1F833" width="0" height="0" codebase=',
	objectStart : '<object id="CommuniGateAV" type="application/npCommuniGateAV-plugin-GIPS" width="0" height="0" codebase=',
	objectEnd : ' ></object>',
	
	win32_name : 'CommuniGate Media Plugin (GIPS)',
	macintel_name : 'CGateAVPluginGIPS',
	
	win32_msie : 'www.communigate.com/MediaPluginGIPS/2.0/CommuniGateAVPluginGIPS.CAB',
	
	firefox : 'www.communigate.com/MediaPluginGIPS/2.0/MediaPluginGIPS.xpi',
	
	win32_chrome : 'www.communigate.com/MediaPluginGIPS/2.0/CGateAVPluginGIPSChromeExtension.crx',
	macintel_chrome : 'www.communigate.com/MediaPluginGIPS/2.0/CGateAVPluginGIPSChromeExtension.crx',  
	macintel_safari : 'www.communigate.com/MediaPluginGIPS/2.0/CGateAVPluginGIPS.dmg',

	chromeWebStore : 'https://chrome.google.com/webstore/detail/cgateavplugingips-chrome-/nojdcclfchcmgnccknlocmbkoldbnkca'
};

//-------------------------------------
// public functions
//-------------------------------------

function getObject(pluginName){
	var plugin = getPlugin(pluginName);
	var browser = getSaneBrowser();
	if (!browser)
		return;
		
	var pluginURL = getPluginURL(plugin, browser);
	if (!pluginURL)
	{
		if (isPluginAvailable(pluginName) == 'yes') // plugin was installed in some way to this browser
			pluginURL = 'manual';
		else
			return null;
	}
		
	return  plugin['objectStart' + ((browser.name == 'msie') ? 'ActiveX' : '')] + 
			'"' + pluginURL + '"' +
		    plugin['objectEnd'];
	
}

// returns 'yes', 'no', 'unknown'
function isPluginAvailable(pluginName){
	var plugin = getPlugin(pluginName);
	var browser = getSaneBrowser();
	
	if (!browser) // unsupported browser
		return 'no';
	else if (browser.name == 'msie') // no way to detect plugin before trying to add it in IE
		return 'unknown';
		
	var name = plugin[browser.platform + '_name'];
	if (!name)
		name = plugin.name;
	if (!name)
		return 'unknown';
	
	var plugins = navigator.plugins;
	if (!plugins)
		return 'unknown';
	
	for (var i = 0; i < plugins.length; i++)
	{	 
	    if (plugins[i] && plugins[i].name == name)
			return 'yes';
	}
	
	return 'no';
}
/*
 {
  envType: 'browser',
  pluginSupported: // true/false
  pluginAvailable: //'yes','no','unknown'
  loadLink: '',
  name: 
  platform:
 }
*/
function getEnvironmentInfo(pluginName) {
	var browser = getSaneBrowser();
	if (browser)
	{
		browser.envType = "browser";
		browser.loadLink = getPluginInstallURL(pluginName);
		browser.pluginSupported = browser.loadLink ? true : false;
		browser.pluginAvailable = isPluginAvailable(pluginName);
	}
	else
	{
		browser = {
			envType :"browser",
			pluginSupported : false,
			pluginAvailable: false
		};
	}
	return browser;
}

function getPluginInstallURL(pluginName){
	var plugin = getPlugin(pluginName);
	var browser = getSaneBrowser();
	if (!browser)
		return null;
	else
		return getPluginURL(plugin, browser);
}

//-------------------------------------
// private functions
//-------------------------------------
function getSaneBrowser() {
	var browser = detectBrowser();
	// browser.name	= // msie, firefox, chrome, opera, safari
	// browser.platform = // win32, win64, macintel
	if (!browser || (browser.platform != "win32" && browser.platform != 'macintel'))
		return null; // unsupported browser or platform
	else
		return browser;
}

function getPlugin(pluginName) {
	pluginName = pluginName.toLowerCase();
	return pluginName == 'gips' ? GIPS : CGP;
}

function getPluginURL(plugin, browser) {
	if (browser.name == "chrome" && plugin.id == "gips"){
		return GIPS.chromeWebStore;
	}
	
	var pluginURL = plugin[browser.platform+'_'+browser.name];
	if (!pluginURL)
    pluginURL = plugin[browser.name];
    
  if (!pluginURL)
		return null;
	
	if (browser.name == 'msie')
		pluginURL += '#' + plugin.activeXVersion;
	
	pluginURL = getHTTPSchema() + pluginURL;
	
	return pluginURL;
}

function getHTTPSchema() {
	// for correct link in debug mode
	if (parent.location.protocol == "file:")
		return "http://";
	else
		return parent.location.protocol + "//";
}

function detectBrowser(){
	var browser = {};
	browser.platform = navigator.platform;
	if (browser.platform)
		browser.platform = browser.platform.toLowerCase();
	
	var userAgent = navigator.userAgent.toLowerCase();
	
	if (userAgent.indexOf('msie') > -1) {
		browser.name = 'msie';
	} else if (userAgent.indexOf('firefox') > -1) {
		browser.name = 'firefox';
	} else if (userAgent.indexOf('chrome') > -1) {
		browser.name = 'chrome';
	} else if (userAgent.indexOf('safari') > -1) {
		browser.name = 'safari';
	} else if (userAgent.indexOf('opera') > -1) {
		browser.name = 'opera';
	} else { // completely unsupported browser
		return null;
	}
	
	return browser;
}
