var weekend = [0,6];  //Means that Weekends are defined as days 0 and 6
var weekendColor = "#e0e0e0";
var gNow = new Date();
	var p_month = new String(gNow.getMonth());
	var p_year = new String(gNow.getFullYear().toString());
	var p_format = "YYYY-MM-DD";
var theCalendarContent;
var ggPosX = 220;
var ggPosY = 25;

Calendar.Months = ["January", "February", "March", "April", "May", "June","July", "August", "September", "October", "November", "December"];

// Non-Leap year Month days..
Calendar.DOMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
// Leap year Month days..
Calendar.lDOMonth = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];

function writeToLayer(id,shtml) {
   if (document.getElementById || document.all) {
      var el = document.getElementById? document.getElementById(id): document.all[id];
      if (el && typeof el.innerHTML != "undefined") el.innerHTML = shtml;
   }
}


function show_calendar() {

	/* 
		CGPmailbox	: The mailbox name, parsed via wssp on the Calendar.wssp page.
	*/

	CGPmailbox = String(arguments[0]);
	Build(p_month, p_year, p_format);

}

function Calendar(p_month, p_year, p_format) {
	if ((p_month == null) && (p_year == null))	return;

	if (p_month == null) {
		this.gMonthName = null;
		this.gMonth = null;
		this.gYearly = true;
	} else {
		this.gMonthName = Calendar.get_month(p_month);
		this.gMonth = new Number(p_month);
		this.gYearly = false;
	}

	this.gYear = p_year;
	this.gFormat = p_format;
}

Calendar.get_month = Calendar_get_month;
Calendar.get_daysofmonth = Calendar_get_daysofmonth;
Calendar.calc_month_year = Calendar_calc_month_year;

function Calendar_get_month(monthNo) {
	return Calendar.Months[monthNo];
}

function Calendar_get_daysofmonth(monthNo, p_year) {
	/* 
	Check for leap year ..
	1.Years evenly divisible by four are normally leap years, except for... 
	2.Years also evenly divisible by 100 are not leap years, except for... 
	3.Years also evenly divisible by 400 are leap years. 
	*/
	if ((p_year % 4) == 0) {
		if ((p_year % 100) == 0 && (p_year % 400) != 0)
			return Calendar.DOMonth[monthNo];
	
		return Calendar.lDOMonth[monthNo];
	} else
		return Calendar.DOMonth[monthNo];
}

function Calendar_calc_month_year(p_Month, p_Year, incr) {
	/* 
	Will return an 1-D array with 1st element being the calculated month 
	and second being the calculated year 
	after applying the month increment/decrement as specified by 'incr' parameter.
	'incr' will normally have 1/-1 to navigate thru the months.
	*/
	var ret_arr = new Array();
	
	if (incr == -1) {
		// B A C K W A R D
		if (p_Month == 0) {
			ret_arr[0] = 11;
			ret_arr[1] = parseInt(p_Year) - 1;
		}
		else {
			ret_arr[0] = parseInt(p_Month) - 1;
			ret_arr[1] = parseInt(p_Year);
		}
	} else if (incr == 1) {
		// F O R W A R D
		if (p_Month == 11) {
			ret_arr[0] = 0;
			ret_arr[1] = parseInt(p_Year) + 1;
		}
		else {
			ret_arr[0] = parseInt(p_Month) + 1;
			ret_arr[1] = parseInt(p_Year);
		}
	}
	
	return ret_arr;
}

// This is for compatibility with Navigator 3, we have to create and discard one object before the prototype object exists.
new Calendar();

Calendar.prototype.getMonthlyCalendarCode = function() {
	var vCode = "";
	var vHeader_Code = "";
	var vData_Code = "";
	
	// Begin Table Drawing code here..
	vCode += ("<div align=center><TABLE width='100%' BGCOLOR='#999999' cellpadding=2 cellspacing=1>");
	
	vHeader_Code = this.cal_header();
	vData_Code = this.cal_data();
	vCode += (vHeader_Code + vData_Code);
	
	vCode += "</TABLE></div>";
	
	return vCode;
}

Calendar.prototype.show = function() {
	var vCode = "";
	
	// Show navigation buttons
	var prevMMYYYY = Calendar.calc_month_year(this.gMonth, this.gYear, -1);
	var prevMM = prevMMYYYY[0];
	var prevYYYY = prevMMYYYY[1];

	var nextMMYYYY = Calendar.calc_month_year(this.gMonth, this.gYear, 1);
	var nextMM = nextMMYYYY[0];
	var nextYYYY = nextMMYYYY[1];
	
	// Begin the main table
	theCalendarContent += ("<TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0>");

	// Add the title and close button
	theCalendarContent += ("<TR><TD><TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 width='100%' background='bgrdwindowtitle.gif'>");
	theCalendarContent += ("<TR><TD align=right>");
	theCalendarContent += ("<a href='#' onClick=\"MM_showHideLayers('CalendarMonths','','hide')\">");
	theCalendarContent += ("<img src='buttonwindowclosesmall.gif' border='0'></TD></TR>");
	theCalendarContent += ("</TABLE></TD></TR>");

	// Add the rest of the calendar
	theCalendarContent += ("<TR><TD><TABLE WIDTH='100%' BORDER=0 CELLSPACING=0 CELLPADDING=2 background='bgrdmenus.gif'><TR><TD>");
	theCalendarContent += "<TH width='50%' align='right' class='GeneralText'>" + this.gMonthName +
		"</TH><TD><table border=0 cellspacing=0 cellpadding=0 class='FormButtonsSmall' onMouseover=\"this.className='FormButtonsSmallOver'\" onMouseout=\"this.className='FormButtonsSmall'\" onClick=\"this.className='FormButtonsSmallClicked'\"><TR><TD>";
	theCalendarContent += ("<A title=\"Back one month\" HREF=\"javascript:void(0);\" " +
		"onClick=\"Build('" + prevMM + "', '" + prevYYYY + "', '" + this.gFormat + "'" +
		");" +
		"\"><IMG SRC='iconleft.gif' border=0><\/A></TD></TR></TABLE></TD>" +
		"<TD><table border=0 cellspacing=0 cellpadding=0 class='FormButtonsSmall' onMouseover=\"this.className='FormButtonsSmallOver'\" onMouseout=\"this.className='FormButtonsSmall'\" onClick=\"this.className='FormButtonsSmallClicked'\"><TR><TD>");
	theCalendarContent += ("<A title=\"Forward one month\" HREF=\"javascript:void(0);\" " +
		"onClick=\"Build('" + nextMM + "', '" + nextYYYY + "', '" + this.gFormat + "'" +
		");" +
		"\"><IMG SRC='iconright.gif' border=0><\/A></TD></TR></TABLE></TD>");
	theCalendarContent += "<TH width='50%' align='right' class='GeneralText'>" + this.gYear +
		"</TH><TD><table border=0 cellspacing=0 cellpadding=0 class='FormButtonsSmall' onMouseover=\"this.className='FormButtonsSmallOver'\" onMouseout=\"this.className='FormButtonsSmall'\" onClick=\"this.className='FormButtonsSmallClicked'\"><TR><TD>";
	theCalendarContent += ("<A title=\"Back one year\" HREF=\"javascript:void(0);\" " +
		"onClick=\"Build('" + this.gMonth + "', '" + (parseInt(this.gYear)-1) + "', '" + this.gFormat + "'" +
		");" +
		"\"><IMG SRC='iconleft.gif' border=0><\/A></TD></TR></TABLE></TD>" +
		"<TD><table border=0 cellspacing=0 cellpadding=0 class='FormButtonsSmall' onMouseover=\"this.className='FormButtonsSmallOver'\" onMouseout=\"this.className='FormButtonsSmall'\" onClick=\"this.className='FormButtonsSmallClicked'\"><TR><TD>");
	theCalendarContent += ("<A title=\"Forward one year\" HREF=\"javascript:void(0);\" " +
		"onClick=\"Build('" + this.gMonth + "', '" + (parseInt(this.gYear)+1) + "', '" + this.gFormat + "'" +
		");" +
		"\"><IMG SRC='iconright.gif' border=0><\/A></TD></TR></TABLE></TD></TR></TABLE>");

	// Get the complete calendar code for the month, and add it to the
	//	content var
	vCode = this.getMonthlyCalendarCode();
	theCalendarContent += vCode;
	theCalendarContent += ("</TD></TR></TABLE>");
}


Calendar.prototype.cal_header = function() {
	var vCode = "";
	
	vCode = vCode + "<TR class='EventFree'>";
	vCode = vCode + "<TH width='14%'>Sun</TH>";
	vCode = vCode + "<TH width='14%'>Mon</TH>";
	vCode = vCode + "<TH width='14%'>Tue</TH>";
	vCode = vCode + "<TH width='14%'>Wed</TH>";
	vCode = vCode + "<TH width='14%'>Thu</TH>";
	vCode = vCode + "<TH width='16%'>Fri</TH>";
	vCode = vCode + "<TH width='14%'>Sat</TH>";
	vCode = vCode + "</TR>";
	
	return vCode;
}

Calendar.prototype.cal_data = function() {
	var vDate = new Date();
	vDate.setDate(1);
	vDate.setMonth(this.gMonth);
	vDate.setFullYear(this.gYear);

	var vFirstDay=vDate.getDay();
	var vDay=1;
	var vLastDay=Calendar.get_daysofmonth(this.gMonth, this.gYear);
	var vOnLastDay=0;
	var vCode = "";
	
	var EpochDate = new Date();
	EpochDate.setHours(0);
	EpochDate.setMinutes(0);
	EpochDate.setSeconds(0);

	/*
	Get day for the 1st of the requested month/year..
	Place as many blank cells before the 1st day of the month as necessary. 
	*/
	vCode = vCode + "<TR>";
	for (i=0; i<vFirstDay; i++) {
		vCode = vCode + "<TD bgcolor='#FFFFFF'" + this.write_weekend_string(i) + " class='GeneralText'>&nbsp;</TD>";
	}

	// Write rest of the 1st week
	for (j=vFirstDay; j<7; j++) {
		EpochDate.setYear(this.gYear);
		EpochDate.setMonth(this.gMonth);
		EpochDate.setDate(vDay);
		var EpochTime = Math.round((EpochDate.getTime() / 86400) / 1000);

		vCode = vCode + "<TD bgcolor='#FFFFFF'" + this.write_weekend_string(j) + " align='center' class='GeneralText' nowrap>" + 
				"<A HREF='calendar.wssp?Mailbox="+
				CGPmailbox +
				"\&JumpDay=" + EpochTime + "' target=\"MainView\" " + 
				"onMouseover=\"this.style.fontWeight='bold';\" " + 
				"onMouseout=\"this.style.fontWeight='normal';\">" +
				this.format_day(vDay) + 
				"</A></TD>";
		vDay=vDay + 1;
	}
	vCode = vCode + "</TR>";

	// Write the rest of the weeks
	for (k=2; k<7; k++) {
		vCode = vCode + "<TR>";

		for (j=0; j<7; j++) {
			EpochDate.setYear(this.gYear);
			EpochDate.setMonth(this.gMonth);
			EpochDate.setDate(vDay);		
			var EpochTime = Math.round((EpochDate.getTime() / 86400) / 1000);

			vCode = vCode + "<TD bgcolor='#FFFFFF'" + this.write_weekend_string(j) + " align='center' class='GeneralText' nowrap>" + 
				"<A HREF='calendar.wssp?Mailbox="+
				CGPmailbox +
				"\&JumpDay=" + EpochTime + "' target=\"MainView\" " + 
				"onMouseover=\"this.style.fontWeight='bold';\" " + 
				"onMouseout=\"this.style.fontWeight='normal';\">" +
				this.format_day(vDay) + 
				"</A></TD>";
			vDay=vDay + 1;

			if (vDay > vLastDay) {
				vOnLastDay = 1;
				break;
			}
		}

		if (j == 6)
			vCode = vCode + "</TR>";
		if (vOnLastDay == 1)
			break;
	}
	
	// Fill up the rest of last week with proper blanks, so that we get proper square blocks
	for (m=1; m<(7-j); m++) {
			vCode = vCode + "<TD bgcolor='#FFFFFF'" + this.write_weekend_string(j+m) + 
			" class='GeneralText' align='center'><FONT COLOR='gray'>" + m + "</FONT></TD>";
	}
	
	return vCode;
}

Calendar.prototype.format_day = function(vday) {
	var vNowDay = gNow.getDate();
	var vNowMonth = gNow.getMonth();
	var vNowYear = gNow.getFullYear();

	if (vday == vNowDay && this.gMonth == vNowMonth && this.gYear == vNowYear)
		return ("<FONT COLOR=\"RED\"><B>" + vday + "</B></FONT>");
	else
		return (vday);
}

Calendar.prototype.write_weekend_string = function(vday) {
	var i;

	// Return special formatting for the weekend day.
	for (i=0; i<weekend.length; i++) {
		if (vday == weekend[i])
			return (" style=\"background-color:" + weekendColor + "\"");
	}
	
	return "";
}

Calendar.prototype.format_data = function(p_day) {
	var vData;
	var vMonth = 1 + this.gMonth;
	vMonth = (vMonth.toString().length < 2) ? "0" + vMonth : vMonth;
	var vMon = Calendar.get_month(this.gMonth).substr(0,3).toUpperCase();
	var vFMon = Calendar.get_month(this.gMonth).toUpperCase();
	var vY4 = new String(this.gYear);
	var vY2 = new String(this.gYear.substr(2,2));
	var vDD = (p_day.toString().length < 2) ? "0" + p_day : p_day;

	return vData;
}

function Build(p_month, p_year, p_format) {
	theCalendar = new Calendar(p_month, p_year, p_format);	

	// initialize the content string
	theCalendarContent = ""; //Left empty by default

	// Choose appropriate show function
	theCalendar.show();

	// Begin Table Drawing code here..
	writeToLayer('CalendarMonths',theCalendarContent);

}
