// Utils
function createRequest() {
       http_request = false;
       if (window.XMLHttpRequest) { // Mozilla, Safari,...
          http_request = new XMLHttpRequest();
          if (http_request.overrideMimeType) {
               http_request.overrideMimeType('text/xml');
          }
        } else if (window.ActiveXObject) { // IE
          try{
             http_request = new ActiveXObject("WinHTTP.WinHTTPRequest.5.1");
          }catch(e){
             try{
                http_request = new ActiveXObject("MSXML2.ServerXMLHTTP.4.0");
             }catch(e){
                try{
                   http_request = new ActiveXObject("Msxml2.XMLHTTP");
                }catch(e){
                   try{
                      http_request = new ActiveXObject("Microsoft.XMLHTTP");
                   }catch(e){
                         // :( 
                   }
                }
             }
          }
        }
    return http_request;
}
documentImportData = null;
function importDocument(data) {
    if (documentImportData == null) {
        documentImportData = document.createElement("DIV");
    }
    if (data) {
        documentImportData.innerHTML = data;
        return documentImportData.firstChild;
    } else return null;
}

function sendRequest(URI, readyFunc) {
    var request = createRequest();
    if (request != null) {
        try {
            request.open('GET', URI);
        }catch(err){};
        request.onreadystatechange = function() {
            if (request) {
                try {
                    if (request.readyState == 4 && request.status == 200) {
                        if (request.responseText != null) {
                            var txt = request.responseText;
                            if (readyFunc)
                                setTimeout(function() {readyFunc(txt);}, 50);
                        } else {
                            alert('The connection to the remote server was lost. The page may fail to work correctly. Reloading the page may fix the problem.');
                        }
                    } else if (request.readyState == 4 && request.status == 404 ) {
                        if (readyFunc)
                            readyFunc(null, 404);
                    } else if (request.readyState == 4 && request.status == 500 ) {
                        if (readyFunc)
                            readyFunc(null, 500);
                    } else if (request.readyState == 4 && request.status == 405 ) {
                        if (readyFunc)
                            readyFunc(null, 500);
                    }
                }catch(err){
                };
            }
        }
        request.send(null);
    }
}

function sendPostRequest(requestURI, readyFunc, formData, mode) {
    var request = createRequest();
    if (request != null) {
        request.open('post', requestURI);
        request.onreadystatechange = function() {
            if (request) {
                if (request.readyState == 4 && request.status == 200 ) {
                    if (request.responseText != null) {
                        if(mode=="XML"){ txt = request.responseXML; }
                        else{ txt = request.responseText; }
                        if (readyFunc) {
                            setTimeout(function() {readyFunc(txt);}, 50);
                        }
                    } else {
                        alert('The connection to the remote server was lost. The page may fail to work correctly. Reloading the page may fix the problem.');
                    }
                } else if (request.readyState == 4 && request.status == 404 ) {
                    if (readyFunc) 
                        readyFunc(null, 404);
                } else if (request.readyState == 4 && request.status == 500 ) {
                    if (readyFunc) 
                        readyFunc(null, 500);
                } else if (request.readyState == 4 && request.status == 405 ) {
                    if (readyFunc)
                        readyFunc(null, 500);
                }

            }
        }
        var boundary = "---------------------------12345678";
        request.setRequestHeader("Content-type", "multipart/form-data; boundary="+boundary);
        boundary = "--" + boundary;
        var requestContent = "";
        for(var key in formData) {
            var values = formData[key];
            //alert(formData[key]+": "+typeof(values))
            if (typeof(values) == "string" || typeof(values) == "number") {
                requestContent += boundary;
                requestContent += "\r\n";
                requestContent += 'Content-Disposition: form-data; name="';
                requestContent += key;
                requestContent += '"\r\n\r\n'
                requestContent += values;
                requestContent += "\r\n";
            } else if(typeof(values) == "object") {
                if (values.getType && values.getType() == "file") {
                    var fName = values.getFileName();
                    var fData = values.getFileData();
                    var fMIME = values.getFileMIME();
                    requestContent += boundary;
                    requestContent += "\r\n";
                    requestContent += 'Content-Disposition: form-data; name="Upload"; filename="'+fName+'"';
                    requestContent += "\r\n";
                    requestContent += "Content-Type: "+fMIME;
                    requestContent += '"\r\n\r\n'
                    requestContent += fData;
                    requestContent += "\r\n\r\n";
                } else {
	                for (var j = 0; j < values.length; j++) {
	                    requestContent += boundary;
	                    requestContent += "\r\n";
	                    requestContent += 'Content-Disposition: form-data; name="';
	                    requestContent += key;
	                    requestContent += '"\r\n\r\n'
	                    requestContent += values[j];
	                    requestContent += "\r\n";
	                }
		}
            }
        }

        requestContent += boundary;
        requestContent += "--";
        //alert(requestContent);
        request.send(requestContent);
    }
}

            function sendForm(URI, form, afterHandler) {
                var formData = new Array();
                for (var i=0; i<form.elements.length; i++) {
                    var el = form.elements[i];
                    if(el.name&&el.disabled!=true) {
                        if (el.type == "checkbox") {
                            if(el.checked){
                                formData[el.name] = [el.value];
                            }
                        }else if (el.type == "radio") {
                            if(el.checked){
                                formData[el.name] = [el.value];
                            }
                        } else if (el.type != "button" && el.type != "submit" && el.type != "image" && el.type != "select-multiple") {
                                if(formData[el.name]) {
                                    var m=formData[el.name];
                                    m[m.length]=""+el.value;
                                }
                                else {
                                    formData[el.name] = [el.value];
                                }
                        } else if (el.type == "select-multiple") {
                            var selectValues = new Array();
                            for (var v = 0; v < el.options.length; v++) {
                                if (el.options[v].selected) {
                                    selectValues[selectValues.length] = el.options[v].value;
                                }
                            }
                            formData[el.name] = selectValues;
                        }
                    }
                }
                var request = createRequest();
                sendPostRequest(URI, function(text) {
                    var errors_form = null;
                    var errors_field = null;
                    if (text != null) {
                        if(afterHandler) afterHandler(form, text);
                    }
                }, formData);
            }
