/* Connects to server and downloads a file using byte ranges. */
/* This program is intended to be used for testing. */

#define USEWIN32

#ifdef USEWIN32
	#include <winsock2.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <mem.h>

#ifndef SHUT_WR
	#define SHUT_WR 1
#endif

int ConnectToServer(char *ip, int port);
int CloseConnection(int sd);

#ifdef USEWIN32
int InitWinsock(void) {
	WORD wVersionRequested = MAKEWORD(1,1);
   WSADATA wsaData;

	if (WSAStartup(wVersionRequested, &wsaData) != 0) {
      puts("ERROR - Could not Initialize Winsock.");
      return -1;
   }
   return 0;
}
#endif

/* Closes connection sd. Returns 0 on success or -1 on failure. */
int CloseConnection(int sd) {
	int nNewBytes;
   char buf[256];

   if( shutdown(sd, SHUT_WR) < 0 ) {
   	/* shutdown failed. */
      /* Ignore this as we must free the resources associated with sd. */
   }

   while( 1 ) {
   	nNewBytes = recv(sd, buf, sizeof(buf), 0);
      if( nNewBytes < 0 ) { break; } /* Connection reset by peer. */
      else if( nNewBytes != 0 ) {} /* Unexpected bytes during shutdown. */
      else { break; }
   }

   #ifdef USEWIN32
   if(closesocket(sd) < 0) { return -1; } /* Closing connection failed */
   #endif
   #ifdef USEOS2
   if(soclose(sd) < 0) { return -1; } /* Closing connection failed */
   #endif
   #ifdef USEUNIX
   if(close(sd) < 0) { return -1; } /* Closing connection failed */
   #endif

   return 0;
}

int InputString(char *string, int len) {
   int i;

   fflush(stdin);
	if( fgets(string, len, stdin) == NULL ) { return -1; }
   else {
   	for(i=0;i<len;i++) {
      	if ( string[i] == '\n' ) {
            string[i] = '\0';
            break;
      	}
      }
   }
   return 0;
}


int main(void) {
   char ip[16], Method[16], ByteRange[32], FileName[64], ServerPort[6];
   int sd;
   char buf[512];
   char *ptr;
   int retval;

   strcpy(ip, "127.0.0.1");

   while(1) {
   	printf("Enter server IP address or q to quit program.\n: ");
   	if( InputString(ip, sizeof(ip)) == -1 ) { break; }

   	if( strcmp(ip, "q") == 0 ) { break; }

   	printf("Enter server port.\n: ");
   	if( InputString(ServerPort, sizeof(ServerPort)) == -1 ) { break; }

      printf("Enter HTTP Method.\n: ");
   	if( InputString(Method, sizeof(Method)) == -1 ) { break; }

      printf("Enter byte range field or x to skip.\n: ");
   	if( InputString(ByteRange, sizeof(ByteRange)) == -1 ) { break; }

      printf("Enter file name.\n: ");
   	if( InputString(FileName, sizeof(FileName)) == -1 ) { break; }

      if( strcmp(ByteRange, "x") == 0 ) {
      	sprintf(buf, "%s /%s HTTP/1.0\r\n\r\n", Method, FileName);
		}
      else {
      	sprintf(buf, "%s /%s HTTP/1.0\r\nRange: bytes=%s\r\n\r\n", Method, FileName, ByteRange);
      }

   	if( InitWinsock() == 0 ) {
   		if( (sd = ConnectToServer(ip, atoi(ServerPort))) > 0 ) {
      		puts("Connected to server.");
            send(sd, buf, strlen(buf), 0);
            retval = 1;
            while( retval > 0 ) {
            	memset(buf, 0, sizeof(buf));
               retval = recv(sd, buf, sizeof(buf) - 1, 0);
               if( retval == 0 ) {
               	puts("\nConnection closed by server.");
                  break;
               }
               else if( retval < 0 ) {
               	puts("Error on socket.");
                  break;
               }
               else {
               	printf("%s", buf);
                  break;
               }
            }
            CloseConnection(sd);
            /*
            ptr = strstr(buf, "\r\n\r\n");
            if( ptr != NULL ) {
            	*ptr = '\0';
               puts(buf);
            }
            */
      	}
   	}
   }

   #ifdef USEWIN32
   WSACleanup();
   #endif
   return 0;
}


int ConnectToServer(char *ip, int port) {
  	struct sockaddr_in serv;
   int retval;
   fd_set writefds;
   struct timeval timeout;
   unsigned long nNoBlock = 1;
   int sd;

  	/* Creating socket */
  	sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  	if( sd == -1 ) {
    	puts("Creating socket failed.");
    	return -1;
  	}

   ioctlsocket(sd, FIONBIO, &nNoBlock);

  	/* fill-in address information */
  	serv.sin_family = AF_INET;
  	serv.sin_port = htons((short)port);
  	serv.sin_addr.s_addr = inet_addr(ip);

   /* connect to the server */
   connect(sd, (LPSOCKADDR)&serv, sizeof(struct sockaddr));

   FD_ZERO(&writefds);
   FD_SET((unsigned int)sd, &writefds);

   puts("5 s timeout-time set.");
   timeout.tv_sec = 5;
   timeout.tv_usec = 0;
      
   retval = select(sd, 0, &writefds, 0, &timeout);
   if( retval > 0 ) {
   	if( FD_ISSET(sd, &writefds) ) {
      	CloseConnection(sd);

  			/* Creating socket */
  			sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  			if( sd == -1 ) {
    			puts("Creating socket failed.");
    			return -1;
  			}

  			/* fill-in address information */
  			serv.sin_family = AF_INET;
  			serv.sin_port = htons((short)port);
  			serv.sin_addr.s_addr = inet_addr(ip);

   		/* connect to the server */
   		if( connect(sd, (LPSOCKADDR)&serv, sizeof(struct sockaddr)) != 0 ) {
         	puts("Connect failed.");
            return -1;
         }
      }
   }
   else if( retval == 0 ) {
   	puts("Timeout expired.");
      return -1;
   }
   else {
      puts("Select failed.");
   	return -1;
   }

   return sd;
}


