struct connection *rw_connection (struct connection *c, struct in_addr him,
                   struct in_addr *client_net, struct in_addr *client_mask) {

  struct connection *d = clone_thing(*c, "temporary connection");
  struct routeinfo *route;

  d->rw_state = rwcs_instance;
  d->parent = c;
  clonetochunk(d->this.id, c->this.id.ptr, c->this.id.len, "left end rwid");
  clonetochunk(d->that.id, c->that.id.ptr, c->that.id.len, "right end rwid");

  passert(oriented(*d));
  d->that.host = him;
  if (client_net && d->that.client_net.s_addr == 0x0
      && d->that.client_mask.s_addr == 0xFFFFFFFF) {
    d->that.client_net = *client_net;
    d->that.client_mask = *client_mask;
    d->that.has_client = TRUE;
  }

  route = find_route(d->that.host);
  if (route  &&  route->gateway.s_addr != 0)
    default_end(&d->this, route->gateway);
  else
    default_end(&d->this, d->that.host);

  /* set internal fields */
  d->next = connections;
  connections = d;
  d->routed = FALSE;
  d->newest_isakmp_sa = SOS_NOBODY;
  d->newest_ipsec_sa = SOS_NOBODY;
  d->eroute_owner = SOS_NOBODY;

  return d;
}
