int is_subnet (unsigned long netb, unsigned long maskb,
               unsigned long nets, unsigned long masks) {

/*
  char s1[32];
  char s2[32];
  char s3[32];
  char s4[32];
  struct in_addr t1, t2, t3, t4;

  t1.s_addr = netb;
  t2.s_addr = maskb;
  t3.s_addr = nets;
  t4.s_addr = masks;

  strcpy (s1, inet_ntoa (t1));
  strcpy (s2, inet_ntoa (t2));
  strcpy (s3, inet_ntoa (t3));
  strcpy (s4, inet_ntoa (t4));
  syslog (1, "big   = %s/%s\nsmall = %s/%s", s1, s2, s3, s4);
*/
  if (masks < maskb)
    return 0;

  if (masks == inet_addr ("255.255.255.255"))
    return 1;  // we allow road-warriors without subnet

  if ((netb & maskb) == (nets & maskb))
    return 1;

  return 0;
}


/* given a connection suitable for ISAKMP (i.e. the hosts match)
 * find a one suitable for IPSEC (i.e. with matching clients).
 */
struct connection *
find_client_connection(

    struct connection *c,
/* aggr-patch */
    int peer_idtype, chunk_t peeridentity,
//
    struct in_addr our_net, struct in_addr our_mask,
    struct in_addr peer_net, struct in_addr peer_mask)


{
    struct connection
	*d,
	*unrouted = NULL;

    /* give priority to current connection
     * but even greater priority to a routed connection
     */

    if (c->this.client_net.s_addr == our_net.s_addr
    && c->this.client_mask.s_addr == our_mask.s_addr
    && c->that.client_net.s_addr == peer_net.s_addr
    && c->that.client_mask.s_addr == peer_mask.s_addr)
    {
	passert(oriented(*c));
	if (c->routed)
	    return c;
	unrouted = c;
    }

    for (d = connections; d != NULL; d = d->next)
    {
	if (d->this.host.s_addr == c->this.host.s_addr
	|| d->that.host.s_addr == c->this.host.s_addr)
	{
/*
  char s1[32];
  char s2[32];
  char s3[32];
  char s4[32];
  struct in_addr t1, t2, t3, t4;

  t1.s_addr = d->this.client_net.s_addr;
  t2.s_addr = d->this.client_mask.s_addr;
  t3.s_addr = our_net.s_addr;
  t4.s_addr = our_mask.s_addr;

  strcpy (s1, inet_ntoa (t1));
  strcpy (s2, inet_ntoa (t2));
  strcpy (s3, inet_ntoa (t3));
  strcpy (s4, inet_ntoa (t4));
  syslog (1, "this = %s/%s\nour = %s/%s", s1, s2, s3, s4);
*/

	    if (!oriented(*d))
		(void)orient(d, FALSE);


	    /* check this.host last -- it is almost certainly us */
	    if (d->that.host.s_addr == c->that.host.s_addr
/*
the check below is replaced to this one to allow road-warriors to have own
subnets behind them. all subnets must be in the area of common subnet defined
on server side. dev@fx.dk 09/10/99
*/
            && is_subnet (our_net.s_addr, our_mask.s_addr, d->this.client_net.s_addr,
               d->this.client_mask.s_addr)

//            && d->this.client_net.s_addr == our_net.s_addr
//            && d->this.client_mask.s_addr == our_mask.s_addr
            && is_subnet (d->that.client_net.s_addr,
               d->that.client_mask.s_addr, peer_net.s_addr, peer_mask.s_addr)

/* this check is removed (see above) dev@fx.dk 09/10/99
	    && d->this.client_net.s_addr == our_net.s_addr
	    && d->this.client_mask.s_addr == our_mask.s_addr
	    && d->that.client_net.s_addr == peer_net.s_addr
	    && d->that.client_mask.s_addr == peer_mask.s_addr
vp */
	    && d->this.host.s_addr == c->this.host.s_addr
	    && (!no_klips || d->this.host_port == pluto_port))
	    {
/* dev@fx.dk */
		d->that.s_client_net.s_addr = peer_net.s_addr;
		d->that.s_client_mask.s_addr = peer_mask.s_addr;

/* dev@fx.dk */
		if (d->routed)
		    return d;
		if (unrouted == NULL)
		    unrouted = d;
	    }
	}
    }

    return unrouted;
}
