/* misc. universal things
 * Copyright (C) 1997 Angelos D. Keromytis.
 * Copyright (C) 1998, 1999  D. Hugh Redelmeier.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: defs.h,v 1.1 2000/11/18 00:30:20 bj Exp $
 */

/* GCC magic! */
#ifdef GCC_LINT
# define PRINTF_LIKE(n) __attribute__ ((format(printf, n, n+1)))
# define NEVER_RETURNS __attribute__ ((noreturn))
# define UNUSED __attribute__ ((unused))
# define BLANK_FORMAT " "	/* GCC_LINT whines about empty formats */
#else
# define PRINTF_LIKE(n)	/* ignore */
# define NEVER_RETURNS /* ignore */
# define UNUSED /* ignore */
# define BLANK_FORMAT ""
#endif

/* our version of assert: log result */
#define passert(pred) { if (!(pred)) passert_fail(#pred, __FILE__, __LINE__); }
extern void passert_fail(const char *pred_str
    , const char *file_str, unsigned long line_no) NEVER_RETURNS;

/* type of serial number of a state object
 * Needed in connections.h and state.h; here to simplify dependencies.
 */
typedef unsigned long so_serial_t;
#define SOS_NOBODY  0	/* null serial number */


/* memory allocation */

extern void *alloc_bytes(size_t size, const char *name);
#define alloc_thing(thing, name) (alloc_bytes(sizeof(thing), (name)))

extern void *clone_bytes(const void *orig, size_t size, const char *name);
#define clone_thing(orig, name) clone_bytes((void *)&(orig), sizeof(orig), (name))

#ifdef LEAK_DETECTIVE
  extern void pfree(void *ptr);
  extern void report_leaks(void);
#else
# define pfree(ptr) free(ptr)	/* ordinary stdc free */
#endif
#define pfreeany(p) { if ((p) != NULL) pfree(p); }
#define replace(p, q) { pfreeany(p); (p) = (q); }


/* chunk is a simple pointer-and-size abstraction */

struct chunk {
    size_t len;
    u_char *ptr;
    };
typedef struct chunk chunk_t;

/* aggr-patch */
#define chunksequal(ch1, ch2) \
    ((ch1).len == (ch2).len  &&  memcmp((ch1).ptr, (ch2).ptr, (ch1).len) == 0)
//
#define setchunk(ch, addr, size) { (ch).ptr = (addr); (ch).len = (size); }
/* NOTE: freeanychunk, unlike pfreeany, NULLs .ptr */
#define freeanychunk(ch) { pfreeany((ch).ptr); (ch).ptr = NULL; }
#define clonetochunk(ch, addr, size, name) \
    { (ch).ptr = clone_bytes((addr), (ch).len = (size), name); }
#define clonereplacechunk(ch, addr, size, name) \
    { pfreeany((ch).ptr); clonetochunk(ch, addr, size, name); }


/* make a struct sockaddr_in */

#define mksin(/*struct sockaddr_in*/ sin, /*in_addr_t*/ addr, /*u_int16_t*/ port) { \
	memset(&(sin), '\0', sizeof(sin)); \
	(sin).sin_family = AF_INET; \
	(sin).sin_addr.s_addr = (addr); \
	(sin).sin_port = htons(port); \
    }


/* cleanly exit Pluto */

extern void exit_pluto(int /*status*/) NEVER_RETURNS;
