#define AD(x) x, elemsof(x) /* Array Description */

/**************** IPsec (quick mode) SA database ****************/


/* arrays of transforms, each in in preference order */

static struct db_trans espa_trans_tunnel3[] = {
    { ESP_DES, AD(espmd5_attr_tunnel) },
    { ESP_DES, AD(espsha1_attr_tunnel) },
    { ESP_3DES, AD(espmd5_attr_tunnel) },
    { ESP_3DES, AD(espsha1_attr_tunnel) },
    };

static struct db_trans espa_trans_transport3[] = {
    { ESP_DES, AD(espmd5_attr_transport) },
    { ESP_DES, AD(espsha1_attr_transport) },
    { ESP_3DES, AD(espmd5_attr_transport) },
    { ESP_3DES, AD(espsha1_attr_transport) },
    };

static struct db_trans esp_trans_tunnel3[] = {
    { ESP_DES, AD(esp_attr_tunnel) },
    { ESP_3DES, AD(esp_attr_tunnel) },
    };

static struct db_trans esp_trans_transport3[] = {
    { ESP_DES, AD(esp_attr_transport) },
    { ESP_3DES, AD(esp_attr_transport) },
    };

#ifdef SUPPORT_ESP_NULL
static struct db_trans espnull_trans_tunnel3[] = {
    { ESP_NULL, AD(espmd5_attr_tunnel) },
    { ESP_NULL, AD(espsha1_attr_tunnel) },
    };

static struct db_trans espnull_trans_transport3[] = {
    { ESP_NULL, AD(espmd5_attr_transport) },
    { ESP_NULL, AD(espsha1_attr_transport) },
    };
#endif

static struct db_trans ah_trans_tunnel3[] = {
    { AH_MD5, AD(ah_HMAC_MD5_attr_tunnel) },
    { AH_MD5, AD(ah_HMAC_SHA1_attr_tunnel) },
    };

static struct db_trans ah_trans_transport3[] = {
    { AH_MD5, AD(ah_HMAC_MD5_attr_transport) },
    { AH_MD5, AD(ah_HMAC_SHA1_attr_transport) },
    };

//
static struct db_prop ah_pc_tunnel3[] = {
    { PROTO_IPSEC_AH, AD(ah_trans_tunnel3) },
    };

static struct db_prop ah_pc_transport3[] = {
    { PROTO_IPSEC_AH, AD(ah_trans_transport3) },
    };

#ifdef SUPPORT_ESP_NULL
static struct db_prop espnull_pc_tunnel3[] = {
    { PROTO_IPSEC_ESP, AD(espnull_trans_tunnel3) },
    };

static struct db_prop espnull_pc_transport3[] = {
    { PROTO_IPSEC_ESP, AD(espnull_trans_transport3) },
    };
#endif

static struct db_prop esp_pc_tunnel3[] = {
    { PROTO_IPSEC_ESP, AD(espa_trans_tunnel3) },
    };

static struct db_prop esp_pc_transport3[] = {
    { PROTO_IPSEC_ESP, AD(espa_trans_transport3) },
    };

static struct db_prop ah_esp_pc_tunnel3[] = {
    { PROTO_IPSEC_AH, AD(ah_trans_tunnel3) },
    { PROTO_IPSEC_ESP, AD(esp_trans_tunnel3) },
    };

static struct db_prop ah_esp_pc_transport3[] = {
    { PROTO_IPSEC_AH, AD(ah_trans_transport3) },
    { PROTO_IPSEC_ESP, AD(esp_trans_transport3) },
    };


static struct db_prop_conj ah_tunnel_props3[] =
    { { AD(ah_pc_tunnel3) },
#ifdef SUPPORT_ESP_NULL
      { AD(espnull_pc_tunnel3) }
#endif
    };

static struct db_prop_conj ah_transport_props3[] =
    { { AD(ah_pc_transport3) },
#ifdef SUPPORT_ESP_NULL
      { AD(espnull_pc_transport3) }
#endif
    };

static struct db_prop_conj esp_tunnel_props3[] =
    { { AD(esp_pc_tunnel3) } };

static struct db_prop_conj esp_transport_props3[] =
    { { AD(esp_pc_transport3) } };

static struct db_prop_conj ah_esp_tunnel_props3[] =
    { { AD(ah_esp_pc_tunnel3) } };

static struct db_prop_conj ah_esp_transport_props3[] =
    { { AD(ah_esp_pc_transport3) } };

struct db_sa ipsec_sadb3[1 << 3] = {
    { NULL, 0 },
    { AD(esp_transport_props3) },
    { AD(ah_transport_props3) },
    { AD(ah_esp_transport_props3) },
    { NULL, 0 },
    { AD(esp_tunnel_props3) },
    { AD(ah_tunnel_props3) },
    { AD(ah_esp_tunnel_props3) },
    };
#undef AD

