#if	!defined(_LIB_H_INCLUDED_)
#define _LIB_H_INCLUDED_

#if defined(__OS2__)
    #undef  inline
    #define inline
    #define static  extern
#endif

#define IF_FREE(p)	{ if (p) free(p); p = NULL; }
#define IF_STRDUP(d, s)	{ if (d) free(d); d = strdup(s); }


#if     defined(OSF)
    /* DU don't want to sleep in poll when number of descriptors is 0 */
#define	my_msleep(msec)		usleep(msec*1000)
#elsif	defined(HAVE_POLL) && !defined(FREEBSD)
#define	my_msleep(msec)		poll(NULL, 0, msec)
#elsif	defined(FREEBSD)
#define	my_msleep(msec)				\
    {						\
	struct timeval	tv;			\
	int		rc;			\
    restart0:					\
	tv.tv_sec =  msec/1000 ;		\
	tv.tv_usec = (msec%1000)*1000 ;		\
	rc = select(1, NULL, NULL, NULL, &tv);	\
	if ( (rc < 0) && (ERRNO == EINTR) )	\
	    goto restart0;			\
    }
#else
#define	my_msleep(msec)				\
    {						\
	struct timeval	tv;			\
	tv.tv_sec =  msec/1000 ;		\
	tv.tv_usec = (msec%1000)*1000 ;		\
	select(1, NULL, NULL, NULL, &tv);	\
    }
#endif

#define	my_sleep(s)	my_msleep(s*1000)


#if	defined(HAVE_CTIME_R)
#if	defined(SOLARIS)
#define	CTIME_R(a, b, l)	ctime_r(a, b, l)
#else
#define	CTIME_R(a, b, l)	ctime_r(a, b)
#endif /* SOLARIS */
#else
#define	CTIME_R(a, b, l) \
    {								\
	struct	tm	tm;					\
	localtime_r(a, &tm);					\
	snprintf(b, l, "%s, %02d %s %d %02d:%02d:%02d\n",	\
		 days[tm.tm_wday], tm.tm_mday,			\
		 months[tm.tm_mon], tm.tm_year+1900,		\
		 tm.tm_hour, tm.tm_min, tm.tm_sec);		\
    }
#endif /* HAVE_CTIME_R */


#define	IS_SPACE(a)	isspace((unsigned)a)
#define	IS_DIGIT(a)	isdigit((unsigned)a)

#define	SPACES_CHARS	" \t\n\r"
#define	SKIP_SPACES(s)	s += strspn(s, SPACES_CHARS)

#define	STRERROR(err)	STRERROR_R(err, errbuf, sizeof(errbuf)-1)
#define	ERRBUF		char	errbuf[256]


inline	static	struct	buff *alloc_buff(int size);
inline	static	int	attach_av_pair_to_buff(char* attr, char *val, struct buff *buff);
inline	static	int	attach_data(char* src, int size, struct buff *buff);
inline	static	void	free_container(struct buff *buff);
inline	static	int	is_negative_status(int code);
inline	static	char	*my_inet_ntop(struct sockaddr_in *sa, char *inet_ntop_buf);
inline	static	int	store_in_chain(char *src, int size, struct mem_obj *obj);
inline  static  char    *attr_value(struct av *avp, char *attr);
inline  static  void    memcpy_to_lower(char *d, char *s, size_t size);
inline  static  int     add_av_pair(char *avtext, struct av **avp);

#if !defined(__OS2__) || defined(DECLARE_INLINES)


inline
static struct	buff *
alloc_buff(int size)
{
struct buff	*b;

    if ( size <= 0 ) return(NULL);
    if ( !(b = (struct buff *)calloc(1, sizeof(*b))) ) return(NULL);
    if ( !(b->data = (char *)malloc(size+2)) ) {
	free(b);
	return(NULL);
    }
    b->curr_size = size;
    b->used = 0;
    return(b);
}

inline
static int
attach_av_pair_to_buff(char* attr, char *val, struct buff *buff)
{
    if ( !attr || !val || !buff ) return(-1);

    if ( *attr != '\0' ) {
	attach_data(attr, strlen(attr), buff);
	attach_data(" ", 1, buff);
	attach_data(val, strlen(val), buff);
    }
    attach_data(CRLF, 2, buff);
    return(0);
}

/* concatenate data in continuous buffer */
inline
static int
attach_data(char* src, int size, struct buff *buff)
{
int	tot;

    if ( size <= 0 ) return(-1);

    if ( !buff->data ) {
	tot = ((size / CHUNK_SIZE) + 1) * CHUNK_SIZE;
	if ( !(buff->data = (char *)malloc(tot+2)) ) return(-1);
	memcpy(buff->data, src, size);
	buff->curr_size = tot;
	buff->used = size;
	return(0);
    }
    tot = buff->used + size;
    if ( tot <= buff->curr_size ) {
	memcpy(buff->data+buff->used, src, size);
	buff->used += size;
    } else {
	char	*t;
	tot = ((tot / CHUNK_SIZE) + 1) * CHUNK_SIZE;
	if ( !(t = (char *)malloc(tot+2)) ) {
	    my_xlog(OOPS_LOG_SEVERE, "attach_data(): No mem in attach data.\n");
	    return(-1);
	}
	memcpy(t, buff->data, buff->used);
	memcpy(t+buff->used, src, size);
	free(buff->data); buff->data = t;
	buff->used += size;
	buff->curr_size = tot;
    }
    return(0);
}

inline
static char *
attr_value(struct av *avp, char *attr)
{
char	*res = NULL;

    if ( !attr ) return(NULL);

    while( avp ) {
	if ( avp->attr && !strncasecmp(avp->attr, attr, strlen(attr)) ) {
	    res = avp->val;
	    break;
	}
	avp = avp->next;
    }
    return(res);
}

inline
static void
free_container(struct buff *buff)
{
struct buff *next;

    while(buff) {
	next = buff->next;
	/*my_xlog(OOPS_LOG_DBG, "free_container(): Free buffer: %d of %d, next: %p\n", buff->size, buff->curr_size, buff->next);*/
	IF_FREE(buff->data);
	free(buff);
	buff = next;
    }
}

inline
static int
is_negative_status(int code) {
    if ( code == STATUS_NOT_FOUND )
	return(TRUE);
    return(FALSE);
}
#endif // DECLARE_INLINES

#if defined(__OS2__)
#define INET_NTOP_BUF
inline static char *my_inet_ntoa(struct sockaddr_in *sa);

#if defined(DECLARE_INLINES)
inline
static char *
my_inet_ntoa(struct sockaddr_in *sa)
{
    return inet_ntoa(sa->sin_addr);
}
#endif // DECLARE_INLINES
#else  // __OS2__
#define	INET_NTOP_BUF	char	inet_ntop_buf[INET_ADDRSTRLEN]
#define	my_inet_ntoa(s)		my_inet_ntop(s, inet_ntop_buf)

inline
static char *
my_inet_ntop(struct sockaddr_in *sa, char *inet_ntop_buf)
{
    return (char *)inet_ntop(AF_INET, &sa->sin_addr, inet_ntop_buf, INET_ADDRSTRLEN);
}
#endif // __OS2__

#if !defined(__OS2__) || defined(DECLARE_INLINES)
/* store in hot_buff, allocate buffs if need*/
inline
static int
store_in_chain(char *src, int size, struct mem_obj *obj)
{
struct buff *hot = obj->hot_buff, *new;

    if (!hot) {
	my_xlog(OOPS_LOG_SEVERE, "store_in_chain(): hot == NULL!\n");
	return(-1);
    }
    if (!obj) {
	my_xlog(OOPS_LOG_SEVERE, "store_in_chain(): obj == NULL!\n");
	return(-1);
    }
    if ( size < 0 ) {
	my_xlog(OOPS_LOG_SEVERE, "store_in_chain(): size = %d!\n", size);
	return(-1);
    }
    if ( hot->used + size <= hot->curr_size ) {
	memcpy( hot->data + hot->used, src, size);
	hot->used += size;
    } else {
	int	moved, to_move;
	/* copy part */
	memcpy(hot->data + hot->used, src, hot->curr_size - hot->used);
	moved = hot->curr_size - hot->used;
	hot->used = hot->curr_size;
	to_move = size - moved;
	/* allocate  */
	if ( !(new = alloc_buff(ROUND_CHUNKS(to_move))) ) return(-1);
	/* copy rest */
	memcpy(new->data, src+moved, to_move);
	new->used = to_move;
	hot->next = new;
	obj->hot_buff = new;
    }
    return(0);
}

#endif  /* DECLARE_INLINES */

#define	LOCK_OBJ(o)	pthread_mutex_lock(&o->lock);
#define	UNLOCK_OBJ(o)	pthread_mutex_unlock(&o->lock);

#if !defined(__OS2__) || defined(DECLARE_INLINES)

inline
static int
add_av_pair(char *avtext, struct av **avp)
{
struct	av	*new, *next;
char		*sp = avtext, *attr, *val, holder;
char		*new_attr, *new_val;

    if ( *avtext == '\0' ) return(-1);

    SKIP_SPACES(sp); attr = sp;
    if ( !(sp = strpbrk(attr, SPACES_CHARS":")) ) goto errhdr;

    if ( *sp == ':' ) sp++;
    else
	if ( !IS_DIGIT(*(sp+1)) ) goto errhdr;

    holder = *sp; *sp = '\0';
    new_attr = strdup(attr);
    *sp = holder;

    val = sp;
    SKIP_SPACES(val);		/* if ( *val != '\0' ) return(-1); */
    new_val = strdup(val);

    if ( !(new_attr && new_val && (new = malloc(sizeof(*new)))) ) {
	my_xlog(OOPS_LOG_NOTICE|OOPS_LOG_DBG|OOPS_LOG_INFORM, "add_av_pair(): Can't memory allocation: %m\n");
	IF_FREE(new_attr);
	IF_FREE(new_val);
	return(-1);
    }

    new->attr = new_attr;
    new->val  = new_val;
    new->next = NULL;
    if ( !*avp ) {
	*avp = new;
    } else {
	next = *avp;
	while (next->next) next = next->next;
	next->next = new;
    }
    return(0);

errhdr:
    my_xlog(OOPS_LOG_NOTICE|OOPS_LOG_DBG|OOPS_LOG_INFORM, "add_av_pair(): Invalid header: '%s'\n", avtext);
    return(-1);
}

inline
static void
memcpy_to_lower(char *d, char *s, size_t size)
{
    if ( !s || !d || ((signed)size <= 0) ) return;
    while(size) {
	*d = tolower(*s);
	d++; s++; size--;
    }
}
#endif  /* DECLARE_INLINES */

#if defined(__OS2__)
    #undef  static
#endif

#endif	/* !_LIB_H_INCLUDED_ */
