/*
      rp_PreExit - on the preexit step catchs calls to the proxy 
 authorization engine. Used for receiving control finctions.
*/
#include "rproxy.h"


void HTTPD_LINKAGE rp_PreExit ( unsigned char *handle, long *rcode )
{
        unsigned char *pathTRANSLATED;
        unsigned char *querySTRING;
        unsigned char *remoteADDR;
        register unsigned char *p;


*rcode = HTTP_NOACTION;
if ( (pathTRANSLATED=rp_GetCGIvar(handle,CGI_PathTranslated)) != NULL )
    {
    strupr ( pathTRANSLATED );
    if ( (p=strrchr(pathTRANSLATED,'/')) != NULL && !*(p+1) )
        *p = (unsigned char)'\0';
    if ( !strncmp(pathTRANSLATED+1,RPROXY_Control_Entry,20) )
        {                       // if this is the control entry for engine
        if ( (remoteADDR=rp_GetCGIvar(handle,CGI_RemoreAddr)) != NULL )
            {                   // check authorization
            if ( rp_CheckURL(handle,remoteADDR,pathTRANSLATED) == _ACL_RULE_PERMIT )
                {
                if ( (querySTRING=rp_GetCGIvar(handle,CGI_QueryString)) != NULL )
                    {
                    rp_ProcessRequest ( handle, CommandsDictionary, CdictSize,
                                        querySTRING, rcode );
                    free ( querySTRING );
                    }
                }
            free ( remoteADDR );
            }
        }
    else
        {
        if ( !strncmp(pathTRANSLATED+1,RPROXY_User_Entry,17) )
            {                   // if this is user entry, process user request
            if ( (querySTRING=rp_GetCGIvar(handle,CGI_QueryString)) != NULL )
                {
                rp_ProcessRequest ( handle, UsersDictionary, UdictSize,
                                    querySTRING, rcode );
                free ( querySTRING );
                }               // and no any control functions.
            }
        }
    free ( pathTRANSLATED );
    }
}
