/*
      rp_AddACLrule - add new acl rule.
      rp_AddPublicACLrule - add new public acl rule.
*/
#include "rproxy.h"


static void rp_AddRule ( unsigned char *handle, unsigned char Value[],
                         long *rcode, ACL *List, int *Lsize, int Msize );


void rp_AddACLrule ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
rp_AddRule ( handle, Value, rcode, ACList, &ACListSize, maxACLListSize );
}


void rp_AddPublicACLrule ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
rp_AddRule ( handle, Value, rcode, publicACList, &publicACListSize, _MAX_PUBLIC_ACL );
}


static int haveACL ( ACL *List, int Lsize, unsigned char name[] )
{
        register int i;

for ( i = 0; i < Lsize; i++ )
    {
    if ( !strcmp(List[i].name,name) )
        return ( i + 1 );
    }
return ( 0 );
}

static void rp_AddRule ( unsigned char *handle, unsigned char Value[],
                         long *rcode, ACL *List, int *Lsize, int Msize )
{
        register unsigned char *p, *pname;

for ( p = Value; *p && *p != ','; p++ );
if ( *p )
    {
    pname = Value;              // after name we have a mask, "p" points to a
    *p = (unsigned char)'\0';   // http mask
    ++p;
    rp_PutHeader ( handle, rcode, _MIME_TEXT );
    if ( *Lsize < Msize )
        {
        DosEnterCritSec();
        if ( !haveACL(List,*Lsize,pname) )
            {
            strncpy ( List [*Lsize].name, pname, _MAX_USERNAME_LENGTH-1 );
            List [*Lsize].name [_MAX_USERNAME_LENGTH-1] = (unsigned char)'\0';
            pname = p;
            for ( ; *p && *p != ','; p++ );
            if ( *p )
                {
                *p = (unsigned char)'\0';
                ++p;
                List [*Lsize].state = (short)atoi(p);    
                }
            else
                List [*Lsize].state = _ACL_RULE_PERMIT;    
            strncpy ( List [*Lsize].url, pname, _MAX_URL_LENGTH-1 );
            List [*Lsize].url [_MAX_URL_LENGTH-1] = (unsigned char)'\0';
            ++(*Lsize);
            }
        DosExitCritSec();
        rp_write ( handle, Msgs[0], rcode );
        }
    else
        {
        rp_write ( handle, Msgs[1], rcode );
        }
    }
*rcode = HTTP_OK;
}
