/*
      rp_AddTrustedHost - set up trusted hosts ip address mask.
      rp_DeleteTrustedHost - delete trusted host mask.
*/
#include "rproxy.h"

static int rp_SearchHost ( unsigned char hostmask[] )
{
        register int i;

for ( i = 0; i < totalTrustedHosts; i++ )
    {
    if ( !strcmp(TrustedHosts[i].hostmask,hostmask) )
        return ( i );
    }
return ( EOF );
}


void rp_AddTrustedHost ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
        register unsigned char *p, *pip;
        unsigned char *pstate;
        short  state;

for ( p = Value; *p && *p != ','; p++ );
pip = Value;
state = _ACL_RULE_PERMIT;
if ( *p == ',' )
    {
    *p = (unsigned char)'\0';
    state = atoi(++p);
    }
if ( M != NULL )
    rp_PutHeader ( handle, rcode, _MIME_TEXT );
if ( totalTrustedHosts < _MAX_TRUSTED_HOSTS )
    {

    DosEnterCritSec();
    if ( rp_SearchHost(pip) == EOF )
        {
        strncpy ( TrustedHosts [totalTrustedHosts].hostmask, pip, _MAX_IP_IN_STRING-1 );
        TrustedHosts [totalTrustedHosts].hostmask [_MAX_IP_IN_STRING-1] = (unsigned char)'\0';
        TrustedHosts [totalTrustedHosts].state = (M == NULL)? _ACL_RULE_ADMIN : state;
        ++totalTrustedHosts;
        }
    DosExitCritSec();
    if ( M != NULL )
        rp_write ( handle, Msgs[2], rcode );
    }
else
    {
    if ( M != NULL )
        rp_write ( handle, Msgs[3], rcode );
    }
*rcode = HTTP_OK;
}



void rp_DeleteTrustedHost ( unsigned char *handle, CommandMessage *M,
                   unsigned char Value[], long *rcode )
{
        register unsigned char *p, *pip;
        register int n;
        char  *msg;

for ( p = Value; *p && *p != ','; p++ );
*p = (unsigned char)'\0';
pip = Value;

DosEnterCritSec();
if ( (n=rp_SearchHost(pip)) != EOF )
    {
    memcpy ( &TrustedHosts[n],&TrustedHosts[n+1],
                    sizeof(TrustedHosts[0])*(totalTrustedHosts-n) );
    --totalTrustedHosts;
    msg = Msgs [11];
    }
else
    {
    msg = Msgs [12];
    }
DosExitCritSec();
if ( M != NULL )
    {
    rp_PutHeader ( handle, rcode, _MIME_TEXT );
    rp_write ( handle, msg, rcode );
    }
*rcode = HTTP_OK;
}
