/*
    rp_GarbageCollection - separated thread performs garbage collection.
 It sleeps for a timeout, then wakes up and scans user list, if it finds
 user record with too old timestamp, it removes this record.
*/
#include "rproxy.h"


void _System rp_GarbageCollection ( ULONG timeout )
{
    register int i, n;
    time_t   cTime;
    double   diffTime;
    double   def_timeout;

while ( !DosSleep (timeout) )
    {
    time(&cTime);
    def_timeout = (double)timeout/1000.0;
    DosEnterCritSec();
    for ( n = i = 0; i < userListSize; i++ )
        {
        diffTime = difftime(cTime,userList[i].timestamp);
        if ( diffTime > def_timeout )
            {
            memset ( userList [i].name, 0xFF, _MAX_USERNAME_LENGTH-1 );
            userList [i].name [_MAX_USERNAME_LENGTH-1] = (unsigned char)'\0';
            userList [i].totalgroups = 0;
            ++n;
            }
        }
    qsort ( userList, userListSize, sizeof(uIP), (VoidStub)strcmp );
    userListSize -= n;
    DosExitCritSec();
    }
}
