/*********************************************************************

   Copyright (c) 1999 Michael A. Potapoff  All Rights Reserved.

   Description: Simplify use of Novell API to NDS

*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "NDS_Func.h"

NWDSCCODE N_API NW_Start (NWDSContextHandle *cx)
   {
   NWDSCCODE   ccode;
   LCONV       lcInfo;

   ccode = NWCallsInit (NULL, NULL);
   if (!ccode)
      {
      if (NWLlocaleconv (&lcInfo))
         {
         ccode = NWInitUnicodeTables (lcInfo.country_id, lcInfo.code_page);
         if (!ccode)
            {
            *cx = NWDSCreateContext ();
            if (*cx == ERR_CONTEXT_CREATION)
//            ccode = NWDSCreateContextHandle (cx);
//            if (!ccode)
               {
               NWFreeUnicodeTables ();
               ccode = ERR_CONTEXT_CREATION;
               }
            }
         }
      else
         ccode = UNI_OPEN_FAILED;
      }
   return (ccode);
   }

//****************************************************
NWDSCCODE N_API NW_Stop (NWDSContextHandle cx)
   {
   NWDSCCODE   ccode;

   ccode = NWDSFreeContext (cx);
   if (ccode)
      {
      NWFreeUnicodeTables ();
      return (ccode);
      }
   else
      return (NWFreeUnicodeTables ());
   }

//****************************************************
NWDSCCODE N_API NW_GetAttr (NWDSContextHandle cx,           // nuint32
                            pnstr8   strCN,
                            pnstr8   strAttrName,
                            pnstr8   strAttrVal)
   {
   NWCCODE     ccode;       // nuint: unsigned int
   pBuf_T      iBuf;        // struct {...} N_FAR *pBuf_T
   pBuf_T      oBuf;
   nstr8       s1 [(MAX_SCHEMA_NAME_CHARS)+1];
   nstr8       s2 [(MAX_SCHEMA_NAME_CHARS)+1];
   nuint32     luSyntax;
   nuint32     luCount = 1;
   nint32      lIterationHandle = NO_MORE_ITERATIONS;

   if (!strCN || !(*strCN))
     {
     strCN = s1;
     ccode = NWDSWhoAmI (cx, strCN);
     if (ccode)
       return (ccode);
     }
   ccode = NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &iBuf);
   if (!ccode)
     {
     ccode = NWDSInitBuf (cx, DSV_READ, iBuf);
     if (!ccode)
       {
       ccode = NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &oBuf);
       if (!ccode)
         {
         ccode = NWDSPutAttrName (cx, iBuf, strAttrName);
         if (!ccode)
           {     // 3rd attr (FALSE) indicates that only attr info desired.
           ccode = NWDSRead (cx, strCN, DS_ATTRIBUTE_VALUES,
                             FALSE, iBuf, &lIterationHandle, oBuf);
           if (!ccode)
             {
             ccode = NWDSGetAttrCount (cx, oBuf, &luCount);
             if (!ccode)
               {
               ccode = NWDSGetAttrName (cx, oBuf, s2, &luCount, &luSyntax);
               if (!ccode)
                 {
                 if (luCount)
                   {
                   ccode = NWDSGetAttrVal (cx, oBuf, luSyntax, strAttrVal);
                   }
                 }
               }
             }
           }
         }
       NWDSFreeBuf (oBuf);
       }
     }
   NWDSFreeBuf (iBuf);
   return (ccode);
   }

//****************************************************
NWDSCCODE N_API NW_GetAttrs (NWDSContextHandle cx,          // nuint32
                            pnstr8   strCN,
                            pnstr8   strAttrName,
                            pnstr8   strAttrVals)
   {
   NWCCODE     ccode;       // nuint: unsigned int
   pBuf_T      iBuf;        // struct {...} N_FAR *pBuf_T
   pBuf_T      oBuf;
   nstr8       s1 [(MAX_SCHEMA_NAME_CHARS)+1];
   nstr8       s2 [(MAX_SCHEMA_NAME_CHARS)+1];
   nuint32     luSyntax;
   nuint32     luCount = 1;
   nint32      lIterationHandle = NO_MORE_ITERATIONS;

   if (!strCN || !(*strCN))
     {
     strCN = s1;
     ccode = NWDSWhoAmI (cx, strCN);
     if (ccode)
       return (ccode);
     }
   ccode = NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &iBuf);
   if (!ccode)
     {
     ccode = NWDSInitBuf (cx, DSV_READ, iBuf);
     if (!ccode)
       {
       ccode = NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &oBuf);
       if (!ccode)
         {
         ccode = NWDSPutAttrName (cx, iBuf, strAttrName);
         if (!ccode)
           {     // 3rd attr (FALSE) indicates that only attr info desired.
           ccode = NWDSRead (cx, strCN, DS_ATTRIBUTE_VALUES,
                             FALSE, iBuf, &lIterationHandle, oBuf);
           if (!ccode)
             {
             ccode = NWDSGetAttrCount (cx, oBuf, &luCount);
             if (!ccode)
               {
               ccode = NWDSGetAttrName (cx, oBuf, s2, &luCount, &luSyntax);
               if (!ccode)
                 {
                 while (luCount--)
                   {
                   ccode = NWDSGetAttrVal (cx, oBuf, luSyntax, strAttrVals);
                   strAttrVals += strlen (strAttrVals) + 1;
                   }
                 }
               }
             }
           }
         }
       NWDSFreeBuf (oBuf);
       }
     }
   NWDSFreeBuf (iBuf);
   strcpy (strAttrVals, "");
   return (ccode);
   }

//****************************************************
NWDSCCODE N_API NW_PutAttr (NWDSContextHandle cx,           // nuint32
                            pnstr8   strCN,
                            pnstr8   strAttrName,
                            pnstr8   strAttrVal)
   {
   NWCCODE     ccode;       // nuint: unsigned int
   pBuf_T      pBuf;        // struct {...} N_FAR *pBuf_T
   nstr8       s1 [(MAX_SCHEMA_NAME_CHARS)+1];
   nstr8       s2 [(MAX_SCHEMA_NAME_CHARS)+1];
   nuint32     luSyntax;
   nuint32     luCount = 1;
   nint32      lIterationHandle = NO_MORE_ITERATIONS;

   if (!strCN || !(*strCN))
     {
     strCN = s1;
     ccode = NWDSWhoAmI (cx, strCN);
     if (ccode)
       return (ccode);
     }
   ccode = NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &pBuf);
   if (!ccode)
     {
     ccode = NWDSInitBuf (cx, DSV_MODIFY_ENTRY, pBuf);
     if (!ccode)
       {
       ccode = NWDSPutChange (cx, pBuf, DS_CLEAR_ATTRIBUTE, strAttrName);
       if (!ccode)
         {
         ccode = NWDSPutChange (cx, pBuf, DS_ADD_ATTRIBUTE, strAttrName);
         if (!ccode)
           {
           ccode = NWDSPutAttrVal (cx, pBuf, SYN_CI_STRING, strAttrVal);
           if (!ccode)
             {
             ccode = NWDSModifyObject (cx, strCN, NULL, 0, pBuf);
             }
           }
         }
       }
     }
   NWDSFreeBuf (pBuf);
   return (ccode);
   }
