/*
    This module intended to inform Rproxy about user. It sends to Rproxy
 the name of client, groups he included and his current IP-address.
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <direct.h>
#include <winsock.h>
#include <windows.h>
#include <winbase.h>
#include <winuser.h>
#include <winnls.h>
#include "NDS_Func.h"


char *NDS_GetNames ( char str[] )
{
       NWDSContextHandle cx;
       char  *buf;
       char  tmp  [16];
       char  *s, *p1, *p2;

if ( !(buf=malloc(512)) )
   return (NULL);

if ( NW_Start (&cx) )
   return ( NULL );;

if ( NW_GetAttr  (cx, NULL, "Common Name", (pnstr8) str) ||
     NW_GetAttrs (cx, NULL, "Group Membership", (pnstr8) buf))
    {
    NW_Stop (cx);
    return ( NULL );
    }
NW_Stop (cx);

s = buf;
while ( *s )
    {
    p1 =  str + strlen (str);
    strcat (str, ",");
    strcat (str, s);
    while ((p2 = strstr (p1, "CN=")) != NULL ||
           (p2 = strstr (p1, "OU=")) != NULL)
        {
        strcpy (p2, p2 + 3);
        }
    while (*p1)
        {
        if (iscntrl (*p1) || isspace (*p1))
            {
            memmove (p1 + 2, p1, strlen (p1) + 1);
            sprintf (tmp, "%%%02X", (unsigned) *p1);
            strncpy (p1, tmp, 3);
            }
        p1++;
        }
    s += strlen (s) + 1;
    }
free (buf);
return (str);
}

#define hostADDR buffer

int   SendData2Rproxy ( char sIP[], int sPort )
{
        int        rv = 0;
        WORD       VersionRequested;
        WSADATA    ImplementationDetails;
        SOCKET     ClientSocket;
        SOCKADDR_IN ServerSocketAddress;
        static     char buffer[1024];
        static     char names [1024];
        register int i;
        register char *pnames;
        struct hostent *hostProxy;
        static  char  uIP [32];

VersionRequested = MAKEWORD(1,1);
rv = WSAStartup ( VersionRequested, &ImplementationDetails );
if ( rv )
    return ( rv );

/*
   Gets this host parameters
*/
gethostname ( hostADDR, sizeof(hostADDR)-1 );
hostProxy = gethostbyname(hostADDR);
sprintf ( uIP, "%d.%d.%d.%d", hostProxy->h_addr[0],
               hostProxy->h_addr[1], hostProxy->h_addr[2], 
               hostProxy->h_addr[3] );

/*
    Create the Client Socket and verify that it was created
*/
ClientSocket = socket (PF_INET,SOCK_STREAM,0);
if ( ClientSocket == INVALID_SOCKET )
    return ( EOF );

/*
    Connect the Socket to an address and port on the network
*/
ServerSocketAddress.sin_family		 = AF_INET;
ServerSocketAddress.sin_addr.S_un.S_addr = inet_addr(sIP);
ServerSocketAddress.sin_port        	 = htons(sPort);

rv = connect(ClientSocket,(LPSOCKADDR)&ServerSocketAddress,sizeof(ServerSocketAddress));
if ( rv )
    return ( rv );

if ( (pnames=NDS_GetNames(names)) == NULL )
    pnames = "Unknown,everyone";

sprintf ( buffer, "GET /RPROXY_USER_ENTRY?ADDUSERQUIET=%s,%s\r\n", pnames, uIP );

printf ( "send to %s:%d - %s\n", sIP, sPort, buffer );

rv = send ( ClientSocket, buffer, strlen(buffer)+1, 0 );
if ( rv == SOCKET_ERROR )
    return ( rv );

closesocket(ClientSocket);
return ( 0 );
}



void main ( void )
{

SendData2Rproxy ( "192.168.3.2", 80 );

}
