/*
      rp_ViewYourIP - sends caller's IP address and hostname.

*/
#include "rproxy.h"


void rp_ViewYourIP ( unsigned char *handle, CommandMessage *M, unsigned char Value[], long *rcode )
{
        unsigned char *remoteADDR;
        unsigned char *buf;
        unsigned long userIPaddress;
        struct hostent *userHost = NULL;

if ( (remoteADDR=rp_GetCGIvar(handle,CGI_RemoteAddr)) != NULL )
    {
    userIPaddress = inet_addr(remoteADDR);
    userHost = gethostbyaddr ( (unsigned char *)&userIPaddress, 
                               sizeof(userIPaddress), AF_INET );
    }
rp_PutHeader ( handle, rcode, _MIME_TEXT );
if ( (buf=malloc(256)) != NULL )
    {
    sprintf ( buf, "Your IP address is %s\nYour hostname is %s\n",
             remoteADDR == NULL ? "unknown" : remoteADDR,
             userHost == NULL ? "unknown" : userHost->h_name );

    rp_write ( handle, buf, rcode );
    free ( buf );
    }
else
    {
    rp_write ( handle, Errs [3], rcode );
    }
if ( remoteADDR != NULL )
    free ( remoteADDR );
*rcode = HTTP_OK;
}
