/*
      rp_GetCGIvar - extracts value for CGI variable. This routine
 allocates memory for value buffer, you have to free this buffer after 
 using the value.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <htapi.h>


#define _MAX_BUF          1024

unsigned char *rp_GetCGIvar ( unsigned char *handle, unsigned char *name )
{
      unsigned char *Buf;
      unsigned long  maxsize = _MAX_BUF;
      long     rcode = HTTPD_SUCCESS;
      unsigned long namelength;

if ( (Buf=malloc(maxsize)) != NULL )     // allocate buffer
    {                                    // if , extract value
    namelength = strlen(name)+1;
    HTTPD_extract(handle,name,&namelength,Buf,&maxsize,&rcode);
    if ( rcode == HTTPD_BUFFER_TOO_SMALL )
        {                                // if buffer too small, try again
        free ( Buf );                    // free previous allocated memory
                                         // maxsize now contents needed size
                                         // for value
        if ( (Buf=malloc(maxsize+1)) != NULL )
            {                            // allocate new buffer and try to extract
            HTTPD_extract(handle,name,&namelength,Buf,&maxsize,&rcode);
            }
        else
            {                            // here I have to insert error handler
            Buf = NULL;
            }                            // "Not enough memory"
        }
    }
else
    {                                    // here I have to insert error handler
    Buf = NULL;
    }                                    // "Not enough memory"
if ( rcode != HTTPD_SUCCESS && rcode != HTTPD_PARAMETER_ERROR )
    {                                    // another error handler
    }
else
    {
    if ( Buf != NULL )
        Buf [maxsize] = '\0';            // limit value
    }
return ( Buf );
}
