/*
	rp_Match - evaluate regular expression. Returs 1 if string
 satisfies regular expression, 0 if not.
*/
#include "rproxy.h"

#define   REGULAR_TYPE          0

typedef struct  subStringList {
	char         *str;      /* Piece of string to search for */
	short        strType;
	struct subStringList *next;
	}       subStringList;

static  char *regExprKeyChar  = "*?" ;

static subStringList *uMatch_buildlist ( unsigned char searchPattern[],
                                         short *pmallocCalls )
{
	register unsigned char *tmpPtr;
	short    pieceLength;
	subStringList *prevPtr;
	subStringList *curPtr;
        subStringList *listHead;

/***********************************************************/
/* Below, we are building a linked-list of search patterns.*/
/* Each block is composed of the longest substring before  */
/* the appearance of any Special Chars (ie ? and * ).      */
/* There are two types of blocks, one type is the  one     */
/* mentioned above, the other type is a block containing   */
/* information on how many '?'s we have to match.          */
/***********************************************************/
listHead = NULL;                /* Parsing of the expression line. */
*pmallocCalls = 1;
if ((listHead = (subStringList *)malloc(sizeof(subStringList))) == NULL)
    {
    return ( NULL );
    }
else
    {
    curPtr = listHead;
    curPtr->strType = 0;
    curPtr->str = NULL;
    curPtr->next = NULL;
    prevPtr = NULL;

    tmpPtr = searchPattern;

    while ( *tmpPtr != '\0' )
	{
	pieceLength = strcspn(tmpPtr,regExprKeyChar) ;

	if ( !pieceLength )     /* Found '*' or '?' */
	    {
	    if ( *tmpPtr == '*' )
		{
		curPtr->str = NULL;
		curPtr->strType = -1;
		while ( *tmpPtr == '*' )
		    ++tmpPtr;
		}
	    else
                {
		curPtr->str = NULL;
                curPtr->strType = 1;
		++tmpPtr;
		while ( *tmpPtr == '?' )
		    {
		    ++tmpPtr;
		    ++curPtr->strType;
		    }
		}
	    if ((curPtr->next=(subStringList *)malloc(sizeof(subStringList))) == NULL)
		{
		return ( NULL );
		}
	    ++(*pmallocCalls);
	    prevPtr = curPtr;
	    curPtr = curPtr->next;
	    curPtr->next = NULL;
	    }
	else
	    {
	    if ( (curPtr->str=(char *)malloc(pieceLength+1)) == NULL )
                {
		return ( NULL );
		}
	    ++(*pmallocCalls);
	    memcpy ( curPtr->str, tmpPtr, pieceLength );
	    *(curPtr->str+pieceLength) = '\0';
	    curPtr->strType = REGULAR_TYPE;
	    tmpPtr += pieceLength;
	    if ((curPtr->next=(subStringList *)malloc(sizeof(subStringList))) == NULL)
                {
		return ( NULL );
		}
	    ++(*pmallocCalls);
	    prevPtr = curPtr;
	    curPtr = curPtr->next;
	    curPtr->next = NULL;
	    }
	}
    }
if ( prevPtr == NULL )
    {
    return ( NULL );
    }
else
    {
    --(*pmallocCalls);
    free ( prevPtr->next );     /* Throw away the extra block. */
    prevPtr->next = NULL;       /* We always allocate one more */
    }                           /* block on the list.          */
return ( listHead );
}


int  rp_Match ( unsigned char inputLine[], unsigned char searchPattern[] )
{
	int foundFlag = 0;
	register unsigned char *theLine;
	register unsigned char *tmpLine;
	subStringList *curPtr;
        subStringList *listHead;
        short mallocCalls;

errno = 0;
if ( (listHead=uMatch_buildlist(searchPattern,&mallocCalls)) != NULL )
    {
    theLine  = inputLine;
    /*******************************************/
    /* The following code walk the linked-list */
    /* of pieces of the string.                */
    /* if strType is 0 : we match 'str' as-is, */
    /* else strType = the number of ?'s in the */
    /* regular expression.                     */
    /*******************************************/
    curPtr = listHead;
    while( !foundFlag && curPtr )
	{
	if ( curPtr->strType == 0 ) /* Match String as-is */
	    {               /* This line does not have the pattern we wanted */
	    if ( strncmp(theLine,curPtr->str,strlen(curPtr->str)) )
		curPtr = NULL;
	    else
		{
		theLine += strlen(curPtr->str);
		curPtr = curPtr->next ;
		if ( !curPtr )
		    foundFlag = 1 ;
		}
	    }
	else                    /* this is '*'  */
	    {
	    if ( curPtr->strType < 0 )
		{
		if ( curPtr->next != NULL )
		    {
		    if ( curPtr->next->str != NULL )
			{
			if((tmpLine=strstr(theLine,curPtr->next->str))==NULL)
			    curPtr = NULL;
			else
			    {
/*
			    for ( theLine = tmpLine;
				(tmpLine=strstr(++tmpLine,curPtr->next->str))!=NULL;
				theLine = tmpLine );
*/
			    theLine = tmpLine;
			    curPtr = curPtr->next;
			    if ( !curPtr )
				foundFlag = 1 ;
			    }
			}
		    else
			{
			curPtr = curPtr->next ;
			}
		    }
		else
		    {
		    curPtr = curPtr->next ;
		    if ( !curPtr )
			foundFlag = 1 ;
		    }
		}
	    else
		{               /* We must skip over strType # of ?'s  */
		if ( (short)strlen(theLine) < curPtr->strType )
		    curPtr = NULL ;
		else
		    {
		    theLine += curPtr->strType;
		    curPtr = curPtr->next;
		    if ( !curPtr && !*theLine )
			foundFlag = 1;
		    }
		}
	    }
	}                           /* end while */
    }
for ( curPtr = listHead; curPtr != NULL; curPtr = curPtr->next )
    {
    if ( curPtr->str != NULL )
	{
	--mallocCalls;
	free ( curPtr->str );
	}
    --mallocCalls;
    free ( curPtr );
    }
return ( foundFlag );
}
