/*
program: ih2all.cmd
type:    REXXSAA-OS/2
purpose: execute INF-HTML.EXE to produce *all* HTML-files *and* call ih2merge.cmd
         in order to produce a HTML-version which contains *all* HTML-files in 
         one *big* file which allows for printing the entire document e.g. via 
         WebExplorer (ih2merge.cmd; BTW ih2merge.cmd allows for merging just a 
         subset of the HTML-files if used individually)

usage:   ih2all INF/HLP-file
         ... INF/HLP-file may reside on another drive/path

version: 1.0.1
date:    1995-04-09, 1995-05-29
changed: included functionality of "IH2CONV.CMD" (needed for earlier versions):
         execute INF-HTML.EXE to produce the TOC-, Index- and 
         HELP/INF-html-files; location of support-directory changed to
         "./Support/" (previously called "./inf-html/")

needs:  INFHTML-package of Peter Childs, IH2MERGE.CMD, HPFS-partition to work on

author:  Rony G. Flatscher,
         Wirtschaftsuniversitt/Vienna
         Rony.Flatscher@wu-wien.ac.at

All rights reserved, copyrighted 1995, no guarantee that it works without
errors, etc. etc.

donated to the public domain granted that you are not charging anything
(money etc.) for it and derivates based upon it, as you did not write it,
etc. if that holds you may bundle it with commercial programs too

Please, if you find an error, post me a message describing it, I will
try to fix and rerelease it to the net.
*/

PARSE ARG inFile

IF STREAM(inFile, "C", "QUERY EXISTS") = "" THEN
DO
   SAY inFile": does not exist, aborting ..."
   EXIT -1
END

SAY "Input:   ["inFile"]"

fileName   = FILESPEC("name", inFile)
SAY "File:    ["fileName"]"
filePrefix = SUBSTR(fileName, 1, POS(".", fileName) - 1)
SAY "Prefix:  ["filePrefix"]"

/******************** produce HTML-chunks ***********************/
SAY
SAY "Producing HTML-files ..."
SAY

inf_html_dir = ".\Support\"             /* location of INF-HTML-support files */

say "inFile ["inFile"] inf-html-dir ["inf_html_dir"]"

"inf-file" inFile "toc" inf_html_dir
"inf-file" inFile "text" inf_html_dir
"inf-file" inFile "idx" inf_html_dir

SAY "Producing HTML-files ... - done."

/****************** merge all HTML-chunks ***********************/
SAY
SAY "Merging all HTML-file-chunks into one big file (e.g. for printing)..."
SAY
CALL ih2merge   filePrefix
SAY "Merging all HTML-file-chunks into one big file (e.g. for printing)... - done."
SAY

SAY "Finished."

