/* Modify an SRE2003 configuration file */
mod_ini:
parse arg stuff
parse var stuff daname isreset daflag usepid '"' filtername '"'
daname=strip(daname) ; isreset=striP(isreset)
daflag=strip(daflag) ; usepid=strip(usepid)
varlist=''
if isreset=1 then do
 varlist='DATADIR LIMITBODY LIMITCLIENTS LIMITHEADER LIMITTIMETOTAL ' ,
        'LIMITTIMEWAIT LIMITTIMEINACTIVE ' ,
        'SERVER_SOFTWARE SERVER_SOFTWARE_SHORT CACHE_ENABLE  SECURITY_LEVEL' 
end
if isreset=2 then do
   varlist='PORT  FILTER REQ_CACHE_ENABLE  DATADIR  '|| ,
               'FILTER LIMITCLIENTS LIMITTIMEINACTIVE LIMITTIMETOTAL PORT SECURITY_LEVEL STATUS_ITEMS AUDIT_ITEMS  CACHE_RECORD '
end

if daname='' then do
   say " This SRE2003 utility is not meant to be run from the command line"
  exit
end /* do */

signal on halt name foomod

call mod_init

say aesc||"[2J"
say     "      " cy_ye "Modify the SRE2003 configuration file "normal

stuff=sre_read_file(daname,3)
parse var stuff isz ainfo '0d0a'x stuff

if isz<0 then do
   say reverse'ERROR:'normal' can not open configuration file: 'ainfo
   if daflag<>'' then foo=sre_flag_set(daflag,1,usepid)
   return 'no changes'
end 
if isz=0 then do
   say reverse'ERROR:'normal' empty configuration file: 'daname
   if aflag<>'' then foo=sre_flag_set(daflag,1,usepid)
   return 'no changes'
end 

say isz " bytes in the "daname" configuration file."
say
if varlist<>'' then do
  say " Modifying a subset of "||words(varlist)||' variables.'
  parse  source a1 a2 aa
  foo=strip(filespec('d',aa)||filespec('p',aa),,'\')
  say " [To modify all the parameters, run "foo">SRE2003 -mall ] "
end

nchanges=0
nochanges=0
outfile=daname
ii=0

say " "
say bold " Enter values: " normal
say "   ENTER  -- retain current value "
say "   ?      -- show a brief description "
say "   value  -- replace with value "
say "   ;FIND vvv -- find variable vvv "
if varlist='' then say "   ;UP    -- view prior variable"
say "   ;LIST  -- display list of variables "
say "   ;DONE  -- no more changes"
say "   ;QUIT  -- leave without making changes "
say " "
say ' #)' reverse left('Variable name ',20) ' = ' normal bold 'Current Value 'normal cy_ye ' ? ' normal '(new value)'
say ' ----------------------------------------------------------------------------'

lastmodline=''
jines.=''
jines.0=0

mm=0
stuffs.=''
currentvars=''
lastmodline=''
do until stuff=''
   parse var stuff aline '0d0a'x stuff
   aline=strip(aline)
   if abbrev(translate(aline),';LAST-MODIFIED:')=1 then do
     lastmodline=aline
     iterate
   end
   mm=mm+1
   stuffs.mm=aline
   if aline='' | abbrev(aline,';')=1 then do
     stuffs.mm.!type='C'
   end
   else do
        parse var aline vname '=' vval
        vvname=strip(vvname)
        stuffs.mm.!VAR=strip(vname)
        stuffs.mm.!VAL=strip(vval)
        currentvars=currentvars' '||translate(strip(vname))
   end 
end 
stuffs.0=mm


/* pre processing is done. Now make changes */
jj=1
ith=0
findit=''
nct=0 
lastvarname=''
do forever
  if jj>stuffs.0 then leave
  aline=stuffs.jj
  if stuffs.jj.!type='C' | nochanges=1 then do
      if stuffs.jj.!type<>'C' then nct=nct+1
    
      ith=jines.0+1
      jines.ith=aline
      jines.0=ith 
      jj=jj+1
      iterate
  end 

  lastvarname=vname0

  vname0=stuffs.jj.!VAR
  vval=stuffs.jj.!VAL

  if varlist<>'' then do                /* "dynamic parameters mode" -- is it dynamic? */
     tvn=translate(vname0)
     if wordpos(tvn,varlist)=0 then do   /* not in todo list, so retain */
        ith=jines.0+1
        jines.ith=aline ; jines.0=ith
        jj=jj+1
        iterate
     end
   end

 if findit<>'' then do          /* in a !FIND mode? */
    if findit<>translate(vname0) then do
       ith=jines.0+1
       jines.ith=aline
       jines.0=ith 
      if stuffs.jj.!type<>'C' then nct=nct+1

      jj=jj+1
      iterate
    end
    findit=''
 end 

   nct=nct+1
   call charout,left(nct,2)')' reverse vname0 ' = ' normal bold||space(vval,1)||' '  normal
   if length(vval)+length(vname0)>35 then do
      say ; call charout,copies(' ',7+length(vname0))
   end
   call charout,' 'cy_ye '?' normal 

   parse pull aval ;aval=strip(aval)
   if aval="" then do 
      ith=jines.0+1
      jines.ith=aline ; jines.0=ith
      jj=jj+1
      iterate
   end  
   if aval="?" then do
       say " " ; say " ----> " bold vname0 normal
       call showhelp vname0
       iterate
   end  

   if translate(aval)=';QUIT' then do
      if daflag<>'' then foo=sre_flag_set(daflag,1,usepid)
      return "No changes were made"
   end

   if translate(strip(word(aval,1)))=';FIND' then do
     parse var aval . findit .
     findit=translate(strip(findit))
     jj=1
     ith=0
     jines.=''
     jines.0=0  
     nct=0
     iterate
    end 

   if translate(strip(word(aval,1)))=';UP' & varlist='' then do
     if lastvarname='' then iterate
     findit=translate(lastvarname)
     if wordpos(findit,currentvars)=0 then do
         say "No such variable: "findit
         findit=''
         iterate
     end 
     jj=1
     ith=0
     jines.=''
     jines.0=0  
     nct=0
     iterate
    end 

   if translate(aval)=';LIST'  then do
        aline=': '
        cc=currentvars
        if isreset<>'' then cc=varlist
        do until cc=''
           parse var cc aword cc ; aword=strip(aword)
           jl=length(aword)
           jl=trunc(0.99+(jl/14))
           aword=left(aword,(jl*14)+jl-1,' ')
           if length(aline' 'aword)>80 then do
               say aline
               aline=': '||aword' '
           end
           else do 
               aline=aline||aword||' '
           end
        end
        if aline<>'' then  say aline
        iterate
    end
   if translate(aval)=';DONE'  then do
        say " Exiting without making any more changes. "
        ith=jines.0+1
        jines.ith=aline ; jines.0=ith
        nochanges=1
        jj=jj+1
        iterate
   end

   if abbrev(aval,';')=1 then do                /* a goof? */
       if abbrev(aval,';;')=1 then do           /* convert ;; to ; */
            aval=substr(aval,2)
       end 
       else do
          iterate                       /* assume it's a mistake */
       end 
    end

/* value entered? */
   ith=jines.0+1
   jines.ith=vname0'='aval
   jines.0=ith
   stuffs.jj.!VAL=aval
   stuffs.jj=stuffs.jj.!VAR' = ' aval
   jj=jj+1
   nchanges=nchanges+1
end 

if findit<>'' then do
  say "Unable to find: "findit
  say "press ENTER to continue ..."
  pull foo
end 

if nchanges>0 then lastmodline=';last-modified: '||date('n')||' '||time('n')
ith=jines.0+1
jines.ith=lastmodline
jines.0=ith

if nchanges=0 then signal foomod

bdir=filespec('d',daname)||filespec('p',daname)
if dosisdir(bdir'old')=1 then
  dd=bdir'old\'||filespec('n',daname)
else
  dd=daname

ip=lastpos('.',dd)
if ip=0 then do
   bakfile=dd||'.???'
end
else do
   bakfile=left(dd,ip)||'???'
end

bakfile=dostempname(bakfile)
say daname ' is being renamed as '  bakfile
foo=dosrename(daname,bakfile)
if foo=0 then  do
   say " ERROR: Unable to rename "dname " to "bakfile" ! "
   foo=sre_pmprintf("SRE2003 Mod_Ini ERROR: Unable to rename "dname " to "bakfile" ! "
   call syssleep 3
   if daflag<>'' then foo=sre_flag_set(daflag,1,usepid)
   return "No changes were made."
end


do mm=1 to jines.0
   call lineout outfile,jines.mm
end 
call lineout outfile
if daflag<>'' then foo=sre_flag_set(daflag,1,usepid)
call syssleep 2
return nchanges" were made "

foomod:
if daflag<>'' then foo=sre_flag_set(daflag,1,usepid)
call syssleep 1
return "No changes were made."




/***************/
showhelp:
parse upper arg avar
avar=strip(avar)

avar2=translate('!'||avar)
if helps.avar2='' then do
  say bold'No help is available for: 'normal||avar
end
else do
  ss=helps.avar2
  do until ss=''
     parse var ss aline '0d0a'x ss
     say reverse"  : "normal||' '||strip(aline)
  end
  say
end
return 0



/************/
/* initialize some vars */
mod_init:

aesc='1B'x
cy_ye=aesc||'[37;46;m'
normal=aesc||'[0;m'
bold=aesc||'[1;m'
reverse=aesc||'[7;m'
crlf='0d0a'x

def_srevars='PORT DATADIR LIMITBODY LIMITCLIENTS LIMITHEADER LIMITTIMETOTAL ' ,
        'LIMITTIMEWAIT LIMITTIMEINACTIVE FILTER FAST_FILTER  EXIT_PROC INIT_PROC ' ,
        'DEFAULT_SOCKET_TIMEOUT  SERVER_SOFTWARE STATUS_ITEMS ',
        'SERVER_SOFTWARE_SHORT ' ,
        'MAXHOSTS  MAXCOUNTERS MAXCLIENTNAMES MAXSTATVALS'

helps.=''


helps.!AUDIT_DELAY='    How many minutes (fractions okay) to wait when writing to audit file. 'crlf,
    ' SRE2003 will store this many minutes worth of 'crlf,
    ' AUDIT output, and write it to the audit file all at once. '

helps.!errorfile='The file where errors are recorded to. By default, this is LOG/ERRORS.LOG'

helps.!PORT='The port the server should listen to 'crlf,
             '(typically,  port 80 is used for the WWW)'
helps.!DATADIR='The default root directory for your web documents'
helps.!LIMITBODY='Maximum size (in kbytes) of request body ',
                crlf'(as may be passed by a POST request)'
helps.!LIMITCLIENTS='Maximum number of simultaneously connected clients'
helps.!LIMITHEADER='Maximum size (in kybtes) of the request header'crlf,
                         '(including the request line)'
helps.!LIMITTIMETOTAL='Maximum time (in seconds) a the server will allow a given request 'crlf,
                      'to be connected (even if active)' crlf,
                      'The connection will be closed if this limit is exceeded'
helps.!LIMITTIMEWAIT='Time (in seconds) the server will wait between requests 'crlf,
                        '(on a maintained connection)'
helps.!LIMITTIMEINACTIVE='Maximum time, in seconds, the server'crlf ,
            'will allow a client to remain connected but inactive (that is, 'crlf,
            'without sending or reading data) [0 through LIMITTIMETOTAL].'

helps.!FILTER='The "filter" file (the filter resolves requests)'
helps.!FAST_FILTER='A "fast" filter file (can be used for specific requests)'

helps.!EXIT_PROC='A comma delimited list of exit procedures. 'crlf,
                 'These procedures will be called before requests are accepted.'crlf,
                 'If your filter does NOT use initialization procedures, set this to 0.'

helps.!INIT_PROC='A comma delimited list of initialization procedures. 'crlf,
                 'These procedures will be called just before SRE2003 shuts down.'crlf,
                 'If your filter does NOT use exit procedures, set this to 0.'

helps.!DEFAULT_SOCKET_TIMEOUT='Time (in seconds) that SRE2003 will allocate to each'crlf,
                'socket call. If a "send" or a "recieve" (typically, of less then 'crlf,
                '1000 bytes exceeds this limit, the request is terminated and 'crlf,
                'the connection is dropped.'

helps.!MAXHOSTS='Maximum number of "hosts" supported. '
helps.!MAXCOUNTERS='Maximum number of global counter variables'
helps.!MAXMD5S='Size of the MD5 "LRU" cache '
helps.!MAXCLIENTNAMES='Size of the "clientname" LRU cache '
helps.!MAXSTATVALS='Size of the "response time and bytes sent" LRU cache'

helps.!REQ_CACHE_ENABLE=' Enable the request cache. 'crlf,
        ' 0 = do NOT enable the request cache 'crlf,
        ' > 0 = time-to-live of each cache entries , in days '

helps.!REQ_CACHE_HITFILE=' File containing record of cache hits. This file is used when REQ_CACHE_'CRLF,
     'RECORD is enabled. It should be a relative filename (relative to the 'CRLF,
     'SRE2003 installation directory). You might want to place it in the LOG' CRLF,
     'subdirectory of the  working directory . '


helps.!REQ_CACHE_CALL_ANYWAYS='Call the filter even when if cache was used'crlf,
    ' 0 = Do NOT call filter 'crlf,
    ' * or 1 = Always call filter 'crlf,
    '  A_LIST (space delimited) = call if request abbrev matches item in A_LIST'crlf,
    'Example:  REQ_CACHECALL_ANYWAYS=/DOCS/ /HTMLS/'

helps.!REQ_CACHE_RECORD=' Record cache hits to the REQ_CACHE_HITFILE file.'crlf,
 '   0     =   Do NOT use the cache-hit file 'crlf,
 '   MMM   =   Use the cache hit file, and save results very MMM minutes'

helps.!REQ_CACHE_SIZE=' The size of the request cache, in number of entries.'crlf,
   '  Example:  REQ_CACHE_SIZE=200'

helps.!REQ_CACHE_VERIFY=' Enable http/1.1 style verification prior to use of the request cache.'crlf,
    ' 0 = never verify (always use cache entry if it exists)'crlf,
    ' 1 = verify, check Pragma, Cache-Control, If-None-Match, etc. 'crlf,
    ' 2 = verify, just using etag and date headers '

helps.!SECURITY_LEVEL='A flag used to control remote configuration.'crlf,
     ' The interpretation of SECURITY_LEVEL depends on what filter you are using'crlf,
     ' For example, for the SIMPLE, sreLite2, and SREhttp/2 filters: 'crlf,
     ' :   0 = remote (using html forms) configuration disallowed 'crlf,
     ' :   1 = remote configuration only from the server machine '
if filtername<>'' then 
   helps.!SECURITY_LEVEL=helps.!SECURITY_LEVEL||crlf||'Note: the current filter is='filtername 


helps.!SERVER_SOFTWARE='The name of this server software.'
helps.!SERVER_SOFTWARE_SHORT='A short version of the name of this server software'
helps.!STATUS_ITEMS='Events to display in status window.'crlf,
                    'A space delimited list is used to specify a set of the following events:'crlf,
                    '  >>   ERRORS CONNECTION CLIENTS LIMITS PEAK STATS VERBOSE  <<'crlf,
                    ' :    CONNECTION: report each connection 'crlf,
                    ' :    CLIENTS: Currently active connections'crlf,
                    ' :    ERRORS: report errors.             'crlf,
                    ' :    LIMITS: report timeouts  'crlf,
                    ' :    PEAK: peak number of connections'crlf,
                    ' :    SHOW_WAIT: show time of last connection 'crlf,
                    ' :    STATS: summary statistics         'crlf,
                    ' :    VERBOSE: Report other items '
helps.!AUDITFILE='File to write AUDIT items to (default=AUDIT.LOG)'
helps.!AUDIT_ITEMS='Events to write to audit file.'crlf,
                    'A space delimited list is used to specify a set of the following events:'crlf,
                    ' >>  CLIENT REQUEST SEND RESET DIAG DIAG2  << 'crlf,
                    ' :     CLIENT: client address and port    'crlf,
                    ' :     REQUEST: request line 'crlf ,
                    ' :     SEND: bytesread, response code bytes sent 'crlf,
                    ' :     RESET: reset of SRE2003.CFG  'crlf,
                    ' :     DIAG: diagnostic mode -- audit a variety of calls 'crlf,
                    ' :     DIAG2: diagnostic mode -- superset of DIAG 'crlf,
                    'Note that errors are always written to the audit file.'
     
helps.!CACHE_SIZE=' Size of the request-resolution cache '
helps.!CACHE_CALL_ANYWAYS='When to call filter after request resolution (so that auditing may occur)'crlf,
                 ':    0 = Never  'crlf,
                 ':    * = Always ' crlf,
                 ':    or, a space delimited list of abbreviatons (such as /DOCS/ /HTMLS/ ) '
helps.!CACHE_ENABLE=' Enable (1) the request-resolution cache '
helps.!CACHE_VERIFY=' Enable check request headers before using cache 'crlf,
                    ':  0= never verify (always use cache entry if it exists) 'crlf,
                    ':  1= verify (check Pragma, Cache-Control, If-None-Match, and If-modified)'crlf,
                    ':  2= verify, but ignore Pragma and Cache-Control:no-cache '
helps.!CACHE_RECORD='Record cache hits in the CACHE_HITFILE'crlf,
                      'The use of a Hit-FIle is an alternative to CACHE_CALL_ANYWAYS'crlf,
                      'Requests that are "called anyways" will NOT be recorded in the Hit-File'crlf,
                      ':   0 = Do NOT use the cache-hit file'crlf
                      ': mmm = Frequency of reporting (in minutes) 'crlf
                      'Be sure to specify a CACHE_HITFILE! '
helps.!CACHE_HITFILE='File to record cache-hits to (relative to SRE2003 working directory)'
helps.!NO_MODIFY_ONTHEFLY='Suppress the Alt-M "modify parameters on-the-fly capability'crlf,
                          ':   0=No 'crlf,
                          ':   1=Yes '
helps.!STATUS_MESSAGE='What to display on the side of status window 'crlf,
                      'The default message is "SRE2003"'

helps.!UNALLOWED_FILE=' File containing a list of "UnAllowed" IP addresses.'crlf,
                      ' To suppress (and not specify unallowed ip addresses), set = 0 '
helps.!TRACKING_ON='Enable aggressive tracking of client status. 'crlf,
                   ' :   0 = Disable 'crlf,
                   ' :   1 = Enable 'crlf,
                   ' Note that tracking information is stored in the "audit and tracking" daemon'
return 0

