/* This is the "display registered addons".
   An addon is "registered" either by its installation procedure,
   of by a special call to this program. See the details below ...

   The key to this program is the ADDONS.INI file, located in the 
   SREHTTP2\ADDON directory. It contains information on 
   what SREhttp/2 "addons" have been installed. By default, lists a
   few of the addons packaged with SREhttp/2 (_DIR and STATUS). 
   More importantly, installation programs for SREhttp/2 can readily
   add information to this ADDONS.INI file.


*/

addonlst:

parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,client_ip,privset,,
          uri,host_nickname,id_info,aiter,attribs

adir=sreh2_Value('ADDON_DIR',,host_nickname)
inifile=strip(adir,,'\')||'\ADDONS.INI'



call lineout tempfile, '<!doctype html public "-//IETF//DTD HTML 2.0//EN">'
nowtime=sre_datestamp()
call lineout tempfile, "<html><head><title>SREhttp/2: List of  addons</title>"
call lineout tempfile, "</head><body>"


if list<>'' then do
   call regit
   resp1=result
   return resp1
end 


call lineout tempfile,'<br><table align="center" bgcolor="lightblue"><tr><td>'
call lineout tempfile,' <h3 >SREhttp/2: List of addons </h3>'
call lineout tempfile,'</table>'


foo=stream(inifile,'c','query exists')
if foo='' then do
  call lineout tempfile,'Error. Unable to find SREhttp/2-addons initialization file.</body></html> '
  call lineout tempfile
  return 'File erase type text/html name 'tempfile
end

foo=sysini(inifile,'ALL:','apps.')

if foo='ERROR:' then do
  call lineout tempfile,'Error. Unable to open SREhttp/2-addons initialization file </body></html> '
  call lineout tempfile
  return 'File erase type text/html name 'tempfile
end

if apps.0=0 then do
  call lineout tempfile,'Error. No addons have been registered in the SREhttp/2-addons initialization file.</body></html> '
  call lineout tempfile
  return 'File erase type text/html name 'tempfile
end

 call lineout tempfile,'<dl>'

do mm=1 to apps.0
   anapp=apps.mm
   aurl=sysini(inifile,anapp,'URL')
   adoc=sysini(inifile,anapp,'DOC')
   adesc=sysini(inifile,anapp,'DESC')

   goo=''
   if length(anapp)<15 then goo=copies('&nbsp;',15-length(anapp))
  call lineout tempfile,'<dt> <b>'||anapp'</b>'||goo
  if aurl<>'' & aurl<>'ERROR:' then
      call lineout tempfile,'<a href="'||aurl||'" target="addon">Tryit</a>&nbsp;&nbsp;&nbsp;'
  if adoc<>'' & adoc<>'ERROR:' then
      call lineout tempfile,'<a href="'||adoc||'" target="addon">Documentation</a>'
  call lineout tempfile,'<dd>'
  if adesc<>'' & adesc<>'ERROR:' then  call lineout tempfile,adesc
  call lineout tempfile,'<p>'
end

call lineout tempfile,'</dl>'

call lineout tempfile,'<hr><b>Note:</b> this list of <em>registered</em> addons is <b>not</b> '
call lineout tempfile,'a complete list of all SREhttp/2 addons available on this server.<br>'
call lineout tempfile,'It only lists those addons whose installation procedure bothered to <em>register</em>'
call lineout tempfile,'the addon with SREhttp/2.'
call lineout tempfile,'<p><em>SuperUsers only:</em> <a href="/addonlst?register target="addon">Register an addon</a>'
call lineout tempfile,'</body></html>'
call lineout tempfile
return 'File erase type text/html name 'tempfile

/*******************************/
/* register an addon */
regit:

/* Superuser privileges required */
if wordpos('SUPERUSER',privset)=0 then do
  if aiter='' then return 'PRIVS Addon registration requires superuser privileges '
  return 'AUTH Addon registration requires that you have superuser privileges '
end 

call lineout tempfile,'<font size=-1><a href="javascript:history.go(-1)">back ... </a></font><br>'
call lineout tempfile,'<br><table align="center" bgcolor="lightblue"><tr><td>'

opts.=''
do until list=''
    parse var list a1 '&' list
    parse var a1 avar '=' aval
    avar=strip(translate(avar))
    aval=strip(sre_packur(translate(aval,' ','+')))
    vv='!'||avar
    opts.vv=aval
end

if opts.!DEREGISTER=1 then do
   call deregit
   res1=result
   return res1
end 

call lineout tempfile,' <h3 >SREhttp/2: Register an addon </h3>'
call lineout tempfile,'</table>'


if opts.!NAME='' then do                /* give user a form */
call lineout tempfile,'Please enter the name, links, and descriptive information for the '
call lineout tempfile,'addon you want to register. '
call lineout tempfile,'<br>In addition to the <b>name</b> field, you should fill out at least one of the other fields.'

call lineout tempfile,'<form action="/ADDONLST" method="GET">'
call lineout tempfile,'<table>'
call lineout tempfile,'<tr><th>Addon <br>name</th>'
call lineout tempfile,'<td><input type="text" name="NAME" size=15></td>'
call lineout tempfile,'<tr bgcolor="cyan"><th>URL</th>'
call lineout tempfile,'<Td><input type="text" name="URL" size=55>'
call lineout tempfile,'<br><font size=-1>A URL pointing to this addon, or to front-end to the addon </font></td>'
call lineout tempfile,'<tr><th>Documentation</th>'
call lineout tempfile,'<Td><input type="text" name="DOC" size=55>'
call lineout tempfile,'<br><font size=-1>A URL pointing to the documentation file for the addon </font></td>'

call lineout tempfile,'<tr bgcolor="cyan"><th>Description</th>'
call lineout tempfile,'<Td><textarea name="DESC" rows=5 cols=60></textarea>'
call lineout tempfile,'<br><font size=-1>A short description of this addon </font></td>'


call lineout tempfile,'<tr><th>Temporary files</th>'
call lineout tempfile,'<Td><input type="text" name="TEMP" size=55>'
call lineout tempfile,'<br><font size=-1>A fully qualified directory to use for storing temporary &amp; transient files </font></td>'

call lineout tempfile,'</table>'
call lineout tempfile,'<input type="submit" value="Register an addon">'
call lineout tempfile,'</form>'
call lineout tempfile,'<P><Em>or, </em> <a href="/addonlst?deregister=1">DeRegister an addon</a>'
call lineout tempfile,'</body></html>'
end

else do         /* use info in form to register it */
  aaad=opts.!NAME
  if aaad='' then do
     call lineout tempfile,'You forget to enter a name for this addon'
  end 
  else do
    adesc=opts.!DESC
    adoc=opts.!DOC
    aurl=opts.!URL
    atemp=opts.!TEMP
    if atemp<>'' then do
        atemp=strip(atemp,'t','\')
        if right(atemp,1)=':' then atemp=atemp||'\'
        oog=dosisdir(atemp)
        if oog=0 then
           call lineout tempfile,'<b>Warning:</b> temporary directory not available (<tt>'||atemp||'</tt>)<br>'
    end 
    if aurl='' & adoc='' & aurl='' then do
         call lineout tempfile,'You need to fill out one (or more) of the URL, Documentation, Temporary files, or Description fields.'
    end 
    else do
       if adesc<>'' then ifoo=sysini(inifile,aaad,'DESC',adesc)
       if adoc<>'' then oo=sysini(inifile,aaad,'DOC',adoc)
       if aurl<>'' then oo=sysini(inifile,aaad,'URL',aurl)
       if atemp<>'' then oo=sysini(inifile,aaad,'TEMP',atemp)
       call lineout tempfile,' The <tt>'aaad'</tt> addon has been registered.'
    end
  end
end 

call lineout tempfile,'<hr><a href="javascript:history.go(-1)">back ... </a>'
call lineout tempfile,'</body></html>'

call lineout tempfile
return 'file type text/html erase name 'tempfile


/*************************/
/* deregister an addon */
deregit:

call lineout tempfile,' <h3 >SREhttp/2: Register an addon </h3>'
call lineout tempfile,'</table>'

foo=sysini(inifile,'ALL:','apps')

if apps.0=0 then do
   call lineout tempfile,'No addons are currently registered '
   call lineout tempfile,'<hr><a href="javascript:history.go(-1)">back ... </a>'
   call lineout tempfile,'</body></html>'
   call lineout tempfile
   return 'file type text/html erase name 'tempfile
end

if opts.!REMOVEME<>'' then signal remove2
    
call lineout tempfile,'Select an addon to De-Register '
call lineout tempfile,'<form action="/ADDONLST" method="GET">'
call lineout tempfile,'<input type="hidden" name="DEREGISTER" value="1">'
call lineout tempfile,'<ul type="square">'
do imm=1 to apps.0
  call lineout tempfile,'<li><input type="radio" name="REMOVEME" value="'||apps.imm||'">'||apps.imm
end
call lineout tempfile,'</ul>'
call lineout tempfile,'<input type="submit" value="De-Register an addon">'
call lineout tempfile,'<hr><a href="javascript:history.go(-1)">back ... </a>'
call lineout tempfile,'</body></html>'
call lineout tempfile
return 'file type text/html erase name 'tempfile


remove2:

call lineout tempfile,'Removing: <tt>'||opts.!REMOVEME||'</tt>'
call lineout tempfile,'<p>'

foo=sysini(inifile,opts.!REMOVEME,'DELETE:')
if foo='ERROR:' then 
   call lineout tempfile,'<b>Error.</b> Unable to remove 'opts.!REMOVEME
else
   call lineout tempfile,'<tt>'||opts.!REMOVEME||' was de-registered</tt> '
call lineout tempfile,'<hr><a href="javascript:history.go(-1)">back ... </a>'
call lineout tempfile,'</body></html>'
call lineout tempfile
call pmprintf(" oo ")

return 'file type text/html erase name 'tempfile



