/* This addon is used to "re-logon" a user, and to save
   the current privileges assigned to this client 

 For the details, see DYNPRIV.TXT

*/
dynP_log:

parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,client_ip,privset,,
          uri,host_nickname,id_info,aiter,attribs

if verb=" " then do
   say "This SREhttp/2 procedure is not meant to be run in standalone mode "
   exit
end  

if aiter='' & privset='' then return 'PRIVS_LOOK'

/* This only has one argument:
     a) a URL, or
     b) a temp-storage identifier
*/

/* If ?%%xxx, this is a "2nd stage" response. So do it */
if abbrev(list,'%%')=1 then do
   rcode=got_response()
   return rcode
end

/* this is the first stage. */

/*  If list is empty, use referer: request header (if it exists)*/
aurl=list
if aurl='' then do
   aurl=sre_reqfield('REFERER',,id_info)
   if aurl<>'' then do
      if abbrev(translate(aurl),'HTTP://')=1 then
         parse var aurl . '//' . '/' aurl
   end
end

aduration=15

/* get attributes of aurl, so as to determine realm */
attribs=sreh2_get_attributes(host_nickname,aurl,,id_info)

realm=sreh2_get_attributes(host_nickname,aurl,'REALM',id_info,attribs)
if realm='' then realm=sreh2_value('REALM_DEFAULT',,host_nickname)

opts=sreh2_get_attributes(host_nickname,aurl,'OPTIONS',id_info,attribs)
do until opts=''
    parse var opts aopt '0d0a'x opts
    if aopt='' then iterate
    parse upper var aopt . oname oval 
    if oname='DYNPRIV_DURATION' then do
       aduration=strip(oval)
       if datatype(aduration)<>'NUM' then aduration=15
       leave
    end
end 

temp_id=reqnum||'_'||random(1000,9999)

authh=sre_reqfield('Authorization')
username=sre_extract_username(authh)
uname=strip(translate(username))
stuff=sreh2_get_userinfo(authh,host_nickname,id_info)

if stuff='' then do   /* not currently logged on with valid username */
  dodigest=sre_value('DIGEST_AUTH',,'SRE')-1    
     sht_mess='Please enter a valid (for this site) username &amp; password'
  rcode=sre_auth_response(realm,servername,dodigest,,id_info,sht_mess)     
  return rcode
end 

if uname<>'' then do
   oldpriv=sreh2_dynamic_privs('READ','!USER:'||username,,,id_info)
   if oldpriv<>'' then 
        privset=oldpriv
   else
        privset=uname||'  '||privset
end   

info=aurl||'  ;  '||realm||'  ;  '||uname||'  ;  '||aduration||'  ;  '||privset

foo=sreh2_dynamic_privs('WRITE',temp_id,info,,id_info)

/* now do an authorization request */

/*ask for redirect to 2nd stage form (/dynp_log.cmd?%%temp_id) */
rcode=sre_move_response(302,'/dynp_log.cmd?%%'||temp_id,servername,,,0)

return rcode

/*********************/
/* a response, of the form /dynp_log.cmd?%%temp_id */
got_response:

temp_id=substr(list,3)
foo=sreh2_dynamic_privs('READ',temp_id,aurl,,id_info)||'   '

parse var foo aurl ' ; ' old_realm ' ; ' old_username ' ; ' duration ' ; ' oldprivs

authh=sre_reqfield('Authorization')

stuff=sreh2_get_userinfo(authh,host_nickname,id_info)

if stuff='' then do   /* not currently logged on with valid username */
  dodigest=sre_value('DIGEST_AUTH',,'SRE')-1    
     sht_mess='Please enter a new and valid (for this site) username &amp; password'
  rcode=sre_auth_response(old_realm,servername,dodigest,,id_info,sht_mess)     
  return rcode
end 



username=sre_extract_username(authh)

/* if username has not changed, send an authorization response */

username=translate(strip(username))
if old_username=username then do        /* send auth response if same username */
  dodigest=sre_value('DIGEST_AUTH',,'SRE')-1    
  if username<>'' then
     sht_mess='Although your current (<tt> '||username||'</tt>) is valid, it has insufficient privileges. Please enter a different username &amp; password '
  else
     sht_mess='Please enter a username &amp; password'
  rcode=sre_auth_response(old_realm,servername,dodigest,,id_info,sht_mess)     
  return rcode
end 

/* if here, different usernames. */
foo=sreh2_dynamic_privs('DELETE',temp_id,,,id_info)
if oldprivs<>'' then do
  if  privset <> ' ' then 
     newprivs=oldprivs||' ; '||username||' '||privset
  else
     newprivs=oldprivs||' ; '||username
end
else do
   newprivs=username||' '||privset
end

duration=strip(duration)
foo=sreh2_dynamic_privs('WRITE','!USER:'||username,newprivs,duration,id_info)

/* and send success message, or redirect to the URL */
if  aurl<>'' then do
  rcode=sre_move_response(302,aurl,servername,,0)
  return rcode
end
else do
    rcode=sre_command('String You have been granted "dynamic" privileges.',,id_info)
end
return rcode



