/* POSTMAIL: A SREhttp/2 post-response procedure

This will automatically send "e-mail alerts" to specified recipients 
given specified events. 

It requires that a valid SMTP Gateway be available. 
You can use the SMTP_GATEWAY (in the user-configurable parameters
section below) parameter to specify this smtp gateway address.

Or, leave it blank, and the SMTP_GATEWAY parameter stored in
SRE_UTIL.CFG is used (assuming one was set).

  **  If an smtp gateway address is not available,  **
  ** this post-response procedure will do nothing.  **

Note: you should be able to use OS/2's SENDMAIL program to 
      use your web-server machine as an SMTP gateway -- 
      see the bottom of this file for further discussion.

To use this post-response procedure, you will need to set up an "event" list.  
The event list should contain the following information:

 a)   What type of events to examine (client or request selector)
 b)   The value that triggers a "match" (i.e.; a client's address, 
      or a request for a particular file)
 c)   The list of e-mail addresses to send "e-mail alerts" to
 d)   An optional message to include in these alerts.
 e)   An optional subject line

This routine uses the EVENTS.field.n  stem variables to store this event list,
where field should take one of the following values:

   Field   ==         value 
  -------  :     -----------------
    TYPE   : Either CLIENT or REQUEST or HTTPCODE
               CLIENT is the client's IP address (or domain name)
               REQUEST is the "request selector"
               HTTPCODE is the http response code
    VALUE  : An IP (name or numeric) address, or a request selector.  
             Either may contain * (wildcard) characters
 RECIPIENTS: A space delimited list of e-mail addresses
   MESSAGE : An optional message.  It may contain CRLFs, and be quite long.
             If not set, then the POST_RESPONSE parameter is used
   SUBJECT : An optional 1 line text string to use as the SUBJECT.

   n (in events.field.n) should be an integer value (that should run 
   from 1.. "# of events")

You also must set EVENTS.0 equal to the "# of  events"
 
The algorithim works by:

For m=1.. to EVENTS.0
 
  If EVENTS.TYPE.m='CLIENT', then 
     see if client's numeric IP address matches EVENTS.VALUE.m 
     (with * acceptable as a wildcard)

  If EVENTS.TYPE.m='REQUEST', then
     see if the client's request selector matches EVENTS.VALUE.m,

     NOTE: The SEL0 parameter is used. This is the original request,
           with !SPECIAL commands stripped off, and URL decoded.
           It does NOT have internal redirection or ~ substituton.
           Also note that "query strings" (following a ?) are part of
           sel0.

  If EVENTS.TYPE.m='HTTPCODE' then
    see if the http response code matches EVENTS.VALUE.m.
    * (wildcard) matches are allowed. 

      
  If either of these 3 "events" occurs:
      Create a note containing time, date, server name, client's name, 
      the response code, and a message (as stored in EVENTS.MESSAGE.m)
      Note that 
        > EVENTS.MESSAGE.m is optional.
        > If EVENTS.SUBJECT.j is missing, a generic subject line is used.

      The note is sent to each e-mail addresss listed in EVENT.RECIPIENTS.m

There may be multiple matches; hence several different e-mail alerts (to
different sets of e-mail addresses, some of which may contain common 
addresses) may be generated by each call to this post-response procedure.

Example  -- note that the numbering goes from 1 (first event) to 3 (third event):

EVENTS.0=4

EVENTS.TYPE.1="CLIENT"
EVENTS.VALUE.1="*"
EVENTS.RECIPIENTS.1="bob@hisorg.net  jill@staff.agency.gov "

EVENTS.TYPE.2="REQUEST"
EVENTS.VALUE.2="PROJECTS/PROJ1.HTM"
EVENTS.RECIPIENTS.2="ANDREW@myorg.org"
EVENTS.MESSAGE.2="A request for PROJ1 was recieved "
events.subject.2=' PROJ1 Request '

EVENTS.TYPE.3="REQUEST"
EVENTS.VALUE.3="/PUT_FILE*"
EVENTS.RECIPIENTS.3="WEBMASTER@MYORG.ORG"
EVENTS.MESSAGE.3="A file upload has been recieved! "||'0d0a'x||'Do not forget to move it.'

EVENTS.TYPE.3="HTTPCODE"
EVENTS.VALUE.4="5*"
EVENTS.RECIPIENTS.4="TECHSUPPORT@MYORG.ORG"
EVENTS.MESSAGE.4="A 5xx error occured: "||request_line


Notes:

  *  EVENTS.MESSAGE.1 is not set, so no message is sent
  *  A CLIENT type with a VALUE of * means "all requests".
  *  EVENTS.MESSAGE.3 uses '0d0a'x to insert a line feed
  *  When considering EVENTS.TYPE.m=REQUEST, a leading / is ignored.
  *  In EVENTS.VALUE.4, the '5*' is used to match all "server error" responses.
     Also, note that EVENTS.MESSAGE.4 uses the ||request_line to append
     the current "request line" to the message sent to TECHSUPPORT@MYORG.ORG.

  * If you are using OS/2's SENDMAIL as an SMTP gateway, you might want to
    read the short appendix at the bottom of this file.


            --------------------------------------------------
*/


  
postmail:
CRLF = '0d0a'x
signal on syntax name error2
signal on error name error2

parse arg request_line,source,sel0,seluse2,reqnum,user , ,
           usedfile,rcode,host_nickname,id_info,post_response

/*  ==============  User configurable parameters   ================  */

EVENTS.0=0

/* SMTP gateway. If not specified, will check environment for
   a SMTP_GATEWAY variable in SRE_UTIL.CFG */
gateway='' 

/* optional: set verbose=1 to echo status stuff, 2 more stuff, 0 for quiet operation */
verbose=0

/* optional: name of sender. If left blank, or =0, a generic name is used.
   Warning: If you are using your ISP's SMTP gateway, you may need to 
            use a recognized e-mail address (to identify yourself as 
            someone with email sending privileges) */
sender_name='' 


/* ============ DO NOT CHANGE BELOW HERE  ===================== */


parse arg request_line,source,sel0,seluse2,reqnum,user , ,
           usedfile,rcode,host_nickname,id_info,post_response

parse var source serveraddr serverport transaction_number clientaddr clientport

if gateway='' then do
  gateway=sreh2_value('SU_SMTP_GATEWAY',,host_nickname)
  if gateway='' then do
     was_init=sreh2_value('SU_CURRENT_PROCESS',,host_nickname,,1)
     if wasinit='' then do
        foo=sreh2_sre_util_cfg(host_nickname)
        gateway=sreh2_value('SU_SMTP_GATEWAY',,host_nickname)
     end 
  end
end

if symbol('sender_name')<>'VAR' then sender_name=' '
if sender_name=0 then sender_name=' '

if gateway=0 then do                    /* if no gateway specified, do nothing */
  call sre_pmprintf(' POSTMAIL: No gateway specified ')
  return ' '
end

if events.0=0 then do   /* no events specified */
     return ' '
end 

sname=sre_servername()
cname=sre_clientname(clientaddr)

atime=time()
adate=date()
CRLF = '0d0a'x

/* loop through events list .. */
didit=0
tsel0=translate(strip(sel0))

do jj=1 to events.0

/* properly specified EVENTS list? */
    if symbol('EVENTS.TYPE.'||jj)<>'VAR' then do
        if verbose>0 then call sre_pmprintf(" POSTMAIL warning: EVENTS.TYPE."jj" not specified. ")
        iterate
    end
    if symbol('EVENTS.VALUE.'||jj)<>'VAR' then do
        if verbose>0 then call sre_pmprintf(" POSTMAIL warning: EVENTS.VALUE."jj" not specified. ")
        iterate
    end
    ok=0

/* look for a match */
   if events.TYPE.jj="HTTPCODE" then do 
      parse var rcode hcode . ;hcode=strip(hcode)
      ii=sre_wild_match(hcode,events.value.jj)
      if ii<>0 then ok=1
   end

   if events.TYPE.jj="CLIENT" then do 
        ool=verify(events.value.jj,'1234567890*.')
        if ool=0 then
           ok=goodip(events.VALUE.jj,clientaddr)
        else
           ok=goodip(events.VALUE.jj,translate(cname))
   end
   if events.type.jj='REQUEST' then do
       if events.type.jj='REQUEST' then do
          ok=goodsel(upper(events.value.jj),tsel0)
       end
    end
    if ok=0 then iterate

    if didit=0 & verbose>0 then  call sre_pmprintf(" Using SMTP gateway at " gateway)
    didit=1


/* if here, a match occurred */
   address_list=events.recipients.jj
 
   if symbol('events.subject.jj')='VAR' then  
          asubject='Subject: '||events.subject.jj
   else
          asubject='Subject: Notification of WEB transaction  '

   themessage="Date: " || adate || ' ' ||atime
   if sender_name=' ' then
      themessage=themessage||crlf||'From: WebServer@'||sname
   else
      themessage=themessage||crlf||'From: 'sender_name

   themessage=themessage||crlf||asubject
   themessage=themessage||crlf||'To: '||address_list||crlf

   themessage=themessage||crlf||'An e-mail alert from the Web Server at '||sname
   themessage=themessage||crlf||"    Date of occurrence: " || adate || ' ' ||atime
   themessage=themessage||crlf||'     Request by client: '|| cname
   themessage=themessage||crlf||'      Request selector: '|| sel0

   if symbol('events.message.jj')='VAR' then do /* check for a message */
      themessage=themessage||crlf||crlf||"Notes:"||crlf||crlf||events.message.jj||crlf
   end
   else do
      if post_response<>"1" then 
         themessage=themessage||crlf||crlf||"Notes:"||crlf||crlf||post_response||crlf
      else
         themessage=themessage||crlf
   end
   foo=sreh2_mailit(address_list,themessage, gateway,sender_name,verbose)
   if verbose>0 then callx=sre_pmprintf(" Event " jj ", MAILIT status: "foo,1)

end                     /* try next event */

return ' '

/* -----------------------------------------------------------------------*/
/* see if match (or abbreviation match) the sel                          */
/* -----------------------------------------------------------------------*/
goodsel: procedure 
parse  arg asel,thesel
asel=translate(asel) 
asel=translate(asel,'/','\') ; asel=strip(asel,,'/')
thesel=translate(thesel,'/','\') ; thesel=strip(thesel,,'/')

oo=sre_wild_match(thesel,asel)
if oo=0 then return 0           /* no match */
return 1



/* -----------------------------------------------------------------------*/
/* see if matches one of a set of good ips (1 if yes)*/
/* -----------------------------------------------------------------------*/
goodip: procedure 

parse upper arg anips,cip0

oo=sre_wild_match(cip0,anips)
if oo=0 then return 0           /* no match */
return 1



/******/
/* here on error */
error2:
signal off syntax ; signal off error
call sre_pmprintf(' Error in POSTMAIL at line ' sigl)
return 0




/*****/
/* A note on using SENDMAIL (10 Nov 2002)

 Sigh, we can't seem to get SENDMAIL to work (although we have in the past).
 Let us know if it's real important (danielh@crosslink.net) and we'll
 take another crack at it.

*/
