/*SREhttp/2 postfiler: record client & request specific information for

This will record clientname, and other information, when certain
events happen. These events are:
  a) a selector was requested
  b) a request led to the use of a file

To specify events, modify the EVENTS. stem variable in the user-configurable
parameters section.

   * EVENTS.0  should equal the number of events you want to define
   * EVENTS.n ; n =1 to EVENTS.0, are the event definitions

Each event definition has the syntax (note the "commas" before 
and after "putfile", but NOT between TYPE and VALUE):

   EVENTS.n ='TYPE  VALUE , OUTFILE, AMESSAGE '

where:
   TYPE : Either URL or FILE -- refers to SEL0 and USEDFILE (respectively)
   VALUE: The, possibly *-wildcard containing, string to compare to
          SEL0 or  USEDFILE.
          Value may contain embedded spaces (but not leading or trailing
          spaces).
   OUTFILE:  Fully qualified file name (results will be written there )
   AMESSAGE optional message to write.
            If AMESSAGE is not specified, then write POST_RESPONSE

Basically...
  If the "VALUE" of an entry matches the "SEL0" or "USEDFILE", 
  then a short report (possibly containing the "AMESSAGE") is 
  written to "OUTFILE".

  Note that "SEL0" is the requst selector, after !SPECIAL commands have
  been stripped, and after url-decoding.

  USEDFILE is the actual file SREhttp/2 used (say, the file transmitted
  to the client). In some cases (such as requests for addons), this will
  be blank.

Example:
 events.1=' file  d:\www\zoo\tigers.htm,  d:\goserve\tigers.lst '
 events.2=' url   members/renewal.htm , d:\users\incoming\renew.in '
 events.3=' url   staff/ *  ,  d:\staff\wwwbiz.log , A staff-member visited. '
 events.0=3

Notes:
   Make sure you set EVENTS.0 (in the above example case, EVENTS.0=3) 
   All matches will be honored -- more then one "recording" may occur.

*/
postrcrd:

CRLF = '0d0a'x

/*  ==============  INSERT  EVENTS list here   ================  */

events.0=0



/* ============ DO NOT CHANGE BELOW HERE  ===================== */


parse arg request_line,source,sel0,seluse2,reqnum,user , ,
           usedfile,rcode,host_nickname,id_info,post_response

parse var source myaddr port transaction who whoport . /* Often useful */
parse var request verb uri protocol .        /* split up the request line */
usedfile=strip(translate(usedfile)) ; sel0=strip(translate(sel0))

do mm=1 to events.0
  parse upper var events.mm type avalue ',' afile ',' amessage
  type=strip(type); avalue=strip(avalue); afile=strip(afile)
  filematch=0
  selmatch=0
  select
    when type='FILE' then do
       ares=sre_wild_match(usedfile,avalue)
       if ares=0 then iterate
       filematch=1
    end
    when type='URL' | type='SEL' then do
       ares=sre_wild_match(sel0,avalue)
       if ares=0 then iterate   /* no match */
       selmatch=1
    end
    otherwise do
        call sre_write_error(' Error in post-filter recorder. Bad Event entry: ' events.mm,,1)
        iterate
    end   /* otherwise */
  end   /* select */

 clientname=sre_clientname(who)
 thereferer=sre_reqfield('REFERER',,id_info)
 adate=date() ; atime=time()
 amess=crlf||date() ' ' time()||crlf
 amess=amess||' Request #'||reqnum||' from: ' ||who|| ' ( ' clientname' )'||crlf
 amess=amess||' to host: '||host_nickname||crlf
 amess=amess||' Referer: '||thereferer||crlf
 if filematch=1 then amess=amess||' File= ' usedFile || crlf
  if selmatch=1 then amess=amess||' URI= ' sel0|| crlf
 amess=amess||' Result: '||rcode||crlf
 if post_response=1 then post_response=''
 if amessage='' & post_response<>1 then amessage=Post_response
 amess=amess||' Message: ' amessage
 astat=sre_append_file(afile,amess,2,1)
 if abbrev(astat,'-')=1 then
    foo=sre_write_error('POSTRCRD: unable to append to 'afile,,1)
end                     /* end do */
return ' '




