"""
An object containing well-formed text/xml format data
"""
# $Id: XMLFile.py,v 1.1.1.1 2002/02/03 17:07:16 root Exp $
#
# $Log: XMLFile.py,v $
# Revision 1.1.1.1  2002/02/03 17:07:16  root
#
#
# Revision 1.6  2001/11/14 17:08:49  adrian
# Corrected Auto Update bug where changing properties failed to
# cause a data-reload.
# Changed XMLODBCClient to return brains instead of XML
# (DOM(self) returns the DOM for clients if required)
#
# Revision 1.5  2001/10/31 01:25:46  adrian
# Fixed several problems with creation and editing of XMLFiles
# Fixed pretty-printing of XML (Indentation)
#
# Revision 1.4  2001/10/29 09:20:48  adrian
# Cleaned up a number of "Ambiguous name..." warnings
#
# Revision 1.3  2001/10/24 15:34:12  adrian
# Completed factoring out common code into 3 base classes
# (XMLClientBase, XMLServerBase, and XMLReloadBase)
#
# Completed XMLProxy.
#
# Revision 1.2  2001/10/21 15:10:15  adrian
# no message
#
#
__version__ = '$Revision: 1.1.1.1 $'[11:-2]

import Globals
import AccessControl.Role
import OFS.SimpleItem
import OFS.PropertyManager
import Persistence
import Acquisition
import XML
import OFS.History
import DateTime
import urllib
import XMLKitBase

manage_addXMLFileForm = Globals.HTMLFile('www/addXMLFile', globals())
def manage_addXMLFile(self, id='', title='', submit=None, REQUEST=None):
    """ """
    obj = XMLFile(str(id), str(title))
    self._setObject(obj.getId(), obj)
    if REQUEST is not None:
        try: u=self.DestinationURL()
        except: u=REQUEST['URL1']
        if submit==" Add and Edit ": u="%s/%s" % (u, urllib.quote(obj.getId()))
        REQUEST.RESPONSE.redirect(u+'/manage_workspace')
    return ''

class XMLFile(
        XMLKitBase.XMLServerBase,
        OFS.PropertyManager.PropertyManager,
        OFS.SimpleItem.SimpleItem,
        Persistence.Persistent,
        Acquisition.Implicit,
        AccessControl.Role.RoleManager,
        OFS.History.Historical,
    ):
    """ A simple method type object that contains parsed XML and returns it when called """
    id = "XMLFile"
    title = "XML File"
    meta_type = "XML File"
    index_html = None

    # Masquerade as function:
    class func_code: pass
    func_code=func_code()
    func_code.co_varnames='self','REQUEST','RESPONSE'
    func_code.co_argcount=3

    manage_main = Globals.HTMLFile('www/editXMLFile', globals())
    manage_options = (
        (
            {'label': 'Edit', 'action': 'manage_main',
             'help':('XMLKit', 'editXMLFile.stx'), },
        ) +
        OFS.PropertyManager.PropertyManager.manage_options +
        XMLKitBase.XMLServerBase.manage_options +
        OFS.History.Historical.manage_options +
        OFS.SimpleItem.SimpleItem.manage_options
    )
    _properties=(
        XMLKitBase.XMLServerBase._properties +
        (
            {'id':  'title', 'type': 'string', 'mode': 'w'},
        )
    )
    _size_changes={
        'Bigger': (5,5),
        'Smaller': (-5,-5),
        'Narrower': (0,-5),
        'Wider': (0,5),
        'Taller': (5,0),
        'Shorter': (-5,0),
        }

    def _internal_getDOMref(self):
        """ Return a reference to the DOM """
        return self.DOM

    def _auto_reload(self):
        """ """
        return 1

    def __init__(self, id, title):
        """ """
        self.id = id
        self.title = title
        DOM = XML.Node.Document()
        DOM.addChild(XML.Node.XMLNode())
        DOM.addChild(XML.Node.Node('root')).addCDATA('Your XML Data Goes Here')
        self.DOM = DOM

    def _er(self, data, title, SUBMIT, dtpref_cols, dtpref_rows, REQUEST):
        """ Resize the edit field """
        dr,dc = self._size_changes[SUBMIT]
        rows=max(1,atoi(dtpref_rows)+dr)
        cols=max(40,atoi(dtpref_cols)+dc)
        e=(DateTime('GMT') + 365).rfc822()
        resp=REQUEST['RESPONSE']
        resp.setCookie('dtpref_rows',str(rows),path='/',expires=e)
        resp.setCookie('dtpref_cols',str(cols),path='/',expires=e)
        return self.manage_main(
            self,REQUEST,title=title,__str__=self.quotedHTML(data),
            dtpref_cols=cols,dtpref_rows=rows)

    def manage_edit(self, data, title, SUBMIT='Change', dtpref_cols='50',
                    dtpref_rows='20', REQUEST=None):
        """ Replaces an XMLFiles contents with Data, Title with Title """
        if self._size_changes.has_key(SUBMIT):
            return self._er(data,title,SUBMIT,dtpref_cols,dtpref_rows,REQUEST)
        self.title=str(title)
        if type(data) is not type(''):
            data=data.read()
        self.manage_upload(data)
        if REQUEST:
            message="Saved changes."
            return self.manage_main(self, REQUEST, manage_tabs_message=message)

    def manage_upload(self, file='', REQUEST=None):
        """ Replace the contents of the file with the text in file """
        if type(file) is not type(''):
            file=file.read()
        xp = XML.XMLParser.XMLParser()
        xp.runString(file)
        self.DOM = xp.DOM
        if REQUEST:
            message="Saved changes."
            return self.manage_main(self, REQUEST, manage_tabs_message=message)

    def dump(self, REQUEST=None):
        """ Return unprocess XML """
        return self._internal_getDOMref().dump()

Globals.default__class_init__(XMLFile)
