"""
    ZVisualQuery
    ============

A complete data query, collation, and reporting tool.

One of the main features of this product is that you do not need any
SQL programming skills - everything is visual!
"""
# $Id: ZVisualQuery.py,v 1.2 2002/05/17 22:43:14 adrian Exp $
#
# $Log: ZVisualQuery.py,v $
# Revision 1.2  2002/05/17 22:43:14  adrian
# *** empty log message ***
#
# Revision 1.1.1.1  2002/02/03 17:07:16  root
#
#
# Revision 1.11  2002/01/21 13:16:53  adrian
# Changing database connection_id no longer resets the query.
#
# Revision 1.10  2002/01/21 00:58:09  adrian
# Rebased all queries and datacombiner on the Aqueduct DA
# Added argument support
# Added Drill-Down support to ZReportTool
#
# Revision 1.9  2002/01/15 17:32:37  adrian
# Factored out common code in all-QT and ZDC
# Added support for comparing against constants in all-QT
# Added support for multi-column joins in all-QT
# Added sorting to ZRT
# Added no-print group type to ZRT
# You now set the connection ID when creating a ZVQ
# added property support to ZVQ
# Corrected display of calculated columns in ZRT
#
# Revision 1.8  2002/01/14 19:18:49  adrian
# Fixed bug where ZVisualQuery and ZVisualODBCClient validate the
# table selections and joins before any tables had been selected.
#
# Revision 1.7  2002/01/13 21:08:58  adrian
# Completed relational logic in ZDataCombiner.
# Fixed up compatibility bugs in combiner and report.
# Started online help pages.
#
# Revision 1.6  2002/01/13 09:50:24  adrian
# Fixed bug in _VisualQueryMixin that where there last character of the table
# name got lost if there was only one table in the query
#
# Revision 1.5  2002/01/13 01:22:49  adrian
# Added brain support to ODBC Socket Client
# Completed Visual Query Designer and Visual ODBC Query Designer
#
# Revision 1.4  2002/01/02 07:55:37  adrian
# Added initial support for Visual ODBC Client
#
# Revision 1.3  2001/10/29 09:29:56  adrian
# Cleaned up a number of "Ambiguous name..." warnings
#
# Revision 1.2  2001/10/21 15:03:36  adrian
# no message
#
#
__version__ = '$Revision: 1.2 $'[11:-2]

# Todo:
#  Change all lists to use ZMI colours

import urllib
import Globals
import OFS.PropertyManager
from Products.ZSQLMethods.SQL import SQLConnectionIDs
import Shared.DC.ZRDB.DA
from Shared.DC.ZRDB.Aqueduct import parse
from App.Extensions import getBrain
import VisualQueryMixin
try: from IOBTree import Bucket
except: Bucket=lambda:{}

manage_addZVisualQueryForm = Globals.HTMLFile('www/addZVisualQuery', globals())
def manage_addZVisualQuery(self, id, title='', connection_id='', submit='', REQUEST=None):
    """ """
    obj = ZVisualQuery(str(id), title=str(title), connection_id=str(connection_id))
    self._setObject(obj.getId(), obj)
    if REQUEST is not None:
        try: u = self.DestinationURL()
        except: u = REQUEST['URL1']
        if submit==" Add and Edit ": u="%s/%s" % (u, urllib.quote(id))
        REQUEST.RESPONSE.redirect(u+'/manage_main')
    return ''

class ZVisualQuery(
        OFS.PropertyManager.PropertyManager,
        VisualQueryMixin._VisualQueryMixin,
        Shared.DC.ZRDB.DA.DA,
    ):
    """ A Visual ZSQL Query Creator/Editor """
    manage_main = Globals.ComputedAttribute.ComputedAttribute('manage_propertiesForm')
    manage_Tables = Globals.HTMLFile('www/queryTables', globals())
    id = 'ZVisualQuery'
    title = 'Z Visual Query'
    meta_type = 'Z Visual Query'

    manage_options = (
        OFS.PropertyManager.PropertyManager.manage_options +
        VisualQueryMixin._VisualQueryMixin.manage_options +
        Shared.DC.ZRDB.DA.DA.manage_options[1:]
    )
    _properties	= (
        {'id': 'title',         'type': 'string',   'mode': 'w'},
        {'id': 'connection_id', 'type': 'selection','mode': 'w', 'select_variable': 'SQLConnectionIDs'},
    )

    src = ""
    arguments_src = ""

    def __init__(self, id, title="", connection_id=""):
        """ """
        self.id = str(id)
        self.title = str(title)
        self.connection_id = str(connection_id)
        self.manage_resetQuery()

#    def _updateProperty(self, id, value):
#        """ Catch changes to properties and recache the DOM """
#        OFS.PropertyManager.PropertyManager._updateProperty(self, id, value)
#        if id == 'connection_id':
#            self.manage_resetQuery()

    def listTables(self):
        """ Return a list of table data in the selected connection """
        try:
            if not self.tableCache:
                db = getattr(self, self.connection_id)
                conn = db._v_database_connection
                self.tableCache = conn.tables(rdb=0)
        except:
            pass
        return self.tableCache

    def listColumns(self, table):
        """ Return a list of the columns in a table """
        db = getattr(self, self.connection_id)
        conn = db._v_database_connection
        list = conn.columns(table)
        return list

Globals.InitializeClass(ZVisualQuery)
