Title   filter socket services PCI write access

a_proc                  strat_filter_socketdriver_pci
                        cmp es:RequestBlock[bx].Command_Code,01bh
                        jne not_strat_filter_socketdriver_pci_basedevinit

                        mov es:RequestBlock[bx].Pointer_1._OFF,Offset end_resident_code
                        mov es:RequestBlock[bx].Pointer_1._SEG,Offset end_resident_data

  not_strat_filter_socketdriver_pci_basedevinit:
                        mov word ptr es:RequestBlock[bx].Request_Packet_Status,0100h
                        retf
a_endp                  strat_filter_socketdriver_pci

;
                        ; eax=cf8 dword
                        ; ->CF
a_proc                  test_write_protect
			push ds
                        push dx
                        push si
                        
                        ; only write protect.. 
                        sub dx,dx		; for clc in skip write protection case
                        
                        ; - command register (W[04])
                        cmp al,004h
                        jb ignore_write_protection
                        cmp al,006h
                        jb test_write_protection
                        
                        ; - BAR0 register (L[10])
                        cmp al,010h
                        jb ignore_write_protection
                        cmp al,014h
                        jb test_write_protection
                        
  test_write_protection:
                        ror eax,8               ; ah=bus,al=device/function

                          mov dx,data16
                          mov ds,dx
                          mov si,Offset filter_table
  test_write_protect_loop:
                          mov dx,[si].mask
                          test dx,dx
                          jz test_write_protect_next
                          and dx,ax
                          sub dx,[si].addr
                          jz test_write_protect_found ;dx=0->stc

  test_write_protect_next:
                          add si,Type filter_entry
                          cmp si,Offset filter_table_end
                          jne test_write_protect_loop

                          mov dx,1              ; clc

  test_write_protect_found:
                        rol eax,8
  ignore_write_protection:
                        pop si
                        cmp dx,1                ; set stc/clc
                        pop dx
                        pop ds
                        ret
a_endp                  test_write_protect

;

a_proc  ibmcode_write_pci_byte
        db 066h,00dh,000h,000h,000h,080h        ; or      eax, 80000000h
        db 0bah,0f8h,00ch                       ; mov     dx, 0CF8h
        db 066h,0efh                            ; out     dx, eax
        db 0bah,0fch,00ch                       ; mov     dx, 0CFCh
        db 08bh,0c7h                            ; mov     ax, di
        db 083h,0e0h,003h                       ; and     ax, 3
        db 003h,0d0h                            ; add     dx, ax
        db 08ah,0c1h                            ; mov     al, cl
        db 0eeh                                 ; out     dx, al
a_endp  ibmcode_write_pci_byte

a_proc                  replace_ibmcode_write_pci_byte
                        or eax,(1 shl 31)
                        call test_write_protect
                        jc exit_replace_ibmcode_write_pci_byte
                        mov dx,0cf8h
                        out dx,eax
                        mov dx,di
                        and dx,3
                        add dx,0cfch
                        mov al,cl
                        out dx,al
  exit_replace_ibmcode_write_pci_byte:
                        retf
a_endp                  replace_ibmcode_write_pci_byte
;

a_proc  ibmcode_write_pci_word
        db 066h,00dh,000h,000h,000h,080h        ; or      eax, 80000000h
        db 0bah,0f8h,00ch                       ; mov     dx, 0CF8h
        db 066h,0efh                            ; out     dx, eax
        db 0bah,0fch,00ch                       ; mov     dx, 0CFCh
        db 08bh,0c7h                            ; mov     ax, di
        db 083h,0e0h,003h                       ; and     ax, 3
        db 003h,0d0h                            ; add     dx, ax
        db 08bh,0c1h                            ; mov     ax, cx
        db 0efh                                 ; out     dx, ax
a_endp  ibmcode_write_pci_word

a_proc                  replace_ibmcode_write_pci_word
                        or eax,(1 shl 31)
                        call test_write_protect
                        jc exit_replace_ibmcode_write_pci_word
                        mov dx,0cf8h
                        out dx,eax
                        mov dx,di
                        and dx,3
                        add dx,0cfch
                        mov ax,cx
                        out dx,ax
  exit_replace_ibmcode_write_pci_word:
                        retf
a_endp                  replace_ibmcode_write_pci_word

;

a_proc  ibmcode_write_pci_dword
        db 066h,00dh,000h,000h,000h,080h        ; or      eax, 80000000h
        db 0bah,0f8h,00ch                       ; mov     dx, 0CF8h
        db 066h,0efh                            ; out     dx, eax
        db 0bah,0fch,00ch                       ; mov     dx, 0CFCh
        db 08bh,0c7h                            ; mov     ax, di
        db 083h,0e0h,003h                       ; and     ax, 3
        db 003h,0d0h                            ; add     dx, ax
        db 066h,08bh,0c1h                       ; mov     ax, cx
        db 066h,0efh                            ; out     dx, ax
a_endp  ibmcode_write_pci_dword

a_proc                  replace_ibmcode_write_pci_dword
                        or eax,(1 shl 31)
                        call test_write_protect
                        jc exit_replace_ibmcode_write_pci_dword
                        mov dx,0cf8h
                        out dx,eax
                        mov dx,di
                        and dx,3
                        add dx,0cfch
                        mov eax,ecx
                        out dx,eax
  exit_replace_ibmcode_write_pci_dword:
                        retf
a_endp                  replace_ibmcode_write_pci_dword

;
                        ; cs:si=search string
                        ; es:0,cx=search area
                        ; bp=replacement procedure
a_proc                  search_replace_code
                        pusha

                          sub di,di                     ; start at es:0
                          mov dx,bp                     ; length=begin-next code
                          sub dx,si

                          mov al,Byte Ptr cs:[si]
                          cld
                          sub cx,dx                     ; not search beyond end
                          jbe exit_search_replace_code
  loop_search_replace_code:
                          repne scasb
                          jne exit_search_replace_code

                          push si
                          push di
                          push cx
                            inc si
                           ;mov di,di
                            mov cx,dx
                            dec cx
                            segcs
                            repe cmpsb
                          pop cx
                          pop di
                          pop si
                          jne loop_search_replace_code

                          dec di
                          pusha
                          push es

                            mov cx,dx

                            ; map memory at es:di,cx writeable..

                            ; virtual es:di -> physical ax:bx
                            push ds
                            push es
                            pop ds              ; ds:si=memory
                            pop es              ; es=data16 (for Device_Help)
                              mov si,di
                              mov dl,016h       ; DevHlp_VirtToPhys
                              call es:[Device_Help]
                            push es             ; restore DS
                            pop ds

                            ; physical ax:bx -> es:di virtual
                           ;mov ax,ax           ; ax:bx physical
                           ;mov bx,bx
                           ;mov cx,cx           ; number of bytes to change
                            mov dh,1            ; get result pointer to es:di
                            mov dl,015h         ; DevHlp_PhysToVirt
                            call [Device_Help]

                            ; disable all old code

                            push di
                              mov al,090h
                              rep stosb
                            pop di

                            ; replace with a call to replacement code

                            mov Byte Ptr es:[di+0],09ah
                            mov Word Ptr es:[di+1],bp
                            mov Word Ptr es:[di+3],cs

                          pop es
                          popa
                          add di,dx
                          jmp loop_search_replace_code

  exit_search_replace_code:

                        popa
                        ret
a_endp                  search_replace_code

;

a_proc                  patch_socket_driver
                        push es
                        pushad

                          mov ax,socket_driver_attach.IDC_CS_ring0
                          lsl cx,ax
                          jnz exit_patch_socket_driver

                          mov es,ax
                          mov bx,Offset socket_patch_table
  all_socket_patches_loop:
                          mov si,Word Ptr ds:[bx+0]
                          mov bp,Word Ptr ds:[bx+2]
                          call search_replace_code
                          add bx,2+2
                          cmp bx,Offset socket_patch_table_end
                          jne all_socket_patches_loop

  exit_patch_socket_driver:

                        popad
                        pop es
                        ret
a_endp                  patch_socket_driver

;


a_proc                  install_socket_driver_filter
                        cmp socket_driver_patched,true
                        je install_socket_driver_filter_ret

                        mov socket_driver_patched,true


                        pushad
                          mov bx,Offset socket_driver_names-8
  loop_socket_drivers:
                          add bx,8
                          cmp bx,Offset socket_driver_names_end
                          je break_socket_drivers

                         ;mov bx,bx
                          mov di,Offset socket_driver_attach
                          mov dl,02ah           ; AttachDD
                          call [Device_Help]
                          if_nc <call patch_socket_driver>
                          jmp loop_socket_drivers
  break_socket_drivers:
                        popad

  install_socket_driver_filter_ret:
                        ret
a_endp                  install_socket_driver_filter

;

a_proc                  idc_filter_socketdriver_pci
                        push ds
                        push data16
                        pop ds

                        ;--------------------------------------------
                        ; enable write protection
                        ; ah=1 (command)
                        ; bx=bus/device/function
                        ; cx=mask for bx (ffff=exact,fff8=all functions)
                        cmp ah,1
                        jne not_fsp_function_1

                        cmp cx,0fff8h           ; global?
                        jb fsp_generic_error

                        ; search free slot
                        mov si,(Offset filter_table)-(Type filter_entry)
  search_free_slot_loop:
                        add si,Type filter_entry
                        cmp si,Offset filter_table_end
                        je fsp_generic_error
                        cmp [si].addr,0
                        jne search_free_slot_loop
                        cmp [si].mask,0
                        jne search_free_slot_loop

                        mov [si].addr,bx
                        and [si].addr,cx
                        mov [si].mask,cx
                        sub ax,ax
                        call install_socket_driver_filter
                        jmp fsp_function_handled
  not_fsp_function_1:
                        ;--------------------------------------------

                        ;--------------------------------------------
                        ; disable write protection
                        ; ah=2 (command)
                        ; bx=bus/device/function
                        ; cx=mask for bx (ffff=exact)
                        cmp ah,2
                        jne not_fsp_function_2

                        cmp cx,0fff8h           ; global?
                        jb fsp_generic_error

                        ; search slot
                        mov ax,bx
                        and ax,cx
                        mov si,(Offset filter_table)-(Type filter_entry)
  search_slot_loop:
                        add si,Type filter_entry
                        cmp si,Offset filter_table_end
                        je fsp_generic_error
                        cmp [si].addr,ax
                        jne search_slot_loop
                        cmp [si].mask,cx
                        jne search_slot_loop

                        sub ax,ax
                        mov [si].addr,ax
                        mov [si].mask,ax
                       ;sub ax,ax
                        jmp fsp_function_handled

  not_fsp_function_2:
                        ;--------------------------------------------

  fsp_generic_error:
                        mov ax,1                ; command unknown, out of resource

  fsp_function_handled:
                        test ax,ax
                        pop ds
                        retf
a_endp                  idc_filter_socketdriver_pci

;

