{&Use32+}
unit CardServ;
(* V.K. 2002.08.03 *)

interface

uses
  Os2Base;

var
  cslevel               :smallword=$200;
  cshandle              :smallword=$ffff;

const
  SUCCESS               =$000;
  BAD_ADAPTER           =$001;
  BAD_ATTRIBUTE         =$002;
  BAD_BASE              =$003;
  BAD_EDC               =$004;

  BAD_IRQ               =$006;
  BAD_OFFSET            =$007;
  BAD_PAGE              =$008;
  READ_FAILURE          =$009;
  BAD_SIZE              =$00A;
  BAD_SOCKET            =$00B;

  BAD_TYPE              =$00D;
  BAD_VCC               =$00E;
  BAD_VPP               =$00F;

  BAD_WINDOW            =$011;
  WRITE_FAILURE         =$012;

  NO_CARD               =$014;
  UNSUPPORTED_FUNCTION  =$015;
  UNSUPPORTED_MODE      =$016;
  BAD_SPEED             =$017;
  BUSY                  =$018;
  GENERAL_FAILURE       =$019;
  WRITE_PROTECTED       =$01A;
  BAD_ARG_LENGTH        =$01B;
  BAD_ARGS              =$01C;
  CONFIGURATION_LOCKED  =$01D;
  IN_USE                =$01E;
  NO_MORE_ITEMS         =$01F;
  OUT_OF_RESOURCE       =$020;
  BAD_HANDLE            =$021;

  error_Invalid_Parameter=Os2Base.error_Invalid_Parameter;


// from ftl2.h

//----- Layer 1 Data Recording Format Tuples ------
  CISTPL_NULL           =$00;
  CISTPL_DEVICE         =$01;
  CISTPL_CHECKSUM       =$10;
  CISTPL_LONGLINK_A     =$11;
  CISTPL_LONGLINK_C     =$12;
  CISTPL_LINKTARGET     =$13;
  CISTPL_NO_LINK        =$14;
  CISTPL_VERS_1         =$15;
  CISTPL_ALTSTR         =$16;
  CISTPL_DEVICE_A       =$17;
  CISTPL_JEDEC_C        =$18;
  CISTPL_JEDEC_A        =$19;
  CISTPL_CONFIG         =$1A;
  CISTPL_CFTABLE_ENTRY  =$1B;
  CISTPL_DEVICE_OC      =$1C;
  CISTPL_DEVICE_OA      =$1D;

//----- Layer 2 Data Recording Format Tuples ------
  CISTPL_VERS_2         =$40;
  CISTPL_FORMAT         =$41;
  CISTPL_GEOMETRY       =$42;
  CISTPL_BYTEORDER      =$43;
  CISTPL_DATE           =$44;
  CISTPL_BATTERY        =$45;

//------ Layer 3 Data Organization Tuples ------
  CISTPL_ORG            =$46;

//------ Layer 4 System-Specific Standard Tuples ------
  CISTPL_END            =$FF;
  CISTPL_FUNCID         =$21;
  CISTPL_FUNCE          =$22;

// some cardbus
  CISTPL_CONFIG_CB      =$04;
  CISTPL_CFTABLE_ENTRY_CB=$05;
  CISTPL_BAR            =$07;
  CISTPL_MANFID         =$20;



function CS_Open:longint;
function CS_Close:longint;

type
  TCardServicesIOCtlHeader=
    packed record
      Function_Code     :smallword;
      Handle            :smallword;
      Event_Semaphore   :longint;
      Length            :smallword;
    end;

type
  TGetCardServicesInfo  =
    packed record
      IOCtlHeader       :TCardServicesIOCtlHeader;
      wCSInfoLen        :smallword; // Length of data returned by CS
      wCSSignature      :smallword; // Signature
      wCSCount          :smallword; // Count
      wCSRevision       :smallword; // Revision
      wCSCSLevel        :smallword; // CS Level
      wCSVStrOff        :smallword; // Offset to Vendor String
      wCSVStrLen        :smallword; // Vendor String Length
      sCSVendorString   :smallword; // VendorString
      stringbuffer      :array[0..512] of byte;
    //stringbuffer      :array[0..40] of byte;
    end;

function CS_GetCardServicesInfo(var GetCardServicesInfo:TGetCardServicesInfo):longint;

const
  ATR_MemoryCDD         =$0001; // Bit 0 = Memory Client DD
  ATR_MTD               =$0002; // Bit 1 = MTD
  ATR_IOCDD             =$0004; // Bit 2 = I/O Client DD
  ATR_CIForSharable     =$0008; // Bit 3 = CARD_INSERTION For Sharable
  ATR_CIForExclusive    =$0010; // Bit 4 = CARD_INSERTION For Exclusive

type
  TRegisterClient       =
    packed record
      IOCtlHeader       :TCardServicesIOCtlHeader;
      wRCAttributes     :smallword; // Attributes
      wRCEventMask      :smallword; // Event Mask
      wRCClientData1    :smallword; // Client Data 1
      wRCClientData2    :smallword; // Client Data 2
      wRCClientData3    :smallword; // Client Data 3
      reserved          :smallword; // Reserved
      wRCVersion        :smallword; // Client Version Number
    end;

function CS_RegisterClient(var RegisterClient:TRegisterClient):longint;

type
  TDeregisterClient     =
    packed record
      IOCtlHeader       :TCardServicesIOCtlHeader;
    end;

function CS_DeregisterClient(var DeregisterClient:TDeregisterClient):longint;

//function CS_GetStatus;

type
  TGetConfigurationInfo  =
    packed record
      IOCtlHeader       :TCardServicesIOCtlHeader;
      Socket            :smallword;     // logical socket
      Attribute         :smallword;     // bit mask for attributes
      Vcc               :byte;          // vcc setting
      Vpp1              :byte;          // vpp1 setting
      Vpp2              :byte;          // vpp2 setting
      IntType           :byte;          // interrupt? Interface? type
      ConfigBase        :longint;       // base address of registers
      Status_INFO       :byte;          // status register setting
      Pin_INFO          :byte;          // card pin register setting
      Copy_INFO         :byte;          // copy register setting
      Option_INFO       :byte;          // option register setting
      Present_INFO      :byte;          // config registers present
      FirstDevType      :byte;          // 1 //Buffer            :array[1..20] of byte;
      FuncCode          :byte;          // 2
      SysInitMask       :byte;          // 3
      ManuCode          :smallword;     // 4
      ManuInfo          :smallword;     // 6
      CardValues        :byte;          // 8
      AssignedIRQ       :byte;          // 9
      IRQAttributes     :smallword;     // 10
      BasePort1         :smallword;     // 12
      NumPorts1         :byte;          // 14
      Attributes1       :byte;          // 15
      BasePort2         :smallword;     // 16
      NumPorts2         :byte;          // 18
      Attributes2       :byte;          // 19
      IOAddrLines       :byte;          // 20
      unknown_level800  :array[0..30] of byte;
    end;

{
GCIP                    Struc

   wGCISocket           dw    ?
   wGCIAttributes       dw    ?
   bGCIVcc              db    ?
   bGCIVpp1             db    ?
   bGCIVpp2             db    ?
   bGCIIntType          db    ?
   dGCIConfigBase       dd    ?
   bGCIStatus           db    ?
   bGCIPin              db    ?
   bGCICopy             db    ?
   bGCIOption           db    ?
   bGCIPresent          db    ?
   bGCIFirstDevType     db    ?
   bGCIFuncCode         db    ?
   bGCISysInitMask      db    ?
   wGCIManuCode         dw    ?
   wGCIManuInfo         dw    ?
   bGCICardValues       db    ?
   bGCIAssignedIRQ      db    ?
   wGCIIRQAttributes    dw    ?
   wGCIBasePort1        dw    ?
   bGCINumPorts1        db    ?
   bGCIAttributes1      db    ?
   wGCIBasePort2        dw    ?
   bGCINumPorts2        db    ?
   bGCIAttributes2      db    ?
   bGCIIOAddrLines      db    ?

GCIP                    Ends


}


function CS_GetConfigurationInfo(var GetConfigurationInfo:TGetConfigurationInfo):longint;

type
  TGetTuple             =
    packed record
      IOCtlHeader       :TCardServicesIOCtlHeader;
      wGTSocket         :smallword;
      wGTAttributes     :smallword;
      bGTDesiredTuple   :byte;
      bGTReserved       :byte;
      wGTFlags          :smallword;
      dGTLinkOffset     :pointer;
      dGTCISOffset      :pointer;
      bGTTupleCode      :byte;
      bGTTupleLink      :byte;
    end;

function CS_GetFirstTuple(var GetTuple:TGetTuple):longint;
function CS_GetNextTuple(var GetTuple:TGetTuple):longint;

type
  TGetTupleData         =
    packed record
      IOCtlHeader       :TCardServicesIOCtlHeader;
      wGTDSocket        :smallword;
      wGTDAttributes    :smallword;
      bGTDDesiredTuple  :byte;
      bGTDTupleOffset   :byte;
      wGTDFlags         :smallword;
      dGTDLinkOffset    :pointer;
      dGTDCISOffset     :pointer;
      wGTDTupleDataMax  :smallword;
      wGTDTupleDataLen  :smallword;
      bGTDTupleData     :array[0..4096-1] of byte;
    end;

function CS_GetTupleData(var GetTupleData:TGetTupleData):longint;

{function CS_GetFirstRegion;
function CS_GetNextRegion;
function CS_GetFirstPartition;
function CS_GetNextPartition;
function CS_VendorSpecific;
function CS_AdjustResourceInfo;
function CS_GetFirstWindow;
function CS_GetNextWindow;
function CS_GetMemPage;
function CS_GetFirstClient;
function CS_GetNextClient;
function CS_GetClientInfo;}

function cs_errortext(n:word):string;

implementation

uses
  Os2Def,
  VpSysLow,
  VpUtils;

var
  pcmcia_handle :longint=-1;

function CS_Open;
  begin
    Result:=SysFileOpen('\DEV\CARDBUS$',0,pcmcia_handle);
    if Result<>0 then
      Result:=SysFileOpen('\DEV\PCMCIA$',0,pcmcia_handle);
  end;

function CS_Close;
  begin
    CS_Close:=SysFileClose(pcmcia_handle);
    pcmcia_handle:=-1;
  end;

function CS_GetCardServicesInfo;
  begin
    with GetCardServicesInfo do
      begin
        IOCtlHeader.Function_Code:=$0b;
        IOCtlHeader.Length:=SizeOf(GetCardServicesInfo);
        CS_GetCardServicesInfo:=
          DosDevIOCtl(pcmcia_handle,$0d,$4f,
                      @GetCardServicesInfo,SizeOf(GetCardServicesInfo),nil,
                      nil                 ,0                          ,nil);
      end;
  end;

function CS_RegisterClient;
  begin
    with RegisterClient do
      begin
        IOCtlHeader.Function_Code:=$10;
        IOCtlHeader.Length:=SizeOf(RegisterClient);
        CS_RegisterClient:=
          DosDevIOCtl(pcmcia_handle,$0d,$4f,
                      @RegisterClient,SizeOf(RegisterClient),nil,
                      nil            ,0                     ,nil);
      end;
  end;

function CS_DeregisterClient;
  begin
    with DeregisterClient do
      begin
        IOCtlHeader.Function_Code:=$02;
        IOCtlHeader.Length:=SizeOf(DeregisterClient);
        CS_DeregisterClient:=
          DosDevIOCtl(pcmcia_handle,$0d,$4f,
                      @DeregisterClient,SizeOf(DeregisterClient),nil,
                      nil              ,0                       ,nil);
      end;
  end;

//function CS_GetStatus;
function CS_GetConfigurationInfo;
  begin
    with GetConfigurationInfo do
      begin
        IOCtlHeader.Function_Code:=$04;
        IOCtlHeader.Length:=SizeOf(GetConfigurationInfo);
        CS_GetConfigurationInfo:=
          DosDevIOCtl(pcmcia_handle,$0d,$4f,
                      @GetConfigurationInfo,SizeOf(GetConfigurationInfo),nil,
                      nil                  ,0                           ,nil);
      end;
  end;


function CS_GetFirstTuple;
  begin
    with GetTuple do
      begin
        IOCtlHeader.Function_Code:=$07;
        IOCtlHeader.Length:=SizeOf(GetTuple);
        CS_GetFirstTuple:=
          DosDevIOCtl(pcmcia_handle,$0d,$4f,
                      @GetTuple,SizeOf(GetTuple),nil,
                      nil      ,0               ,nil);
      end;
  end;

function CS_GetNextTuple;
  begin
    with GetTuple do
      begin
        IOCtlHeader.Function_Code:=$0a;
        IOCtlHeader.Length:=SizeOf(GetTuple);
        CS_GetNextTuple:=
          DosDevIOCtl(pcmcia_handle,$0d,$4f,
                      @GetTuple,SizeOf(GetTuple),nil,
                      nil      ,0               ,nil);
      end;
  end;

function CS_GetTupleData;
  begin
    with GetTupleData do
      begin
        IOCtlHeader.Function_Code:=$0d;
        IOCtlHeader.Length:=SizeOf(GetTupleData);
        CS_GetTupleData:=
          DosDevIOCtl(pcmcia_handle,$0d,$4f,
                      @GetTupleData,SizeOf(GetTupleData),nil,
                      nil          ,0                   ,nil);
      end;
  end;

{function CS_GetFirstRegion;
function CS_GetNextRegion;
function CS_GetFirstPartition;
function CS_GetNextPartition;
function CS_VendorSpecific;
function CS_AdjustResourceInfo;
function CS_GetFirstWindow;
function CS_GetNextWindow;
function CS_GetMemPage;
function CS_GetFirstClient;
function CS_GetNextClient;
function CS_GetClientInfo;}


const
  cs_errortext_table:array[SUCCESS..BAD_HANDLE] of string[20]=
    ('SUCCESS',
     'BAD_ADAPTER',
     'BAD_ATTRIBUTE',
     'BAD_BASE',
     'BAD_EDC',
     '',
     'BAD_IRQ',
     'BAD_OFFSET',
     'BAD_PAGE',
     'READ_FAILURE',
     'BAD_SIZE',
     'BAD_SOCKET',
     '',
     'BAD_TYPE',
     'BAD_VCC',
     'BAD_VPP',
     '',
     'BAD_WINDOW',
     'WRITE_FAILURE',
     '',
     'NO_CARD',
     'UNSUPPORTED_FUNCTION',
     'UNSUPPORTED_MODE',
     'BAD_SPEED',
     'BUSY',
     'GENERAL_FAILURE',
     'WRITE_PROTECTED',
     'BAD_ARG_LENGTH',
     'BAD_ARGS',
     'CONFIGURATION_LOCKED',
     'IN_USE',
     'NO_MORE_ITEMS',
     'OUT_OF_RESOURCE',
     'BAD_HANDLE');

function cs_errortext(n:word):string;
  var
    res:string;
  begin

    if  (n>=Low (cs_errortext_table))
    and (n<=High(cs_errortext_table)) then
      res:=cs_errortext_table[n]

    else if n=error_Invalid_Parameter then
      res:='Invalid Parameter'

    else
      res:='';

    if res='' then
      res:='Error#'+Int2Str(n);

    cs_errortext:=res;
  end;

end.

